﻿<%@ Page Language="C#" MasterPageFile="~/Blogger/Admin/BloggerAdmin.master" AutoEventWireup="true" Inherits="Ruiao.WebSite.Blogger.Plugins.RuiaoLink.Admin.LinkCategoryManage" Codebehind="LinkCategoryManage.aspx.cs" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="cc1" %>
<asp:Content ID="MyContent" ContentPlaceHolderID="cphMainAdmin" Runat="Server">
<form id="MainForm" runat="server">
<div id="ContentTitle"><%=MyTitle %></div>
<div id="ContentBody">

    <div style="">
    <input type="button" class="LinkButton" value="管理链接" onclick="location='Default<%=ExtensionName %>'" />
    <input type="button" class="LinkButton" value="添加链接" onclick="location='LinkAdd<%=ExtensionName %>'" />
    <input type="button" class="LinkButton" value="链接分类" onclick="location='LinkCategoryManage<%=ExtensionName %>'" />
    </div>
    
    <asp:Repeater ID="rpLinkCategory" runat="server">
    <HeaderTemplate>
    <table id="LinkList" class="MainContentTable" cellpadding="3" cellspacing="1">
	<tr class="MainContentList_HeadTR">
		<td class="MainContentList_HeadTD" style="width:auto;">目录名称</td>
		
		<td class="MainContentList_HeadTD" style="width:50px;">显示图片</td>
		<td class="MainContentList_HeadTD" style="width:50px;">显示描述</td>
		<td class="MainContentList_HeadTD" style="width:50px;">显示评级</td>
		<td class="MainContentList_HeadTD" style="width:50px;">最后更新</td>
		
		<td class="MainContentList_HeadTD" style="width:50px;">排序方式</td>
		<td class="MainContentList_HeadTD" style="width:50px;">升序排列</td>
		<td class="MainContentList_HeadTD" style="width:50px;">显示数量</td>
		<td class="MainContentList_HeadTD" style="width:60px;">操作</td>
	</tr>
    </HeaderTemplate>
    <ItemTemplate>
    	<tr class="MainContentList_ItemTR">
		<td class="MainContentList_ItemTD" style="text-align:left;"><%# DataBinder.Eval(Container, "DataItem.Name")%></td>
		<td class="MainContentList_ItemTD"><%# ((bool)DataBinder.Eval(Container, "DataItem.ShowImages"))?"是":"否" %></td>
		<td class="MainContentList_ItemTD"><%# ((bool)DataBinder.Eval(Container, "DataItem.ShowDescription"))?"是":"否" %></td>
		<td class="MainContentList_ItemTD"><%# ((bool)DataBinder.Eval(Container, "DataItem.ShowRating")) ? "是" : "否"%></td>
		<td class="MainContentList_ItemTD"><%# ((bool)DataBinder.Eval(Container, "DataItem.ShowUpdated")) ? "是" : "否"%></td>
		<td class="MainContentList_ItemTD"><%# Ruiao.Blog.Plugins.RuiaoLink.Common.Dictionary.SortOrder.Get().TryGetValue(DataBinder.Eval(Container, "DataItem.SortOrder").ToString(), out SortOrderText)?SortOrderText:"未知排序"%></td>
		<td class="MainContentList_ItemTD"><%# ((bool)DataBinder.Eval(Container, "DataItem.SortAsc")) ? "是" : "否"%></td>
		<td class="MainContentList_ItemTD"><%# (DataBinder.Eval(Container, "DataItem.ListLimit").ToString() == "0") ? "不限制" : DataBinder.Eval(Container, "DataItem.ListLimit")%></td>
		<td class="MainContentList_ItemTD"><a href="LinkCategoryEdit<%=ExtensionName %>?CategoryID=<%# DataBinder.Eval(Container, "DataItem.ID")%>">编辑</a> | <a href="LinkCategoryManage<%=ExtensionName %>?Action=Delete&CategoryID=<%# DataBinder.Eval(Container, "DataItem.ID")%>">删除</a></td>
	</tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </FooterTemplate>
    </asp:Repeater>
    
    <cc1:aspnetpager id="Pager" PageSize="20" runat="server" AlwaysShow='true' OnPageChanged="Pager_PageChanged"></cc1:aspnetpager>
    
    <br /><br />
    <fieldset class="ContentBox">
    <div class="ContentBox_Head" onclick="BoxSwitch('mcBody','siBody','/Blogger/Admin/Images/Box_')"><div style="float:left;">添加链接分类：</div><div id="siBody" class="SwitchIcon_Down"></div></div> 
    <div class="ContentBox_ContentBox" id="mcBody" style="display:none;">
        <div class="ContentBox_ContentItem">
        <table id="MainOptions" width="100%" border="0" cellpadding="3" cellspacing="0" class="Body">

		<tr>
        <td align="right" style="width: 15%">名称：</td>
        <td >
        <img id="LinkIconPreview" alt="" src="" style=" width:16px;display:none;" />
        <asp:DropDownList ID="ddlIcon" runat="server"></asp:DropDownList>
        <asp:TextBox ID="tbName" runat="server" Width="120px"></asp:TextBox>
        </td>
      	</tr>
      	
      	<tr>
        <td align="right" style="width: 15%">显示：</td>
        <td>
        <asp:CheckBox ID="cbxShowImages" runat="server" Text="图片" /><br />
        <asp:CheckBox ID="cbxShowDescription" runat="server" Text="描述" /><br />
        <asp:CheckBox ID="cbxShowRating" runat="server" Text="评级" /><br />
        <asp:CheckBox ID="cbxShowUpdated" runat="server" Text="最后更新" />
        </td>
      	</tr>
      	
      	<tr>
        <td align="right" style="width: 15%">排序：</td>
        <td>
        <asp:DropDownList ID="ddlSortOrder" runat="server"></asp:DropDownList>
        <asp:CheckBox ID="cbxSortAsc" runat="server" Text="升序" Checked="true" />
        </td>
      	</tr>
		
		<tr>
		<td align="right"style="width: 15%">限制：</td>
		<td >最多显示<asp:TextBox ID="tbListLimit" runat="server" Width="20px"></asp:TextBox>个链接</td>
		</tr>
      	
	    </table>
	    
	    <div style="text-align:right; padding:5px">
        <asp:Button ID="btSave" runat="server" Text="添加链接分类" CssClass="SubmitButton" OnClick="btSave_Click" />
        </div>
        </div>
    </div>
	</fieldset>
    
</div>
<div id="ContentBottom"></div>
</form>
</asp:Content>

