
var selected_cell = null;
var delete_image_path = "";
var properties_image_path = "";
var btnSelectModule = "btnSelectModule";
var module_name = "module";
var selected_item_background_color = "#cccccc";

function GetPageLayout(element)
{
	if(element==null) return;
	
	var html = "";
	
	switch(element.tagName)
	{
		case "DIV":
			if(element.type=="module")
			{
				if(element.selected+''=="true")
				{
					html += '<' + module_name +' selected="true" guid="' + element.guid + '" name="' + element.innerText + '"></' + module_name + '>';
				}
				else
				{
					html += '<' + module_name + ' guid="' + element.guid + '" name="' + element.innerText + '"></' + module_name + '>';
				}
			}
			else
			{
				if(element.id!="ElementPageLayout")
				{
					html = "<div";
								
					if(element.style.cssText != "")
					{
						html += ' style="' + element.style.cssText + '"';
					}
					
					html += ">";
					for(var k=1; k<element.children.length; k++)
					{
						html += GetPageLayout(element.children(k));
					}
					html += "</div>";
				}
				else
				{
					for(var k=0; k<element.children.length; k++)
					{
						html += GetPageLayout(element.children(k));
					}
				}
			}
			break;
		case "TABLE":
			html = "<table>";
			for(var k=0; k<element.children.length; k++)
			{
				html += GetPageLayout(element.children(k));
			}
			html += "</table>";
			break;
		case "TD":
			html += "<td";
			
			if(element.colSpan > 1)
			{
				html += ' colspan="' + element.colSpan + '"';
			}
			
			if(element.width != "")
			{
				html += ' width="' + element.width + '"';
			}
			
			if(element.style.cssText != "")
			{
				html += ' style="' + element.style.cssText + '"';
			}
			
			html += ">";
			for(var k=1; k<element.children.length; k++)
			{
				html += GetPageLayout(element.children(k));
			}
			html += "</td>";
			break;
		case "TR":
			html = "<tr>";
			for(var k=0; k<element.children.length; k++)
			{
				html += GetPageLayout(element.children(k));
			}
			html += "</tr>";
			break;
		case "TBODY":
			for(var k=0; k<element.children.length; k++)
			{
				html += GetPageLayout(element.children(k));
			}
			break;
	}
	
	return html;
}
/*
function GetTableLayout(table)
{
	return;
	
	if(table.tagName!="TABLE") return "";
	
	var html = "<table>";
	
	for(var i=0; i<table.rows.length; i++)
	{
		var tr = table.rows(i);
		
		html += "<tr>";
		
		for(var j=0; j<tr.cells.length; j++)
		{
			var td = tr.cells(j);
			
			html += "<td";
			
			if(td.colSpan > 1)
			{
				html += ' colspan="' + td.colSpan + '"';
			}
			
			if(td.width != "")
			{
				html += ' width="' + td.width + '"';
			}
			
			if(td.style.cssText != "")
			{
				html += ' style="' + td.style.cssText + '"';
			}
			
			html += ">";
			
			for(var k=1; k<td.children.length; k++)
			{
				var div = td.children(k);
				
				if(div.type+'' == "Table")
				{
					html += GetTableLayout(div.children(0));
				}
				else
				{
					if(div.selected+''=="true")
					{
						html += '<' + module_name +' selected="true" guid="' + div.guid + '" name="' + td.children(k).innerText + '"></' + module_name + '>';
					}
					else
					{
						html += '<' + module_name + ' guid="' + div.guid + '" name="' + td.children(k).innerText + '"></' + module_name + '>';
					}
				}
			}
			
			html += "</td>";
			
		}
		
		html += "</tr>";
		
	}
	
	html += "</table>";
	
	return html;
}
*/
function SavePageLayouts()
{
	//var html = GetTableLayout(document.all.MainTable);
	
	var html = "<div>" + GetPageLayout(document.all.ElementPageLayout) + "</div>";
	
	//alert(html);
			
	document.all.page_layout.value = html;
	document.all.layout_changed.value = "true";	
}

// Add new row or column
function NewRow(table)
{
	var length = table.rows.length;
	var max_td = 0;
			
	for(var i=0; i<length; i++)
	{
		var tr = table.rows(i);
		
		if(tr.cells.length > max_td)
		{
			max_td = tr.cells.length;
		}
	}
	
	var tr = table.insertRow(length);
	
	for(var j=0; j<max_td; j++)
	{
		var td = tr.insertCell(tr.cells.length);
		
		SetTdAtrributes(td);
	}
}

function NewColumn(table)
{
	var length = table.rows.length;
		
	for(var i=0; i<length; i++)
	{
		var tr = table.rows(i);
		var td = tr.insertCell(tr.cells.length);
		
		SetTdAtrributes(td);
	}
}

function SetTdAtrributes(td)
{
	td.setAttribute("DragDropTarget", "true");
	
	td.innerHTML = "<div class='Toolbar' onmousedown='ModuleSelectedOnMouseDown(this)'><a onclick='return ShowCellProperties(this.parentElement.parentElement)' href='#'><img style='border:0px' src='" + properties_image_path + "' alt='Set cell properties' /></a> <a onclick='return CollapseColumn(this.parentElement.parentElement)' href='#'><img style='border:0px' src='" + delete_image_path + "' alt='Delete this cell' /></a></div>";
}

// delete cell of some row
function DeleteCell(tr, td)
{
	if(tr.tagName!="TR") return;
	
	var table = tr;
	while(table.tagName!="TABLE")
	{
		table = table.parentElement;
	}

	if(table.id=="MainTable" && table.rows.length==1 && table.rows(0).cells.length==1)
	{
		return false;
	}
	
	if(td==selected_cell)
	{
		selected_cell = null;
		document.all.LinkSaveCellProperties.disabled = true;
	}
	
	tr.deleteCell(td.cellIndex);
	
	return true;
}

function VerifySpan(table)
{
	var max_td = 0;
	var max_span = 0;

	var length = table.rows.length;
		
	for(var i=0; i<length; i++)
	{
		var tr = table.rows(i);
		
		if(tr.cells.length > max_td)
		{
			max_td = tr.cells.length;
		}
	}
	
	for(var i=0; i<table.rows(0).cells.length; i++)
	{
		var td = table.rows(0).cells(i);
		
		max_span += td.colSpan;
	}
	
	if(max_span > max_td)
	{
		for(var i=0; i<table.rows.length; i++)
		{
			var span = max_span;
			var tr = table.rows(i);
			
			for(var j=0; j<table.rows(i).cells.length; j++)
			{
				var td = table.rows(i).cells(j);
				
				if(td.colSpan>1)
				{
					var minus = span - max_td;
					
					if(td.colSpan - 1 < minus)
					{
						minus = td.colSpan - 1;
					}
					
					span -= minus;
					td.colSpan -= minus;
				}
			}
		}
	}
}

function CollapseColumn(td)
{
	if(td.tagName!="TD") return;
	
	var num = td.colSpan;
	
	var table = td;
	while(table.tagName!="TABLE")
	{
		table = table.parentElement;
	}
	
	if(table.rows.length==1 && table.rows(0).cells.length==1)
	{
		// Delete the whole table if the tale has only one row and one column.
		table.parentElement.removeChild(table);
	}
	else
	{
		var previous = td.previousSibling;
		var next = td.nextSibling;
		var tr = td.parentElement;
		
		var span = td.colSpan;
		
		var ok = DeleteCell(tr, td);
		
		if(previous != null)
		{
			previous.colSpan = previous.colSpan + span;
			
			previous.removeAttribute("width", 0);
			
			//SetTDHtml(previous);
		}
		else if(next != null)
		{
			next.colSpan = next.colSpan + span;
			
			next.removeAttribute("width", 0);
			
			//SetTDHtml(next);
		}
		else
		{
			if(ok) table.deleteRow(tr.rowIndex);
		}
		
		if(ok) VerifySpan(table);
		
		if(selected_cell != null)
		{
			ShowCellProperties(selected_cell);
		}
	}

	SavePageLayouts();
	
	return false;
}

function AdjustWidth(td)
{
	if(td.tagName!="TD") return;
	
	var tr = td.parentElement;
	var span = 0;

	var table = td;
	while(table.tagName!="TABLE")
	{
		table = table.parentElement;
	}
	
	for(var i=0; i<=td.cellIndex; i++)
	{
		span += tr.cells(i).colSpan;
	}
	
	for(var i=0; i<table.rows.length; i++)
	{
		tr = table.rows(i);
		var tmp_span = 0;
		
		for(var j=0; j<tr.cells.length; j++)
		{
			tmp_span += tr.cells(j).colSpan;
			
			if(tmp_span == span) tr.cells(j).width = td.width;
		}
	}

	SavePageLayouts();
}

// Cell Properties
function ShowCellProperties(element)
{
	//if(selected_cell!=null) selected_cell.style.backgroundColor="";//.className = "";//removeAttribute("bgColor");
	
	selected_cell = element;
	
	document.all.LinkSaveCellProperties.disabled = false;
	
	document.all.TextCellWidth.disabled = false;
	if(element.tagName=="TD")
	{
		document.all.TextCellWidth.value = element.width;
	}
	else
	{
		document.all.TextCellWidth.value = "";
	}
	
	document.all.TextCellWidth.focus();
	
	if((element.tagName=="TD" && element.colSpan>1) || element.tagName=="DIV")
	{
		document.all.TextCellStyle.focus();
		document.all.TextCellWidth.value = "The width can't be modified.";
		document.all.TextCellWidth.disabled = true;
	}
	
	document.all.TextCellStyle.value = element.style.cssText;
	
	//element.style.backgroundColor = selected_item_background_color;//.className = "CellSelected"; // .bgColor = "#cccccc";
}

function SaveCellProperties()
{
	if(selected_cell!=null && (selected_cell.tagName=="TD" || selected_cell.tagName=="DIV"))
	{
		if(!document.all.TextCellWidth.disabled)
		{
			selected_cell.width = document.all.TextCellWidth.value;
		}
		
		selected_cell.style.cssText = document.all.TextCellStyle.value;

		SavePageLayouts();
	}
}

function RemoveDiv(element)
{
	if(element.tagName=="DIV")
	{
		element.parentElement.removeChild(element);

		SavePageLayouts();		
	}
}

var mousex = null;
var mousey = null;
function ModuleSelectedOnMouseDown(element)
{
	var from = window.event.srcElement;
		
	if(from.tagName=="TD" || from.tagName=="DIV")
	{
		while(element!=null && element.DragDrop+''!="true")
		{
			element = element.parentElement;
		}
			
		if(element == null) return;

		document.body.onmousemove = ModuleSelectedOnMouseMove;
		document.body.onmouseup = ModuleSelectedOnMouseUp;
		
		element.style.position = "absolute";
		
		var x = window.event.x - window.event.offsetX - 6;
		var y = window.event.y - window.event.offsetY - 10;
		
		//alert("X:" + window.event.x + ",Y:" + window.event.y+ ";ClientX:" + window.event.clientX+",ClientY:" + window.event.clientY+ ";OffsetX:" + window.event.offsetX + ", OffsetY:" + window.event.offsetY + ";" + x + "," + y);
		/*
		if(from.tagName=="DIV")
		{
			from = from.parentElement;
			
			x = x - from.offsetLeft;
			y = y - from.offsetTop;
		}
		*/
		//alert(x+"," + y);
		element.style.left = x;
		element.style.top = y;
		
		dragobject = element;
		
		mousex = window.event.clientX;
		mousey = window.event.clientY;
	}
}

function ModuleSelectedOnMouseMove()
{
	if (dragobject)
	{
		if (window.event.clientX >= 0 && window.event.clientY >= 0)
		{
			var x = parseInt(dragobject.style.left);
			var y = parseInt(dragobject.style.top);
			
			//alert(x +"," + y);
			
			dragobject.style.left = x + window.event.clientX - mousex;
			dragobject.style.top = y + window.event.clientY - mousey;
			
			mousex = window.event.clientX;
			mousey = window.event.clientY;
		}
		
		window.event.returnValue = false;
		window.event.cancelBubble = true;
	}	
}

function GetDragDropTarget()
{
	var element = document.elementFromPoint(window.event.clientX, window.event.clientY);
		
	while(element!=null && element.DragDropTarget!="true")
	{
		element = element.parentElement;
	}
	
	return element;
}

function ModuleSelectedOnMouseUp()
{
	if(dragobject)
	{
		var parent = dragobject.parentElement;
		parent.removeChild(dragobject);
		
		var element = GetDragDropTarget();
						
		if(element!=null)
		{
			InsertDragObject(element, dragobject);
		
			dragobject.style.position = "";
			dragobject.style.left = "";//0;
			dragobject.style.top = "";//0;
						
			dragobject = null;
			
			SavePageLayouts();
		}
		else
		{
			document.body.removeChild(dragobject);
			
			dragobject = null;
		}
	}
}

// Drag & Drop
var dragobject = null;
function DragDropOnMouseDown(element)
{
	var div = document.createElement("DIV");

	document.body.onmousemove = DragDropOnMouseMove;
	document.body.onmouseup = DragDropOnMouseUp;

	document.body.insertBefore(div);

	div.innerHTML = element.innerHTML;
	
	div.style.cssText = "";
	div.className = "ModuleMoving";
	div.style.position = "absolute";
	div.style.left = window.event.clientX + document.body.scrollLeft;
	div.style.top = window.event.clientY + document.body.scrollTop;
	
	div.onselectstart = "return false";
	
	if(element.type!=null)
	{
		div.type = element.type;
	}
	else
	{
		div.type = "module";
	}
	
	dragobject = div;
}

function DragRowColumn(type)
{
	var element = GetDragDropTarget();
	
	/*	
	document.elementFromPoint(window.event.clientX, window.event.clientY);
	while(element!=null && element.tagName!="TABLE")
	{
		element = element.parentElement;
	}
	*/	
	if(element!=null && element.tagName=="TD")
	{
		while(element!=null && element.tagName!="TABLE")
		{
			element = element.parentElement;
		}
		
		if(element!=null)
		{
			if(type=="row")
			{
				NewRow(element);
			}
			else if(type=="column")
			{
				NewColumn(element);
			}
			
			SavePageLayouts();
		}
	}

	document.body.removeChild(dragobject);
		
	dragobject = null;
}

function InsertDragObject(element, dragitem)
{
	if(element.type=="module")
	{
		var parentelement = element.parentElement;

		while(parentelement!=null && parentelement.DragDropTarget!="true")
		{
			parentelement = parentelement.parentElement;
		}
		
		if(parentelement==null) return;
		
		parentelement.insertBefore(dragitem, element);
	}
	else
	{
		element.appendChild(dragitem);
	}
}

function DragHtmlElement(type)
{
	var element = GetDragDropTarget();

	if(element!=null)
	{
		var html ="";
		if(type=="table")
		{
			html = "<table DragDrop='true' type='table' width='100%' cellpadding='0' cellspacing='0' border='1' style='margin-top:4px;margin-bottom:4px;font:10.5pt Verdana;'></table>";
			
			var table = document.createElement(html);
			var tr = table.insertRow();
			var td = tr.insertCell();
			
			td.DragDropTarget = "true";
			
			html = "<div class='Toolbar' onmousedown='ModuleSelectedOnMouseDown(this)'><a onclick='return ShowCellProperties(this.parentElement.parentElement)' href='#'><img style='border:0px' src='" + properties_image_path + "' alt='Set cell properties' /></a> <a onclick='return CollapseColumn(this.parentElement.parentElement)' href='#'><img style='border:0px' src='" + delete_image_path + "' alt='Delete this cell' /></a></div>";
			td.innerHTML = html;
						
			InsertDragObject(element, table);
	
			document.body.removeChild(dragobject);
		}
		else if(type=="div")
		{
			html = "<div class='Toolbar' onmousedown='ModuleSelectedOnMouseDown(this)'><a onclick='return ShowCellProperties(this.parentElement.parentElement)' href='#'><img style='border:0px' src='" + properties_image_path + "' alt='Set cell properties' /></a> <a onclick='return RemoveDiv(this.parentElement.parentElement)' href='#'><img style='border:0px' src='" + delete_image_path + "' alt='Delete this cell' /></a></div>";
			
			InsertDragObject(element, dragobject);
			
			dragobject.style.cssText = "";
			dragobject.className = "ModuleSelected";
			
			dragobject.DragDrop = "true";
			dragobject.DragDropTarget = "true";
			dragobject.type = type;
			
			dragobject.innerHTML = html;
		}
	}
	else
	{
		document.body.removeChild(dragobject);
	}

	dragobject = null;
		
	SavePageLayouts();
}

function DragModule()
{
	var element = GetDragDropTarget();
					
	if(element!=null)
	{
		InsertDragObject(element, dragobject);
		
		dragobject.style.cssText = "";
		dragobject.className = "ModuleSelected";
		
		dragobject.guid = "";
		dragobject.DragDrop = "true";
		dragobject.DragDropTarget = "true";
		dragobject.type = "module";
		
		var html = "<table style='width:100%;border:0px' cellpadding='0' cellspacing='0'>";
		html+= "<tr><td onmousedown='ModuleSelectedOnMouseDown(this)'>";
		html+= "<a onclick='SelectModule(this)' href='#' title='Select this user control to edit its properties'>" + dragobject.innerHTML + "</a>";
		html+= "</td><td width='16'>";
		html+= "<a onclick='DeleteModule(this)' href='#'><img style='border:0px' src='" + delete_image_path + "' alt='Delete this user control' /></a>&nbsp;";
		html+= "</td></tr></table>";
		
		dragobject.innerHTML = html;
		
		SavePageLayouts();
	}
	else
	{
		document.body.removeChild(dragobject);
	}
	
	dragobject = null;
}

function DragDropOnMouseUp()
{
	if(dragobject)
	{
		switch(dragobject.type)
		{
			case "div":
			case "table":
				DragHtmlElement(dragobject.type);
				break;
			
			case "row":			
			case "column":
				DragRowColumn(dragobject.type);
				break;
			
			case "module":
				DragModule();
				break;
			default:
				document.body.removeChild(dragobject);
				dragobject = null;
				break;
		}
	}
}

function DragDropOnMouseMove()
{
	if (dragobject)
	{
		if (window.event.clientX >= 0 && window.event.clientY >= 0)
		{
			dragobject.style.left = window.event.clientX + document.body.scrollLeft;
			dragobject.style.top = window.event.clientY + document.body.scrollTop;
		}
		window.event.returnValue = false;
		window.event.cancelBubble = true;
	}
}

function DeleteModule(element)
{
	while(element!=null && element.tagName!='DIV')
	{
		element = element.parentElement;
	}
	
	if(element != null)
	{
		element.parentElement.removeChild(element);

		SavePageLayouts();
	}
	
}

function SelectModule(element)
{
	var pos = "";
	
	while(element!=null && element.tagName!="DIV")
	{
		element = element.parentElement;
	}
	
	if(element!=null)
	{
		element.setAttribute("selected", "true");
		
		SavePageLayouts();

		__doPostBack(btnSelectModule,'');
	}
}

// Module Properties
function SetStatus(element, disabled)
{
	if(element.children!=null && element.children.length > 0)
	{
		for(var i = 0; i<element.children.length; i++)
		{
			SetStatus(element.children(i));
		}
	}
	
	if(element.disabled != null)
	{
		element.disabled = !disabled;
	}
}

function ClickMe(element, disabled)
{
	element = element.parentElement.nextSibling;

	while(element!=null)
	{
		SetStatus(element, disabled);
		
		element = element.nextSibling;
	}
}

function FocusInput(element)
{
	element = element.parentElement.nextSibling;

	while(element!=null)
	{
		if(element.tagName=="INPUT" || element.tagName=="TEXTAREA")
		{
			element.focus();
			
			return;
		}
		
		element = element.nextSibling;
	}
}

function SelectMe(element)
{
	if(element.tagName=="INPUT")
	{
		if(element.type=="radio")
		{
			var radios = document.body.all.tags("INPUT");
			for(var i=0; i<radios.length; i++)
			{
				if(radios(i).type=="radio" && radios(i).name==element.name)
				{
					ClickMe(radios(i), !element.checked);
				}
			}
			
			ClickMe(element, element.checked);
			
			if(element.checked) FocusInput(element);
		}
		else if(element.type == "checkbox")
		{
			ClickMe(element, element.checked);
			
			if(element.checked) FocusInput(element);
		}
	}
}

function InitPage()
{
	var fieldsets = document.body.all.tags("FIELDSET");
	
	for(var i=0; i<fieldsets.length; i++)
	{
		var element = fieldsets(i).children(0).children(0);
		if(element.tagName=="INPUT")
		{
			if(element.type=="radio" || element.type=="checkbox")
			{
				ClickMe(element, element.checked);
			}
		}
	}
	
	/*
	if(document.all.module_selected.value!="")
	{
		//var pos = document.all.module_selected.value;
		
		//var index = pos.split("$");
								
		//document.all.MainTable.rows[index[0]].cells[index[1]].children(Math.abs(index[2]) + 1).className = "ModuleEditing";
	}
	*/
}


