﻿<%@ Page Language="C#" MasterPageFile="Member.master" AutoEventWireup="true" Inherits="Ruiao.WebSite.Public.Member.InfoView" Codebehind="InfoView.aspx.cs" %>
<asp:Content ID="MyContent" ContentPlaceHolderID="cphMain" runat="Server">
<div id="ContentContainer">
    <table id="InfoView_MainTable" class="MainTable">
        <tr id="InfoView_TitleTR" class="TR, Title">
            <td id="InfoView_TitleTD" colspan="2"><%=MyTitle %></td>
        </tr>
        <tr>
            <td style="width:60%">
                <table width='100%' cellpadding='4' cellspacing='0' class="NoBorder">
				    <tr>
					    <td width='40%'>显示名称:</td>
					    <td><%=MemberEntity.DisplayName %></td>
				    </tr>
				    <tr>
					    <td>注册日期:</td>
					    <td><%=MemberEntity.AddTime %></td>
				    </tr>
				    <tr>
					    <td>最后登录IP:</td>
					    <td><%= MemberEntity.LastLoginIP.Remove(MemberEntity.LastLoginIP.LastIndexOf('.')) %>.*</td>
				    </tr>
				    <tr>
					    <td>最后登录日期:</td>
					    <td><%=MemberEntity.LastLoginTime %></td>
				    </tr>
				    <tr>
					    <td>最后到访日期:</td>
					    <td><%=MemberEntity.LastComeTime %></td>
					</tr>
					<tr>
					    <td>会员组:</td>
					    <td><%=MemberEntity.MemberGroupID %></td>
				    </tr>
					<tr>
					    <td>积分:</td>
					    <td><%=MemberEntity.Score %></td>
				    </tr>
				    <tr>
					    <td colspan='2'><hr size='1' width='98%'></td>
				    </tr>
				    <tr>
					    <td>性别:</td>
					    <td><%=Ruiao.Public.Common.Dictionary.Sex.GetValue(MemberEntity.Sex)%></td>
				    </tr>
				    <tr>
					    <td>婚姻:</td>
					    <td><%=Ruiao.Public.Common.Dictionary.Wedlock.GetValue(MemberEntity.Wedlock) %></td>
				    </tr>
				    <tr>
					    <td>生日:</td>
					    <td><%=MemberEntity.Birthday.ToString("yyyy-MM-dd") %></td>
				    </tr>
				    <tr>
					    <td>来自:</td>
					    <td><%=MemberEntity.Address %></td>
				    </tr>
				    <tr>
					    <td colspan='2'><hr size='1' width='98%'></td>
				    </tr>
				    <tr>
					    <td>相片:</td>
					    <td>
					    <%if(String.IsNullOrEmpty(MemberEntity.Photo)) {%>
					    暂无
					    <%}else{%>
					    <a href="<%=MemberEntity.Photo %>" target="_blank">点击查看</a>
                        <%} %>
					    </td>
				    </tr>
				    <tr>
					    <td>个性签名:</td>
					    <td><%=MemberEntity.Signature %></td>
				    </tr>
				    <tr>
					    <td>兴趣爱好:</td>
					    <td><%=MemberEntity.MyLike %></td>
				    </tr>
				    <tr>
					    <td>个人介绍:</td>
					    <td><%=MemberEntity.Intro %></td>
				    </tr>
			    </table>
            </td>
            <td style="width:40%">
                <table width='100%' cellpadding='6' cellspacing='0' class='NoBorder'>
				    <tr>
					    <td style='padding-bottom:20px; text-align:center;'><img src='<%=MemberEntity.Face %>' border='0' /></td>
				    </tr>
			    </table>
			    <table width='100%' cellpadding='5' cellspacing='0' class='NoBorder'>
				    <tr>
					    <td>信箱:</td>
					    <td><a href='mailto:<%=MemberEntity.Email %>'><%=MemberEntity.Email %></a></td>
				    </tr>
				    <tr>
					    <td>MSN:</td>
					    <td><a href='mailto:<%=MemberEntity.MSN %>'><%=MemberEntity.MSN %></a></td>
				    </tr>
				    <tr>
					    <td>QQ:</td>
					    <td><%=MemberEntity.QQ %></td>
				    </tr>
				    <tr>
					    <td>电话:</td>
					    <td><%=MemberEntity.Phone %></td>
				    </tr>
				    <tr>
					    <td>手机:</td>
					    <td><%=MemberEntity.Mobile %></td>
				    </tr>
				    <%if (!String.IsNullOrEmpty(MemberBlogUrl)){%>
				    <tr>
					    <td>博客:</td>
					    <td><a href="<%=MemberBlogUrl %>">访问我的博客</a></td>
				    </tr>
				    <%} %>
			    </table>
            </td>
        </tr>
	</table>
</div>
</asp:Content>