Option Explicit On 
Option Strict On

Imports System.Web.UI.WebControls

Public Class EditArticle
    Inherits BlogPageBase

#Region " Web ɵĴ "

    'õ Web ġ
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub
    Protected WithEvents Form1 As System.Web.UI.HtmlControls.HtmlForm
    Protected WithEvents edtID As System.Web.UI.HtmlControls.HtmlInputHidden
    Protected WithEvents edtTitle As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtCateID As System.Web.UI.HtmlControls.HtmlInputHidden
    Protected WithEvents edtAuthorID As System.Web.UI.HtmlControls.HtmlInputHidden
    Protected WithEvents edtLevel As System.Web.UI.HtmlControls.HtmlInputHidden
    Protected WithEvents edtYear As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtMonth As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtDay As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtTime As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtTag As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtAlias As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents cmbCate As System.Web.UI.WebControls.DropDownList
    Protected WithEvents btnSend As System.Web.UI.HtmlControls.HtmlInputButton
    Protected WithEvents cmbUser As System.Web.UI.WebControls.DropDownList
    Protected WithEvents cmbArticleLevel As System.Web.UI.WebControls.DropDownList
    Protected WithEvents edit As System.Web.UI.HtmlControls.HtmlForm
    Protected WithEvents btnPost As System.Web.UI.HtmlControls.HtmlInputButton
    Protected WithEvents edtTrackback As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents LabelUser As System.Web.UI.WebControls.Label
    Protected WithEvents LabelArticleLevel As System.Web.UI.WebControls.Label
    Protected WithEvents LabelPostTime As System.Web.UI.WebControls.Label
    Protected WithEvents LabelTags As System.Web.UI.WebControls.Label
    Protected WithEvents LabelAlias As System.Web.UI.WebControls.Label
    Protected WithEvents LabelTitle As System.Web.UI.WebControls.Label
    Protected WithEvents LabelCategory As System.Web.UI.WebControls.Label
    Protected WithEvents LabelFileType As System.Web.UI.WebControls.Label
    Protected WithEvents LabelIntro As System.Web.UI.WebControls.Label
    Protected WithEvents LabelContent As System.Web.UI.WebControls.Label
    Protected WithEvents AutoSavePanel1 As com.oucsoft.WSBLog.AutoSavePanel
    Protected WithEvents TagsInputPannel1 As com.oucsoft.WSBLog.TagsInputPannel
    Protected WithEvents UploadFileDialog1 As com.oucsoft.WSBLog.UploadFileDialog
    Protected WithEvents txaContent As System.Web.UI.HtmlControls.HtmlTextArea
    Protected WithEvents txaIntro As System.Web.UI.HtmlControls.HtmlTextArea
    Protected WithEvents LabelMessage As System.Web.UI.WebControls.Label
    Protected WithEvents PlaceHolderHtmlUbb As System.Web.UI.WebControls.PlaceHolder
    Protected WithEvents PlaceHolderToolbar As System.Web.UI.WebControls.PlaceHolder

    'ע: ռλ Web ġ
    'Ҫɾƶ
    Private designerPlaceholderDeclaration As System.Object

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: ˷ Web 
        'Ҫʹô༭޸
        InitializeComponent()
    End Sub

#End Region



    Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Response.Buffer = True

        'Ƿ
        'Call CheckReference("")
        'Ȩ
        If Not CheckRights("ArticleEdt") Then Call ShowError(6)
        'Dim EditArticle

        If (Not Request("type") Is Nothing) AndAlso (Request("type").Trim() <> "") Then
            Me.EditorType = Request("type").Trim() '.ToLower()
        End If

        'ʼ༭
        
        Me.btnPost.Value = Messages.MSG_POST
        Me.btnSend.Value = Messages.MSG_SEND_TRACKBACK

        Me.initLabel()

        Me.initEditor()
        Me.initToolbar()
        Me.initTags()
        Me.initAutoSavePanel()
        Me.initUploadFileDialog()

        Dim scriptkey As String = "ArticleEditScript"
        'If (Not IsStartupScriptRegistered(scriptkey)) Then
        '    RegisterStartupScript(scriptkey, Me.javascriptBlock())
        'End If
        If (Not IsClientScriptBlockRegistered(scriptkey)) Then
            RegisterClientScriptBlock(scriptkey, Me.javascriptBlock())
        End If

        Me.btnPost.Attributes.Add("onclick", "return checkArticleInfo();")
        Me.btnSend.Attributes.Add("onclick", "if(document.getElementById(""edtID"").value==0){alert(str12);return false};")

        PageTitle = BlogTitle & Messages.MSG_TITLE_SEPARATOR & Messages.MSG_EDIT_ARTICLE


        If Not Me.IsPostBack Then

            Dim editArticle As PageArticle = New PageArticle(Me.BlogContext)
            editArticle.AuthorID = CurrentUser.ID

            If Not IsNothing(Request.QueryString("id")) Then
                If editArticle.LoadInfoByID(CInt(Request.QueryString("id"))) Then
                    If editArticle.AuthorID <> CurrentUser.ID Then
                        If CheckRights("Root") = False Then
                            Call ShowError(6)
                        End If
                    End If
                Else
                    Call ShowError(9)
                End If
            End If

            Me.edtTitle.Value = editArticle.Title
            Me.edtID.Value = editArticle.ID.ToString()
            Me.edtAlias.Value = editArticle.Alias

            Me.initPostTimeEdit(editArticle)
            Me.initTagsEdit(editArticle.ArticleTags)

            'Me.initArticleEditTextarea(editArticle)
            'Me.initIntroEditTextarea(editArticle)
            Me.txaContent.Value = Server.HtmlEncode(editArticle.Content)
            Me.txaIntro.Value = Server.HtmlEncode(editArticle.Intro)

            Me.initCategories(editArticle)
            Me.initArticleLevels(editArticle)
            Me.initUsers(editArticle)

        End If

    End Sub

    Private Sub initToolbar()
        Me.initTemplate()
    End Sub

    Private Sub initTemplate()

        Dim labelTemplate As New Label
        labelTemplate.Text = Me.Messages.MSG_ARTICLE_TEMPLATE & ":"
        Me.PlaceHolderToolbar.Controls.Add(labelTemplate)

        Dim list As New DropDownList
        list.Attributes.Add("onchange", "if(this.selectedIndex!=0){restoreFromUrl('" & Me.BlogRootUrl & "PLUGIN/Editor/Template/'+this.options[this.selectedIndex].value);}")

        Dim li As ListItem
        li = New ListItem("", "")
        list.Items.Add(li)

        Dim fileName As String
        Dim templateName As String
        Dim templatePath As String
        templatePath = System.IO.Path.Combine(Me.BlogPath, "PLUGIN\Editor\Template")
        Dim files() As String
        files = System.IO.Directory.GetFiles(templatePath, "*.html")
        If Not files Is Nothing Then
            For Each filePath As String In files
                fileName = System.IO.Path.GetFileName(filePath)
                templateName = System.IO.Path.GetFileNameWithoutExtension(filePath)
                li = New ListItem(templateName, fileName)
                list.Items.Add(li)
            Next
        End If

        Me.PlaceHolderToolbar.Controls.Add(list)

    End Sub

    Private Sub initTagsEdit(ByVal tags As TTag())
        Dim s As String = ""
        If Not tags Is Nothing Then
            For Each tag As TTag In tags
                s = s + tag.Name + ","
            Next
        End If
        Me.edtTag.Value = s
    End Sub

    Private _editorType As String = "normal"
    Public Property EditorType() As String
        Get
            Return Me._editorType
        End Get
        Set(ByVal Value As String)
            Me._editorType = Value
        End Set
    End Property

    Private Sub initEditor()

        If (Me.EditorType.ToLower() = "widgeditor") Then

            'Response.Write("<textarea id=""txaContent"" name=""txaContent"" class=""widgEditor nothing"">")
            'Response.Write(EditArticle.Content)
            'Response.Write("</textarea>")
            Me.txaContent.Attributes.Add("class", "widgEditor nothing")
            'Me.AutoSavePanel1.EditorType = Me.EditorType
            'Dim scriptkey As String = "UbbInputPanelHideClientScript"
            'If Not (Page.IsStartupScriptRegistered(scriptkey)) Then
            '    Page.RegisterStartupScript(scriptkey, UbbInputPanel.GetUbbInputPanelHideScript())
            'End If

        Else

            Me.EditorType = "normal"

            Dim ubbP As UbbInputPanel
            ubbP = CType(LoadControl("UbbInputPanel.ascx"), UbbInputPanel)
            ubbP.LabelTextHtmlTags = Me.Messages.MSG_HTML_TAGS
            ubbP.LabelTextUbbCodes = Me.Messages.MSG_UBB_CODES
            Me.PlaceHolderHtmlUbb.Controls.Add(ubbP)


            'Response.Write("<textarea rows=""4"" onchange=""GetActiveText(this.id);"" onclick=""GetActiveText(this.id);"" onfocus=""GetActiveText(this.id);""")
            Me.txaContent.Attributes.Add("onchange", "GetActiveText(this.id);")
            Me.txaContent.Attributes.Add("onclick", "GetActiveText(this.id);")
            Me.txaContent.Attributes.Add("onfocus", "GetActiveText(this.id);")

        End If

    End Sub

    Private Sub initAutoSavePanel()

        'If (Me.EditorType = "widgeditor") Then
        '    Me.AutoSavePanel1 = New WidgEditorAutoSavePanel
        'End If
#If DEBUG Then
        Me.AutoSavePanel1.Interval = 600
#End If
        Me.AutoSavePanel1.HintEmptyContent = Messages.MSG_EMPTY_CONTENT 'As String = ""
        'Me.AutoSavePanel1.HintUsedInIncorrectForm = Messages.MSG_AUTO_SAVE_ARTICLE_ERROR1 'As String = "ȴд"
        Me.AutoSavePanel1.HintRestoreConfirm = Messages.MSG_AUTO_SAVE_RESTOR_CONFIRM 'As String = "ȷҪָô?"
        Me.AutoSavePanel1.HintDraftIsRestored = Messages.MSG_RESTORED 'As String = "ѻָ"
        Me.AutoSavePanel1.HintRestore = Messages.MSG_RESTORE   'As String = "ָ"
        Me.AutoSavePanel1.HintSecondToSave = Messages.MSG_AUTO_SAVE_AFTER_SECONDS  'As String = "Զ"
        Me.AutoSavePanel1.HintSaving = Messages.MSG_SAVING  'As String = "ڱ"
        Me.AutoSavePanel1.HintSave = Messages.MSG_SAVE 'As String = ""
        Me.AutoSavePanel1.HintView = Messages.MSG_VIEW 'As String = "鿴"

    End Sub

    Private Sub initLabel()

        Me.LabelTitle.Text = Messages.MSG_TITLE
        Me.LabelCategory.Text = Messages.MSG_CATEGORY
        Me.LabelUser.Text = Messages.MSG_SAVE
        Me.LabelArticleLevel.Text = Messages.MSG_TYPE
        Me.LabelPostTime.Text = Messages.MSG_POSTTIME
        Me.LabelTags.Text = Messages.MSG_TAGS
        Me.LabelAlias.Text = Messages.MSG_ALIAS
        'Me.LabelShowTags.Text = Messages.ZC_MSG139
        Me.LabelFileType.Text = BlogConfig.STATIC_TYPE
        Me.LabelIntro.Text = Messages.MSG_EXCERPT
        Me.LabelContent.Text = Messages.MSG_CONTENT

    End Sub

    Private Sub initTags()
        Dim tag As TTag
        Dim tags() As TTag = (New TagManager).GetTags()
        Dim sb As New System.Text.StringBuilder
        For Each tag In tags
            If Not IsNothing(tag) Then
                sb.Append(tag.Name)
                sb.Append(",")
            End If
        Next
        Me.TagsInputPannel1.Tags = sb.ToString()

        Me.TagsInputPannel1.HintDisplayTags = Messages.MSG_SHOW_USED_TAGS

    End Sub

    Protected Function initPostTimeEdit(ByVal article As PageArticle) As String

        Me.edtYear.Value = Year(article.PostTime).ToString()
        Me.edtMonth.Value = Month(article.PostTime).ToString()
        Me.edtDay.Value = Day(article.PostTime).ToString()
        Me.edtTime.Value = Hour(article.PostTime) & ":" & Minute(article.PostTime) & ":" & Second(article.PostTime)

    End Function

    Private Sub initCategories(ByVal editArticle As PageArticle)

        Dim category As TCategory
        Dim cates() As TCategory = (New CategoryManager).GetOrderedCategories()

        Dim li As ListItem
        Me.cmbCate.Items.Clear()
        li = New ListItem("", "0")
        Me.cmbCate.Items.Add(li)
        For Each category In cates
            If Not IsNothing(category) Then
                li = New ListItem(category.Name, category.ID.ToString())
                If (editArticle.CateID = category.ID) Then
                    li.Selected = True
                End If
                Me.cmbCate.Items.Add(li)
            End If
        Next
    End Sub

    Private Sub initArticleLevels(ByVal editArticle As PageArticle)
        Dim articleLevel As String
        Dim i As Integer 'i = 0
        Dim li As ListItem
        Me.cmbArticleLevel.Items.Clear()
        For i = 0 To Messages.ARTICLE_TYPE_NAMES.Length - 1 'For Each articleLevel In Messages.ZVA_Article_Level_Name
            articleLevel = Messages.ARTICLE_TYPE_NAMES(i)
            'Response.Write("<option value=""" & i & """ ")
            li = New ListItem(articleLevel, i.ToString())
            If editArticle.Level = i Then
                li.Selected = True 'If EditArticle.Level = i Then Response.Write("selected=""selected""")
                'Response.Write(">" & Messages.ZVA_Article_Level_Name(i) & "</option>")
            End If 'i = i + 1
            Me.cmbArticleLevel.Items.Add(li)
        Next
    End Sub

    Private Sub initUsers(ByVal editArticle As PageArticle)

        Dim users() As TUser
        Dim user As TUser
        Dim li As ListItem
        Me.cmbUser.Items.Clear()
        Dim um As New UserManager
        users = um.GetUsers()

        'li = New ListItem("", "0")
        'Me.cmbUser.Items.Add(li)

        For Each user In users
            If Not IsNothing(user) Then
                If user.ID = editArticle.AuthorID Then
                    li = New ListItem(user.Name, user.ID.ToString())
                    li.Selected = True
                    Me.cmbUser.Items.Add(li)
                End If
            End If
        Next

    End Sub


    'Private Sub initArticleEditTextarea(ByVal editArticle As PageArticle)
    'End Sub
    'Private Sub initIntroEditTextarea(ByVal editArticle As PageArticle)
    'End Sub

    Private Function javascriptBlock() As String

        Dim sb As New System.Text.StringBuilder
        sb.Append("	<script language=javascript>") : sb.Append(vbCrLf)
        sb.Append("	<!--") : sb.Append(vbCrLf)

        sb.Append(Me.javascriptCommon())

        sb.Append(Me.javascriptArticleCheck())

        sb.Append(Me.javascriptAutoSaveSupport())

        sb.Append(Me.javascriptUploadCallbackFunction())

        sb.Append("//-->") : sb.Append(vbCrLf)
        sb.Append("</script>") : sb.Append(vbCrLf)

        Return sb.ToString()
    End Function

    Private Function javascriptCommon() As String
        Dim sb As New System.Text.StringBuilder

        sb.Append("function getHTTPObject() {") : sb.Append(vbCrLf)
        sb.Append("  var xmlhttprequest=false; ") : sb.Append(vbCrLf)
        sb.Append("  try {") : sb.Append(vbCrLf)
        sb.Append("  xmlhttprequest = new XMLHttpRequest();") : sb.Append(vbCrLf)
        sb.Append("  } catch (trymicrosoft) {") : sb.Append(vbCrLf)
        sb.Append("    try {") : sb.Append(vbCrLf)
        sb.Append("    xmlhttprequest = new ActiveXObject(""Msxml2.XMLHTTP"");") : sb.Append(vbCrLf)
        sb.Append("    } catch (othermicrosoft) {") : sb.Append(vbCrLf)
        sb.Append("      try {") : sb.Append(vbCrLf)
        sb.Append("      xmlhttprequest = new ActiveXObject(""Microsoft.XMLHTTP"");") : sb.Append(vbCrLf)
        sb.Append("      } catch (failed) {") : sb.Append(vbCrLf)
        sb.Append("        xmlhttprequest = false;") : sb.Append(vbCrLf)
        sb.Append("      }") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)
        sb.Append("  }") : sb.Append(vbCrLf)
        sb.Append("  return xmlhttprequest;") : sb.Append(vbCrLf)
        sb.Append("}") : sb.Append(vbCrLf)

        Return sb.ToString()
    End Function

    Private Function javascriptArticleCheck() As String
        Dim sb As New System.Text.StringBuilder
        sb.Append("") : sb.Append(vbCrLf)
        sb.Append("	objActive=""txaContent"";") : sb.Append(vbCrLf)
        sb.Append("") : sb.Append(vbCrLf)

        sb.Append("	var str10=""" & Messages.MSG_NO_EMPTY_CATEGORY & """;") : sb.Append(vbCrLf)
        sb.Append("	var str11=""" & Messages.MSG_NO_EMPTY_CONTENT & """;") : sb.Append(vbCrLf)
        sb.Append("	var str12=""" & Messages.MSG_SEND_TRACKBACK_AFTER_POST & """;") : sb.Append(vbCrLf)

        sb.Append("	function checkArticleInfo(){") : sb.Append(vbCrLf)

        'sb.Append("		document.getElementById(""edit"").action=""../Cmd.aspx?act=ArticlePst"";") : sb.Append(vbCrLf)

        sb.Append("") : sb.Append(vbCrLf)

        sb.Append("		if(document.getElementById(""cmbCate"").value==0){") : sb.Append(vbCrLf)
        sb.Append("			alert(str10);") : sb.Append(vbCrLf)
        sb.Append("			return false;") : sb.Append(vbCrLf)
        sb.Append("		}") : sb.Append(vbCrLf)
        sb.Append("") : sb.Append(vbCrLf)

        If (EditorType = "normal") Then
            sb.Append("		if(!document.getElementById(""txaContent"").value){") : sb.Append(vbCrLf)
            sb.Append("			alert(str11);") : sb.Append(vbCrLf)
            sb.Append("			return false;") : sb.Append(vbCrLf)
            sb.Append("		}") : sb.Append(vbCrLf)
        End If

        sb.Append("	}") : sb.Append(vbCrLf)

        Return sb.ToString()
    End Function


    Private Function javascriptAutoSaveSupport() As String
        Dim sb As New System.Text.StringBuilder
        If (Me.EditorType.Trim().ToLower() = "widgeditor") Then
            'sb.Append("  var postForm = null; ") : sb.Append(vbCrLf)
            'sb.Append("  var msg = null; ") : sb.Append(vbCrLf)
            'sb.Append("function init(){") : sb.Append(vbCrLf)
            'sb.Append("  postForm =document.getElementById('txaContentWidgIframe').contentWindow.document.getElementsByTagName('body')[0];") : sb.Append(vbCrLf)
            'sb.Append("  return postForm.innerHTML;") : sb.Append(vbCrLf)
            'sb.Append("}") : sb.Append(vbCrLf)
            'sb.Append("init();") : sb.Append(vbCrLf)

            sb.Append("function getArticleContent(){") : sb.Append(vbCrLf)
            sb.Append("  var postForm = null; ") : sb.Append(vbCrLf)
            sb.Append("  postForm =document.getElementById('txaContentWidgIframe').contentWindow.document.getElementsByTagName('body')[0];") : sb.Append(vbCrLf)
            sb.Append("  return postForm.innerHTML;") : sb.Append(vbCrLf)
            sb.Append("}") : sb.Append(vbCrLf)

            sb.Append("function restore(obj){") : sb.Append(vbCrLf)
            'sb.Append("  init();") : sb.Append(vbCrLf)
            sb.Append("  var postForm = null; ") : sb.Append(vbCrLf)
            sb.Append("  postForm =document.getElementById('txaContentWidgIframe').contentWindow.document.getElementsByTagName('body')[0];") : sb.Append(vbCrLf)
            sb.Append("  postForm.innerHTML=obj;") : sb.Append(vbCrLf)
            sb.Append("}") : sb.Append(vbCrLf)
        Else
            'sb.Append("  var postForm = null; ") : sb.Append(vbCrLf)
            'sb.Append("  var msg = null; ") : sb.Append(vbCrLf)
            'sb.Append("function init(){") : sb.Append(vbCrLf)
            'sb.Append("  postForm = document.getElementById(""" & Me.TextArea & """);") : sb.Append(vbCrLf) 'sb.Append("  postForm = document.edit.txaContent;") : sb.Append(vbCrLf)
            'sb.Append("  msg = document.getElementById(""responsemsg"");") : sb.Append(vbCrLf)
            'sb.Append("  return postForm.value;") : sb.Append(vbCrLf)
            'sb.Append("}") : sb.Append(vbCrLf)

            sb.Append("function getArticleContent(){") : sb.Append(vbCrLf)
            sb.Append("  var postForm = null; ") : sb.Append(vbCrLf)
            sb.Append("  postForm = document.getElementById(""" & Me.txaContent.ClientID & """);") : sb.Append(vbCrLf)
            sb.Append("  return postForm.value;") : sb.Append(vbCrLf)
            sb.Append("}") : sb.Append(vbCrLf)

            sb.Append("function restore(obj){") : sb.Append(vbCrLf)
            'sb.Append("  init();") : sb.Append(vbCrLf)
            sb.Append("  var postForm = null; ") : sb.Append(vbCrLf)
            sb.Append("  postForm = document.getElementById(""" & Me.txaContent.ClientID & """);") : sb.Append(vbCrLf)
            sb.Append("  postForm.value=obj;") : sb.Append(vbCrLf)
            sb.Append("}") : sb.Append(vbCrLf)

        End If

        sb.Append("function restoreFromUrl(url)") : sb.Append(vbCrLf)
        sb.Append("{") : sb.Append(vbCrLf)
        'sb.Append("if (window.confirm('" & Me.Messages.MSG_AUTO_SAVE_RESTOR_CONFIRM & "'))") : sb.Append(vbCrLf)
        'sb.Append("{")
        'sb.Append("		var url = SavedFileName;") : sb.Append(vbCrLf)
        sb.Append("		var ajax = getHTTPObject();") : sb.Append(vbCrLf)
        sb.Append("     if (url.indexOf(""?"")>=0) {") : sb.Append(vbCrLf)
        sb.Append("        url += '&random='+Math.random();") : sb.Append(vbCrLf)
        sb.Append("     }else{") : sb.Append(vbCrLf)
        sb.Append("        url += '?random='+Math.random();") : sb.Append(vbCrLf)
        sb.Append("     }") : sb.Append(vbCrLf)
        sb.Append("		ajax.open(""GET"", url, true); ") : sb.Append(vbCrLf)
        sb.Append("		ajax.onreadystatechange = function() { ") : sb.Append(vbCrLf)
        sb.Append("		if (ajax.readyState == 4 && ajax.status == 200) { ") : sb.Append(vbCrLf)
        sb.Append("		restore(ajax.responseText);") : sb.Append(vbCrLf)
        sb.Append("		} } ;") : sb.Append(vbCrLf)
        sb.Append("		ajax.send(null); ") : sb.Append(vbCrLf)
        'sb.Append("		ti=-1000;") : sb.Append(vbCrLf)
        'sb.Append("}") : sb.Append(vbCrLf)
        sb.Append("}") : sb.Append(vbCrLf)
        sb.Append(vbCrLf)

        Return sb.ToString()
    End Function

    Private Function javascriptUploadCallbackFunction() As String

        Dim sb As New System.Text.StringBuilder
        sb.Append("function uploadCallback(fileInfo){") : sb.Append(vbCrLf)

        'sb.Append("    //alert(""Upload File Success, ID:"" + fileInfo.fileID + ""; Name:"" + fileInfo.fileName + "";"");") : sb.Append(vbCrLf)

        'edit
        'Response.Write("<script language=""Javascript"">try{parent.document.edit.txaContent.currPos.text+='" & message & "';}catch(e){try{parent.document.edit.txaContent.value+='" & message & "'}catch(e){}}</script>")

        sb.Append("    var ubb=fileInfo.UBB;") : sb.Append(vbCrLf)
        sb.Append("    try{") : sb.Append(vbCrLf)
        sb.Append("        document.edit.txaContent.currPos.text+=ubb;") : sb.Append(vbCrLf)
        sb.Append("    }catch(e){") : sb.Append(vbCrLf)
        sb.Append("        try{") : sb.Append(vbCrLf)
        sb.Append("            document.edit.txaContent.value+=ubb;") : sb.Append(vbCrLf)
        sb.Append("        }catch(e){}") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)

        ''edit_widgeditor
        'Response.Write("<script language=""Javascript"">try{parent.document.getElementById('txaContentWidgIframe').contentWindow.document.getElementsByTagName('body')[0].innerHTML+='" & message & "'}catch(e){}</script>")
        'Response.Write("<script language=""Javascript"">window.location.href=""" & page.BlogRootUrl & "Cmd.aspx?act=UpFile""</script>")
        sb.Append("    try{document.getElementById('txaContentWidgIframe').contentWindow.document.getElementsByTagName('body')[0].innerHTML+=ubb}catch(e){};") : sb.Append(vbCrLf)

        sb.Append("}") : sb.Append(vbCrLf)

        Return sb.ToString()

    End Function


    Private Sub initUploadFileDialog()

        Me.UploadFileDialog1.Title = Messages.MSG_UPLOAD_FILE
        Me.UploadFileDialog1.ButtonTextUpload = Messages.MSG_UPLOAD_FILE
        'Response.Write("<form border=""1"" name=""edit"" id=""upfile"" method=""post"" enctype=""multipart/form-data"" action=""" & page.BlogRootUrl & "Cmd.aspx?act=FileUpload2"" style=""background-color: #eaeaea;position: absolute;top:0;left:0;margin:0;padding:0;width:1024px;"">")
        Me.UploadFileDialog1.HintAutoRename = Messages.MSG_AUTO_RENAME_UPLOADED_FILE 'Response.Write("<p><input type=""checkbox"" onclick='if(this.checked==true){document.getElementById(""upfile"").action=document.getElementById(""upfile"").action+""&autoname=1"";}else{document.getElementById(""upfile"").action=""" & page.BlogRootUrl & "Cmd.aspx?act=FileUpload"";}' id=""chkAutoName"" id=""chkAutoName""/><label for=""chkAutoName"">" & Messages.ZC_MSG131 & "</label></p>")
        'Response.Write("<p><input type=""file"" id=""edtFileLoad"" name=""edtFileLoad"" size=""20"">  ")
        Me.UploadFileDialog1.ButtonTextSubmit = Messages.MSG_POST 'Response.Write("<input type=""submit"" class=""button"" value=""" & Messages.ZC_MSG087 & """ name=""B1"" onclick='document.getElementById(""upfile"").action=document.getElementById(""upfile"").action+""&filename=""+escape(edtFileLoad.value)' /> ")
        Me.UploadFileDialog1.ButtonTextReset = Messages.MSG_RESET 'Response.Write("<input class=""button"" type=""reset"" value=""" & Messages.ZC_MSG088 & """ name=""B2"" />")
        'Response.Write("</p></form>")
        Me.UploadFileDialog1.HintUploading = Messages.MSG_UPLOADING

    End Sub

    Private Sub btnPost_ServerClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPost.ServerClick

        Dim pm As PageArticleManager = New PageArticleManager(Me.BlogContext)

        Dim posttime As String = edtYear.Value & "-" & edtMonth.Value & "-" & edtDay.Value & " " & edtTime.Value
        Dim articleId As Integer 'As PageArticle
        Dim errMessage As String = "" 'Ϣ

        If pm.PostArticle(Me.edtID.Value, Me.cmbCate.SelectedValue, Me.cmbUser.SelectedValue, Me.cmbArticleLevel.SelectedValue, _
            posttime, Me.edtTitle.Value, Me.edtTag.Value, Me.edtAlias.Value, _
            Request.Form(Me.txaIntro.ClientID), Request.Form(Me.txaContent.ClientID), articleId, errMessage) Then
            'עҪɵµID
            Me.edtID.Value = articleId.ToString() 'Response.Redirect("Admin.aspx?act=ArticleMng")
            Me.LabelMessage.ForeColor = System.Drawing.Color.Blue
            Me.LabelMessage.Text = "Post Article OK!"
            Response.Redirect("Admin.aspx?act=ArticleMng")
        Else
            Me.LabelMessage.ForeColor = System.Drawing.Color.Red
            Me.LabelMessage.Text = Me.Messages.ERROR_MESSAGES(11) & ":" & errMessage
            Call ShowError(11, errMessage)
        End If

    End Sub


    Private Sub btnSend_ServerClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSend.ServerClick

        Dim tb As PageTrackbackManager = New PageTrackbackManager(Me.BlogContext)
        Dim articleId As Integer = CInt(Me.edtID.Value)
        Dim trackbackUrl As String = Me.edtTrackback.Value
        Dim errMessage As String = ""
        If tb.SendTrackback(articleId, trackbackUrl, errMessage) Then
            Me.LabelMessage.ForeColor = System.Drawing.Color.Blue
            Me.LabelMessage.Text = "Trackback OK!" '
            ' Response.Redirect("Cmd.aspx?act=ArticleMng") 
        Else
            Me.LabelMessage.ForeColor = System.Drawing.Color.Red
            Me.LabelMessage.Text = Me.Messages.ERROR_MESSAGES(20) & ":" & errMessage 'Call ShowError(20)
        End If

    End Sub

End Class
