Option Explicit On 
Option Strict On

Imports System.Web.UI.WebControls

Public Class EditCategory
    Inherits BlogPageBase


#Region " Web ɵĴ "

    'õ Web ġ
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub
    Protected WithEvents edit As System.Web.UI.HtmlControls.HtmlForm
    Protected WithEvents edtName As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtOrder As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtCode As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtID As System.Web.UI.HtmlControls.HtmlInputHidden
    Protected WithEvents btnPost As System.Web.UI.HtmlControls.HtmlInputButton
    Protected WithEvents LabelName As System.Web.UI.WebControls.Label
    Protected WithEvents LabelOrder As System.Web.UI.WebControls.Label
    Protected WithEvents LabelCode As System.Web.UI.WebControls.Label
    Protected WithEvents LabelParentCategory As System.Web.UI.WebControls.Label
    Protected WithEvents cmbParentCategory As System.Web.UI.WebControls.DropDownList

    'ע: ռλ Web ġ
    'Ҫɾƶ
    Private designerPlaceholderDeclaration As System.Object

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: ˷ Web 
        'Ҫʹô༭޸
        InitializeComponent()
    End Sub

#End Region

    Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'Ƿ
        Call CheckReference("")
        '#If DEBUG Then
        '        '
        '#Else
        'Ȩ
        If Not CheckRights("CategoryEdt") Then Call ShowError(6)
        '#End If

        Dim scriptkey As String = "EditCategoryScriptSupport"
        If Not (Page.IsClientScriptBlockRegistered(scriptkey)) Then
            Page.RegisterClientScriptBlock(scriptkey, Me.javascriptBlock())
        End If

        Me.btnPost.Attributes.Add("onclick", "return checkCateInfo();")

        Me.initLabel()

        If (Not Me.IsPostBack) Then

            Dim editCate As New TCategory

            If Not IsNothing(Request.QueryString("id")) And Request.QueryString("id") <> "" Then
                Dim cm As New CategoryManager
                If cm.LoadInfoByID(CInt(Request.QueryString("id")), editCate) = False Then
                    Call ShowError(12)
                End If
            End If

            Me.edtID.Value = editCate.ID.ToString()
            Me.edtName.Value = editCate.Name

            Me.edtOrder.Value = editCate.Order
            Me.edtCode.Value = editCate.Code

            Me.initParentCategory(editCate)
        End If

        PageTitle = BlogTitle & Messages.MSG_TITLE_SEPARATOR & Messages.MSG_MANAGE_CATEGORY

    End Sub


    Private Sub initParentCategory(ByVal currentCate As TCategory)
        Dim currentCateId As Integer = currentCate.ID
        Dim parentId As Integer = currentCate.ParentID

        Dim li As ListItem
        cmbParentCategory.Items.Clear()

        Dim selected As Boolean = False
        li = New ListItem("", "0")
        If parentId = 0 Then
            li.Selected = True
            selected = True
        End If
        cmbParentCategory.Items.Add(li)

        Dim cm As New CategoryManager
        Dim cates() As TCategory
        cates = cm.GetOrderedCategories()
        If Not cates Is Nothing Then
            For Each c As TCategory In cates
                If (c.ID <> currentCateId) Then
                    li = New ListItem(c.Name, c.ID.ToString())
                    If Not selected AndAlso c.ID = parentId Then
                        li.Selected = True
                    End If
                    cmbParentCategory.Items.Add(li)
                End If
            Next
        End If
    End Sub


    Private Sub initLabel()

        Me.LabelName.Text = Messages.MSG_NAME
        Me.LabelOrder.Text = Messages.MSG_ORDER
        Me.LabelCode.Text = Messages.MSG_ALIAS
        Me.LabelParentCategory.Text = Messages.MSG_PARENT_CATEGORY
        Me.btnPost.Value = Messages.MSG_POST

    End Sub

    Private Function javascriptBlock() As String

        Dim sb As New System.Text.StringBuilder
        sb.Append("<script language=""javascript""><!--") : sb.Append(vbCrLf)
        sb.Append("    var str17=""" & Messages.MSG_NO_EMPTY_NAME & """;") : sb.Append(vbCrLf)
        sb.Append("    function checkCateInfo(){") : sb.Append(vbCrLf)
        'sb.Append("        //document.getElementById(""edit"").action=""../Cmd.aspx?act=CategoryPst"";"): sb.Append(vbcrlf)
        sb.Append("        if(!document.getElementById(""edtName"").value){") : sb.Append(vbCrLf)
        sb.Append("            alert(str17);") : sb.Append(vbCrLf)
        sb.Append("            return false;") : sb.Append(vbCrLf)
        sb.Append("        }") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)
        sb.Append("//--></script>") : sb.Append(vbCrLf)

        Return sb.ToString()

    End Function


    Private Sub btnPost_ServerClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPost.ServerClick

        Dim objCategory As TCategory
        objCategory = New TCategory

        objCategory.ID = CInt(Me.edtID.Value) 'Request.Form("edtID"))
        objCategory.Name = Me.edtName.Value 'Request.Form("edtName")
        objCategory.Order = Me.edtOrder.Value
        objCategory.Code = Me.edtCode.Value 'Request.Form("edtAlias")
        objCategory.ParentID = CInt(Me.cmbParentCategory.SelectedValue)

        If (New CategoryManager).Post(objCategory) Then
            'PostCategory = True
            Response.Redirect("../Cmd.aspx?act=CategoryMng")
        Else
            Call ShowError(12)
        End If

    End Sub

End Class
