Option Explicit On 
Option Strict On

Public Class EditComment
    Inherits BlogPageBase

#Region " Web ɵĴ "

    'õ Web ġ
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub
    Protected WithEvents inpCommentID As System.Web.UI.HtmlControls.HtmlInputHidden
    Protected WithEvents inpLogID As System.Web.UI.HtmlControls.HtmlInputHidden
    Protected WithEvents inpName As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents inpEmail As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents inpArticle As System.Web.UI.HtmlControls.HtmlTextArea
    Protected WithEvents edit As System.Web.UI.HtmlControls.HtmlForm
    Protected WithEvents inpHomepage As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents LabelTitle As System.Web.UI.WebControls.Label
    Protected WithEvents btnPost As System.Web.UI.HtmlControls.HtmlInputButton
    Protected WithEvents LabelName As System.Web.UI.WebControls.Label
    Protected WithEvents LabelEmail As System.Web.UI.WebControls.Label
    Protected WithEvents LabelHomepage As System.Web.UI.WebControls.Label
    Protected WithEvents LabelContent As System.Web.UI.WebControls.Label

    'ע: ռλ Web ġ
    'Ҫɾƶ
    Private designerPlaceholderDeclaration As System.Object

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: ˷ Web 
        'Ҫʹô༭޸
        InitializeComponent()
    End Sub

#End Region

    Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'Ȩ
        '#If DEBUG Then
        'do nothing
        '#Else
        If Not CheckRights("CommentEdt") Then Call ShowError(6)
        '#End If

        PageTitle = BlogTitle & Messages.MSG_TITLE_SEPARATOR & Messages.MSG_ADMIN

        If Not Me.IsPostBack Then
            Dim id As Integer = CInt(Request.QueryString("id"))
            Me.initForm(id)
        End If

    End Sub

    Private Sub initForm(ByVal intID As Integer) ', ByVal intLogID As Integer

        Dim objComment As TComment
        Dim objArticle As TArticle
        objComment = New TComment
        objArticle = New TArticle

        Dim cm As CommentManager = New CommentManager
        Dim am As ArticleManager = New ArticleManager

        If cm.LoadInfoByID(intID, objComment) Then

            Me.LabelName.Text = Messages.MSG_NAME
            Me.LabelEmail.Text = Messages.MSG_EMAIL
            Me.LabelHomepage.Text = Messages.MSG_WEBSITE_URL
            Me.LabelContent.Text = Messages.MSG_CONTENT & "(*)(" & Messages.MSG_COMMENT_MAX_LENGTH & ":" & BlogConfig.CONTENT_MAX & ")"

            Dim objTestArticle As TArticle
            objTestArticle = New TArticle
            If am.LoadInfoByID(objComment.LogID, objTestArticle) Then
                If Not ((objComment.AuthorID = CurrentUser.ID) Or (objTestArticle.AuthorID = CurrentUser.ID) Or (Me.CheckRights("Root") = True)) Then Exit Sub
            Else
                Call ShowError(9)
            End If

            Me.LabelTitle.Text = Messages.MSG_EDIT & Messages.MSG_COMMENT & "(" & objTestArticle.Title & ")"

            Me.inpCommentID.Value = objComment.ID.ToString()
            Me.inpLogID.Value = objComment.LogID.ToString()
            Me.inpName.Value = objComment.Author
            Me.inpEmail.Value = objComment.Email
            Me.inpHomepage.Value = objComment.Homepage
            Me.inpArticle.Value = Server.HtmlEncode(objComment.Content)

            Me.btnPost.Value = Messages.MSG_POST

        End If

    End Sub

    Private Sub btnPost_ServerClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPost.ServerClick

        Dim objComment As TComment

        objComment = New TComment
        objComment.ID = CInt(Me.inpCommentID.Value)  'CInt(Unescape(Request("ID")))
        objComment.LogID = CInt(Me.inpLogID.Value) '(Unescape(Request("inpID")))
        objComment.AuthorID = CInt(CurrentUser.ID)
        objComment.Author = Me.inpName.Value 'Unescape(Request("inpName"))
        objComment.Content = Request(Me.inpArticle.ClientID) 'Unescape(Request("inpArticle"))
        objComment.Email = Me.inpEmail.Value 'Unescape(Request("inpEmail"))
        objComment.Homepage = Me.inpHomepage.Value 'Unescape(Request("inpHomepage"))
        objComment.PostTime = Now()

        Dim sameComment As Boolean
        Dim pcm As New PageCommentManager(Me.BlogContext)

        If pcm.Post(objComment, sameComment) Then
            Response.Redirect("Admin.aspx?act=CommentMng")
        Else
            If sameComment Then
                ShowError(38, Messages.MSG_REPEATE_POST_SAME_CONTENT)
            Else
                ShowError(38)
            End If
        End If

    End Sub

End Class
