Option Explicit On 
Option Strict On

Imports System.Web
Imports System.Web.UI.WebControls

Public Class EditUser
    Inherits BlogPageBase

#Region " Web ɵĴ "

    'õ Web ġ
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub
    Protected WithEvents edit As System.Web.UI.HtmlControls.HtmlForm
    Protected WithEvents edtName As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtEmail As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents btnPost As System.Web.UI.HtmlControls.HtmlInputButton
    Protected WithEvents edtID As System.Web.UI.HtmlControls.HtmlInputHidden
    Protected WithEvents cmbUserLevel As System.Web.UI.WebControls.DropDownList
    Protected WithEvents LabelLevel As System.Web.UI.WebControls.Label
    Protected WithEvents LabelName As System.Web.UI.WebControls.Label
    Protected WithEvents LabelPassword As System.Web.UI.WebControls.Label
    Protected WithEvents LabelEmail As System.Web.UI.WebControls.Label
    Protected WithEvents LabelHomepage As System.Web.UI.WebControls.Label
    Protected WithEvents edtPassword As System.Web.UI.HtmlControls.HtmlInputText
    Protected WithEvents edtHomepage As System.Web.UI.HtmlControls.HtmlInputText

    'ע: ռλ Web ġ
    'Ҫɾƶ
    Private designerPlaceholderDeclaration As System.Object

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: ˷ Web 
        'Ҫʹô༭޸
        InitializeComponent()
    End Sub

#End Region

    Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'Ƿ
        Call CheckReference("")

        'Ȩ
        If Not CheckRights("UserEdt") Then Call ShowError(6)

        Dim scriptkey As String = "EditUserScriptSupport"
        If Not (Page.IsClientScriptBlockRegistered(scriptkey)) Then
            Page.RegisterClientScriptBlock(scriptkey, Me.javascriptBlock())
        End If

        Me.btnPost.Attributes.Add("onclick", "return checkUserInfo();")

        If (Not Me.IsPostBack) Then

            Me.initLabel()

            Dim editUser As New TUser

            editUser.Level = 4
            editUser.Name = ""
            editUser.Email = "a@b.com"

            If Not IsNothing(Request.QueryString("id")) And Request.QueryString("id") <> "" Then
                Dim um As New UserManager
                If um.LoadInfoByID(CInt(Request.QueryString("id")), editUser) = False Then
                    Call ShowError(16)
                Else
                    If (editUser.ID <> CurrentUser.ID) And (CheckRights("Root") = False) Then Call ShowError(6)
                End If
            End If

            Me.edtID.Value = editUser.ID.ToString()
            Me.edtName.Value = editUser.Name
            Me.edtEmail.Value = editUser.Email
            Me.edtHomepage.Value = editUser.Homepage

            Me.initUserLevel(editUser)

        End If

        PageTitle = BlogTitle & Messages.MSG_TITLE_SEPARATOR & Messages.MSG_MANAGE_USER

    End Sub


    Private Sub initLabel()

        Me.LabelLevel.Text = Messages.MSG_TYPE

        Me.LabelName.Text = Messages.MSG_NAME
        Me.LabelPassword.Text = Messages.MSG_PASSWORD
        Me.LabelEmail.Text = Messages.MSG_EMAIL
        Me.LabelHomepage.Text = Messages.MSG_WEBSITE_URL

        Me.btnPost.Value = Messages.MSG_EDIT

    End Sub


    Private Sub initUserLevel(ByVal editUser As TUser)

        Dim userLevel As String
        Dim i As Integer
        Dim li As ListItem

        i = 0
        Me.cmbUserLevel.Items.Clear()
        For Each userLevel In Messages.USER_ROLE_NAMES
            li = New ListItem(Messages.USER_ROLE_NAMES(i), i.ToString())
            Me.cmbUserLevel.Items.Add(li)
            If i = editUser.Level Then
                li.Selected = True 'Response.Write("selected=""selected""")
            End If
            i = i + 1
        Next

    End Sub


    Private Function javascriptBlock() As String

        Dim sb As New System.Text.StringBuilder

        sb.Append("<script language=""javascript"">") : sb.Append(vbCrLf)
        sb.Append("<!--") : sb.Append(vbCrLf)

        sb.Append("    var str13=""" & Messages.MSG_NO_EMPTY_NAME & """;") : sb.Append(vbCrLf)
        sb.Append("    var str14=""" & Messages.MSG_NO_EMPTY_PASSWORD & """;") : sb.Append(vbCrLf)
        sb.Append("    var str15=""" & Messages.MSG_NO_EMPTY_EMAIL & """;") : sb.Append(vbCrLf)
        sb.Append("    var str16=""" & Messages.MSG_PASSWORD_TOO_SHORT & """;") : sb.Append(vbCrLf)

        sb.Append("    function checkUserInfo(){") : sb.Append(vbCrLf)
        sb.Append("            if(document.getElementById(""edtName"").value==""""){") : sb.Append(vbCrLf)
        sb.Append("                alert(str13);") : sb.Append(vbCrLf)
        sb.Append("                return false;") : sb.Append(vbCrLf)
        sb.Append("            }") : sb.Append(vbCrLf)
        sb.Append("            if(document.getElementById(""edtEmail"").value==""""){") : sb.Append(vbCrLf)
        sb.Append("                alert(str15);") : sb.Append(vbCrLf)
        sb.Append("                return false;") : sb.Append(vbCrLf)
        sb.Append("            }") : sb.Append(vbCrLf)
        sb.Append("            if(document.getElementById(""edtPassword"").value){") : sb.Append(vbCrLf)
        sb.Append("                if(document.getElementById(""edtPassword"").value==""""){") : sb.Append(vbCrLf)
        sb.Append("                    alert(str14);") : sb.Append(vbCrLf)
        sb.Append("                    return false;") : sb.Append(vbCrLf)
        sb.Append("                }") : sb.Append(vbCrLf)
        sb.Append("                else if((document.getElementById(""edtPassword"").value).length<=5){") : sb.Append(vbCrLf)
        sb.Append("                    alert(str16);") : sb.Append(vbCrLf)
        sb.Append("                    return false;") : sb.Append(vbCrLf)
        sb.Append("                }") : sb.Append(vbCrLf)
        sb.Append("            }") : sb.Append(vbCrLf)
        sb.Append("            if(document.getElementById(""edtPassword"").value){") : sb.Append(vbCrLf)
        sb.Append("                document.getElementById(""edtPassword"").value=MD5(document.getElementById(""edtPassword"").value);") : sb.Append(vbCrLf)
        sb.Append("            }") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)
        sb.Append("    ") : sb.Append(vbCrLf)
        sb.Append("//--></script>") : sb.Append(vbCrLf)

        Return sb.ToString()

    End Function


    Private Sub btnPost_ServerClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPost.ServerClick

        Dim objUser As TUser

        objUser = New TUser

        objUser.ID = CInt(Me.edtID.Value) 'CInt(Request.Form("edtID"))
        objUser.Level = CInt(Me.cmbUserLevel.SelectedValue) 'CInt(Request.Form("edtLevel"))
        objUser.Name = Me.edtName.Value 'Request.Form("edtName")
        objUser.Password = Me.edtPassword.Value 'Request.Form("edtPassword")
        objUser.Email = Me.edtEmail.Value 'Request.Form("edtEmail")
        objUser.Homepage = Me.edtHomepage.Value 'Request.Form("edtHomepage")

        If Not ((CInt(objUser.ID) = CurrentUser.ID) Or (CheckRights("Root") = True)) Then
            ShowError(6)
            Exit Sub
        End If

        'Try
        Dim um As New PageUserManager(Me.BlogContext)
        If um.Edit(objUser, Me.CurrentUser) Then
            Response.Redirect("Admin.aspx?act=UserMng")
        Else
            ShowError(16)
        End If
        'Catch ex As Exception
        'ShowError(16, ex.Message)
        'End Try

    End Sub


End Class
