Option Explicit On 
Option Strict On

Imports System.Collections

Public Class BlogPageBase
    Inherits System.Web.UI.Page

    Public Sub New()
        Me.startTime = Timer()
    End Sub

    Private _pageTitle As String = Nothing
    Protected Property PageTitle() As String
        Get
            Return _pageTitle
        End Get
        Set(ByVal Value As String)
            _pageTitle = Value
        End Set
    End Property



#Region "BlogϢ"

    Public ReadOnly Property BlogRootUrl() As String
        Get
#If DEBUG Then
            Return "http://localhost/WSBLog/"
#Else
            Return System.Configuration.ConfigurationSettings.AppSettings.Get("blogRootUrl")
#End If
        End Get
    End Property

    Public ReadOnly Property BlogGuid() As String
        Get
#If DEBUG Then
            Return "60E32840-F51D-4520-A8DE-4FEF627D5022"
#Else
            Return System.Configuration.ConfigurationSettings.AppSettings.Get("blogGuid")
#End If
        End Get
    End Property

    Private _blogPath As String = Nothing
    Public ReadOnly Property BlogPath() As String
        Get
            If Me._blogPath Is Nothing Then
                Me._blogPath = Me.getBlogRootDirectory()
            End If
            Return Me._blogPath
        End Get
    End Property

    '*********************************************************
    ' Ŀģ    õBlogĸĿ¼
    '*********************************************************
    Protected Function getBlogRootDirectory() As String
        Dim mapPath As String = Server.MapPath(Nothing)
        Dim flagFile As String = "E73FCAF8-44E9-41fc-B43B-1769206B1193.txt"
        If System.IO.File.Exists(System.IO.Path.Combine(mapPath, flagFile)) Then
            'Return mapPath
        ElseIf System.IO.File.Exists(System.IO.Path.Combine(mapPath, "../" & flagFile)) Then
            mapPath = System.IO.Path.Combine(mapPath, "../")
        ElseIf System.IO.File.Exists(System.IO.Path.Combine(mapPath, "../../" & flagFile)) Then
            mapPath = System.IO.Path.Combine(mapPath, "../../")
        Else
            'Return mapPath
        End If
        Return System.IO.Path.GetFullPath(mapPath)
    End Function

#End Region


    Private _blogConfig As BlogConfiguration
    Public ReadOnly Property BlogConfig() As BlogConfiguration
        Get
            If Me._blogConfig Is Nothing Then

                Try
                    'Dim filepath As String
                    ''#If DEBUG Then
                    ''                    filepath = System.Reflection.Assembly.GetExecutingAssembly().CodeBase
                    ''                    filepath = System.IO.Path.GetDirectoryName(filepath)
                    ''                    filepath = System.IO.Path.Combine(filepath, "../blogconfig.xml")
                    ''#Else
                    'filepath = System.IO.Path.Combine(Me.BlogPath, "blogconfig.xml")
                    ''#End If
                    'Me._blogConfig = BlogConfiguration.LoadFromFile(filepath)
                    Me._blogConfig = Me.GlobalCache.BlogConfig
                Catch ex As Exception
                    System.Diagnostics.Debug.WriteLine(ex.Message)
                End Try
                '#If DEBUG Then
                If Me._blogConfig Is Nothing Then
                    Me._blogConfig = New BlogConfiguration
                    'Try
                    '    Me._blogConfig.ReadFromConfigFile()
                    'Catch
                    'End Try
                End If
                '#End If
            End If

            'עBlogĸURLǴblogconfig.xmlеģǴڳļе
            Me._blogConfig.BlogRootUrl = BlogRootUrl

            Return Me._blogConfig
        End Get
    End Property


    Private _messages As BlogMessages = Nothing

    Public ReadOnly Property Messages() As BlogMessages
        Get
            If Me._messages Is Nothing Then
                Try
                    Me._messages = Me.GlobalCache.BlogMessages
                Catch ex As Exception
                    System.Diagnostics.Debug.WriteLine(ex.Message)
                End Try
                If Me._messages Is Nothing Then
                    Me._messages = New BlogMessages
                    Dim filepath As String = System.IO.Path.Combine(Me.BlogPath, "blogmessages.xml")
                    If Not System.IO.File.Exists(filepath) Then
                        Me.Messages.Save(filepath)
                    End If
                End If
            End If
            Return Me._messages
        End Get
    End Property


#Region "Blog Context"

    'Protected BlogTitle
    'Protected BlogUser As TUser

    Private _blogContext As BlogPageContext = Nothing

    Protected ReadOnly Property BlogContext() As BlogPageContext

        Get
            If (Me._blogContext Is Nothing) Then
                Me._blogContext = New BlogPageContext(Me, Me.Context)
            End If
            Return Me._blogContext
        End Get

    End Property


    '**************************************************
    'ȫķ
    '**************************************************
    'Private fCategories() As TCategory = Nothing
    'Public ReadOnly Property Categories() As TCategory()
    '    Get
    '        If IsNothing(Me.fCategories) Then
    '            Dim cm As CategoryManager = New CategoryManager
    '            Me.fCategories = cm.GetCategoriesArray()
    '        End If
    '        Return Me.fCategories
    '    End Get
    'End Property
    'Public Sub RefreshCategories()
    '    Dim cm As CategoryManager = New CategoryManager
    '    Me.fCategories = cm.GetCategoriesArray()
    'End Sub

    Private _categories As PageCategoryCache = Nothing
    Public ReadOnly Property Categories() As PageCategoryCache
        Get
            If IsNothing(Me._categories) Then
                Me._categories = New PageCategoryCache(Me.BlogContext)
            End If
            Return Me._categories
        End Get
    End Property

    '****************************************************
    'ȫû
    '****************************************************
    'Private fUsers() As TUser = Nothing
    'Public ReadOnly Property Users() As TUser()
    '    Get
    '        If IsNothing(Me.fUsers) Then
    '            Dim um As UserManager = New UserManager
    '            Me.fUsers = um.GetUsers()
    '        End If
    '        Return Me.fUsers
    '    End Get
    'End Property
    'Public Sub RefreshUsers()
    '    Dim um As UserManager = New UserManager
    '    Me.fUsers = um.GetUsers()
    'End Sub

    Private _users As PageUserCache = Nothing
    Public ReadOnly Property Users() As PageUserCache
        Get
            If IsNothing(Me._users) Then
                Me._users = New PageUserCache(Me.BlogContext)
            End If
            Return Me._users
        End Get
    End Property

    '****************************************************
    'ȫıǩ
    '****************************************************
    'Private fTags() As TTag = Nothing
    'Public ReadOnly Property Tags() As TTag()
    '    Get
    '        If IsNothing(Me.fTags) Then
    '            Dim tm As TagManager = New TagManager
    '            Me.fTags = tm.GetTags()
    '        End If
    '        Return Me.fTags
    '    End Get
    'End Property

    Private _tags As PageTagCache = Nothing
    Public ReadOnly Property Tags() As PageTagCache
        Get
            If IsNothing(Me._tags) Then
                Me._tags = New PageTagCache(Me.BlogContext)
            End If
            Return Me._tags
        End Get
    End Property

#End Region


    Protected LoginType As String = "Cookies"

    Private fBlogUser As PageUser = Nothing

    '*********************************************************
    'ȡõǰûϢ
    '*********************************************************
    Public ReadOnly Property CurrentUser() As PageUser
        Get

            If fBlogUser Is Nothing Then
                fBlogUser = New PageUser(Me.BlogContext)
                fBlogUser.LoginType = Me.LoginType
                Dim pum As New PageUserManager(Me.BlogContext)
                Try
                    pum.Verify(fBlogUser)
                Catch ex As Exception
                    '
                End Try
            End If

            Return fBlogUser
        End Get
    End Property

    Private _globalCache As GlobalCache
    Public ReadOnly Property GlobalCache() As GlobalCache
        Get
            If (Me._globalCache Is Nothing) Then
                Me._globalCache = New GlobalCache(Me.BlogContext)
            End If
            Return Me._globalCache
        End Get
    End Property


    Private startTime As Double

    '*********************************************************
    ' Ŀģ    ʱƳ
    '*********************************************************
    Public Function RunTime() As String
        Dim EndTime As Double = Timer()
        RunTime = CStr(CLng(FormatNumber((EndTime - startTime) * 1000, 3))) & "ms"
    End Function


    '*********************************************************
    ' Ŀģ    Ȩ
    '*********************************************************
    Public Function CheckRights(ByVal strAction As String) As Boolean
        Dim i As Integer
        i = RightsHelper.GetRights(strAction)
        If i < 0 Then
            ShowError(Messages.MSG_ERROR_CMD_OR_UNFINISHED_FUNC)
        End If
        If CurrentUser.Level > i Then
            CheckRights = False
        Else
            CheckRights = True
        End If
    End Function

    'Private Function GetRights(ByVal strAction As String) As Integer
    '    'Dim i As Integer
    '    Return RightsHelper.GetRights(strAction)
    '    'If i < 0 Then
    '    'ShowError(1)
    '    'End If
    'End Function


#Region ""

    'Protected Function FilterSQL(ByVal strSQL As String) As String
    '    Return StringHelper.FilterSQL(strSQL)
    'End Function

    Protected Function LoadFromFile(ByVal strFullName As String, ByVal strCharset As String) As String
        Return TextFileHelper.LoadFromFile(strFullName, strCharset)
    End Function

    Protected Sub SaveToFile(ByVal strFullName As String, ByVal strContent As String, ByVal strCharset As String)
        TextFileHelper.SaveToFile(strFullName, strContent, strCharset)
    End Sub

    Protected Sub ShowError(ByVal id As Integer)
        Me.ShowError(id, Nothing)
    End Sub

    Protected Sub ShowError(ByVal description As String)
        Me.ShowError(0, description)
    End Sub

    Protected Sub ShowError(ByVal id As Integer, ByVal description As String)
        Dim url As String
        url = Me.BlogRootUrl & "ADMIN/Error.aspx"
        ErrorHelper.ShowError(id, description, url, Me.Context)
    End Sub


    '*********************************************************
    ' Ŀģ    
    ' أ    
    '*********************************************************
    Protected Sub CheckReference(ByVal strDestination As String)

        Exit Sub

        Dim strReferer As String
        strReferer = CStr(Request.ServerVariables("HTTP_REFERER"))

        If InStr(strReferer, Me.BlogRootUrl) = 0 Then
            ShowError(5)
        End If

    End Sub

    Function CheckRegExp(ByVal source As String, ByVal para As String) As Boolean
        Return StringHelper.CheckRegExp(source, para)
    End Function

    '*********************************************************
    ' Ŀģ    JavaScriptescapeַ
    ' 룺    escapeַ
    '*********************************************************
    Protected Function Unescape(ByVal source As String) As String
        Return JSEscapeUnescape.Unescape(source)
    End Function

    Protected Function Escape(ByVal source As String) As String
        Return JSEscapeUnescape.Escape(source)
    End Function

#End Region



    Private _ubbHtmlHandler As IUbbHtmlHandler

    Public ReadOnly Property UbbHtmlHandler() As IUbbHtmlHandler

        Get

            If Me._ubbHtmlHandler Is Nothing Then


                Dim ubbhtml As New RegexUbbHtmlHandler

                ubbhtml.HintMessagePlayPauseMedia = Me.Messages.MSG_PLAY_PAUSE_MEDIA
                ubbhtml.HintMessageQuoteFrom = Me.Messages.MSG_QUOTE_FROM
                ubbhtml.HintMessageClick2Download = Me.Messages.MSG_CLICK_TO_DOWNLOAD


                ubbhtml.AbsoluteWebSiteUrl = Me.BlogRootUrl

                ubbhtml.AutoNewLineEnable = Me.BlogConfig.AUTO_NEWLINE
                ubbhtml.LinkNofollowEnable = Me.BlogConfig.COMMENT_NOFOLLOW_ENABLE
                ubbhtml.Japanese2HtmlEntityEnable = Me.BlogConfig.JAPANESE_TO_HTML_ENTITIES

                ubbhtml.UbbEmotionFaceSize = Me.BlogConfig.EMOTICONS_FILESIZE
                ubbhtml.UbbLinkEnable = Me.BlogConfig.UBB_LINK_ENABLE
                ubbhtml.UbbFontEnable = Me.BlogConfig.UBB_FONT_ENABLE
                ubbhtml.UbbCodeEnable = Me.BlogConfig.UBB_CODE_ENABLE
                ubbhtml.UbbEmotionFaceEnable = Me.BlogConfig.UBB_FACE_ENABLE
                ubbhtml.UbbImageEnable = Me.BlogConfig.UBB_IMAGE_ENABLE
                ubbhtml.UbbMediaEnable = Me.BlogConfig.UBB_MEDIA_ENABLE
                ubbhtml.UbbFlashEnable = Me.BlogConfig.UBB_FLASH_ENABLE
                ubbhtml.UbbTypesetEnable = Me.BlogConfig.UBB_TYPESET_ENABLE
                ubbhtml.UbbAutoLinkEnable = Me.BlogConfig.UBB_AUTOLINK_ENABLE
                ubbhtml.UbbAutoKeywordEnable = Me.BlogConfig.UBB_AUTOKEY_ENABLE
                ubbhtml.UbbUploadEnable = Me.BlogConfig.UBB_UPLOAD_ENABLE

                Me._ubbHtmlHandler = ubbhtml
            End If

            Return Me._ubbHtmlHandler

        End Get

    End Property



#Region "Blog "

    Public ReadOnly BlogTitle As String = BlogConfig.BlogTitle
    Public ReadOnly BlogSubTitle As String = BlogConfig.BlogSubTitle
    Public ReadOnly BlogName As String = BlogConfig.BlogName
    Public ReadOnly BlogSubName As String = BlogConfig.BlogSubName
    Public ReadOnly BlogLanguage As String = BlogConfig.BlogLanguage  '= "zh-CN"	

    Public ReadOnly WebSiteDescription As String = BlogConfig.WebSiteDescription
    Public ReadOnly WebSiteKeywords As String = BlogConfig.WebSiteKeywords

#End Region


End Class


Public Class PageUserCache

    Public Sub New(ByVal context As BlogPageContext)
        Me._context = context
    End Sub

    Private _context As BlogPageContext

    Public Function UnknownUser() As TUser
        Dim u As New TUser
        u.Name = Me._context.Messages.MSG_UNKNOWN_USER
        u.Intro = Me._context.Messages.MSG_UNKNOWN_USER
        Return u
    End Function

    Private _tableUsers As System.Collections.Hashtable
    Default Public Property Item(ByVal id As Integer) As TUser
        Get
            Dim u As TUser = Nothing
            If Not (Me._context.GlobalCache.BlogIndex Is Nothing) Then
                u = Me._context.GlobalCache.BlogIndex.GetUserInfoById(id)
            End If
            If Not u Is Nothing Then
                'Me._tableUsers(id) = u 'ѾGlobalCacheлˣԲ
                Return u
            End If
            'ڱػв
            If Not Me._tableUsers Is Nothing AndAlso Me._tableUsers.Contains(id) Then
                Return CType(Me._tableUsers(id), TUser)
            End If
            'ݿв
            u = Me.getUserInfo(id)
            If Not u Is Nothing Then
                If (Me._tableUsers Is Nothing) Then Me._tableUsers = New System.Collections.Hashtable
                Me._tableUsers(id) = u
                Return u
            End If
            Return UnknownUser() 'Return Nothing
        End Get
        Set(ByVal Value As TUser)
            If (Me._tableUsers Is Nothing) Then Me._tableUsers = New System.Collections.Hashtable
            Me._tableUsers(id) = Value
        End Set
    End Property

    Private Function getUserInfo(ByVal id As Integer) As TUser
        Dim um As New UserManager
        Dim userInfo As New TUser
        If um.LoadInfoByID(id, userInfo) Then
            Return userInfo
        Else
            Return Nothing
        End If
    End Function

End Class


Public Class PageCategoryCache

    Public Sub New(ByVal context As BlogPageContext)
        Me._context = context
    End Sub

    Private _context As BlogPageContext

    Public Function UnknownCategory() As TCategory
        Dim c As New TCategory
        c.Intro = Me._context.Messages.MSG_UNKNOWN_CATEGORY
        c.Name = Me._context.Messages.MSG_UNKNOWN_CATEGORY
        Return c
    End Function

    Private _tableCategories As System.Collections.Hashtable
    Default Public Property Item(ByVal id As Integer) As TCategory
        Get
            Dim c As TCategory = Nothing
            If Not (Me._context.GlobalCache.BlogIndex Is Nothing) Then
                c = Me._context.GlobalCache.BlogIndex.GetCategoryInfoById(id)
            End If
            If Not c Is Nothing Then
                'Me._tableCategories(id) = c'GlobalCacheѾ
                Return c
            End If
            'ұػ
            If Not Me._tableCategories Is Nothing AndAlso Me._tableCategories.Contains(id) Then
                Return CType(Me._tableCategories(id), TCategory)
            End If
            'ݿв
            c = Me.getCategoryInfo(id)
            If Not c Is Nothing Then
                If (Me._tableCategories Is Nothing) Then Me._tableCategories = New System.Collections.Hashtable
                Me._tableCategories(id) = c
                Return c
            End If
            Return UnknownCategory() 'עŻһδֹ֪࣬߿ó
        End Get
        Set(ByVal Value As TCategory)
            If (Me._tableCategories Is Nothing) Then Me._tableCategories = New System.Collections.Hashtable
            Me._tableCategories(id) = Value
        End Set
    End Property

    Private Function getCategoryInfo(ByVal id As Integer) As TCategory
        Dim cm As New CategoryManager
        Dim cateInfo As New TCategory
        If cm.LoadInfoByID(id, cateInfo) Then
            Return cateInfo
        Else
            Return Nothing
        End If
    End Function

End Class



Public Class PageTagCache

    Public Sub New(ByVal context As BlogPageContext)
        Me._context = context
        'Me.loadCache()
    End Sub

    'Private Sub loadCache()
    '    Dim idx As BlogIndex = Me._context.GlobalCache.BlogIndex
    '    If Not idx Is Nothing Then
    '        If Not idx.Tags Is Nothing Then
    '            For Each tag As TTag In idx.Tags
    '                If Not tag Is Nothing Then
    '                    Me._tableTag.Add(tag.ID, tag)
    '                End If
    '            Next
    '        End If
    '    End If
    'End Sub

    Private _context As BlogPageContext

    Private _tableTags As System.Collections.Hashtable

    Default Public Property Item(ByVal id As Integer) As TTag
        Get
            Dim t As TTag
            If Not (Me._context.GlobalCache.BlogIndex Is Nothing) Then
                t = Me._context.GlobalCache.BlogIndex.GetTagInfoById(id)
            End If
            If Not t Is Nothing Then
                'Me._tableTags(id) = t
                Return t
            End If
            'ڱػв
            If Not Me._tableTags Is Nothing AndAlso Me._tableTags.Contains(id) Then
                Return CType(Me._tableTags(id), TTag)
            End If
            'ݿв
            t = Me.getTagInfo(id)
            If Not t Is Nothing Then
                If (Me._tableTags Is Nothing) Then Me._tableTags = New System.Collections.Hashtable
                Me._tableTags(id) = t
                Return t
            End If
            Return Nothing
        End Get
        Set(ByVal Value As TTag)
            If (Me._tableTags Is Nothing) Then Me._tableTags = New System.Collections.Hashtable
            Me._tableTags(id) = Value
        End Set
    End Property

    Public Function GetTagInfoByName(ByVal strTagName As String) As TTag

        Dim t As TTag
        If Not (Me._context.GlobalCache.BlogIndex Is Nothing) Then
            t = Me._context.GlobalCache.BlogIndex.GetTagInfoByName(strTagName)
        End If
        If Not t Is Nothing Then
            'Me._tableTags(id) = t
            Return t
        End If
        'ڱػв
        If Not Me._tableTags Is Nothing Then
            For Each entry As DictionaryEntry In Me._tableTags
                t = CType(entry.Value, TTag)
                If t.Name = strTagName Then
                    Return t
                End If
            Next
        End If
        'ݿв
        t = Me.getTagInfo(strTagName)
        If Not t Is Nothing Then
            If (Me._tableTags Is Nothing) Then Me._tableTags = New System.Collections.Hashtable
            Me._tableTags.Add(t.ID, t) 'ڱػ
            Return t
        End If

        Return Nothing
    End Function

    Private Function getTagInfo(ByVal id As Integer) As TTag
        Dim tm As New TagManager
        Dim tagInfo As New TTag
        If tm.LoadInfoByID(id, tagInfo) Then
            Return tagInfo
        Else
            Return Nothing
        End If
    End Function

    Private Function getTagInfo(ByVal name As String) As TTag
        Dim tm As New TagManager
        Dim tagInfo As New TTag
        If tm.LoadInfoByName(name, tagInfo) Then
            Return tagInfo
        Else
            Return Nothing
        End If
    End Function


End Class