Option Explicit On 
Option Strict On

Imports System.Web

Public Class BlogPageContext


    Private _httpContext As HttpContext
    Public Property HttpContext() As HttpContext
        Get
            Return Me._httpContext
        End Get
        Set(ByVal Value As HttpContext)
            Me._httpContext = Value
        End Set
    End Property


    Private _page As BlogPageBase
    Public Property Page() As BlogPageBase
        Get
            Return Me._page
        End Get
        Set(ByVal Value As BlogPageBase)
            Me._page = Value
        End Set
    End Property


    Public ReadOnly Property Categories() As PageCategoryCache
        Get
            Return Me.Page.Categories
        End Get
    End Property

    Public ReadOnly Property Users() As PageUserCache
        Get
            Return Me.Page.Users
        End Get
    End Property

    Public ReadOnly Property Tags() As PageTagCache
        Get
            Return Me.Page.Tags
        End Get
    End Property


    Public ReadOnly Property GlobalCache() As GlobalCache
        Get
            Return Me.Page.GlobalCache
        End Get
    End Property


    'Public Keywords(,) As String
    Public ReadOnly Property BlogPath() As String
        Get
            Return Me.Page.BlogPath
        End Get
    End Property

    Public ReadOnly Property CurrentUser() As PageUser
        Get
            Return Me.Page.CurrentUser
        End Get
    End Property


    Public ReadOnly Property Messages() As BlogMessages
        Get
            Return Page.Messages
        End Get
    End Property


    Public ReadOnly Property BlogConfig() As BlogConfiguration
        Get
            Return Page.BlogConfig
        End Get
    End Property

    Public ReadOnly Property UbbHtmlHandler() As IUbbHtmlHandler
        Get
            Return Page.UbbHtmlHandler
        End Get
    End Property


    Public Sub New(ByVal page As BlogPageBase, ByVal httpContext As HttpContext)
        Me.Page = page
        Me.HttpContext = httpContext
    End Sub


End Class
