Option Explicit On 
Option Strict On

Imports System.IO
Imports System.Collections
Imports com.oucsoft.WSORM

Public Class ArticleManager
    Inherits BusinessRulesBase


    Public Function GetTagArticles(ByVal pagesize As Integer, ByVal intPage As Integer, ByVal intTagId As Integer) As TArticle()

        Dim s As String
        s = "(TagID=" & intTagId.ToString() & ") ORDER BY ArticleID DESC"

        Dim offset As Integer = (intPage - 1) * pagesize + 1
        Dim limitcount As Integer = pagesize

        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TTagArticle)).IsView = True
        session.ObjectMaps(GetType(TTagArticle)).MemberMaps("ArticleInfo").CascadedQuery = True
        session.ObjectMaps(GetType(TArticle)).IsView = True        'session.ObjectMaps(GetType(TTag)).IsView = True
        'If ignoreContent Then
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        'End If

        Dim tagArticles() As TTagArticle
        tagArticles = CType(session.Query(GetType(TTagArticle), s, offset, limitcount), TTagArticle())
        If tagArticles Is Nothing OrElse tagArticles.Length <= 0 Then
            Return Nothing
        End If
        Dim articles As New ArrayList
        For Each tagArticle As TTagArticle In tagArticles
            If Not (tagArticle.ArticleInfo Is Nothing) Then 'AndAlso (tagArticle.ArticleInfo.Level >= minLevel) Then
                articles.Add(tagArticle.ArticleInfo)
            End If
        Next
        Return CType(articles.ToArray(GetType(TArticle)), TArticle())

    End Function

    Public Function GetTagArticles(ByVal intTagID As Integer, ByVal minLevel As Integer, ByVal ignoreContent As Boolean, ByVal ignoreIntro As Boolean, ByVal maxCount As Integer) As TArticle()

        'Dim s As String
        's = "(ID>0) AND (Level>=" & minLevel.ToString() & ") AND (Tag LIKE '%{" & intTagID & "}%') ORDER BY ID DESC"
        'Dim session As ISession = Me.SessionFactory.CreateSession()
        'session.ObjectMaps(GetType(TArticle)).IsView = True
        'If ignoreContent Then
        '    session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        'End If
        'Dim articles() As TArticle
        'articles = CType(session.Query(GetType(TArticle), s, maxCount), TArticle())
        'Return articles

        Dim s As String
        s = "(TagID=" & intTagID.ToString() & ") ORDER BY ArticleID DESC"
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TTagArticle)).IsView = True
        session.ObjectMaps(GetType(TTagArticle)).MemberMaps("ArticleInfo").CascadedQuery = True
        session.ObjectMaps(GetType(TArticle)).IsView = True        'session.ObjectMaps(GetType(TTag)).IsView = True

        If ignoreContent Then
            session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        End If
        If ignoreIntro Then
            session.ObjectMaps(GetType(TArticle)).MemberMaps("Intro").Ignored = True
        End If

        Dim tagArticles() As TTagArticle
        tagArticles = CType(session.Query(GetType(TTagArticle), s, maxCount), TTagArticle())
        If tagArticles Is Nothing OrElse tagArticles.Length <= 0 Then
            Return Nothing
        End If
        Dim articles As New ArrayList
        For Each tagArticle As TTagArticle In tagArticles
            If Not (tagArticle.ArticleInfo Is Nothing) AndAlso (tagArticle.ArticleInfo.Level >= minLevel) Then
                articles.Add(tagArticle.ArticleInfo)
            End If
        Next
        Return CType(articles.ToArray(GetType(TArticle)), TArticle())

    End Function


    Public Function GetCategoryArticles(ByVal intCateID As Integer, ByVal minLevel As Integer, ByVal ignoreContent As Boolean, ByVal maxCount As Integer) As TArticle()
        'strSql = "SELECT * FROM [blog_Article] WHERE ([log_ID]>0) AND ([log_Level]>=" & minLevel.ToString() & ") AND ([log_CateID]=" & intCateID & ") ORDER BY [log_PostTime] DESC"
        Dim s As String
        s = "(ID>0) AND (Level>=" & minLevel.ToString() & ") AND (CateID=" & intCateID & ") ORDER BY ID DESC"
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True
        If ignoreContent Then
            session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        End If
        Dim articles() As TArticle
        articles = CType(session.Query(GetType(TArticle), s, maxCount), TArticle())
        Return articles
    End Function


    Public Function GetAllArticles(ByVal minLevel As Integer, ByVal ignoreContent As Boolean, ByVal maxCount As Integer) As TArticle()
        'strSql = "SELECT * FROM [blog_Article] WHERE ([log_ID]>0) AND ([log_Level]>=" & minLevel.ToString() & ") ORDER BY [log_PostTime] DESC"
        Dim s As String
        s = "(ID>0) AND (Level>=" & minLevel.ToString() & ") ORDER BY ID DESC"
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True
        If ignoreContent Then
            session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        End If
        Dim articles() As TArticle
        articles = CType(session.Query(GetType(TArticle), s, maxCount), TArticle())
        Return articles
    End Function


    '*************************************************************
    'ĳҳµID
    '*************************************************************
    Public Function GetArticlesByPage(ByVal pagesize As Integer, ByVal page As Integer, ByVal minLevel As Integer, ByVal ignoreContent As Boolean, ByVal ignoreIntro As Boolean) As TArticle()
        Dim s As String = "Level>=" & minLevel.ToString()
        Dim offset As Integer = pagesize * (page - 1) + 1
        Dim limitcount As Integer = pagesize
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = ignoreContent
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Intro").Ignored = ignoreIntro
        Dim articles() As TArticle
        articles = CType(session.Query(GetType(TArticle), s, offset, limitcount), TArticle())
        Return articles
    End Function


    'Public Function GetPageArticleIds(ByVal pagesize As Integer, ByVal page As Integer, ByVal minLevel As Integer) As Integer()
    '    Dim allID As New ArrayList
    '    Dim s As String = "Level>=" & minLevel.ToString()
    '    Dim offset As Integer = pagesize * (page - 1) + 1
    '    Dim limitcount As Integer = pagesize
    '    Dim session As ISession = Me.SessionFactory.CreateSession()
    '    session.ObjectMaps(GetType(TArticle)).IsView = True
    '    session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
    '    session.ObjectMaps(GetType(TArticle)).MemberMaps("Intro").Ignored = True
    '    Dim articles() As TArticle
    '    articles = CType(session.Query(GetType(TArticle), s, offset, limitcount), TArticle())
    '    If Not articles Is Nothing AndAlso articles.Length > 0 Then
    '        For i As Integer = 0 To articles.Length - 1
    '            allID.Add(articles(i).ID)
    '        Next
    '    End If
    '    Return CType(allID.ToArray(GetType(Integer)), Integer())
    'End Function


    ''**************************************************************************
    ''ȡöµID
    ''**************************************************************************
    'Public Function GetAllTopArticleIDs() As Integer()
    '        objRS.Open("SELECT [log_ID] FROM [blog_Article] WHERE [log_Level]>1 AND [log_IsTop]=1 ORDER BY [log_PostTime] DESC")
    'End Function


    '****************************************************
    'ȡ
    '****************************************************
    Public Function GetTotalCount() As Integer
        'objRS.Open("SELECT COUNT([log_ID])AS allArticle,SUM([log_CommNums]) AS allCommNums,SUM([log_TrackbackNums]) AS allTrackbackNums FROM [blog_Article]")
        Dim session As ISession = Me.SessionFactory.CreateSession()
        Return session.QueryCount(GetType(TArticle), Nothing)
    End Function


    Public Function GetMonthArchivesStat(ByVal maxcount As Integer) As String()

        Dim dtMaxYM As DateTime
        Dim dtMinYM As DateTime
        Dim arrayYM As New ArrayList
        Dim articles() As TArticle

        Dim sql As String
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Intro").Ignored = True

        'objRS = objConn.Execute("SELECT * FROM [blog_Article] WHERE ([log_Level]>1) ORDER BY [log_PostTime] DESC")
        sql = "([Level]>1) ORDER BY [PostTime] DESC"
        articles = CType(session.Query(GetType(TArticle), sql, 1), TArticle())
        If articles Is Nothing OrElse articles.Length <= 0 Then
            Return Nothing
        End If
        dtMaxYM = articles(0).PostTime
        dtMaxYM = New DateTime(dtMaxYM.Year, dtMaxYM.Month, 1)
        sql = "([Level]>1) ORDER BY [PostTime] ASC"
        articles = CType(session.Query(GetType(TArticle), sql, 1), TArticle())
        If articles Is Nothing OrElse articles.Length <= 0 Then
            Return Nothing
        End If
        dtMinYM = articles(0).PostTime
        dtMinYM = New DateTime(dtMinYM.Year, dtMinYM.Month, 1)

        While dtMinYM <= dtMaxYM
            arrayYM.Add(dtMinYM.Year.ToString() & "-" & dtMinYM.Month.ToString())
            dtMinYM = dtMinYM.AddMonths(1)
        End While

        Dim arrayMonthCount As New ArrayList
        'If Not arrayYM Is Nothing Then
        Dim i As Integer = 1
        For Each strCurrentYM As String In arrayYM
            Dim l As Integer = CInt(Split(strCurrentYM, "-")(0))
            Dim n As Integer = CInt(Split(strCurrentYM, "-")(1)) + 1
            If n > 12 Then l = l + 1 : n = 1
            'Dim strSql As String = "SELECT COUNT([log_ID]) FROM [blog_Article] WHERE ([log_Level]>1) AND [log_PostTime] BETWEEN '" & dtmYM(i) & "-1' AND '" & l & "-" & n & "-1'"
            'sql = "([Level]>1) AND [PostTime] BETWEEN '" & strCurrentYM & "-1 00:00:00' AND '" & l & "-" & n & "-1 00:00:00'"
            sql = "([Level]>1) AND [PostTime] BETWEEN '" & strCurrentYM & "-1' AND '" & l & "-" & n & "-1'"
            Dim count As Integer = session.QueryCount(GetType(TArticle), sql)
            If count > 0 Then
                If maxcount > 0 Then 'maxcountΪЧֵôͳ·
                    If i = maxcount Then Exit For
                End If
                arrayMonthCount.Add(strCurrentYM & vbTab & count.ToString())
                i = i + 1
            End If
        Next
        'End If

        Return CType(arrayMonthCount.ToArray(GetType(String)), String())

    End Function


    '********************************************************
    'õǰ
    '********************************************************
    Public Function GetPrevious(ByVal maxcount As Integer) As TArticle()
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True
        'objRS = objConn.Execute("SELECT [log_ID] FROM [blog_Article] WHERE ([log_ID]>0) AND ([log_Level]>1) ORDER BY [log_PostTime] DESC")
        Dim s As String
        s = "(ID>0) AND (Level>1) ORDER BY ID DESC"
        Dim articles() As TArticle
        articles = CType(session.Query(GetType(TArticle), s, maxcount), TArticle())
        Return articles
    End Function


    Public Function SearchArticles(ByVal strQuestion As String, ByVal searchCount As Integer) As TArticle()

        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True

        strQuestion = FilterSQL(strQuestion)
        'sql = "SELECT [log_ID],[log_Tag],[log_CateID],[log_Title],[log_Intro],[log_Content],[log_Level],[log_AuthorID],[log_PostTime],[log_CommNums],[log_ViewNums],[log_TrackbackNums],[log_Url] FROM [blog_Article] "
        'sql = sql & "WHERE ([log_ID]>0) AND ([log_Level]>2)"
        'sql = sql & "AND (([log_Title] LIKE '%" & strQuestion & "%') OR ([log_Intro] LIKE '%" & strQuestion & "%') OR ([log_Content] LIKE '%" & strQuestion & "%')) "
        'sql = sql & "ORDER BY [log_PostTime] DESC,[log_ID] DESC"
        Dim s As String
        s = "WHERE (ID>0) AND (Level>2)" _
          & "AND (([Title] LIKE '%" & strQuestion & "%') OR ([Intro] LIKE '%" & strQuestion & "%') OR ([Content] LIKE '%" & strQuestion & "%')) " _
          & "ORDER BY [ID] DESC"

        Dim articles() As TArticle
        articles = CType(session.Query(GetType(TArticle), s, searchCount), TArticle())
        Return articles

    End Function


    Public Function QueryDayArticles(ByVal y As Integer, ByVal m As Integer, ByVal d As Integer, ByVal maxCount As Integer, ByVal ignoreContent As Boolean, ByVal ignoreIntro As Boolean, ByVal desc As Boolean) As TArticle()
        Dim ny, nm, nd As Integer
        'ny = y
        'nm = m + 1
        'If m = 12 Then
        '    ny = ny + 1
        '    nm = 1
        'End If
        Dim t As DateTime = New DateTime(y, m, d)
        t = t.AddDays(1)
        ny = t.Year
        nm = t.Month
        nd = t.Day
        'sql = "select [log_ID],[log_CateID],[log_AuthorID],[log_Level],[log_PostTime],[log_Url] from [blog_Article] where ([log_Level]>2) And ([log_PostTime] BETWEEN '" & y & "-" & m & "-1' AND '" & ny & "-" & nm & "-1')"
        Dim s As String
        s = "([Level]>2) And ([PostTime] BETWEEN '" & y & "-" & m & "-" & d & "' AND '" & ny & "-" & nm & "-" & nd & "')"
        If (desc) Then
            s = s + " ORDER BY ID DESC"
        End If
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True
        If (ignoreContent) Then
            session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        End If
        If (ignoreIntro) Then
            session.ObjectMaps(GetType(TArticle)).MemberMaps("Intro").Ignored = True
        End If
        Dim articles() As TArticle
        articles = CType(session.Query(GetType(TArticle), s, maxCount), TArticle())
        Return articles
    End Function


    Public Function GetManagedArticles(ByVal isRootUser As Boolean, ByVal userID As String, _
        ByVal intCate As Integer, ByVal intLevel As Integer, ByVal strTitle As String, _
        ByVal intPage As Integer, ByVal pageSize As Integer, ByRef pageCount As Integer) As TArticle()

        If intPage <= 0 Then intPage = 1
        Dim strSql As String = "1=1"

        If isRootUser = False Then strSql = strSql + " AND [AuthorID] = " & userID
        If intCate > 0 Then
            strSql = strSql & " AND [log_CateID] = " & intCate
        End If
        If intLevel > 0 Then
            strSql = strSql & " AND [log_Level] = " & intLevel
        End If

        If Not IsNothing(strTitle) Then
            If strTitle.Trim() <> "" Then
                'strTitle = UnEscape(strTitle)'עӦUnEscape
                Dim searchTxt() As String
                searchTxt = Split(strTitle, " ")
                For i As Integer = LBound(searchTxt) To UBound(searchTxt)
                    'If (Not IsDBNull(searchTxt(i))) And (Trim(searchTxt(i)) <> "") Then
                    strSql = strSql & " AND ( ([Title] LIKE '%" & searchTxt(i) & "%') OR ([Intro] LIKE '%" & searchTxt(i) & "%') OR ([Content] LIKE '%" & searchTxt(i) & "%') OR ([Tag] LIKE '%" & searchTxt(i) & "%') ) "
                    'End If
                Next
            End If
        End If

        'objRS.Open("SELECT *  FROM blog_Article WHERE " & strSql & "  ORDER BY [log_PostTime] DESC")
        Dim strS As String = strSql
        Dim strW As String = strSql + " ORDER BY [ID] DESC"

        Dim offset As Integer = (intPage - 1) * pageSize + 1
        Dim limitcount As Integer = pageSize

        Dim articles() As TArticle
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True
        articles = CType(session.Query(GetType(TArticle), strW, offset, limitcount), TArticle())

        Dim totalcount As Integer = session.QueryCount(GetType(TArticle), strS)
        pageCount = CInt(Math.Ceiling(totalcount / pageSize))

        Return articles

    End Function


    Public Function QueryArticles(ByVal pagesize As Integer, ByVal intPage As Integer, _
        ByVal intCateId As Integer, ByVal intAuthorId As Integer, _
        ByVal dtmYearMonth As Object) As TArticle() ', ByVal intTagId As Integer

        'QueryArticles = Nothing
        Dim art As New TArticle

        Dim sql As String = " (ID>0) AND (Level>1) "

        If intCateId > 0 Then
            sql = sql & "AND (CateID=" & intCateId & ") "
        End If

        If intAuthorId > 0 Then
            sql = sql & "AND (AuthorID=" & intAuthorId & ") "
        End If

        If IsDate(dtmYearMonth) Then
            Dim y As Integer
            Dim m As Integer
            Dim ny As Integer
            Dim nm As Integer
            y = Year(CDate(dtmYearMonth))
            m = Month(CDate(dtmYearMonth))
            ny = y
            nm = m + 1
            If m = 12 Then ny = ny + 1 : nm = 1
            sql = sql & "AND (PostTime BETWEEN '" & y & "-" & m & "-1' AND '" & ny & "-" & nm & "-1') "
        End If

        'If intTagId > 0 Then
        '    sql = sql & " AND (Tag LIKE '%{" & intTagId.ToString() & "}%') "
        'End If

        sql = sql & "ORDER BY [ID] DESC" 'sql = sql & "ORDER BY [log_PostTime] DESC,[log_ID] DESC"

        Dim offset As Integer = (intPage - 1) * pagesize + 1
        Dim limitcount As Integer = pagesize
        Dim session As ISession
        session = Me.SessionFactory.CreateSession()

        Return CType(session.Query(GetType(TArticle), sql, offset, limitcount), TArticle())

    End Function


    'Public Function GetAllViewCounts() As Object(,)
    '        objRS = objConn.Execute("SELECT [log_ID],[log_ViewNums] FROM [blog_Article] ORDER BY [log_ID] ASC")
    '        If (Not objRS.BOF) And (Not objRS.EOF) Then
    '            objDS = CType(objRS.GetRows, Object(,))
    '            GetAllViewCounts = objDS
    '        End If
    'End Function

    'Public Function IncreaseViewCount(ByVal logID As Integer) As Boolean
    '        objConn.Execute("UPDATE [blog_Article] SET [log_ViewNums]=[log_ViewNums]+1 WHERE [log_ID]=" & logID)
    'End Function


    Public Function LoadInfoByID(ByVal logId As Integer, ByVal arti As TArticle) As Boolean
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True
        Dim articles() As TArticle
        articles = CType(session.Query(GetType(TArticle), "ID=" & logId), TArticle())
        If articles Is Nothing OrElse articles.Length < 1 Then
            Return False
        End If
        arti.CopyFrom(articles(0))
        Return True
        'objRS = objConn.Execute("SELECT [log_ID],[log_Tag],[log_CateID],[log_Title],[log_Intro],[log_Content],[log_Level],[log_AuthorID],[log_PostTime],[log_CommNums],[log_ViewNums],[log_TrackbackNums],[log_Url] FROM [blog_Article] WHERE [log_ID]=" & log_ID)
        'arti.ID = CInt(objRS("log_ID").Value)
        'arti.Tag = objRS("log_Tag").Value.ToString()
        'arti.CateID = CInt(objRS("log_CateID").Value)
        'arti.Title = objRS("log_Title").Value.ToString()
        'arti.Intro = objRS("log_Intro").Value.ToString() 'arti.OriginalIntro = arti.Intro
        'arti.Content = objRS("log_Content").Value.ToString() 'arti.OriginalContent = arti.Content
        'arti.Level = CInt(objRS("log_Level").Value)
        'arti.AuthorID = CInt(objRS("log_AuthorID").Value)
        'arti.PostTime = CDate(objRS("log_PostTime").Value)
        'arti.CommNums = CInt(objRS("log_CommNums").Value)
        'arti.ViewNums = CInt(objRS("log_ViewNums").Value)
        'arti.TrackbackNums = CInt(objRS("log_TrackbackNums").Value)
        'arti.[Alias] = objRS("log_Url").Value.ToString()'PostTime = Year(PostTime) & "-" & Month(PostTime) & "-" & Day(PostTime) & " " & Hour(PostTime) & ":" & Minute(PostTime) & ":" & Second(PostTime)
    End Function


    Public Function GetPreviousArticle(ByVal id As Integer, ByVal ignoreContent As Boolean, ByVal ignoreExcerpt As Boolean) As TArticle
        'objRS = objConn.Execute("SELECT TOP 1 [log_ID],[log_Tag],[log_CateID],[log_Title],[log_Intro],[log_Content],[log_Level],[log_AuthorID],[log_PostTime],[log_CommNums],[log_ViewNums],[log_TrackbackNums],[log_Url] FROM [blog_Article] WHERE ([log_Level]>2) AND ([log_PostTime]<'" & postTime & "') ORDER BY [log_PostTime] DESC")
        Dim s As String = "(Level>2) AND (ID<" & id.ToString() & ") ORDER BY ID DESC"
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True
        If ignoreContent Then
            session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        End If
        If ignoreExcerpt Then
            session.ObjectMaps(GetType(TArticle)).MemberMaps("Intro").Ignored = True
        End If
        Dim articles() As TArticle
        articles = CType(session.Query(GetType(TArticle), s, 1), TArticle())
        If articles Is Nothing OrElse articles.Length <= 0 Then
            Return Nothing
        End If
        Return articles(0)
    End Function

    Public Function GetNextArticle(ByVal id As Integer, ByVal ignoreContent As Boolean, ByVal ignoreExcerpt As Boolean) As TArticle
        'objRS = objConn.Execute("SELECT TOP 1 [log_ID],[log_Tag],[log_CateID],[log_Title],[log_Intro],[log_Content],[log_Level],[log_AuthorID],[log_PostTime],[log_CommNums],[log_ViewNums],[log_TrackbackNums],[log_Url] FROM [blog_Article] WHERE ([log_Level]>2) AND ([log_PostTime]>'" & postTime & "') ORDER BY [log_PostTime] ASC")
        Dim s As String = "(Level>2) AND (ID>" & id.ToString() & ") ORDER BY ID ASC"
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).IsView = True
        If ignoreContent Then
            session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        End If
        If ignoreExcerpt Then
            session.ObjectMaps(GetType(TArticle)).MemberMaps("Intro").Ignored = True
        End If
        Dim articles() As TArticle
        articles = CType(session.Query(GetType(TArticle), s, 1), TArticle())
        If articles Is Nothing OrElse articles.Length <= 0 Then
            Return Nothing
        End If
        Return articles(0)
    End Function


    Public Function Post(ByVal arti As TArticle, ByVal excerptMax As Integer) As Boolean

        If (arti.CateID = 0) Then Post = False : Exit Function
        If (arti.AuthorID = 0) Then Post = False : Exit Function
        If (arti.Level = 0) Then Post = False : Exit Function
        If Len(arti.Title) = 0 Then Post = False : Exit Function
        If Len(arti.Content) = 0 Then Post = False : Exit Function
        If Len(arti.Intro) = 0 Then arti.Intro = Left(arti.Content, excerptMax) & "..."
        'arti.Title = FilterSQL(arti.Title)
        'arti.Intro = FilterSQL(arti.Intro)
        'arti.Content = FilterSQL(arti.Content)
        'arti.Tag = FilterSQL(arti.Tag)
        'arti.IP = FilterSQL(arti.IP)
        arti.[Alias] = FilterSQL(arti.[Alias])
        Dim session As ISession
        session = Me.SessionFactory.CreateSession()
        '顰Ƿ
        If Not arti.[Alias] Is Nothing AndAlso arti.[Alias] <> "" Then
            Dim articles() As TArticle
            articles = CType(session.Query(GetType(TArticle), "Alias='" & arti.[Alias] & "'", 1), TArticle())
            If Not articles Is Nothing AndAlso articles.Length > 0 AndAlso arti.ID <> articles(0).ID Then
                Randomize()
                arti.[Alias] = arti.[Alias] & "_" & CStr(Int((9 * Rnd()) + 1)) & CStr(Int((9 * Rnd()) + 1)) & CStr(Int((9 * Rnd()) + 1)) & CStr(Int((9 * Rnd()) + 1))
            End If
        End If
        session.Save(arti)
        session.Execute()

        Call updateQuotedUploadFileInfo(arti)

        Post = True

    End Function


    Private Function updateQuotedUploadFileInfo(ByVal arti As TArticle) As Boolean

        Dim i, j As Integer

        Dim aryMatchedIds() As String
        Dim aryMatchedFileNames() As String
        Dim files() As TUploadFile

        aryMatchedIds = GetQuotedFileIds(arti.Content & arti.Intro)
        aryMatchedFileNames = GetQuotedFileNames(arti.Content & arti.Intro)

        Dim session As ISession = Me.SessionFactory.CreateSession()

        For Each id As String In aryMatchedIds
            If IsNumeric(id) Then
                files = CType(session.Query(GetType(TUploadFile), "ID=" & id), TUploadFile())
                If Not files Is Nothing AndAlso files.Length > 0 Then
                    If Not files(0).Quote Is Nothing Then
                        If InStr(files(0).Quote, "[" & arti.ID & "]") <= 0 Then
                            files(0).Quote = files(0).Quote & "[" & arti.ID & "]||"
                            session.Save(files(0))
                        End If
                    Else
                        files(0).Quote = "[" & arti.ID & "]||"
                        session.Save(files(0))
                    End If
                End If
            End If
        Next

        For Each filename As String In aryMatchedFileNames
            If Not filename Is Nothing AndAlso filename <> "" Then
                files = CType(session.Query(GetType(TUploadFile), "FileName='" & filename & "'"), TUploadFile())
                If Not files Is Nothing AndAlso files.Length > 0 Then
                    If Not files(0).Quote Is Nothing Then
                        If InStr(files(0).Quote, "[" & arti.ID & "]") <= 0 Then
                            files(0).Quote = files(0).Quote & "[" & arti.ID & "]||"
                            session.Save(files(0))
                        End If
                    Else
                        files(0).Quote = "[" & arti.ID & "]||"
                        session.Save(files(0))
                    End If
                End If
            End If
        Next

        session.Execute()

        Return True

    End Function

    Public Function Del(ByVal articleId As Integer) As Boolean
        'Public Function Del(ByVal arti As TArticle, ByVal blogPath As String) As Boolean
        'objConn.Execute("DELETE FROM [blog_Article] WHERE [log_ID] =" & arti.ID)
        'objConn.Execute("DELETE FROM [blog_Comment] WHERE [log_ID] =" & arti.ID)
        'objConn.Execute("DELETE FROM [blog_Trackback] WHERE [log_ID] =" & arti.ID)

        Dim sql As String
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Intro").Ignored = True
        Dim articles() As TArticle
        sql = "ID=" & articleId.ToString()
        articles = CType(session.Query(GetType(TArticle), sql, 1), TArticle())
        If articles Is Nothing OrElse articles.Length <= 0 Then
            Return False
        End If

        Dim comments() As TComment
        sql = "[LogID] =" & articleId
        comments = CType(session.Query(GetType(TComment), sql), TComment())
        If Not comments Is Nothing Then
            For Each c As TComment In comments
                session.Delete(c)
            Next
        End If

        Dim tbs() As TTrackback
        sql = "[LogID] =" & articleId
        tbs = CType(session.Query(GetType(TTrackback), sql), TTrackback())
        If Not tbs Is Nothing Then
            For Each t As TTrackback In tbs
                session.Delete(t)
            Next
        End If

        Dim tagArticles() As TTagArticle
        sql = "[ArticleID] =" & articleId
        tagArticles = CType(session.Query(GetType(TTagArticle), sql), TTagArticle())
        If Not tagArticles Is Nothing Then
            For Each t As TTagArticle In tagArticles
                session.Delete(t)
            Next
        End If

        session.Delete(articles(0))
        session.Execute()
        Return True

    End Function


    Public Function Statistic(ByVal articleId As Integer) As Boolean

        Dim sql As String
        sql = "(ID=" & articleId.ToString() & ")"
        Dim articles() As TArticle
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Intro").Ignored = True
        articles = CType(session.Query(GetType(TArticle), sql, 1), TArticle())
        If (articles Is Nothing OrElse articles.Length <= 0) Then
            Return False
        End If

        'objRS = objConn.Execute("SELECT COUNT([log_ID]) FROM [blog_Comment] WHERE [log_ID] =" & arti.ID)
        'objConn.Execute("UPDATE [blog_Article] SET [log_CommNums]=" & arti.CommNums & " WHERE [log_ID] =" & arti.ID)
        sql = "[log_ID] =" & articleId
        articles(0).CommNums = session.QueryCount(GetType(TComment), sql)
        'objRS = objConn.Execute("SELECT COUNT([log_ID]) FROM [blog_Trackback] WHERE [log_ID] =" & arti.ID)
        'objConn.Execute("UPDATE [blog_Article] SET [log_TrackbackNums]=" & arti.TrackbackNums & " WHERE [log_ID] =" & arti.ID)
        sql = "[log_ID] =" & articleId
        articles(0).TrackbackNums = session.QueryCount(GetType(TTrackback), sql)

        session.Save(articles(0))
        session.Execute()
        Return True

    End Function


    Public Shared Function GetQuotedFileIds(ByVal str As String) As String()

        Dim objRegExp As System.Text.RegularExpressions.Regex 'Dim objRegExp As RegExp
        Dim Matches As System.Text.RegularExpressions.MatchCollection
        Dim i As Integer
        Dim table As New Hashtable

        Dim pattern As String = "\[UPLOAD=(\d+)\]"
        objRegExp = New System.Text.RegularExpressions.Regex(pattern, Text.RegularExpressions.RegexOptions.ECMAScript Or Text.RegularExpressions.RegexOptions.IgnoreCase)
        Matches = objRegExp.Matches(str)

        For i = 0 To Matches.Count - 1
            Dim id As String = Matches(i).Groups(0).Value
            If Not (table.Contains(id)) Then
                table.Add(id, id)
            End If
        Next

        Dim ids(table.Count) As String
        i = 0
        For Each entry As DictionaryEntry In table
            ids(i) = entry.Value.ToString()
            i = i + 1
        Next
        Return ids

    End Function

    Public Shared Function GetQuotedFileNames(ByVal str As String) As String()

        Dim objRegExp As System.Text.RegularExpressions.Regex
        Dim Matches As System.Text.RegularExpressions.MatchCollection
        Dim i As Integer
        Dim table As New Hashtable

        Dim pattern As String = "(?:\[[^\]]+\](?:[^\[])*upload\/([^\[|^\\|^\/]+)\[\/[^\]]+\])|(?:(?:href|src)=[""|\']{0,1}[^\s|^""|^>|^']*upload\/([^\s|^>]+)[""|>|\s\'])"

        objRegExp = New System.Text.RegularExpressions.Regex(pattern, Text.RegularExpressions.RegexOptions.ECMAScript Or Text.RegularExpressions.RegexOptions.IgnoreCase)
        Matches = objRegExp.Matches(str)

        Dim filename As String
        For i = 0 To Matches.Count - 1
            filename = Matches(i).Groups(0).Value
            If (Not filename Is Nothing) AndAlso (Not (table.Contains(filename))) Then
                table.Add(filename, filename)
            End If
            filename = Matches(i).Groups(1).Value
            If (Not filename Is Nothing) AndAlso (Not (table.Contains(filename))) Then
                table.Add(filename, filename)
            End If
        Next

        Dim ids(table.Count) As String
        i = 0
        For Each entry As DictionaryEntry In table
            ids(i) = entry.Value.ToString()
            i = i + 1
        Next
        Return ids

    End Function


End Class