Option Explicit On 
Option Strict On

Imports System.Collections
Imports com.oucsoft.WSORM

Class CommentManager
    Inherits BusinessRulesBase


    '***********************************************************************
    'Commment
    '***********************************************************************
    Public Function GetManagedComments(ByVal isRootUser As Boolean, ByVal userID As Integer, _
        ByVal intLogID As Integer, ByVal strEmail As String, ByVal strURL As String, ByVal strContent As String, _
        ByVal intPage As Integer, ByVal pageSize As Integer, ByRef pageCount As Integer) As TComment()

        If intPage <= 0 Then intPage = 1
        Dim strS As String = "1=1"
        Dim strNativeSql As String
        Dim i As Integer

        Dim comments() As TComment

        Dim session As ISession = Me.SessionFactory.CreateSession()
        Dim commentTableName As String = session.ObjectMaps(GetType(TComment)).TableName
        Dim commentTableFieldId As String = session.ObjectMaps(GetType(TComment)).MemberMaps("ID").FieldName
        Dim commentTableFieldAuthorId As String = session.ObjectMaps(GetType(TComment)).MemberMaps("AuthorID").FieldName
        Dim commentTableFieldLogId As String = session.ObjectMaps(GetType(TComment)).MemberMaps("LogID").FieldName
        Dim commentTableFieldEmail As String = session.ObjectMaps(GetType(TComment)).MemberMaps("Email").FieldName
        Dim commentTableFieldHomepage As String = session.ObjectMaps(GetType(TComment)).MemberMaps("Homepage").FieldName
        Dim commentTableFieldContent As String = session.ObjectMaps(GetType(TComment)).MemberMaps("Content").FieldName

        Dim articleTableName As String = session.ObjectMaps(GetType(TArticle)).TableName
        Dim articleTableFieldId As String = session.ObjectMaps(GetType(TArticle)).MemberMaps("ID").FieldName
        Dim articleTableFieldAuthordId As String = session.ObjectMaps(GetType(TArticle)).MemberMaps("AuthorID").FieldName

        'עĿǰWSORMSQLĴʷ﷨ƣбҪʱ򣬿ʹƴӱSql
        If Not isRootUser Then
            strS = strS & " AND ( ([" & commentTableFieldAuthorId & "]=" & userID & ") " _
                & "OR ((SELECT [" & articleTableFieldAuthordId & "] FROM [" & articleTableName & "] WHERE [" & articleTableName & "].[" & articleTableFieldId & "]=[" & commentTableName & "].[" & commentTableFieldLogId & "])=" & userID & " ) )"
        End If

        If intLogID > 0 Then
            strS = strS & " AND [" & commentTableFieldLogId & "] = " & intLogID
        End If

        If Not IsNothing(strEmail) AndAlso strEmail.Trim() <> "" Then
            strS = strS & " AND [" & commentTableFieldEmail & "]  LIKE '%" & strEmail & "%' "
        End If
        If Not IsNothing(strURL) AndAlso strURL.Trim <> "" Then
            strS = strS & " AND [" & commentTableFieldHomepage & "] LIKE '%" & strURL & "%' "
        End If
        If Not IsNothing(strContent) AndAlso strContent.Trim() <> "" Then
            'strContent = UnEscape(strContent)'UnEscape
            Dim searchTxt() As String
            searchTxt = Split(strContent, " ")
            For i = LBound(searchTxt) To UBound(searchTxt)
                If (Not (searchTxt(i) Is Nothing)) And (Trim(searchTxt(i)) <> "") Then
                    strS = strS & " AND ([" & commentTableFieldContent & "] LIKE '%" & searchTxt(i) & "%') "
                End If
            Next
        End If

        strNativeSql = strS + " ORDER BY [" & commentTableFieldId & "] DESC"
        Dim offset As Integer = pageSize * (intPage - 1) + 1
        Dim limitcount As Integer = pageSize
        'Dim table As System.Data.DataTable
        'table = session.QureyTableByNativeSql(strNativeSql)
        'comments = CType(session.ConvertDataTable2Objects(GetType(TComment), table), TComment())
        comments = CType(session.QueryByNativeSearchCondition(GetType(TComment), strNativeSql, offset, limitcount), TComment())

        Dim count As Integer
        strNativeSql = "SELECT COUNT(*) FROM [" & commentTableName & "] WHERE " + strS '+ " ORDER BY [" & commentTableFieldId & "] DESC"
        count = CType(session.ExecuteScalarByNativeSql(strNativeSql), Integer)
        pageCount = CInt(Math.Ceiling(count / pageSize))

        Return comments
    End Function


    'Public Function GetManagedComments(ByVal isRootUser As Boolean, ByVal userID As Integer, _
    '    ByVal intLogID As Integer, ByVal strEmail As String, ByVal strURL As String, ByVal strContent As String, _
    '    ByVal intPage As Integer, ByVal pageSize As Integer, ByRef pageCount As Integer) As TComment()
    '    If intPage <= 0 Then  intPage = 1
    '    Dim strSQL As String = "1=1"
    '    Dim i As Integer
    '    If isRootUser = False Then
    '        'עĿǰWSORMSQLĴʷ﷨ƣ޷ʹSQL
    '        ''strSQL = strSQL + " AND ( ([AuthorID]=" & userID & ") OR ((SELECT [log_AuthorID] FROM [blog_Article] WHERE [blog_Article].[log_ID]=[blog_Comment].[log_ID])=" & userID & " ) ) "
    '    End If
    '    If intLogID > 0 Then
    '        strSQL = strSQL & " AND [log_ID] = " & intLogID
    '    End If
    '    If Not IsNothing(strEmail) AndAlso strEmail.Trim() <> "" Then
    '        strSQL = strSQL & " AND [Email]  LIKE '%" & strEmail & "%' "
    '    End If
    '    If Not IsNothing(strURL) And strURL.Trim <> "" Then
    '        strSQL = strSQL & " AND [Homepage] LIKE '%" & strURL & "%' "
    '    End If
    '    If Not IsNothing(strContent) And strContent.Trim() <> "" Then
    '        'strContent = UnEscape(strContent)'UnEscape
    '        Dim searchTxt() As String
    '        searchTxt = Split(strContent, " ")
    '        For i = LBound(searchTxt) To UBound(searchTxt)
    '            If (Not IsDBNull(searchTxt(i))) And (Trim(searchTxt(i)) <> "") Then
    '                strSQL = strSQL & " AND ([Content] LIKE '%" & searchTxt(i) & "%') "
    '            End If
    '        Next
    '    End If
    '    'objRS.Open("SELECT * FROM [blog_Comment] WHERE " & strSQL & " ORDER BY [comm_ID] DESC")
    '    Dim strS As String = strSQL
    '    Dim strW As String = strSQL + " ORDER BY [ID] DESC"
    '    Dim comments() As TComment
    '    Dim offset As Integer = pageSize * (intPage - 1) + 1
    '    Dim limitcount As Integer = pageSize
    '    Dim session As ISession = Me.SessionFactory.CreateSession()
    '    comments = CType(session.Query(GetType(TComment), strW, offset, limitcount), TComment())
    '    Dim count As Integer
    '    count = session.QueryCount(GetType(TComment), strS)
    '    pageCount = CInt(Math.Ceiling(count / pageSize))
    '    Return comments
    'End Function


    Public Function GetOrderedComments(ByVal maxcount As Integer, ByVal desc As Boolean) As TComment()
        Dim s As String
        Dim comments() As TComment
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TComment)).IsView = True

        s = "1=1"
        If (desc) Then
            s = s + " ORDER BY [ID] DESC"
        Else
            s = s + " ORDER BY [ID] ASC"
        End If

        comments = CType(session.Query(GetType(TComment), s, maxcount), TComment())

        Return comments
    End Function


    Public Function GetArticleComments(ByVal logID As Integer, ByVal desc As Boolean) As TComment()

        'Dim sql As String = "SELECT [comm_ID],[log_ID],[comm_AuthorID],[comm_Author],[comm_Content],[comm_Email],[comm_Homepage],[comm_PostTime],[comm_IP],[comm_Agent] FROM [blog_Comment] WHERE [log_ID]=" & logID & " ORDER BY [comm_PostTime]"
        Dim s As String = "[LogID]=" & logID & " ORDER BY ID"
        If (desc) Then
            s = s + " DESC"
        End If

        Dim comments() As TComment
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TComment)).IsView = True
        comments = CType(session.Query(GetType(TComment), s), TComment())

        Return comments

    End Function


    Public Function Post(ByVal comment As TComment, ByVal contentMax As Integer, ByVal usernameMax As Integer, ByVal emailMax As Integer, ByVal homepageMax As Integer, ByRef sameComment As Boolean) As Boolean

        If Len(comment.Homepage) > 0 Then
            If InStr(comment.Homepage, "http") = 0 Then comment.Homepage = "http://" & comment.Homepage
        End If

        If Len(comment.Content) > contentMax Then comment.Content = Left(comment.Content, contentMax) & "..."

        'comment.Author = FilterSQL(comment.Author)
        'comment.Content = FilterSQL(comment.Content)
        'comment.Email = FilterSQL(comment.Email)
        'comment.Homepage = FilterSQL(comment.Homepage)
        ''comment.PostTime = FilterSQL(comment.PostTime)
        'comment.IP = FilterSQL(comment.IP)
        'comment.Agent = FilterSQL(comment.Agent)

        'log_IDΪ0
        If (comment.LogID = 0) Then Return False
        If Len(comment.Author) = 0 Then Return False
        If Len(comment.Content) = 0 Then Return False

        If usernameMax > 0 Then
            If Len(comment.Author) > usernameMax Then
                Return False
            End If
        End If
        If emailMax > 0 Then
            If Len(comment.Email) > emailMax Then
                Return False
            End If
        End If
        If homepageMax > 0 Then
            If Len(comment.Homepage) > homepageMax Then
                Return False
            End If
        End If

        Dim s As String
        Dim session As ISession = Me.SessionFactory.CreateSession()

        'ηһ
        If comment.ID = 0 Then

            Dim strSpamIP As String
            Dim strSpamContent As String
            'objRS = objConn.Execute("SELECT [comm_IP],[comm_Content] FROM [blog_Comment] WHERE [comm_ID]= ( SELECT MAX(comm_ID) FROM [blog_Comment] )")

            s = "1=1 ORDER BY [ID] DESC"
            Dim temps() As TComment
            temps = CType(session.Query(GetType(TComment), s, 1), TComment())
            If Not temps Is Nothing AndAlso temps.Length > 0 Then 'If (Not objRS.BOF) And (Not objRS.EOF) Then
                strSpamIP = temps(0).IP 'objRS("comm_IP").Value.ToString()
                strSpamContent = temps(0).Content 'objRS("comm_Content").Value.ToString()
            End If

            If (strSpamIP = comment.IP) And (strSpamContent = comment.Content) Then
                'ע⣬ͬݣôʾҪʾû
                sameComment = True
                Return False
            End If

            'objConn.Execute("INSERT INTO [blog_Comment]([log_ID],[comm_AuthorID],[comm_Author],[comm_Content],[comm_Email],[comm_Homepage],[comm_IP],[comm_PostTime],[comm_Agent]) VALUES (" & comment.log_ID & "," & comment.AuthorID & ",'" & comment.Author & "','" & comment.Content & "','" & comment.Email & "','" & comment.Homepage & "','" & comment.IP & "','" & comment.PostTime & "','" & comment.Agent & "')")
            session.Save(comment)
            session.Execute()

        Else

            'objConn.Execute("UPDATE [blog_Comment] SET [comm_Author]='" & comment.Author & "',[comm_Content]='" & comment.Content & "',[comm_Email]='" & comment.Email & "',[comm_Homepage]='" & comment.Homepage & "' WHERE [comm_ID]=" & comment.ID)
            session.Save(comment)
            session.Execute()

        End If

        Return True

    End Function

    Public Function Del(ByVal commentId As Integer) As Boolean

        If (commentId = 0) Then
            Return False
        End If

        'objConn.Execute("DELETE FROM [blog_Comment] WHERE [comm_ID] =" & ID)
        Dim s As String = "[ID] =" & commentId.ToString()
        Dim session As ISession = Me.SessionFactory.CreateSession()
        Dim comments() As TComment
        comments = CType(session.Query(GetType(TComment), s, 1), TComment())
        If comments Is Nothing OrElse comments.Length <= 0 Then
            Return False
        End If

        session.Delete(comments(0))
        session.Execute()

        Return True

    End Function

    Public Function LoadInfoByID(ByVal commentId As Integer, ByRef comment As TComment) As Boolean

        If (commentId <= 0) Then Return False

        If IsNothing(comment) Then
            comment = New TComment
        End If

        'objRS = objConn.Execute("SELECT [comm_ID],[log_ID],[comm_AuthorID],[comm_Author],[comm_Content],[comm_Email],[comm_Homepage],[comm_PostTime],[comm_IP],[comm_Agent] FROM [blog_Comment] WHERE [comm_ID]=" & comm_ID)
        Dim s As String
        s = "[ID]=" & commentId.ToString()
        Dim comms() As TComment
        Dim session As ISession = Me.SessionFactory.CreateSession()
        comms = CType(session.Query(GetType(TComment), s, 1), TComment())

        comment.CopyFrom(comms(0))
        Return True

    End Function

    Public Function GetTotalCount() As Integer
        'objRS.Open("SELECT COUNT([log_ID])AS allArticle,SUM([log_CommNums]) AS allCommNums,SUM([log_TrackbackNums]) AS allTrackbackNums FROM [blog_Article]")
        Dim session As ISession = Me.SessionFactory.CreateSession()
        Return session.QueryCount(GetType(TComment), Nothing)
    End Function


End Class
