Imports com.oucsoft.WSORM

Public Class ORM

    Private Sub New()
        '
    End Sub

    Private Shared _sessionFactory As com.oucsoft.WSORM.SessionFactory

    Public Shared ReadOnly Property SessionFactory() As com.oucsoft.WSORM.SessionFactory
        Get
            Return _sessionFactory
        End Get
        'Set(ByVal Value As com.oucsoft.WSORM.SessionFactory)
        '    SyncLock GetType(ORM)
        '        _sessionFactory = Value
        '    End SyncLock
        'End Set
    End Property

    Shared Sub New()

        _sessionFactory = New com.oucsoft.WSORM.SessionFactory

        readConfig()

        _sessionFactory.ObjectMaps.Add(GetObjectMapUploadFile())
        _sessionFactory.ObjectMaps.Add(GetObjectMapCategory())
        _sessionFactory.ObjectMaps.Add(GetObjectMapTag())
        _sessionFactory.ObjectMaps.Add(GetObjectMapArticle())
        _sessionFactory.ObjectMaps.Add(GetObjectMapKeyword())
        _sessionFactory.ObjectMaps.Add(GetObjectMapUser())
        _sessionFactory.ObjectMaps.Add(GetObjectMapComment())
        _sessionFactory.ObjectMaps.Add(GetObjectMapTrackback())
        _sessionFactory.ObjectMaps.Add(GetObjectMapTagArticle())

    End Sub

    Private Shared Sub readConfig()
        Dim dbType As String
        dbType = System.Configuration.ConfigurationSettings.AppSettings.Get("dbType").ToUpper()

        If dbType = "ACCESS" Then
            _sessionFactory.FactoryType = com.oucsoft.WSORM.SessionFactoryTypes.Accesss
            _sessionFactory.ConnectionString = System.Configuration.ConfigurationSettings.AppSettings.Get("dataConn")
        Else
            _sessionFactory.FactoryType = com.oucsoft.WSORM.SessionFactoryTypes.SqlServer
            _sessionFactory.ConnectionString = System.Configuration.ConfigurationSettings.AppSettings.Get("dataConn")
        End If
    End Sub


    Public Shared Function GetObjectMapTrackback() As ObjectMap
        'CREATE TABLE [dbo].[blog_TrackBack] (
        '	[tb_ID] [int] IDENTITY (1, 1) NOT NULL ,
        '	[log_ID] [int] NULL ,
        '	[tb_URL] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[tb_Title] [nvarchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[tb_Blog] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[tb_Excerpt] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
        '	[tb_PostTime] [smalldatetime] NULL ,
        '	[tb_IP] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[tb_Agent] [ntext] COLLATE Chinese_PRC_CI_AS NULL 
        ') ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
        'GO
        Dim omap As ObjectMap = New ObjectMap(GetType(TTrackback), "blog_TrackBack")
        omap.MemberMaps.Add("ID", "tb_ID", DbFieldTypes.Int, MemberMapTypes.Identity)
        omap.MemberMaps.Add("LogID", "log_ID", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Url", "tb_URL", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Title", "tb_Title", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Blog", "tb_Blog", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Excerpt", "tb_Excerpt", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("PostTime", "tb_PostTime", DbFieldTypes.DateTime, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("IP", "tb_IP", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Agent", "tb_Agent", DbFieldTypes.String, MemberMapTypes.NormalField)
        Return omap
    End Function

    Public Shared Function GetObjectMapComment() As ObjectMap
        'CREATE TABLE [dbo].[blog_Comment] (
        '	[comm_ID] [int] IDENTITY (1, 1) NOT NULL ,
        '	[log_ID] [int] NULL ,
        '	[comm_AuthorID] [int] NULL ,
        '	[comm_Author] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[comm_Content] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
        '	[comm_Email] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[comm_HomePage] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[comm_PostTime] [smalldatetime] NULL ,
        '	[comm_IP] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[comm_Agent] [ntext] COLLATE Chinese_PRC_CI_AS NULL 
        ') ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
        'GO()
        Dim omap As ObjectMap = New ObjectMap(GetType(TComment), "blog_Comment")
        omap.MemberMaps.Add("ID", "comm_ID", DbFieldTypes.Int, MemberMapTypes.Identity)
        omap.MemberMaps.Add("LogID", "log_ID", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("AuthorID", "comm_AuthorID", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Author", "comm_Author", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Content", "comm_Content", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Email", "comm_Email", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Homepage", "comm_HomePage", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("PostTime", "comm_PostTime", DbFieldTypes.DateTime, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("IP", "comm_IP", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Agent", "comm_Agent", DbFieldTypes.String, MemberMapTypes.NormalField)
        Return omap
    End Function

    Public Shared Function GetObjectMapUser() As ObjectMap
        Dim omap As ObjectMap = New ObjectMap(GetType(TUser), "blog_Member")

        omap.MemberMaps.Add("ID", "mem_ID", DbFieldTypes.Int, MemberMapTypes.Identity)
        omap.MemberMaps.Add("Level", "mem_Level", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Name", "mem_Name", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Password", "mem_Password", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Sex", "mem_Sex", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Email", "mem_Email", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("MSN", "mem_MSN", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("QQ", "mem_QQ", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Homepage", "mem_Homepage", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("LastVisitTime", "mem_LastVisit", DbFieldTypes.DateTime, MemberMapTypes.NormalField)

        '[mem_Status] [int] NOT NULL ,

        omap.MemberMaps.Add("Count", "mem_PostLogs", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("CommentCount", "mem_PostComms", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Intro", "mem_Intro", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("LastVisitIP", "mem_IP", DbFieldTypes.String, MemberMapTypes.NormalField)

        '[mem_Count] [int] NOT NULL

        Return omap
    End Function


    Public Shared Function GetObjectMapKeyword() As ObjectMap

        Dim omap As ObjectMap = New ObjectMap(GetType(TKeyword), "blog_Keyword")

        omap.MemberMaps.Add("ID", "key_ID", DbFieldTypes.Int, MemberMapTypes.Identity)
        omap.MemberMaps.Add("Name", "key_Name", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Intro", "key_Intro", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Url", "key_URL", DbFieldTypes.String, MemberMapTypes.NormalField)

        Return omap

    End Function

    Public Shared Function GetObjectMapArticle() As ObjectMap

        Dim omap As ObjectMap = New ObjectMap(GetType(TArticle), "blog_Article")

        omap.MemberMaps.Add("ID", "log_ID", DbFieldTypes.Int, MemberMapTypes.Identity)
        omap.MemberMaps.Add("CateID", "log_CateID", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("AuthorID", "log_AuthorID", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Level", "log_Level", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Alias", "log_Url", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Title", "log_Title", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Intro", "log_Intro", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Content", "log_Content", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("IP", "log_IP", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("PostTime", "log_PostTime", DbFieldTypes.DateTime, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("CommNums", "log_CommNums", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("ViewNums", "log_ViewNums", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("TrackbackNums", "log_TrackbackNums", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Tag", "log_Tag", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("IsTop", "log_IsTop", DbFieldTypes.Boolean, MemberMapTypes.NormalField)

        Return omap

    End Function

    Public Shared Function GetObjectMapTag() As ObjectMap

        'CREATE TABLE [dbo].[blog_Tag] (
        '	[tag_ID] [int] IDENTITY (1, 1) NOT NULL ,
        '	[tag_Name] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[tag_Intro] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
        '	[tag_ParentID] [int] NULL ,
        '	[tag_URL] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[tag_Order] [int] NOT NULL ,
        '	[tag_Count] [int] NOT NULL 
        ') ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

        Dim omap As ObjectMap = New ObjectMap(GetType(TTag), "blog_Tag")

        omap.MemberMaps.Add("ID", "tag_ID", DbFieldTypes.Int, MemberMapTypes.Identity)
        omap.MemberMaps.Add("Name", "tag_Name", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Intro", "tag_Intro", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Order", "tag_Order", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Count", "tag_Count", DbFieldTypes.Int, MemberMapTypes.NormalField)

        Return omap

    End Function


    Public Shared Function GetObjectMapTagArticle() As ObjectMap
        'CREATE TABLE [dbo].[blog_TagArticle] (
        '	[tag_log_ID] [int] IDENTITY (1, 1) NOT NULL ,
        '	[tag_ID] [int] NOT NULL ,
        '	[tag_Name] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[log_ID] [int] NOT NULL ,
        '	[log_Title] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL 
        ') ON [PRIMARY]
        Dim omap As ObjectMap = New ObjectMap(GetType(TTagArticle), "blog_TagArticle")
        omap.MemberMaps.Add("RecordID", "tag_log_ID", DbFieldTypes.Int, MemberMapTypes.Identity)
        omap.MemberMaps.Add("TagID", "tag_ID", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("TagName", "tag_Name", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("ArticleID", "log_ID", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("ArticleTitle", "log_Title", DbFieldTypes.String, MemberMapTypes.NormalField)

        omap.MemberMaps.Add("ArticleInfo", "log_ID", DbFieldTypes.Int, GetType(TArticle), "log_ID", MemberMapTypes.Many2One)
        omap.MemberMaps("ArticleInfo").CascadedQuery = False
        omap.MemberMaps("ArticleInfo").CascadedDelete = False
        omap.MemberMaps("ArticleInfo").CascadedSave = False

        Return omap
    End Function


    Public Shared Function GetObjectMapUploadFile() As ObjectMap

        'CREATE TABLE [dbo].[blog_Upload] (
        '	[ul_ID] [int] IDENTITY (1, 1) NOT NULL ,
        '	[ul_AuthorID] [int] NULL ,
        '	[ul_FileSize] [int] NULL ,
        '	[ul_FileName] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[ul_PostTime] [smalldatetime] NULL ,
        '	[ul_Quote] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[ul_DownNum] [int] NOT NULL 
        ') ON [PRIMARY]

        Dim omap As ObjectMap = New ObjectMap(GetType(TUploadFile), "blog_Upload")
        omap.MemberMaps.Add("ID", "ul_ID", DbFieldTypes.Int, MemberMapTypes.Identity)
        omap.MemberMaps.Add("AuthorID", "ul_AuthorID", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("FileSize", "ul_FileSize", DbFieldTypes.Int, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("FileName", "ul_FileName", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("PostTime", "ul_PostTime", DbFieldTypes.DateTime, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Quote", "ul_Quote", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("DownNum", "ul_DownNum", DbFieldTypes.Int, MemberMapTypes.NormalField)

        Return omap

    End Function

    Public Shared Function GetObjectMapCategory() As ObjectMap

        'CREATE TABLE [dbo].[blog_Category] (
        '	[cate_ID] [int] IDENTITY (1, 1) NOT NULL ,
        '	[cate_Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[cate_Order] [nvarchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[cate_Intro] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[cate_Count] [int] NOT NULL ,
        '	[cate_Code] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[cate_ParentCode] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        '	[cate_ParentID] [int] NULL 
        ') ON [PRIMARY]


        'һ汾ʹSql޸ıṹ
        '1OrderֶθΪַ
        'alter table blog_Category 
        'ALTER COLUMN
        '    [cate_Order] [nvarchar] (10) COLLATE Chinese_PRC_CI_AS NULL        
        '2ϡࡱֶ
        'alter table blog_Category
        'add
        '    [cate_Code] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        '    [cate_ParentCode] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        '    [cate_ParentID] [int] NULL 

        Dim omap As ObjectMap = New ObjectMap(GetType(TCategory), "blog_Category")

        omap.MemberMaps.Add("ID", "cate_ID", DbFieldTypes.Int, MemberMapTypes.Identity)
        omap.MemberMaps.Add("Name", "cate_Name", DbFieldTypes.String, MemberMapTypes.NormalField)
        'ĿǰƺûбҪʹֶ
        'omap.MemberMaps.Add("Intro", "cate_Intro", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("Count", "cate_Count", DbFieldTypes.Int, MemberMapTypes.NormalField)

        omap.MemberMaps.Add("Order", "cate_Order", DbFieldTypes.String, MemberMapTypes.NormalField)

        omap.MemberMaps.Add("Code", "cate_Code", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("ParentCode", "cate_ParentCode", DbFieldTypes.String, MemberMapTypes.NormalField)
        omap.MemberMaps.Add("ParentID", "cate_ParentID", DbFieldTypes.Int, MemberMapTypes.NormalField)

        omap.MemberMaps.Add("Childs", "cate_ID", DbFieldTypes.Int, GetType(TCategory), "cate_ParentID", MemberMapTypes.One2Many)
        omap.MemberMaps("Childs").CascadedDelete = False
        omap.MemberMaps("Childs").CascadedQuery = False
        omap.MemberMaps("Childs").CascadedSave = False

        Return omap

    End Function

End Class
