Option Explicit On 
Option Strict On

Imports System.Collections
Imports com.oucsoft.WSORM

Class TagManager
    Inherits BusinessRulesBase


    Public Function UpdateArticleCount(ByVal tagId As Integer) As Boolean

        Dim s As String
        Dim i As Integer
        Dim tags() As TTag
        Dim tag As TTag
        Dim session As ISession = Me.SessionFactory.CreateSession()

        s = "[ID]=" & tagId.ToString()
        tags = CType(session.Query(GetType(TTag), s, 1), TTag())
        If tags Is Nothing OrElse tags.Length <= 0 Then
            Return False
        End If
        tag = tags(0)

        's = "[Tag] LIKE '%{" & tagId & "}%'"
        'i = session.QueryCount(GetType(TArticle), s)
        s = "[TagID]=" & tagId.ToString()
        i = session.QueryCount(GetType(TTagArticle), s)
        tag.Count = i

        session.Save(tag)
        session.Execute()

        Return True
    End Function

    Public Function GetOrderedTags() As TTag()

        Dim tags() As TTag
        Dim s As String
        Dim session As ISession = Me.SessionFactory.CreateSession()
        'objRS = objConn.Execute("SELECT [tag_ID],[tag_Name],[tag_Intro],[tag_Order],[tag_Count] FROM [blog_Tag] ORDER BY [tag_Order] DESC,[tag_Count] DESC,[tag_ID] ASC")
        s = "1=1 ORDER BY [Order] DESC,[Count] DESC,[ID] ASC"
        session.ObjectMaps(GetType(TTag)).IsView = True
        tags = CType(session.Query(GetType(TTag), s), TTag())
        Return tags

    End Function


    Public Function GetManagedTagList(ByVal intPage As Integer, ByVal pagesize As Integer, ByRef pagecount As Integer) As TTag()

        'strSQL = "SELECT * FROM [blog_Tag] ORDER BY [tag_Order] DESC,[tag_Count] DESC,[tag_ID] ASC"

        If intPage <= 0 Then intPage = 1 'Call CheckParameter(intPage, "int", 1)
        Dim strS As String = ""
        Dim strW As String = "1=1 ORDER BY [Order] DESC,[Count] DESC,[ID] ASC"
        Dim offset As Integer = (intPage - 1) * pagesize + 1
        Dim limitcount As Integer = pagesize
        Dim tags() As TTag

        Dim session As ISession = Me.SessionFactory.CreateSession()
        tags = CType(session.Query(GetType(TTag), strS, offset, limitcount), TTag())

        Dim i As Integer
        i = session.QueryCount(GetType(TTag), strS)
        pagecount = CInt(Math.Ceiling(i / pagesize))

        Return tags

    End Function


    '*********************************************************
    ' Ŀģ    ȫTagsȡ
    '*********************************************************
    Public Function GetTags() As TTag()

        'objRS = objConn.Execute("SELECT TOP 1 [tag_ID] FROM [blog_Tag] ORDER BY [tag_ID] DESC")
        'If (Not objRS.BOF) And (Not objRS.EOF) Then
        'i = CInt(objRS("tag_ID").Value)
        'ReDim tags(i)
        'End If
        'objRS = objConn.Execute("SELECT [tag_ID],[tag_Name],[tag_Intro],[tag_Order],[tag_Count] FROM [blog_Tag] ORDER BY [tag_ID] ASC")

        Dim s As String
        Dim tags() As TTag
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TTag)).IsView = True

        s = "1=1 ORDER BY [ID] ASC"
        tags = CType(session.Query(GetType(TTag), s), TTag())

        Return tags

        'If (tags Is Nothing OrElse tags.Length <= 0) Then
        '    Return tags
        'End If
        'Dim rets(tags(tags.Length - 1).ID) As TTag
        'For Each tag As TTag In tags
        '    rets(tag.ID) = tag
        'Next
        'Return rets
    End Function


    Public Function Post(ByVal tag As TTag, ByVal checkBeforeSave As Boolean) As Boolean
        Dim session As ISession
        session = Me.SessionFactory.CreateSession()

        If checkBeforeSave Then
            If Me._loadInfoByName(session, tag.Name, tag) Then
                Return True
            End If
        End If

        Return Me._post(session, tag)
    End Function

    Private Function _post(ByVal session As ISession, ByVal tag As TTag) As Boolean
        session.Save(tag)
        session.Execute()
        Return True
    End Function


    Public Function LoadInfoByID(ByVal tagId As Integer, ByRef tag As TTag) As Boolean

        If tagId <= 0 Then Return False

        Dim s As String
        Dim tags() As TTag
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TTag)).IsView = True

        s = "[ID]=" & tagId.ToString()
        tags = CType(session.Query(GetType(TTag), s, 1), TTag())
        If tags Is Nothing OrElse tags.Length <= 0 Then
            Return False
        End If

        If tag Is Nothing Then
            tag = tags(0)
        Else
            tag.CopyFrom(tags(0))
        End If
        Return True

    End Function


    Public Function LoadInfoByName(ByVal tagName As String, ByRef tag As TTag) As Boolean

        If tagName Is Nothing Then Return False
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TTag)).IsView = True
        Return Me._loadInfoByName(session, tagName, tag)

    End Function

    Private Function _loadInfoByName(ByVal session As ISession, ByVal tagName As String, ByRef tag As TTag) As Boolean
        Dim s As String
        Dim tags() As TTag
        s = "[Name]='" & Me.FilterSQL(tagName) & "'"
        tags = CType(session.Query(GetType(TTag), s, 1), TTag())
        If tags Is Nothing OrElse tags.Length <= 0 Then
            Return False
        End If

        If tag Is Nothing Then
            tag = tags(0)
        Else
            tag.CopyFrom(tags(0))
        End If
        Return True
    End Function


    Public Function Del(ByVal tagId As Integer) As Boolean

        If (tagId <= 0) Then Return False

        Dim s As String
        Dim tags() As TTag
        Dim tag As TTag

        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Content").Ignored = True
        session.ObjectMaps(GetType(TArticle)).MemberMaps("Intro").Ignored = True

        s = "[ID]=" & tagId.ToString()
        tags = CType(session.Query(GetType(TTag), s), TTag())
        If tags Is Nothing OrElse tags.Length <= 0 Then
            Return False
        End If
        tag = tags(0)

        'Dim articles() As TArticle
        'Dim article As TArticle
        's = "[Tag] LIKE '%{" & tagId.ToString() & "}%'"
        'articles = CType(session.Query(GetType(TArticle), s), TArticle())
        'If Not articles Is Nothing Then
        '    For Each article In articles
        '        article.Tag = article.Tag.Replace("{" & tagId.ToString() & "}", "")
        '        article.Tag = article.Tag.Trim()
        '        session.Save(article)
        '    Next
        'End If

        session.ObjectMaps(GetType(TTagArticle)).MemberMaps("ArticleInfo").CascadedDelete = False
        Dim tagArticles() As TTagArticle
        s = "TagID=" & tagId.ToString()
        tagArticles = CType(session.Query(GetType(TTagArticle), s), TTagArticle())
        If Not tagArticles Is Nothing Then
            For Each tagArticle As TTagArticle In tagArticles
                session.Delete(tagArticle)
            Next
        End If

        session.Delete(tag)
        session.Execute()

        Return True
    End Function


    'ؽTagһ㲻ҪãĿǰֻݿʱʹ
    Public Function RebuildTagArticleRecords() As Boolean
        Dim session As ISession = Me.SessionFactory.CreateSession()
        Dim s As String

        Dim tagArticle As TTagArticle
        Dim tagArticles() As TTagArticle
        tagArticles = CType(session.Query(GetType(TTagArticle)), TTagArticle())
        If Not tagArticles Is Nothing Then
            For Each tagArticle In tagArticles
                session.Delete(tagArticle)
            Next
        End If
        session.Execute()

        'ȫtag
        s = "1=1"
        Dim tags() As TTag
        tags = CType(session.Query(GetType(TTag), s), TTag())

        If Not tags Is Nothing Then
            For Each tag As TTag In tags
                'ÿtagӦ
                Dim articles() As TArticle
                s = "[Tag] LIKE '%{" & tag.ID & "}%'"
                articles = CType(session.Query(GetType(TArticle), s), TArticle())
                If Not articles Is Nothing Then
                    For Each article As TArticle In articles
                        tagArticle = New TTagArticle
                        tagArticle.ArticleID = article.ID
                        tagArticle.ArticleTitle = article.Title
                        tagArticle.TagID = tag.ID
                        tagArticle.TagName = tag.Name
                        session.Save(tagArticle)
                    Next
                End If

            Next
        End If

        session.Execute()

        Return True
    End Function

    Public Function SaveArticleTags(ByVal articleId As Integer, ByVal articleTitle As String, ByVal tags As TTag()) As Boolean
        Dim session As ISession = Me.SessionFactory.CreateSession()
        Dim tagArticle As TTagArticle

        For Each tag As TTag In tags
            tagArticle = New TTagArticle
            tagArticle.ArticleID = articleId
            tagArticle.ArticleTitle = articleTitle
            tagArticle.TagID = tag.ID
            tagArticle.TagName = tag.Name
            session.Save(tagArticle)
        Next

        session.Execute()
        Return True
    End Function

    Public Function GetArticleTagIds(ByVal articleId As Integer) As Integer()
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TTagArticle)).IsView = True
        Dim tagArticles() As TTagArticle
        Dim s As String
        Dim b As Boolean
        Dim ids As New ArrayList
        s = "ArticleID=" & articleId.ToString()
        tagArticles = CType(session.Query(GetType(TTagArticle), s), TTagArticle())
        If Not tagArticles Is Nothing Then
            For Each tagArticle As TTagArticle In tagArticles
                ids.Add(tagArticle.TagID)
            Next
        End If
        Return CType(ids.ToArray(GetType(Integer)), Integer())
    End Function

    Public Function UpdateArticleTags(ByVal articleId As Integer, ByVal articleTitle As String, ByVal tags As TTag()) As Boolean

        Dim session As ISession = Me.SessionFactory.CreateSession()

        Dim tagArticles() As TTagArticle
        Dim s As String
        Dim b As Boolean

        s = "ArticleID=" & articleId.ToString()
        tagArticles = CType(session.Query(GetType(TTagArticle), s), TTagArticle())

        Dim delRecs As New ArrayList 'Ҫɾļ¼
        Dim newRecs As New ArrayList 'Ҫӵļ¼
        Dim updRecs As New ArrayList
        Dim tagArticle As TTagArticle
        Dim tag As TTag

        If Not tags Is Nothing Then
            For Each tag In tags
                b = False 'ԭеļ¼ûҵӵTag 
                If Not tagArticles Is Nothing Then
                    For Each tagArticle In tagArticles
                        If tag.ID = tagArticle.TagID Then
                            b = True
                            tagArticle.TagName = tag.Name
                            tagArticle.ArticleTitle = articleTitle
                            updRecs.Add(tagArticle)
                            Exit For
                        End If
                    Next
                End If
                If b = False Then
                    newRecs.Add(tag)
                End If
            Next
        End If

        If Not tagArticles Is Nothing Then
            For Each tagArticle In tagArticles
                b = False 'ԭеļ¼ѾҪ
                If Not tags Is Nothing Then
                    For Each tag In tags
                        If tag.ID = tagArticle.TagID Then
                            b = True
                            Exit For
                        End If
                    Next
                End If
                If b = False Then
                    delRecs.Add(tagArticle)
                End If
            Next
        End If

        For Each tagArticle In updRecs
            session.Save(tagArticle)
        Next
        For Each tag In newRecs
            tagArticle = New TTagArticle
            tagArticle.ArticleID = articleId
            tagArticle.ArticleTitle = articleTitle
            tagArticle.TagID = tag.ID
            tagArticle.TagName = tag.Name
            session.Save(tagArticle)
        Next
        For Each tagArticle In delRecs
            session.Delete(tagArticle)
        Next

        session.Execute()
        Return True
    End Function

End Class
