Option Explicit On 
Option Strict On

Imports System.IO
Imports System.Collections
Imports com.oucsoft.WSORM


Class UploadFileManager
    Inherits BusinessRulesBase


    '****************************************************************************
    'ȡõϴļID
    '****************************************************************************
    Public Function GetQuotedFileIds(ByVal articleIds As Integer()) As Integer()

        Dim arrayFileIDs As New ArrayList
        Dim strSql As String = ""
        Dim files() As TUploadFile

        For Each i As Integer In articleIds ' k As Integer = LBound(articleIDs) To UBound(articleIDs)
            If strSql = "" Then
                strSql = "[Quote] LIKE '%[" & i.ToString() & "]%' "
            Else
                strSql = strSql & " OR [Quote] LIKE '%[" & i.ToString & "]%' "
            End If
        Next
        'objRS.Open("SELECT [ul_ID],[ul_Quote] FROM [blog_Upload] " & strSql & " ")

        Dim session As ISession = Me.SessionFactory.CreateSession()
        files = CType(session.Query(GetType(TUploadFile), strSql), TUploadFile())
        'files(0).Quote 

        If Not files Is Nothing Then
            For Each f As TUploadFile In files
                arrayFileIDs.Add(f.ID)
            Next
        End If

        Return CType(arrayFileIDs.ToArray(GetType(Integer)), Integer())

    End Function


    Public Function IncreaseDownCount(ByVal ulfileId As Integer) As Boolean
        'objConn.Execute("UPDATE [blog_Upload] SET [ul_DownNum]=[ul_DownNum]+1 WHERE [ul_ID] =" & ul_ID)

        Dim s As String = "[ID]=" & ulfileId.ToString()
        Dim files() As TUploadFile
        Dim session As ISession
        files = CType(session.Query(GetType(TUploadFile), s, 1), TUploadFile())
        If files Is Nothing OrElse files.Length <= 0 Then
            Return False
        End If
        files(0).DownNum = files(0).DownNum + 1

        session.Save(files(0))
        session.Execute()

        Return True
    End Function


    Public Function GetIdByName(ByVal fileName As String) As Integer
        'objRS = objConn.Execute("SELECT [ul_ID],[ul_FileName] FROM [blog_Upload] WHERE [ul_FileName]='" & fileName & "' ")

        Dim s As String
        s = "[FileName]='" & fileName & "'"

        Dim files() As TUploadFile
        Dim session As ISession
        session = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TUploadFile)).IsView = True
        files = CType(session.Query(GetType(TUploadFile), s, 1), TUploadFile())
        If files Is Nothing OrElse files.Length <= 0 Then
            Return 0
        End If

        Return files(0).ID

    End Function

    Public Function LoadInfoByID(ByVal ulfileId As Integer, ByRef upfile As TUploadFile) As Boolean

        'objRS = objConn.Execute("SELECT * FROM [blog_Upload] WHERE [ul_ID]=" & ul_ID)
        If ulfileId <= 0 Then Return False
        If IsNothing(upfile) Then
            upfile = New TUploadFile
        End If

        Dim files() As TUploadFile
        Dim s As String = "[ID]=" & ulfileId.ToString()
        Dim session As ISession
        session = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TUploadFile)).IsView = True

        files = CType(session.Query(GetType(TUploadFile), s), TUploadFile())
        If (files Is Nothing OrElse files.Length < 1) Then
            Return False
        End If

        upfile.CopyFrom(files(0))

        Return True
    End Function

    Public Function GetManagedUploadFiles(ByVal desc As Boolean, ByVal isRoot As Boolean, ByVal userId As Integer, ByVal intpage As Integer, ByVal pagesize As Integer, ByRef pagecount As Integer) As TUploadFile()
        Dim strS As String = "1=1"
        Dim strW As String
        If isRoot = False Then
            strS = strS & " AND [AuthorID] = " & userId
        End If
        strW = strS & " ORDER BY [ID]"
        If desc Then
            strW = strW & " DESC"
        End If
        Dim files() As TUploadFile
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TUploadFile)).IsView = True
        Dim offset As Integer = (intpage - 1) * pagesize + 1
        Dim limitcount As Integer = pagesize
        files = CType(session.Query(GetType(TUploadFile), strW, offset, limitcount), TUploadFile())

        'objRS.Open("SELECT * FROM [blog_Upload] " & strSQL & " ORDER BY [ul_PostTime] DESC")
        'objRS.PageSize = BlogConfig.MANAGE_COUNT
        Dim count As Integer
        count = session.QueryCount(GetType(TUploadFile), strS)
        pagecount = CInt(Math.Ceiling(count / pagesize))
        Return files

    End Function


    Public Function Del(ByVal fileId As Integer, ByRef deletedFile As TUploadFile) As Boolean

        Dim s As String = "[ID]=" & fileId
        Dim files() As TUploadFile
        Dim session As ISession
        session = Me.SessionFactory.CreateSession()

        files = CType(session.Query(GetType(TUploadFile), s), TUploadFile())
        If (files Is Nothing OrElse files.Length < 1) Then
            Throw New BusinessRulesException("CAN NOT find file!")
        End If
        If (deletedFile Is Nothing) Then
            deletedFile = files(0)
        Else
            deletedFile.CopyFrom(files(0))
        End If

        session.Delete(files(0))
        session.Execute()
        Return True
    End Function


    Public Function Upload(ByVal upfile As TUploadFile) As Boolean

        upfile.PostTime = DateTime.Now()

        Dim session As ISession = Me.SessionFactory.CreateSession()
        Dim files() As TUploadFile
        files = CType(session.Query(GetType(TUploadFile), "FileName='" & upfile.FileName & "'"), TUploadFile())

        If files.Length >= 1 Then
            upfile.ID = files(0).ID '͸
        End If

        session.Save(upfile)
        session.Execute()
        Return True
    End Function


    'Public Function GetAllDownCounts() As Object(,)
    '    GetAllDownCounts = Nothing
    '    Dim objConn As ADODB.Connection = Me.OpenConnect()
    '    Try
    '        Dim objRS As ADODB.Recordset
    '        Dim objDS(,) As Object
    '        objRS = objConn.Execute("SELECT [ul_ID],[ul_DownNum] FROM [blog_Upload] ORDER BY [ul_ID] ASC")
    '        If (Not objRS.BOF) And (Not objRS.EOF) Then
    '            objDS = CType(objRS.GetRows, Object(,))
    '        End If
    '        objRS.Close()
    '        objRS = Nothing
    '        GetAllDownCounts = objDS
    '    Catch ex As Exception
    '        '
    '    Finally
    '        objConn.Close()
    '        'If IsDBNull(objDS) Or IsNothing(objDS) Then ReadFileCountInfo = Nothing : Exit Function
    '    End Try
    'End Function

End Class

