Option Explicit On 
Option Strict On

Imports System.Collections
Imports com.oucsoft.WSORM

Public Class UserManager
    Inherits BusinessRulesBase

    Public Function UpdateArticleCount(ByVal userId As Integer) As Boolean
        'objRS = objConn.Execute("SELECT COUNT([log_ID]) FROM [blog_Article] WHERE [log_AuthorID]=" & user.ID)
        'objConn.Execute("UPDATE [blog_Member] SET [mem_PostLogs]=" & i & " WHERE [mem_ID] =" & user.ID)
        Dim s As String
        Dim i As Integer
        Dim session As ISession = Me.SessionFactory.CreateSession()
        s = "[ID]=" & userId.ToString()
        Dim users() As TUser
        users = CType(session.Query(GetType(TUser), s, 1), TUser())
        If users Is Nothing OrElse users.Length <= 0 Then
            Return False
        End If

        s = "[AuthorID]=" & userId.ToString()
        i = session.QueryCount(GetType(TArticle), s)
        users(0).Count = i

        session.Save(users(0))
        session.Execute()

        Return True
    End Function

    Public Function UpdateCommentCount(ByVal userId As Integer) As Boolean
        'objRS = objConn.Execute("SELECT COUNT([comm_ID]) FROM [blog_Comment] WHERE [comm_AuthorID]=" & user.ID)
        'objConn.Execute("UPDATE [blog_Member] SET [mem_PostComms]=" & i & " WHERE [mem_ID] =" & user.ID)
        Dim s As String
        Dim i As Integer
        Dim session As ISession = Me.SessionFactory.CreateSession()
        s = "[ID]=" & userId.ToString()
        Dim users() As TUser
        users = CType(session.Query(GetType(TUser), s, 1), TUser())
        If users Is Nothing OrElse users.Length <= 0 Then
            Return False
        End If

        s = "[AuthorID]=" & userId.ToString()
        i = session.QueryCount(GetType(TComment), s)
        users(0).CommentCount = i

        session.Save(users(0))
        session.Execute()
        Return True
    End Function


    '*********************************************************
    ' Ŀģ    ȡȫû
    '*********************************************************
    Public Function GetUsers() As TUser()

        'objRS = objConn.Execute("SELECT TOP 1 [mem_ID] FROM [blog_Member] ORDER BY [mem_ID] DESC")
        'If (Not objRS.BOF) And (Not objRS.EOF) Then
        '    i = CInt(objRS("mem_ID").Value)
        '    ReDim users(i)
        'End If
        'objRS = objConn.Execute("SELECT [mem_ID],[mem_Name],[mem_Level],[mem_Password],[mem_Email],[mem_Homepage],[mem_PostLogs] FROM [blog_Member] ORDER BY [mem_ID] ASC")

        Dim s As String
        Dim users() As TUser
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TUser)).IsView = True
        session.ObjectMaps(GetType(TUser)).MemberMaps("Intro").Ignored = True

        s = "1=1 ORDER BY [ID] ASC"
        users = CType(session.Query(GetType(TUser), s), TUser())

        Return users
        'If (users Is Nothing OrElse users.Length <= 0) Then
        '    Return users
        'End If
        'Dim rets(users(users.Length - 1).ID) As TUser
        'For Each u As TUser In users
        '    rets(u.ID) = u
        'Next
        'Return rets

    End Function


    Public Function GetManagedUserList(ByVal isRootUser As Boolean, ByVal currentUserID As Integer, _
        ByVal intPage As Integer, ByVal pagesize As Integer, ByRef pagecount As Integer) As TUser()

        If intPage <= 0 Then intPage = 1

        Dim strS As String = "1=1"

        If isRootUser = False Then
            strS = strS & " AND [ID]=" & currentUserID.ToString() 'strSQL = "WHERE [mem_ID] = " & currentUserID
        End If

        Dim strW As String = strS & " ORDER BY [ID] ASC"

        Dim offset As Integer = (intPage - 1) * pagesize + 1
        Dim limitcount As Integer = pagesize
        Dim users() As TUser
        Dim session As ISession = Me.SessionFactory.CreateSession()
        session.ObjectMaps(GetType(TUser)).IsView = True
        users = CType(session.Query(GetType(TUser), strW, offset, limitcount), TUser())

        Dim i As Integer = session.QueryCount(GetType(TUser), strS)
        pagecount = CInt(Math.Ceiling(i / pagesize))

        Return users
    End Function

    Public Function Verify(ByVal user As TUser, ByVal strUserName As String, ByVal strPassword As String, ByVal usernameMax As Integer, ByVal passwordMax As Integer) As Boolean

        strUserName = FilterSQL(strUserName)
        'strPassword = FilterSQL(strPassword)

        'У
        If Len(strUserName) > usernameMax Then
            Throw New IncorrectUserNameOrPasswordException("User Name exceed length!") 'Me.ErrorMessage(7)) 'Call ShowError(7)
        End If
        If Len(strPassword) <> passwordMax Then
            Throw New IncorrectUserNameOrPasswordException("Password exceed length!") 'Me.ErrorMessage(7)) 'Call ShowError(7)
        End If

        'objRS = objConn.Execute("SELECT [mem_ID],[mem_Level],[mem_Password] FROM [blog_Member] WHERE [mem_Name]='" & strUserName & "'")
        Dim s As String
        Dim users() As TUser
        Dim session As ISession = Me.SessionFactory.CreateSession()

        s = "[Name]='" & strUserName & "'"
        users = CType(session.Query(GetType(TUser), s, 1), TUser())

        If users Is Nothing OrElse users.Length <= 0 Then
            Return False
        End If

        If strPassword.CompareTo(users(0).Password) = 0 Then
            If (user Is Nothing) Then
                user = New TUser
            End If
            user.CopyFrom(users(0))
            user.Password = ""
            Return True
        Else
            Return False
        End If

    End Function


    Public Function Edit(ByVal editedUser As TUser, ByVal currentUser As TUser) As Boolean

        If ((editedUser.Level < 1) Or (editedUser.Level > 5)) Then Throw New NotEnoughPowerException("Not Enough Power to edit User info.") 'BusinessRuleException(ErrorMessage(16)) 'Call ShowError(16)
        Dim session As ISession = Me.SessionFactory.CreateSession()

        If editedUser.ID = 0 Then

            If editedUser.Level <= currentUser.Level Then Throw New NotEnoughPowerException("Not Enough Power to edit User info.") 'BusinessRuleException(ErrorMessage(6)) 'ShowError(6)

        Else

            If (editedUser.ID = currentUser.ID) And (editedUser.Level <> currentUser.Level) Then Throw New NotEnoughPowerException("Not Enough Power to edit User info.") 'BusinessRuleException(ErrorMessage(6)) 'ShowError(6)
            If (editedUser.ID <> currentUser.ID) And (editedUser.Level <= currentUser.Level) Then Throw New NotEnoughPowerException("Not Enough Power to edit User info.") 'BusinessRuleException(ErrorMessage(6)) 'ShowError(6)

            Dim targetUser As New TUser
            If Me.LoadInfoByID(editedUser.ID, targetUser) Then 'targetUser = New TUser
                If editedUser.Password Is Nothing OrElse Len(editedUser.Password) = 0 Then
                    editedUser.Password = targetUser.Password
                End If
            Else
                Throw New BusinessRulesException("CAN NOT Find the user's info!")
                Exit Function
            End If

        End If
        session.Save(editedUser)
        session.Execute()
        Edit = True

    End Function


    Public Function Register(ByVal newUser As TUser, ByVal currentUser As TUser, ByVal userNameExist As Boolean) As Boolean

        'newUser.Email = FilterSQL(newUser.Email)
        'newUser.Homepage = FilterSQL(newUser.Homepage)
        userNameExist = False

        Dim strUserName As String = filtersql(newUser.Name.Trim())
        Dim s As String = "[Name]='" & strUserName & "'"
        Dim session As ISession = Me.SessionFactory.CreateSession()
        Dim users() As TUser

        If newUser.ID = 0 Then

            'עȼû
            'Catch ex As Exception
            'If Err.Number = -2147467259 Then
            'Response.Clear()
            'Response.Write("UserExist")
            'Response.End()
            'End If

            users = CType(session.Query(GetType(TUser), s, 1), TUser())
            If Not users Is Nothing AndAlso users.Length > 0 Then
                userNameExist = True
                Return False
            End If

            'objConn.Execute("INSERT INTO [blog_Member]([mem_Level],[mem_Name],[mem_Password],[mem_Email],[mem_Homepage]) VALUES (" & newUser.Level & ",'" & newUser.Name & "','" & newUser.Password & "','" & newUser.Email & "','" & newUser.Homepage & "')")
            session.Save(newUser)
            session.Execute()

            Return True

        Else
            Return False
        End If

    End Function


    Public Function LoadInfoByID(ByVal userid As Integer, ByRef user As TUser) As Boolean

        Dim session As ISession = Me.SessionFactory.CreateSession()
        Dim users() As TUser
        users = CType(session.Query(GetType(TUser), "ID=" & userid.ToString()), TUser())

        If Not users Is Nothing AndAlso users.Length > 0 Then 'If (Not objRS.BOF) And (Not objRS.EOF) Then

            If user Is Nothing Then
                user = users(0)
            Else
                user.CopyFrom(users(0))
            End If

        Else
            Exit Function
        End If

        LoadInfoByID = True

    End Function


    Public Function Del(ByVal userId As Integer, ByVal currentUser As TUser, ByRef uploadFiles As TUploadFile()) As Boolean

        Dim targetUser As New TUser
        If Me.LoadInfoByID(userId, targetUser) Then
            If targetUser.Level <= currentUser.Level Then
                Throw New NotEnoughPowerException("Not Enough Power to Delete User!") 'BusinessRuleException(Me.ErrorMessage(6)) ' ShowError(6)
            End If
            If currentUser.ID = targetUser.ID Then
                Throw New DeleteUserException("Error:Can NOT Delete Yourself!") 'BusinessRuleException  'Me.ErrorMessage(17)) 'ShowError(17)
            End If
        Else
            Exit Function
        End If

        Dim session As ISession = Me.SessionFactory.CreateSession()

        Dim s As String
        Dim comments() As TComment
        Dim articles() As TArticle
        Dim users() As TUser
        Dim uploads() As TUploadFile

        s = "[ID]=" & userId.ToString()
        users = CType(session.Query(GetType(TUser), s), TUser())
        If users Is Nothing OrElse users.Length <= 0 Then
            Return False
        End If

        s = "[AuthorID]=" & userId.ToString()
        comments = CType(session.Query(GetType(TComment), s), TComment())
        If Not comments Is Nothing Then
            For Each c As TComment In comments
                session.Delete(c)
            Next
        End If

        s = "[AuthorID]=" & userId.ToString()
        articles = CType(session.Query(GetType(TArticle), s), TArticle())
        If Not articles Is Nothing Then
            For Each a As TArticle In articles
                session.Delete(a)
            Next
        End If

        s = "[AuthorID]=" & userId.ToString()
        uploads = CType(session.Query(GetType(TUploadFile), s), TUploadFile())
        uploadFiles = uploads 'ע
        If Not uploads Is Nothing Then
            For Each u As TUploadFile In uploads
                session.Delete(u)
            Next
        End If

        'objConn.Execute("DELETE FROM [blog_Article] WHERE [log_AuthorID] =" & ID)
        'objConn.Execute("DELETE FROM [blog_Comment] WHERE [comm_AuthorID] =" & ID)
        'objConn.Execute("DELETE FROM [blog_Member] WHERE [mem_ID] =" & ID)

        'Dim ufm As UploadFileManager = New UploadFileManager
        'objRS = objConn.Execute("SELECT * FROM [blog_Upload] WHERE [ul_AuthorID] =" & ID)
        'If (Not objRS.BOF) And (Not objRS.EOF) Then
        '    Do While Not objRS.EOF
        '        Dim deletedFile As TUploadFile
        '        If (ufm.Del(CInt(objRS("ul_ID").Value), deletedFile)) Then
        '            If System.IO.File.Exists(System.IO.Path.Combine(blogPath, "upload/" & deletedFile.FileName)) Then
        '                System.IO.File.Delete(System.IO.Path.Combine(blogPath, "upload/" & deletedFile.FileName))
        '            End If
        '        End If
        '        objRS.MoveNext()
        '    Loop
        'End If
        'objRS.Close()
        'objRS = Nothing
        'objConn.Execute("DELETE FROM [blog_Upload] WHERE [ul_AuthorID] =" & ID)

        session.Delete(users(0))

        session.Execute()
        Return True

    End Function


End Class

