Option Explicit On 
Option Strict On

Imports System.Collections
Imports System.Xml.Serialization

Public Class BlogConfiguration


    Dim _blogRootUrl As String
    <HtmlExportTemplateItem("<#ZC_BLOG_HOST#>")> _
    Public Property BlogRootUrl() As String
        Get
            Return Me._blogRootUrl
        End Get
        Set(ByVal Value As String)
            Me._blogRootUrl = Value
        End Set
    End Property

    Public Sub New()
        'ReadFromConfigFile()
    End Sub

    Public Sub New(ByVal blogRootUrl As String)
        Me._blogRootUrl = BlogRootUrl
    End Sub

    'Private Shared instance As BlogConfiguration = Nothing
    'Public Shared Function GetInstance() As BlogConfiguration
    '    If instance Is Nothing Then
    '        SyncLock GetType(BlogConfiguration)
    '            If instance Is Nothing Then
    '                instance = New BlogConfiguration
    '            End If
    '        End SyncLock
    '    End If
    '    Return instance
    'End Function
    'Public Sub New()
    '    ReadFromConfigFile()
    'End Sub

    Public Shared Function LoadFromFile(ByVal filepath As String) As BlogConfiguration
        If Not (System.IO.File.Exists(filepath)) Then
            Return Nothing
        End If

        Dim serializer As New XmlSerializer(GetType(BlogConfiguration))
        Dim reader As New System.IO.StreamReader(filepath, System.Text.Encoding.UTF8)
        Dim objTemp As BlogConfiguration
        Try
            objTemp = CType(serializer.Deserialize(reader), BlogConfiguration)
        Finally
            reader.Close()
        End Try
        Return objTemp
    End Function

    Public Sub Save(ByVal filePath As String)
        Dim serializer As New XmlSerializer(GetType(BlogConfiguration))
        Dim writer As New System.IO.StreamWriter(filePath, False, System.Text.Encoding.UTF8)
        Try
            serializer.Serialize(writer, Me)
            'Catch ex As Exception
        Finally
            writer.Close()
        End Try
    End Sub

    'Public Sub ReadFromConfigFile()
    '    Dim table As Hashtable
    '    table = CType(System.Configuration.ConfigurationSettings.GetConfig("blogConfig/blogConfigDictionary"), Hashtable)
    '    For Each item As DictionaryEntry In table
    '        ObjectMemberHelper.SetMemberValue(CType(item.Key, String), item.Value, Me)
    '    Next
    'End Sub

    '  Public Function GetSettingValue(ByVal strName As String, ByRef strValue As String) As Boolean
    '    GetSettingValue = False
    '    Dim objVal As Object = ObjectMemberHelper.GetMemberValue(strName, Me)
    '    If Not objVal Is Nothing Then
    '        strValue = objVal.ToString()
    '        GetSettingValue = True
    '    End If
    'End Function


    '<HtmlExportTemplateItem("<#ZC_BLOG_HOST#>")> _
    'Public ZC_BLOG_HOST As String = "http://localhost/WSBLog/"
    '<HtmlExportTemplateItem("<#ZC_BLOG_CLSID#>")> _
    'Public ZC_BLOG_CLSID As String = "BC1022C0-542E-4938-AD64-5EE4758F04EC"


    <HtmlExportTemplateItem("<#WebSiteDescription#>")> _
    Public WebSiteDescription As String = "wubuku.com - QR Code,BLOG,ASP.Net,Java,PDA"

    <HtmlExportTemplateItem("<#WebSiteKeywords#>")> _
    Public WebSiteKeywords As String = " ά QR Code RFID ݲɼ ֳն PDA Զʶ ƶ"

    <HtmlExportTemplateItem("<#ZC_BLOG_TITLE#>")> _
    Public BlogTitle As String = "WSBLog"

    <HtmlExportTemplateItem("<#ZC_BLOG_SUBTITLE#>")> _
    Public BlogSubTitle As String = "ļ޵Ĳ"

    <HtmlExportTemplateItem("<#ZC_BLOG_NAME#>")> _
    Public BlogName As String = "ļ"

    <HtmlExportTemplateItem("<#ZC_BLOG_SUB_NAME#>")> _
    Public BlogSubName As String = "ӭʹWSBLogʲôҷлл"

    <HtmlExportTemplateItem("<#ZC_BLOG_LANGUAGE#>")> _
    Public BlogLanguage As String = "zh-CN"

    <HtmlExportTemplateItem("<#ZC_BLOG_CSS#>")> _
    Public BlogCss As String = "newage3"

    <HtmlExportTemplateItem("<#ZC_BLOG_COPYRIGHT#>")> _
    Public BlogCopyright As String = "Copyright 2004-2006 wubuku.com. Some Rights Reserved."

    <HtmlExportTemplateItem("<#ZC_BLOG_MASTER#>")> _
    Public BlogMaster As String = "wubuku"

    <HtmlExportTemplateItem("<#ZC_BLOG_VERSION#>")> _
    Public BlogVersion As String = "1.6 Beta2 Build 70325"

    <HtmlExportTemplateItem("<#ZC_BLOG_WEBEDIT#>")> _
    Public BlogWebEditor As String = "widgeditor"

    <HtmlExportTemplateItem("<#ZC_TIME_ZONE#>")> _
    Public TimeZone As String = "+0800"

    'ʹʹAjax̬װط
    Public UseAjaxCategories As Boolean = False

    'ȱʡ·Ƿչӷ࣬ʹAjaxװطʱ򣬴Ч
    Public CategoryExpandChilds As Boolean = True

    'Ƿʹ̬htmlҳļfalseҪURLд֧
    Public BuildRealStaicPage As Boolean = False

    'ʹ̬htmlļ齫ĳhtml
    Public STATIC_TYPE As String = "aspx"

    'Ƿ±еtagsֶΣ΢һ
    Public USE_ARTICLE_TAG_CACHE_FIELD As Boolean = True

    'ǷʹԶ
    Public AutoUpdateEnable As Boolean = True

    'ؽʱǷؽTags̬ļ
    Public BuildTagsHtmlFile As Boolean = True

    Public STATIC_DIRECTORY As String = "post"

    Public MSG_COUNT As Integer = 10

    Public ARCHIVE_COUNT As Integer = 0

    Public PREVIOUS_COUNT As Integer = 15

    Public DISPLAY_COUNT As Integer = 10

    Public DISPLAY_COUNT_LIST As Integer = 15


    Public MANAGE_COUNT As Integer = 50

    Public RSS2_COUNT As Integer = 10

    Public SEARCH_COUNT As Integer = 25

    Public PAGEBAR_COUNT As Integer = 14

    <HtmlExportTemplateItem("<#ZC_IMAGE_WIDTH#>")> _
    Public IMAGE_WIDTH As Integer = 480

    Public REBUILD_FILE_COUNT As Integer = 100

    Public REBUILD_FILE_INTERVAL As Integer = 1

    Public AUTO_NEWLINE As Boolean = True

    Public JAPANESE_TO_HTML_ENTITIES As Boolean = True

    Public USE_NAVIGATE_ARTICLE As Boolean = True

    <HtmlExportTemplateItem("<#ZC_REGISTER_ENABLE#>")> _
    Public REGISTER_ENABLE As Boolean = False

    <HtmlExportTemplateItem("<#ZC_COMMENT_VERIFY_ENABLE#>")> _
    Public COMMENT_VERIFY_ENABLE As Boolean = True

    Public COMMENT_NOFOLLOW_ENABLE As Boolean = True

    <HtmlExportTemplateItem("<#ZC_HIDE_EMOTION#>")> _
    Public HIDE_EMOTION As Boolean = False

    <HtmlExportTemplateItem("<#ZC_COMMENT_STATIC_SHOW#>")> _
    Public COMMENT_STATIC_SHOW As Boolean = False

    <HtmlExportTemplateItem("<#ZC_COMMENT_MULTI_PAGE#>")> _
    Public COMMENT_MULTI_PAGE As Boolean = True

    <HtmlExportTemplateItem("<#ZC_COMMENT_MULTI_PAGESIZE#>")> _
    Public COMMENT_MULTI_PAGESIZE As Integer = 5


    Public UBB_LINK_ENABLE As Boolean = True

    Public UBB_FONT_ENABLE As Boolean = True

    Public UBB_CODE_ENABLE As Boolean = True

    Public UBB_FACE_ENABLE As Boolean = True

    Public UBB_IMAGE_ENABLE As Boolean = True

    Public UBB_MEDIA_ENABLE As Boolean = True

    Public UBB_FLASH_ENABLE As Boolean = True

    Public UBB_TYPESET_ENABLE As Boolean = True

    Public UBB_AUTOLINK_ENABLE As Boolean = True

    Public UBB_AUTOKEY_ENABLE As Boolean = True

    Public UBB_UPLOAD_ENABLE As Boolean = True

    <HtmlExportTemplateItem("<#ZC_EMOTICONS_FILENAME#>")> _
    Public EMOTICONS_FILENAME As String = "Haha|Hehe|Love|Misdoubt|Music|Nothing_to_say|Sad|Shame|Sleep|Smile|Stop|What|Adore|After_boom|Angry|Cool|Cry|Effort|Faint|Grimace"

    <HtmlExportTemplateItem("<#ZC_EMOTICONS_FILESIZE#>")> _
    Public EMOTICONS_FILESIZE As Integer = 48


    Public UPLOAD_FILETYPE As String = "jpg|gif|png|jpeg|bmp|psd|wmf|ico|rpm|deb|tar|gz|sit|7z|bz2|zip|rar|xml|xsl|svg|svgz|doc|xls|wps|chm|txt|pdf|mp3|avi|mpg|rm|ra|rmvb|mov|wmv|wma|swf|fla|torrent"

    Public UPLOAD_FILESIZE As Integer = 10485760

    'Public DISPLAY_MODE_ALL As Integer = 1
    'Public DISPLAY_MODE_INTRO As Integer = 2
    'Public DISPLAY_MODE_HIDE As Integer = 3
    'Public DISPLAY_MODE_LIST As Integer = 4
    'Public DISPLAY_MODE_ONTOP As Integer = 5
    'Public DISPLAY_MODE_SEARCH As Integer = 6

    Public USERNAME_MAX As Integer = 20

    Public PASSWORD_MAX As Integer = 32

    Public EMAIL_MAX As Integer = 30

    Public HOMEPAGE_MAX As Integer = 100

    <HtmlExportTemplateItem("<#ZC_CONTENT_MAX#>")> _
    Public CONTENT_MAX As Integer = 1000

    <HtmlExportTemplateItem("<#ZC_CONTENT_MIN#>")> _
    Public CONTENT_MIN As Integer = 2

    Public TB_EXCERPT_MAX As Integer = 250

    Public RECENT_COMMENT_WORD_MAX As Integer = 16


    Public FILE_COUNT As Boolean = False

    Public SHOW_LIST_FILE_COUNT As Boolean = False

    Public SHOW_SINGLE_FILE_COUNT As Boolean = False

    Public VIEW_COUNT As Boolean = False

    Public SHOW_LIST_VIEW_COUNT As Boolean = False

    Public SHOW_SINGLE_VIEW_COUNT As Boolean = False

    Public WHOLE_COUNT As Boolean = False


    Public IE_DISPLAY_WAP As Boolean = False
    Public DISPLAY_COUNT_WAP As Integer = 2
    Public COMMENT_COUNT_WAP As Integer = 3
    Public PAGEBAR_COUNT_WAP As Integer = 5
    Public SINGLE_SIZE_WAP As Integer = 100
    Public SINGLE_PAGEBAR_COUNT_WAP As Integer = 5
    Public COMMENT_PAGEBAR_COUNT_WAP As Integer = 5


End Class
