Option Explicit On 
Option Strict On

Imports System.Xml.Serialization

Public Class BlogMessages


    Public Shared Function LoadFromFile(ByVal filepath As String) As BlogMessages
        If Not (System.IO.File.Exists(filepath)) Then
            Return Nothing
        End If

        Dim serializer As New XmlSerializer(GetType(BlogMessages))
        Dim reader As New System.IO.StreamReader(filepath, System.Text.Encoding.UTF8)
        Dim objTemp As BlogMessages
        Try
            objTemp = CType(serializer.Deserialize(reader), BlogMessages)
        Finally
            reader.Close()
        End Try
        Return objTemp
    End Function

    Public Sub Save(ByVal filePath As String)
        Dim serializer As New XmlSerializer(GetType(BlogMessages))
        Dim writer As New System.IO.StreamWriter(filePath, False, System.Text.Encoding.UTF8)
        Try
            serializer.Serialize(writer, Me)
            'Catch ex As Exception
        Finally
            writer.Close()
        End Try
    End Sub

    <HtmlExportTemplateItem("<#ZC_MSG001#>")> Public MSG_NAME As String = "名称"
    <HtmlExportTemplateItem("<#ZC_MSG002#>")> Public MSG_PASSWORD As String = "密码"
    <HtmlExportTemplateItem("<#ZC_MSG003#>")> Public MSG_USER As String = "用户"
    <HtmlExportTemplateItem("<#ZC_MSG004#>")> Public MSG_SAVE As String = "保存"
    <HtmlExportTemplateItem("<#ZC_MSG005#>")> Public MSG_NOT_SAVE As String = "不保存"
    <HtmlExportTemplateItem("<#ZC_MSG006#>")> Public MSG_SAVE_ONE_DAY As String = "保存1天"
    <HtmlExportTemplateItem("<#ZC_MSG007#>")> Public MSG_SAVE_ONE_MONTH As String = "保存1月"
    <HtmlExportTemplateItem("<#ZC_MSG008#>")> Public MSG_SAVE_ONE_YEAR As String = "保存1年"
    <HtmlExportTemplateItem("<#ZC_MSG009#>")> Public MSG_ADMIN_LOGIN As String = "管理登录"
    <HtmlExportTemplateItem("<#ZC_MSG010#>")> Public MSG_NO_EMPTY_USERNAME_OR_PASSWORD As String = "用户名、密码不能为空"
    <HtmlExportTemplateItem("<#ZC_MSG011#>")> Public MSG_PUBLISH As String = "发布"
    <HtmlExportTemplateItem("<#ZC_MSG012#>")> Public MSG_CATEGORY As String = "分类"
    <HtmlExportTemplateItem("<#ZC_MSG013#>")> Public MSG_COMMENT As String = "评论"
    <HtmlExportTemplateItem("<#ZC_MSG014#>")> Public MSG_TRACKBACK As String = "引用"
    <HtmlExportTemplateItem("<#ZC_MSG015#>")> Public MSG_VIEW As String = "查看"
    <HtmlExportTemplateItem("<#ZC_MSG016#>")> Public MSG_EXCERPT As String = "摘要"
    <HtmlExportTemplateItem("<#ZC_MSG017#>")> Public MSG_PLEASE_INPUT_WEBSITE_URL As String = "Please input your website url."
    <HtmlExportTemplateItem("<#ZC_MSG018#>")> Public MSG_GUEST As String = "来宾"
    <HtmlExportTemplateItem("<#ZC_MSG019#>")> Public ZC_MSG019 As String = "查看登录%s登录BLOG%s退出BLOG%s查看管理%s发表评论%s发表引用%s查看权限%s管理文章%s编辑文章%s发布文章%s删除文章%s管理分类%s修改分类%s删除分类%s管理评论%s删除评论%s管理引用%s删除引用%s传送引用%s管理用户%s修改用户%s创建用户%s删除用户%s索引重建%s文章重建%s附件管理%s附件上传%s附件删除%s站内搜索%s全局管理%s网站设置%s设置保存%s插件管理%sRSS输出%s超级管理%s"
    <HtmlExportTemplateItem("<#ZC_MSG020#>")> Public MSG_LOGOUT As String = "退出"
    <HtmlExportTemplateItem("<#ZC_MSG021#>")> Public MSG_VIEW_PRIVILEGE As String = "查看权限"
    <HtmlExportTemplateItem("<#ZC_MSG022#>")> Public MSG_ADMIN As String = "管理"
    <HtmlExportTemplateItem("<#ZC_MSG023#>")> Public MSG_HELLO As String = "您好，%s"
    <HtmlExportTemplateItem("<#ZC_MSG024#>")> Public MSG_POST_COMMENT As String = "发表评论"
    <HtmlExportTemplateItem("<#ZC_MSG025#>")> Public MSG_CONTROL_PANEL As String = "控制面板"      'ControlPanel		
    <HtmlExportTemplateItem("<#ZC_MSG026#>")> Public MSG_CATEGORIES As String = "网站目录"      'Categories		
    <HtmlExportTemplateItem("<#ZC_MSG027#>")> Public MSG_LATEST_COMMENTS As String = "最新评论"      'Comments		
    <HtmlExportTemplateItem("<#ZC_MSG028#>")> Public MSG_ARCHIVES As String = "文章归档"      'Archives		
    <HtmlExportTemplateItem("<#ZC_MSG029#>")> Public MSG_BLOG_STATISTICS As String = "站点统计"      'Blog Statistics		
    <HtmlExportTemplateItem("<#ZC_MSG030#>")> Public MSG_FAVORITES As String = "网站收藏"      'Favorites		
    <HtmlExportTemplateItem("<#ZC_MSG031#>")> Public MSG_LINKAGE As String = "友情链接"      'Linkage		
    <HtmlExportTemplateItem("<#ZC_MSG032#>")> Public MSG_PREVIOUS As String = "最近发表"      'Previous		
    <HtmlExportTemplateItem("<#ZC_MSG033#>")> Public MSG_NO_EMPTY_NAME As String = "名称不能为空"
    <HtmlExportTemplateItem("<#ZC_MSG034#>")> Public MSG_INCORRECT_NAME_OR_EMAIL As String = "名称或邮箱格式不对"
    <HtmlExportTemplateItem("<#ZC_MSG035#>")> Public MSG_COMMENT_TOO_LONG_OR_TOO_SHORT As String = "留言不能过长或过短"
    <HtmlExportTemplateItem("<#ZC_MSG036#>")> Public MSG_PAGE_NUMBER As String = "第%s页"
    <HtmlExportTemplateItem("<#ZC_MSG037#>")> Public MSG_UBB_CODES As String = "UBB标签"
    <HtmlExportTemplateItem("<#ZC_MSG038#>")> Public MSG_PASSWORD_TOO_SHORT As String = "密码不能小于6位"
    <HtmlExportTemplateItem("<#ZC_MSG039#>")> Public MSG_MISC As String = "图标汇集"      'Misc		
    <HtmlExportTemplateItem("<#ZC_MSG040#>")> Public MSG_WELCOME_POST_COMMENT_ As String = "◎欢迎参与讨论，请在这里发表您的看法、交流您的观点."
    <HtmlExportTemplateItem("<#ZC_MSG041#>")> Public MSG_SIZE As String = "大小"
    <HtmlExportTemplateItem("<#ZC_MSG042#>")> Public MSG_PAGE As String = "分页"
    <HtmlExportTemplateItem("<#ZC_MSG043#>")> Public MSG_LOGIN_TO_VIEW_HIDDEN_ARTICLE As String = "文章已隐藏，请先登录"
    <HtmlExportTemplateItem("<#ZC_MSG044#>")> Public MSG_TITLE_SEPARATOR As String = "-"
    <HtmlExportTemplateItem("<#ZC_MSG045#>")> Public MSG_ERROR_OCCUR As String = "错误处理"
    <HtmlExportTemplateItem("<#ZC_MSG046#>")> Public MSG_MANAGE As String = "管理"
    <HtmlExportTemplateItem("<#ZC_MSG047#>")> Public MSG_EDIT_ARTICLE As String = "文章编辑"
    <HtmlExportTemplateItem("<#ZC_MSG048#>")> Public MSG_ARTICLE As String = "文章"
    <HtmlExportTemplateItem("<#ZC_MSG049#>")> Public MSG_REMEMBER_ME As String = "记住我，下次回复时不用重新输入个人信息"
    <HtmlExportTemplateItem("<#ZC_MSG050#>")> Public MSG_CALENDAR As String = "日历"      'Calendar		
    <HtmlExportTemplateItem("<#ZC_MSG051#>")> Public MSG_STICKY As String = "置顶"
    <HtmlExportTemplateItem("<#ZC_MSG052#>")> Public MSG_NAVIGATION As String = "导航菜单"      'Navigation		
    <HtmlExportTemplateItem("<#ZC_MSG053#>")> Public MSG_EMAIL As String = "邮箱"
    <HtmlExportTemplateItem("<#ZC_MSG054#>")> Public MSG_WEBSITE_URL As String = "网站链接"
    <HtmlExportTemplateItem("<#ZC_MSG055#>")> Public MSG_CONTENT As String = "正文"
    <HtmlExportTemplateItem("<#ZC_MSG056#>")> Public MSG_COMMENT_MAX_LENGTH As String = "留言最长字数"
    <HtmlExportTemplateItem("<#ZC_MSG057#>")> Public MSG_SHOW_UBB_EMOTION_FACE As String = "显示UBB表情>>"
    <HtmlExportTemplateItem("<#ZC_MSG058#>")> Public MSG_OK_TO_CONTINUE_OR_CANCEL As String = "单击[确定]继续，单击[取消]停止."
    <HtmlExportTemplateItem("<#ZC_MSG059#>")> Public MSG_HTML_TAGS As String = "HTML标签"
    <HtmlExportTemplateItem("<#ZC_MSG060#>")> Public MSG_TITLE As String = "标题"
    <HtmlExportTemplateItem("<#ZC_MSG061#>")> Public MSG_TYPE As String = "类型"
    <HtmlExportTemplateItem("<#ZC_MSG062#>")> Public MSG_POSTTIME As String = "日期"
    <HtmlExportTemplateItem("<#ZC_MSG063#>")> Public MSG_DELETE As String = "删除"
    <HtmlExportTemplateItem("<#ZC_MSG064#>")> Public MSG_SEND_TRACKBACK As String = "传送引用"
    <HtmlExportTemplateItem("<#ZC_MSG065#>")> Public MSG_GO_BACK As String = "返回"
    <HtmlExportTemplateItem("<#ZC_MSG066#>")> Public MSG_MANAGE_CATEGORY As String = "分类管理"
    <HtmlExportTemplateItem("<#ZC_MSG067#>")> Public MSG_MANAGE_ARTICLE As String = "文章管理"
    <HtmlExportTemplateItem("<#ZC_MSG068#>")> Public MSG_MANAGE_COMMENT As String = "评论管理"
    <HtmlExportTemplateItem("<#ZC_MSG069#>")> Public MSG_MANAGE_TRACKBACK As String = "引用管理"
    <HtmlExportTemplateItem("<#ZC_MSG070#>")> Public MSG_MANAGE_USER As String = "用户管理"
    <HtmlExportTemplateItem("<#ZC_MSG071#>")> Public MSG_MANAGE_ATTACHMENT As String = "附件管理"
    <HtmlExportTemplateItem("<#ZC_MSG072#>")> Public MSG_REBUILD_INDEX As String = "索引重建"
    <HtmlExportTemplateItem("<#ZC_MSG073#>")> Public MSG_REBUILD_STATIC_FILES As String = "文件重建"
    <HtmlExportTemplateItem("<#ZC_MSG074#>")> Public MSG_CREATE_ARTICLE As String = "文章生成"
    <HtmlExportTemplateItem("<#ZC_MSG075#>")> Public MSG_TIME As String = "时间"
    <HtmlExportTemplateItem("<#ZC_MSG076#>")> Public MSG_ID As String = "ID"
    <HtmlExportTemplateItem("<#ZC_MSG077#>")> Public MSG_NEW_CATEGORY As String = "新建分类"
    <HtmlExportTemplateItem("<#ZC_MSG078#>")> Public MSG_EDIT As String = "编辑"
    <HtmlExportTemplateItem("<#ZC_MSG079#>")> Public MSG_ORDER As String = "排序"
    <HtmlExportTemplateItem("<#ZC_MSG080#>")> Public MSG_IP As String = "IP"
    <HtmlExportTemplateItem("<#ZC_MSG081#>")> Public MSG_URL As String = "URL"
    <HtmlExportTemplateItem("<#ZC_MSG082#>")> Public MSG_ARTICLE_TOTAL_NUMBER As String = "文章总数"
    <HtmlExportTemplateItem("<#ZC_MSG083#>")> Public MSG_CURRENT_STYLE As String = "当前样式"
    <HtmlExportTemplateItem("<#ZC_MSG084#>")> Public MSG_CURRENT_LANGUAGE As String = "当前语言"
    <HtmlExportTemplateItem("<#ZC_MSG085#>")> Public MSG_SEARCH As String = "Search"      '搜索		
    <HtmlExportTemplateItem("<#ZC_MSG086#>")> Public MSG_SEARCH_RESULT As String = "搜索%s，共找到%s个结果"
    <HtmlExportTemplateItem("<#ZC_MSG087#>")> Public MSG_POST As String = "提交"
    <HtmlExportTemplateItem("<#ZC_MSG088#>")> Public MSG_RESET As String = "重置"
    <HtmlExportTemplateItem("<#ZC_MSG089#>")> Public MSG_VERIFICATION_CODE As String = "验证"
    <HtmlExportTemplateItem("<#ZC_MSG090#>")> Public MSG_GLOBAL_MANAGEMENT As String = "全局管理"
    <HtmlExportTemplateItem("<#ZC_MSG091#>")> Public MSG_BLOG_NAME As String = "BLOG的名称"
    <HtmlExportTemplateItem("<#ZC_MSG092#>")> Public MSG_BLOG_DESCRIPION As String = "BLOG的简介"
    <HtmlExportTemplateItem("<#ZC_MSG093#>")> Public MSG_BLOG_TITLE As String = "网站的标题"
    <HtmlExportTemplateItem("<#ZC_MSG094#>")> Public MSG_BLOG_SUBTITLE As String = "网站的子标题"
    <HtmlExportTemplateItem("<#ZC_MSG095#>")> Public MSG_STYLE_NAME As String = "界面样式名称"
    <HtmlExportTemplateItem("<#ZC_MSG096#>")> Public MSG_BLOG_COPYRIGHT As String = "BLOG版权说明"
    <HtmlExportTemplateItem("<#ZC_MSG097#>")> Public MSG_BLOG_OWNER As String = "BLOG所有者"
    <HtmlExportTemplateItem("<#ZC_MSG098#>")> Public MSG_ERROR_SOURCE As String = "错误原因"
    <HtmlExportTemplateItem("<#ZC_MSG099#>")> Public MSG_UNTITLED_ARTICLE As String = "未命名文章"
    <HtmlExportTemplateItem("<#ZC_MSG100#>")> Public MSG_EDIT_WYSIWYG As String = "在线编辑"
    <HtmlExportTemplateItem("<#ZC_MSG101#>")> Public MSG_EDIT_NORMAL As String = "普通编辑"
    <HtmlExportTemplateItem("<#ZC_MSG102#>")> Public MSG_OPTIONS As String = "选项"
    <HtmlExportTemplateItem("<#ZC_MSG103#>")> Public MSG_PLAY_PAUSE_MEDIA As String = "播放/隐藏 媒体"
    <HtmlExportTemplateItem("<#ZC_MSG104#>")> Public MSG_BLOG_ROOT_URL As String = "BLOG的地址"
    <HtmlExportTemplateItem("<#ZC_MSG105#>")> Public MSG_BASIC_SETTINGS As String = "基础设置"
    <HtmlExportTemplateItem("<#ZC_MSG106#>")> Public MSG_ADVANCED_SETTINGS As String = "高级设置"
    <HtmlExportTemplateItem("<#ZC_MSG107#>")> Public MSG_MANAGE_PLUGIN As String = "插件管理"
    <HtmlExportTemplateItem("<#ZC_MSG108#>")> Public MSG_UPLOAD_FILE As String = "上传文件"
    <HtmlExportTemplateItem("<#ZC_MSG109#>")> Public MSG_USE_WYSIWYG_EDITOR As String = "使用Web界面的在线编辑器，即见既所得的编辑日志"
    <HtmlExportTemplateItem("<#ZC_MSG110#>")> Public MSG_USE_UBB_EDITOR As String = "使用UBB代码编辑日志，同时也支持HTML代码混合输入(推荐使用)"
    <HtmlExportTemplateItem("<#ZC_MSG111#>")> Public MSG_BASIC_SETTINGS_DESCRIPTION As String = "设置BLOG的标题，更改网站说明，切换界面样式等"
    <HtmlExportTemplateItem("<#ZC_MSG112#>")> Public MSG_REBUILD_ALL_FILES_DESCRIPTION As String = "重新生成所有的日志，当更改BLOG设置时请使用此功能，耗时较长"
    <HtmlExportTemplateItem("<#ZC_MSG113#>")> Public MSG_ADVANCED_SETTINGS_DESCRIPTION As String = "调整各种高级选项，如评论验证、列表页显示数量、日志静态化类型等"
    <HtmlExportTemplateItem("<#ZC_MSG114#>")> Public MSG_PLUGIN_ADMIN_DESCRIPION As String = "浏览系统已安装的插件并执行相关插件"
    <HtmlExportTemplateItem("<#ZC_MSG115#>")> Public MSG_NO_EMPTY_CATEGORY As String = "分类不能为空"
    <HtmlExportTemplateItem("<#ZC_MSG116#>")> Public MSG_NO_EMPTY_CONTENT As String = "正文不能为空"
    <HtmlExportTemplateItem("<#ZC_MSG117#>")> Public MSG_SEND_TRACKBACK_AFTER_POST As String = "先提交日志才能发送引用"
    <HtmlExportTemplateItem("<#ZC_MSG118#>")> Public MSG_NO_EMPTY_NAME_2 As String = "名称不能为空"
    <HtmlExportTemplateItem("<#ZC_MSG119#>")> Public MSG_NO_EMPTY_PASSWORD As String = "密码不能为空"
    <HtmlExportTemplateItem("<#ZC_MSG120#>")> Public MSG_NO_EMPTY_EMAIL As String = "邮箱不能为空"
    <HtmlExportTemplateItem("<#ZC_MSG121#>")> Public MSG_ADD_NEW_LOG As String = "添加新日志"
    <HtmlExportTemplateItem("<#ZC_MSG122#>")> Public MSG_ADD_NEW_CATEGORY As String = "添加新分类"
    <HtmlExportTemplateItem("<#ZC_MSG123#>")> Public MSG_ADD_NEW_USER As String = "添加新用户"
    <HtmlExportTemplateItem("<#ZC_MSG124#>")> Public MSG_COMMENT_TOTAL_COUNT As String = "评论总数"
    <HtmlExportTemplateItem("<#ZC_MSG125#>")> Public MSG_TRACKBACK_TOTAL_COUNT As String = "引用总数"
    <HtmlExportTemplateItem("<#ZC_MSG126#>")> Public MSG_EXCERPT2 As String = "摘要:"
    <HtmlExportTemplateItem("<#ZC_MSG127#>")> Public MSG_NEW_USER As String = "新建用户"
    <HtmlExportTemplateItem("<#ZC_MSG128#>")> Public MSG_AUTHOR_LIST As String = "作者列表"      'Authors		
    <HtmlExportTemplateItem("<#ZC_MSG129#>")> Public MSG_TOTAL_VIEW_COUNT As String = "浏览总数"
    <HtmlExportTemplateItem("<#ZC_MSG130#>")> Public MSG_BROWSE As String = "浏览"
    <HtmlExportTemplateItem("<#ZC_MSG131#>")> Public MSG_AUTO_RENAME_UPLOADED_FILE As String = "自动命名上传文件"
    <HtmlExportTemplateItem("<#ZC_MSG132#>")> Public MSG_AUTO_KEYWORD_DESCRIPTION As String = "将日志中所有的关键字自动替换为相应的链接"
    <HtmlExportTemplateItem("<#ZC_MSG133#>")> Public MSG_ADD_NEW_KEYWORD As String = "添加自动链接的关键字"
    <HtmlExportTemplateItem("<#ZC_MSG134#>")> Public MSG_ADD_NEW_TAG As String = "添加Tag"
    <HtmlExportTemplateItem("<#ZC_MSG135#>")> Public MSG_NEW_KEYWORD As String = "新建关键字"
    <HtmlExportTemplateItem("<#ZC_MSG136#>")> Public MSG_NEW_TAG As String = "新建Tags"
    <HtmlExportTemplateItem("<#ZC_MSG137#>")> Public MSG_NO_EMPTY_URL As String = "链接不能为空"
    <HtmlExportTemplateItem("<#ZC_MSG138#>")> Public MSG_TAGS As String = "Tags"
    <HtmlExportTemplateItem("<#ZC_MSG139#>")> Public MSG_SHOW_USED_TAGS As String = "显示已使用的Tags"
    <HtmlExportTemplateItem("<#ZC_MSG140#>")> Public MSG_TAGS_DESCRIPTION As String = "自由定义Tags并给日志贴上合适的标签"
    <HtmlExportTemplateItem("<#ZC_MSG141#>")> Public MSG_MANAGE_TAGS As String = "Tags管理"
    <HtmlExportTemplateItem("<#ZC_MSG142#>")> Public MSG_AUTOLINK As String = "自动链接"
    <HtmlExportTemplateItem("<#ZC_MSG143#>")> Public MSG_EXPORT_DATA As String = "数据导出"
    <HtmlExportTemplateItem("<#ZC_MSG144#>")> Public MSG_EXPORT_ATOM10_DESCRIPTION As String = "将Blog上的数据导出为基于ATOM 1.0标准的XML文件"
    <HtmlExportTemplateItem("<#ZC_MSG145#>")> Public MSG_LOG_TRACKBACK_URL_AND_COMMENTS_RSS As String = "该日志的引用地址及评论订阅地址"
    <HtmlExportTemplateItem("<#ZC_MSG146#>")> Public MSG_FIND_SAME_NAME_LOG As String = "查询是否有同名的日志"
    <HtmlExportTemplateItem("<#ZC_MSG147#>")> Public MSG_ALIAS As String = "别名"
    <HtmlExportTemplateItem("<#ZC_MSG148#>")> Public MSG_REGISTER As String = "注册"
    <HtmlExportTemplateItem("<#ZC_MSG149#>")> Public MSG_CREATOR As String = "制作"
    <HtmlExportTemplateItem("<#ZC_MSG150#>")> Public MSG_VERSION As String = "版本"
    <HtmlExportTemplateItem("<#ZC_MSG151#>")> Public MSG_LAST_UPDATE As String = "最后更新"
    <HtmlExportTemplateItem("<#ZC_MSG152#>")> Public MSG_GOTO_NEXT_REBUILD_PAGE As String = "%n秒钟后将自动跳转入下一个重建页面中..."
    <HtmlExportTemplateItem("<#ZC_MSG153#>")> Public MSG_QUOTE_FROM As String = "引自"
    <HtmlExportTemplateItem("<#ZC_MSG154#>")> Public MSG_LATEST_TRACKBACKS As String = "最近引用"
    <HtmlExportTemplateItem("<#ZC_MSG155#>")> Public MSG_PREVIOUS_ARTICLE As String = "? 更早的文章"
    <HtmlExportTemplateItem("<#ZC_MSG156#>")> Public MSG_NEXT_ARTICLE As String = "之后的文章 ?"
    <HtmlExportTemplateItem("<#ZC_MSG157#>")> Public MSG_ANY As String = "任意"
    <HtmlExportTemplateItem("<#ZC_MSG158#>")> Public MSG_INCLUDE As String = "包含"
    <HtmlExportTemplateItem("<#ZC_MSG159#>")> Public MSG_SHOW As String = "显示"
    <HtmlExportTemplateItem("<#ZC_MSG160#>")> Public MSG_ITEM As String = "条"
    <HtmlExportTemplateItem("<#ZC_MSG161#>")> Public MSG_SET_SELECTED_ITEMS_TO As String = "将选定条目设定为"
    <HtmlExportTemplateItem("<#ZC_MSG162#>")> Public MSG_NOT_CHANGED As String = "不变"
    <HtmlExportTemplateItem("<#ZC_MSG163#>")> Public MSG_NOT_STICKY As String = "取消置顶"
    <HtmlExportTemplateItem("<#ZC_MSG164#>")> Public MSG_SYSTEM_REQUIRE As String = "需要用到的组件信息"
    <HtmlExportTemplateItem("<#ZC_MSG165#>")> Public MSG_SINGLE_USER_VERSION As String = "单用户多国语言版"
    <HtmlExportTemplateItem("<#ZC_MSG166#>")> Public MSG_APP_NEWS As String = "最新信息"
    <HtmlExportTemplateItem("<#ZC_MSG167#>")> Public MSG_APP_SUPPORT As String = "支持论坛"
    <HtmlExportTemplateItem("<#ZC_MSG168#>")> Public MSG_NEW_ARTICLE As String = "新建文章"
    <HtmlExportTemplateItem("<#ZC_MSG169#>")> Public MSG_WYSIWYG As String = "可视化"
    <HtmlExportTemplateItem("<#ZC_MSG170#>")> Public MSG_NORMAL_FUNCTIONS As String = "常用编辑"
    <HtmlExportTemplateItem("<#ZC_MSG171#>")> Public MSG_CONFIG_SETTINGS As String = "设置管理"
    <HtmlExportTemplateItem("<#ZC_MSG172#>")> Public MSG_AUTO_UPDATE As String = "自动升级"
    <HtmlExportTemplateItem("<#ZC_MSG173#>")> Public MSG_GLOBAL_SETTINGS As String = "全局设置"
    <HtmlExportTemplateItem("<#ZC_MSG174#>")> Public MSG_BLOG_GUID As String = "※BLOG GUID"
    <HtmlExportTemplateItem("<#ZC_MSG175#>")> Public MSG_BLOG_TIMEZONE As String = "※BLOG 时区"
    <HtmlExportTemplateItem("<#ZC_MSG176#>")> Public MSG_BLOG_LANGUAGE As String = "※BLOG 页面语言"
    <HtmlExportTemplateItem("<#ZC_MSG177#>")> Public MSG_STATIC_FILE_EXTENSION As String = "※静态文件后缀名"
    <HtmlExportTemplateItem("<#MSG_BUILD_REAL_STATIC_PAGE#>")> Public MSG_BUILD_REAL_STATIC_PAGE As String = "※使用真正静态的HTML页面(否则需要URL重写)"
    <HtmlExportTemplateItem("<#ZC_MSG178#>")> Public MSG_STATIC_FILE_DIRECTORY As String = "※日志存放目录(该目录必需已存在)"
    <HtmlExportTemplateItem("<#ZC_MSG179#>")> Public MSG_CURRENT_APP_VERSION As String = "※当前WSBLog程序版本"
    <HtmlExportTemplateItem("<#ZC_MSG180#>")> Public MSG_WYSISYG_EDITOR2 As String = "※WEB编辑器(可设为fckeditor,ewebeditor,htmlarea,tinymce等，为空值则不启用WEB编辑)"
    <HtmlExportTemplateItem("<#ZC_MSG181#>")> Public MSG_REBUILD_FILE_NUMBER_ONCE As String = "※单次重建文件数目"
    <HtmlExportTemplateItem("<#ZC_MSG182#>")> Public MSG_REBUILD_FILE_INTERVAL As String = "※单次重建文件后的间隔秒数"
    <HtmlExportTemplateItem("<#ZC_MSG183#>")> Public MSG_UPLOAD_FILE_TYPES2 As String = "※允许上传文件的类型(以|做为分隔)"
    <HtmlExportTemplateItem("<#ZC_MSG184#>")> Public MSG_UPLOAD_FILE_SIZE2 As String = "※上传文件的最大字节数"
    <HtmlExportTemplateItem("<#ZC_MSG185#>")> Public MSG_ENABLE_COMMENT_VERIFICATION_CODE As String = "※发表评论时启用验证码"
    <HtmlExportTemplateItem("<#ZC_MSG186#>")> Public MSG_PAGE_SETTINGS As String = "页面设置"
    <HtmlExportTemplateItem("<#ZC_MSG187#>")> Public MSG_PAGE_SHOW_LATEST_COMMENT_TRACKBACK_NUMBER As String = "※最新评论及引用的数量"
    <HtmlExportTemplateItem("<#ZC_MSG188#>")> Public MSG_PAGE_SHOW_MONTH_ARCHIVES_NUMBER As String = "※文件按月存档的月份的数量(为0不限次数)"
    <HtmlExportTemplateItem("<#ZC_MSG189#>")> Public MSG_PAGE_SHOW_LATEST_ARTICLES_NUMBER As String = "※最近发表文章的数量"
    <HtmlExportTemplateItem("<#ZC_MSG190#>")> Public MSG_PAGE_NORMAL_MODE_ARTICLE_NUMBER As String = "※首页及列表页显示文章的数量（标准模式）"
    <HtmlExportTemplateItem("<#ZC_MSG191#>")> Public MSG_ADMINPAGE_RECORD_NUMBER As String = "※管理页显示记录的数量"
    <HtmlExportTemplateItem("<#ZC_MSG192#>")> Public MSG_RSS_OR_ATOM_ARTICLE_NUMBER As String = "※RSS及ATOM显示文章的数量"
    <HtmlExportTemplateItem("<#ZC_MSG193#>")> Public MSG_SEARCH_PAGE_ARTICLE_NUMBER As String = "※搜索显示文章的数量"
    <HtmlExportTemplateItem("<#ZC_MSG194#>")> Public MSG_PAGEBAR_ITEM_NUMBER As String = "※翻页条的条目数量"
    <HtmlExportTemplateItem("<#ZC_MSG195#>")> Public MSG_UBB_SETTINGS As String = "UBB设置及相关转换"
    <HtmlExportTemplateItem("<#ZC_MSG196#>")> Public MSG_UBB_ENABLE_URL As String = "※UBB转换超连接标签"
    <HtmlExportTemplateItem("<#ZC_MSG197#>")> Public MSG_UBB_ENABLE_FONT As String = "※UBB转换字体标签"
    <HtmlExportTemplateItem("<#ZC_MSG198#>")> Public MSG_UBB_ENABLE_CODE As String = "※UBB转换代码框标签"
    <HtmlExportTemplateItem("<#ZC_MSG199#>")> Public MSG_UBB_ENABLE_EMOTION_FACE As String = "※UBB转换表情标签"
    <HtmlExportTemplateItem("<#ZC_MSG200#>")> Public MSG_UBB_ENABLE_IMAGE As String = "※UBB转换图片标签"
    <HtmlExportTemplateItem("<#ZC_MSG201#>")> Public MSG_UBB_ENABLE_MEDIA As String = "※UBB转换多媒体标签"
    <HtmlExportTemplateItem("<#ZC_MSG202#>")> Public MSG_UBB_ENABLE_FLASH As String = "※UBB转换Flash标签"
    <HtmlExportTemplateItem("<#ZC_MSG203#>")> Public MSG_UBB_ENABLE_TYPESET As String = "※UBB转换排版标签"
    <HtmlExportTemplateItem("<#ZC_MSG204#>")> Public MSG_UBB_ENABLE_AUTOLINK As String = "※UBB自动链接认别"
    <HtmlExportTemplateItem("<#ZC_MSG205#>")> Public MSG_UBB_ENABLE_AUTOKEYWORD As String = "※UBB自动转换关键字(启用关键字转换后文件生成速度将变很慢)"
    <HtmlExportTemplateItem("<#ZC_MSG206#>")> Public MSG_UBB_ENABLE_AUTONEWLINE As String = "※自动替换回车符为换行标签(默认启用，除非全用HTML排版可设为False)"
    <HtmlExportTemplateItem("<#ZC_MSG207#>")> Public MSG_UBB_COMMENT_NOFOLLOW As String = "※评论输出No Follow标签"
    <HtmlExportTemplateItem("<#ZC_MSG208#>")> Public MSG_UBB_JAPANESE_TO_HTML_ENTITY As String = "※日文转义为HTML字符"
    <HtmlExportTemplateItem("<#ZC_MSG209#>")> Public MSG_ARTICLE_PAGE_ENABLE_PRE_NEXT_BAR As String = "※启用单日志页面上下文章导航条"
    <HtmlExportTemplateItem("<#ZC_MSG210#>")> Public MSG_MANAGE_FILES As String = "文件管理"
    <HtmlExportTemplateItem("<#ZC_MSG211#>")> Public MSG_POST_COMMENT2 As String = "发表评论"
    <HtmlExportTemplateItem("<#ZC_MSG212#>")> Public MSG_VIEW_COMMENTS As String = "查看评论"
    <HtmlExportTemplateItem("<#ZC_MSG213#>")> Public MSG_HOMEPAGE As String = "首页"
    <HtmlExportTemplateItem("<#ZC_MSG214#>")> Public MSG_VIEW_BY_CATEGORY As String = "分类查看"
    <HtmlExportTemplateItem("<#ZC_MSG215#>")> Public MSG_WAP_SETTINGS As String = "WAP设置"
    '<HtmlExportTemplateItem("<#ZC_MSG216#>")> Public ZC_MSG216 As String = "※允许桌面浏览器浏览WAP"
    '<HtmlExportTemplateItem("<#ZC_MSG217#>")> Public ZC_MSG217 As String = "※WAP每页显示文章数"
    '<HtmlExportTemplateItem("<#ZC_MSG218#>")> Public ZC_MSG218 As String = "※WAP每页显示评论数"
    '<HtmlExportTemplateItem("<#ZC_MSG219#>")> Public ZC_MSG219 As String = "※WAP文章列表分页页码条长度"
    '<HtmlExportTemplateItem("<#ZC_MSG220#>")> Public ZC_MSG220 As String = "※WAP单页文章文字数"
    '<HtmlExportTemplateItem("<#ZC_MSG221#>")> Public ZC_MSG221 As String = "※WAP文章分页页码条长度"
    '<HtmlExportTemplateItem("<#ZC_MSG222#>")> Public ZC_MSG222 As String = "※WAP评论分页页码条长度"
    '<HtmlExportTemplateItem("<#ZC_MSG223#>")> Public ZC_MSG223 As String = "※WAP文件名"
    <HtmlExportTemplateItem("<#ZC_MSG224#>")> Public MSG_CODE As String = "代码"
    <HtmlExportTemplateItem("<#ZC_MSG225#>")> Public MSG_ATTACHMENT_RESTATISTICS As String = "重新统计附件"
    <HtmlExportTemplateItem("<#ZC_MSG226#>")> Public MSG_CHECK As String = "检测"
    <HtmlExportTemplateItem("<#ZC_MSG227#>")> Public MSG_FILE_NAME As String = "文件名"
    <HtmlExportTemplateItem("<#ZC_MSG228#>")> Public MSG_RELATED_LOG As String = "引用日志"
    <HtmlExportTemplateItem("<#ZC_MSG229#>")> Public MSG_DOWNLOAD_COUNT As String = "下载次数"
    <HtmlExportTemplateItem("<#ZC_MSG230#>")> Public MSG_FILE_DESCRIPTION As String = "文件说明"
    <HtmlExportTemplateItem("<#ZC_MSG231#>")> Public MSG_UPLOAD_TIME As String = "上传时间"
    <HtmlExportTemplateItem("<#ZC_MSG232#>")> Public MSG_CLICK_TO_DOWNLOAD As String = "点击下载该文件"
    <HtmlExportTemplateItem("<#ZC_MSG233#>")> Public MSG_DOWNLOAD_COUNT2 As String = "(下载次数:<#NUM#>)"
    <HtmlExportTemplateItem("<#ZC_MSG234#>")> Public MSG_VIEW_COUNT2 As String = "阅读:<#NUM#> | "
    <HtmlExportTemplateItem("<#ZC_MSG235#>")> Public MSG_VIEW_COUNT3 As String = "阅读统计:<#NUM#>"
    <HtmlExportTemplateItem("<#ZC_MSG236#>")> Public MSG_STATISTICS_SETTINGS As String = "统计设置"
    <HtmlExportTemplateItem("<#ZC_MSG237#>")> Public MSG_ENABLE_DOWNLOAD_STATISTICS As String = "※开启文件下载统计"
    <HtmlExportTemplateItem("<#ZC_MSG238#>")> Public MSG_LIST_PAGE_SHOW_DOWNLOAD_COUNT As String = "※列表页显示文件下载统计"
    <HtmlExportTemplateItem("<#ZC_MSG239#>")> Public MSG_ARTICLE_PAGE_SHOW_DOWNLOAD_COUNT As String = "※日志页显示文件下载统计"
    <HtmlExportTemplateItem("<#ZC_MSG240#>")> Public MSG_SHOW_ARTICLE_VIEW_COUNT As String = "※开启文章阅读统计"
    <HtmlExportTemplateItem("<#ZC_MSG241#>")> Public MSG_LIST_PAGE_SHOW_VIEW_COUNT As String = "※列表页显示文章阅读统计"
    <HtmlExportTemplateItem("<#ZC_MSG242#>")> Public MSG_ARTICLE_PAGE_SHOW_VIEW_COUNT As String = "※日志页显示文章阅读统计"
    <HtmlExportTemplateItem("<#ZC_MSG243#>")> Public MSG_HOMEPAGE_SHOW_TOTAL_VIEW_COUNT As String = "※首页显示全局阅读统计"
    <HtmlExportTemplateItem("<#ZC_MSG244#>")> Public MSG_IMAGE_MAX_WIDTH2 As String = "※超过此尺寸的图片自动缩小到该尺寸(单位:像素)"
    <HtmlExportTemplateItem("<#ZC_MSG245#>")> Public MSG_STICKY2 As String = "[置顶]"
    <HtmlExportTemplateItem("<#ZC_MSG246#>")> Public MSG_SYSTEM_HINT_MESSAGE As String = "系统提示信息"
    <HtmlExportTemplateItem("<#ZC_MSG247#>")> Public MSG_MULTI_POST_IN_TOO_SHORT_TIME As String = "请勿在短时间内多次发送信息"
    <HtmlExportTemplateItem("<#ZC_MSG248#>")> Public MSG_WAIT_SECONDS_TO_POST_COMMENT As String = "您需要耐心等待 %s 秒，就可以发表评论了."
    <HtmlExportTemplateItem("<#ZC_MSG249#>")> Public MSG_INCORRECT_VERIFICATION_CODE As String = "验证码错误，请仔细输入"
    <HtmlExportTemplateItem("<#ZC_MSG250#>")> Public MSG_LOGIN_TO_POST_COMMENT2 As String = "要用 %s 这个名字发表评论要先登录哦!"
    <HtmlExportTemplateItem("<#ZC_MSG251#>")> Public ZC_MSG251 As String = "请使用已登录的用户名称发表评论!"
    <HtmlExportTemplateItem("<#ZC_MSG252#>")> Public MSG_POST_COMMENT_SUCCESS As String = "恭喜你!评论发布成功!"
    <HtmlExportTemplateItem("<#ZC_MSG253#>")> Public MSG_REPEATE_POST_SAME_CONTENT As String = "请不要重复发一样的东西!"
    <HtmlExportTemplateItem("<#ZC_MSG254#>")> Public MSG_UNKNOWN_ERROR As String = "产生了未知错误，向老大报告一下!"
    <HtmlExportTemplateItem("<#ZC_MSG255#>")> Public MSG_NO_ADVERTISEMENT As String = "小子，不要做广告哦!"
    <HtmlExportTemplateItem("<#ZC_MSG256#>")> Public MSG_HIDE_EMOTION_FACES As String = "※默认隐藏表情"
    <HtmlExportTemplateItem("<#ZC_MSG257#>")> Public MSG_USE_DYNAMIC_COMMENTS As String = "※启用评论动态显示及分页"
    <HtmlExportTemplateItem("<#ZC_MSG258#>")> Public MSG_PAGE_COMMENT_NUMBER As String = "※单页显示评论数量"
    <HtmlExportTemplateItem("<#ZC_MSG259#>")> Public MSG_COMMENT_MIN_LENGTH As String = "※允许最短评论长度"
    <HtmlExportTemplateItem("<#ZC_MSG260#>")> Public MSG_NOT_PRIVILEGE_AUTO_SAVE As String = "您无权使用自动保存功能"
    <HtmlExportTemplateItem("<#ZC_MSG261#>")> Public MSG_AUTO_SAVE_SUCCESS As String = "自动保存成功"
    <HtmlExportTemplateItem("<#ZC_MSG262#>")> Public MSG_AUTO_SAVE_FAILED As String = "保存失败"
    <HtmlExportTemplateItem("<#ZC_MSG263#>")> Public MSG_EMPTY_CONTENT As String = "无内容"
    <HtmlExportTemplateItem("<#ZC_MSG264#>")> Public MSG_AUTO_SAVE_ARTICLE_ERROR1 As String = "自动保存文章出错..."
    <HtmlExportTemplateItem("<#ZC_MSG265#>")> Public MSG_AUTO_SAVE_RESTOR_CONFIRM As String = "你确认要恢复么?"
    <HtmlExportTemplateItem("<#ZC_MSG266#>")> Public MSG_RESTORED As String = "已恢复"
    <HtmlExportTemplateItem("<#ZC_MSG267#>")> Public MSG_RESTORE As String = "恢复"
    <HtmlExportTemplateItem("<#ZC_MSG268#>")> Public MSG_AUTO_SAVE_AFTER_SECONDS As String = "秒后自动保存"
    <HtmlExportTemplateItem("<#ZC_MSG269#>")> Public MSG_SAVING As String = "正在保存"
    <HtmlExportTemplateItem("<#ZC_MSG270#>")> Public MSG_USE_STATIC_COMMENTS As String = "※启用评论静态显示，关闭评论动态显示"
    <HtmlExportTemplateItem("<#ZC_MSG271#>")> Public MSG_TRACKBACK_URL As String = "引用通告"
    <HtmlExportTemplateItem("<#ZC_MSG272#>")> Public MSG_COMMENTS_RSS_URL As String = "评论订阅"
    <HtmlExportTemplateItem("<#ZC_MSG273#>")> Public MSG_TRACKBACK_URL_COPYED As String = "该日志的引用通告地址%s已经成功复制到您的剪贴板"
    <HtmlExportTemplateItem("<#ZC_MSG274#>")> Public MSG_COMMENTS_RSS_URL_COPYED As String = "该日志的评论订阅地址%s已经成功复制到您的剪贴板"
    <HtmlExportTemplateItem("<#ZC_MSG275#>")> Public MSG_UPDATE_SUCCESS As String = "升级成功"
    <HtmlExportTemplateItem("<#ZC_MSG276#>")> Public MSG_INCREASE As String = "大"
    <HtmlExportTemplateItem("<#ZC_MSG277#>")> Public MSG_DECREASE As String = "小"
    <HtmlExportTemplateItem("<#ZC_MSG278#>")> Public MSG_FONT_SIZE As String = "字号"
    <HtmlExportTemplateItem("<#ZC_MSG279#>")> Public MSG_SIMPLIFIED_TRADITIONAL_CONVERT As String = "简繁转换"
    <HtmlExportTemplateItem("<#ZC_MSG280#>")> Public MSG_LIST_MODE As String = "列表模式"
    <HtmlExportTemplateItem("<#ZC_MSG281#>")> Public MSG_NORMAL_MODE As String = "标准模式"
    <HtmlExportTemplateItem("<#ZC_MSG282#>")> Public MSG_SIMPLIFIED As String = "简"
    <HtmlExportTemplateItem("<#ZC_MSG283#>")> Public MSG_TRADITIONAL As String = "繁"
    <HtmlExportTemplateItem("<#ZC_MSG284#>")> Public MSG_TAGS_LIST As String = "Tags列表"
    <HtmlExportTemplateItem("<#ZC_MSG285#>")> Public MSG_PAGE_LIST_MODE_ARTICLE_NUMBER As String = "※首页及列表页显示文章的数量（列表模式）"
    <HtmlExportTemplateItem("<#ZC_MSG286#>")> Public MSG_LOGIN As String = "登录"
    <HtmlExportTemplateItem("<#ZC_MSG287#>")> Public MSG_INCORRECT_PASSWORD As String = "密码有问题诶"
    <HtmlExportTemplateItem("<#ZC_MSG288#>")> Public MSG_INCORRECT_USERNAME_OR_PASSWORD As String = "你的用户名密码是不是写错啦?"
    <HtmlExportTemplateItem("<#ZC_MSG289#>")> Public MSG_USERNAME_REGISTERED As String = "该用户已经有人注册过啦!"
    <HtmlExportTemplateItem("<#ZC_MSG290#>")> Public MSG_REGISTER_FAILED As String = "注册失败了……"
    <HtmlExportTemplateItem("<#ZC_MSG291#>")> Public MSG_REGISTER_SUCCESS As String = "注册成功~~"
    <HtmlExportTemplateItem("<#ZC_MSG292#>")> Public MSG_ALLOW_GUEST_REGISTER As String = "※开放访客注册功能"
    <HtmlExportTemplateItem("<#ZC_MSG293#>")> Public MSG_NOT_ALLOW_GUEST_REGISTER As String = "管理员未开放访客注册功能"
    <HtmlExportTemplateItem("<#ZC_MSG294#>")> Public MSG_REBUILD_SUCCESS As String = "重建成功!"
    <HtmlExportTemplateItem("<#MSG_GOTO_PARENT_DIRECTORY#>")> Public MSG_GOTO_PARENT_DIRECTORY As String = "回上级目录"
    <HtmlExportTemplateItem("<#MSG_CURRENT_PATH#>")> Public MSG_CURRENT_PATH As String = "当前目录"
    <HtmlExportTemplateItem("<#MSG_PARENT_CATEGORY#>")> Public MSG_PARENT_CATEGORY As String = "父分类"
    <HtmlExportTemplateItem("<#MSG_UNKNOWN_CATEGORY#>")> Public MSG_UNKNOWN_CATEGORY As String = "未分类"
    <HtmlExportTemplateItem("<#MSG_UNKNOWN_USER#>")> Public MSG_UNKNOWN_USER As String = "未知用户"
    <HtmlExportTemplateItem("<#MSG_OPERATION_SUCCESS#>")> Public MSG_OPERATION_SUCCESS As String = "操作成功"
    <HtmlExportTemplateItem("<#MSG_ERROR_CMD_OR_UNFINISHED_FUNC#>")> Public MSG_ERROR_CMD_OR_UNFINISHED_FUNC As String = "错误的命令或者未完成的功能..."
    <HtmlExportTemplateItem("<#MSG_UPLOADING#>")> Public MSG_UPLOADING As String = "正在上传"
    <HtmlExportTemplateItem("<#MSG_ARTICLE_TEMPLATE#>")> Public MSG_ARTICLE_TEMPLATE As String = "文章模板"
    <HtmlExportTemplateItem("<#MSG_LOADING#>")> Public MSG_LOADING As String = "正在装载..."

    Public ARTICLE_TYPE_NAMES() As String = New String() {"", "草稿文章", "私人文章", "锁定文章", "普通文章"}

    Public USER_ROLE_NAMES() As String = New String() {"", "管理员", "高级用户", "中级用户", "普通用户", "游客"}

    Public MONTH_NAMES() As String = New String() {"", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"}

    Public MONTH_ABBREVIATIONS() As String = New String() {"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}

    Public WEEK_DAY_ABBREVIATIONS() As String = New String() {"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"}

    '自定义错误信息
    Public ERROR_MESSAGES() As String = New String() { _
        "未知错误", "未知命令", "未查询到相关页面", "参数提交错误", "数据库连接错误", _
        "非法访问", "没有权限", "用户名或密码错误", "登录失败", "该文章不存在", _
        "系统初始化失败", "编辑文章失败", "编辑分类失败", "该分类下有文章，删除失败", "评论发表失败", _
        "名称不能为空或格式不正确", "编辑用户失败", "删除用户失败", "删除评论失败", "删除引用失败", _
        "发送引用失败", "文件上传失败", "文件删除失败", "系统重建失败", "搜索字符串失败", _
        "保存设置失败", "文件类型超出设定范围", "文件大小超出设定范围", "文件已存在，请先删除", "邮箱不能为空或格式不正确", _
        "网址不能为空或格式不正确", "请使用已登录的用户名称", "由于设定时间间隔而拒绝操作", "编辑关键字失败", "删除关键字失败", _
        "编辑Tags失败", "删除Tags失败", "编辑文件失败", "编辑评论失败"}


End Class
