if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[blog_Article]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[blog_Article]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[blog_Category]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[blog_Category]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[blog_Comment]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[blog_Comment]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[blog_Counter]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[blog_Counter]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[blog_Keyword]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[blog_Keyword]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[blog_Member]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[blog_Member]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[blog_Tag]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[blog_Tag]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[blog_TagArticle]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[blog_TagArticle]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[blog_TrackBack]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[blog_TrackBack]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[blog_UpLoad]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[blog_UpLoad]
GO

CREATE TABLE [dbo].[blog_Article] (
	[log_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[log_CateID] [int] NULL ,
	[log_AuthorID] [int] NULL ,
	[log_Level] [int] NULL ,
	[log_Url] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[log_Title] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[log_Intro] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[log_Content] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[log_IP] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
	[log_PostTime] [smalldatetime] NULL ,
	[log_CommNums] [int] NOT NULL ,
	[log_ViewNums] [int] NOT NULL ,
	[log_TrackBackNums] [int] NOT NULL ,
	[log_Tag] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[log_IsTop] [bit] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[blog_Category] (
	[cate_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[cate_Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[cate_Order] [nvarchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[cate_Intro] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[cate_Count] [int] NOT NULL ,
	[cate_Code] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[cate_ParentCode] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[cate_ParentID] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[blog_Comment] (
	[comm_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[log_ID] [int] NULL ,
	[comm_AuthorID] [int] NULL ,
	[comm_Author] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[comm_Content] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[comm_Email] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[comm_HomePage] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[comm_PostTime] [smalldatetime] NULL ,
	[comm_IP] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
	[comm_Agent] [ntext] COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[blog_Counter] (
	[coun_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[coun_IP] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[coun_Agent] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[coun_Refer] [nvarchar] (250) COLLATE Chinese_PRC_CI_AS NULL ,
	[coun_PostTime] [smalldatetime] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[blog_Keyword] (
	[key_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[key_Name] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[key_Intro] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[key_URL] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[blog_Member] (
	[mem_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[mem_Level] [int] NULL ,
	[mem_Name] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[mem_Password] [nvarchar] (32) COLLATE Chinese_PRC_CI_AS NULL ,
	[mem_Sex] [tinyint] NULL ,
	[mem_Email] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[mem_MSN] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[mem_QQ] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[mem_HomePage] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[mem_LastVisit] [smalldatetime] NULL ,
	[mem_Status] [int] NOT NULL ,
	[mem_PostLogs] [int] NOT NULL ,
	[mem_PostComms] [int] NOT NULL ,
	[mem_Intro] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[mem_IP] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
	[mem_Count] [int] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[blog_Tag] (
	[tag_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[tag_Name] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[tag_Intro] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[tag_ParentID] [int] NULL ,
	[tag_URL] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[tag_Order] [int] NOT NULL ,
	[tag_Count] [int] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[blog_TagArticle] (
	[tag_log_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[tag_ID] [int] NOT NULL ,
	[tag_Name] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[log_ID] [int] NOT NULL ,
	[log_Title] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[blog_TrackBack] (
	[tb_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[log_ID] [int] NULL ,
	[tb_URL] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[tb_Title] [nvarchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[tb_Blog] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[tb_Excerpt] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[tb_PostTime] [smalldatetime] NULL ,
	[tb_IP] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
	[tb_Agent] [ntext] COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[blog_UpLoad] (
	[ul_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[ul_AuthorID] [int] NULL ,
	[ul_FileSize] [int] NULL ,
	[ul_FileName] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[ul_PostTime] [smalldatetime] NULL ,
	[ul_Quote] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[ul_DownNum] [int] NOT NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[blog_Article] WITH NOCHECK ADD 
	CONSTRAINT [PK_blog_Article] PRIMARY KEY  CLUSTERED 
	(
		[log_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[blog_Category] WITH NOCHECK ADD 
	CONSTRAINT [PK_blog_Category] PRIMARY KEY  CLUSTERED 
	(
		[cate_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[blog_Comment] WITH NOCHECK ADD 
	CONSTRAINT [PK_blog_Comment] PRIMARY KEY  CLUSTERED 
	(
		[comm_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[blog_Counter] WITH NOCHECK ADD 
	CONSTRAINT [PK_blog_Counter] PRIMARY KEY  CLUSTERED 
	(
		[coun_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[blog_Keyword] WITH NOCHECK ADD 
	CONSTRAINT [PK_blog_Keyword] PRIMARY KEY  CLUSTERED 
	(
		[key_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[blog_Member] WITH NOCHECK ADD 
	CONSTRAINT [PK_blog_Member] PRIMARY KEY  CLUSTERED 
	(
		[mem_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[blog_Tag] WITH NOCHECK ADD 
	CONSTRAINT [PK_blog_Tag] PRIMARY KEY  CLUSTERED 
	(
		[tag_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[blog_TagArticle] WITH NOCHECK ADD 
	CONSTRAINT [PK_blog_TagArticle] PRIMARY KEY  CLUSTERED 
	(
		[tag_log_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[blog_TrackBack] WITH NOCHECK ADD 
	CONSTRAINT [PK_blog_TrackBack] PRIMARY KEY  CLUSTERED 
	(
		[tb_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[blog_UpLoad] WITH NOCHECK ADD 
	CONSTRAINT [PK_blog_UpLoad] PRIMARY KEY  CLUSTERED 
	(
		[ul_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[blog_Article] ADD 
	CONSTRAINT [DF_blog_Article_log_PostTime] DEFAULT (getdate()) FOR [log_PostTime],
	CONSTRAINT [DF_blog_Article_log_CommNums] DEFAULT (0) FOR [log_CommNums],
	CONSTRAINT [DF_blog_Article_log_ViewNums] DEFAULT (0) FOR [log_ViewNums],
	CONSTRAINT [DF_blog_Article_log_TrackBackNums] DEFAULT (0) FOR [log_TrackBackNums],
	CONSTRAINT [DF_blog_Article_log_IsTop] DEFAULT (0) FOR [log_IsTop]
GO

 CREATE  INDEX [IX_blog_Article] ON [dbo].[blog_Article]([log_CateID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_Article_1] ON [dbo].[blog_Article]([log_AuthorID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_Article_2] ON [dbo].[blog_Article]([log_PostTime]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_Article_3] ON [dbo].[blog_Article]([log_Tag]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[blog_Category] ADD 
	CONSTRAINT [DF_blog_Category_cate_Order] DEFAULT (0) FOR [cate_Order],
	CONSTRAINT [DF_blog_Category_cate_Count] DEFAULT (0) FOR [cate_Count]
GO

ALTER TABLE [dbo].[blog_Comment] ADD 
	CONSTRAINT [DF_blog_Comment_comm_PostTime] DEFAULT (getdate()) FOR [comm_PostTime]
GO

 CREATE  INDEX [IX_blog_Comment] ON [dbo].[blog_Comment]([log_ID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_Comment_1] ON [dbo].[blog_Comment]([comm_AuthorID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_Comment_2] ON [dbo].[blog_Comment]([comm_PostTime]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[blog_Counter] ADD 
	CONSTRAINT [DF_blog_Counter_coun_PostTime] DEFAULT (getdate()) FOR [coun_PostTime]
GO

 CREATE  INDEX [IX_blog_Counter] ON [dbo].[blog_Counter]([coun_PostTime]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[blog_Member] ADD 
	CONSTRAINT [DF_blog_Member_mem_LastVisit] DEFAULT (getdate()) FOR [mem_LastVisit],
	CONSTRAINT [DF_blog_Member_mem_Status] DEFAULT (0) FOR [mem_Status],
	CONSTRAINT [DF_blog_Member_mem_PostLogs] DEFAULT (0) FOR [mem_PostLogs],
	CONSTRAINT [DF_blog_Member_mem_PostComms] DEFAULT (0) FOR [mem_PostComms],
	CONSTRAINT [DF_blog_Member_mem_Count] DEFAULT (0) FOR [mem_Count]
GO

 CREATE  INDEX [IX_blog_Member] ON [dbo].[blog_Member]([mem_Level]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_Member_1] ON [dbo].[blog_Member]([mem_Name]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[blog_Tag] ADD 
	CONSTRAINT [DF_blog_Tag_tag_Order] DEFAULT (0) FOR [tag_Order],
	CONSTRAINT [DF_blog_Tag_tag_Count] DEFAULT (0) FOR [tag_Count]
GO

 CREATE  INDEX [IX_blog_Tag] ON [dbo].[blog_Tag]([tag_ParentID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_TagArticle] ON [dbo].[blog_TagArticle]([tag_ID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_TagArticle_1] ON [dbo].[blog_TagArticle]([log_ID]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[blog_TrackBack] ADD 
	CONSTRAINT [DF_blog_TrackBack_tb_PostTime] DEFAULT (getdate()) FOR [tb_PostTime]
GO

 CREATE  INDEX [IX_blog_TrackBack] ON [dbo].[blog_TrackBack]([log_ID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_TrackBack_1] ON [dbo].[blog_TrackBack]([tb_PostTime]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[blog_UpLoad] ADD 
	CONSTRAINT [DF_blog_UpLoad_ul_PostTime] DEFAULT (getdate()) FOR [ul_PostTime],
	CONSTRAINT [DF_blog_UpLoad_ul_DownNum] DEFAULT (0) FOR [ul_DownNum]
GO

 CREATE  INDEX [IX_blog_UpLoad] ON [dbo].[blog_UpLoad]([ul_AuthorID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_UpLoad_1] ON [dbo].[blog_UpLoad]([ul_FileSize]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_UpLoad_2] ON [dbo].[blog_UpLoad]([ul_FileName]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_blog_UpLoad_3] ON [dbo].[blog_UpLoad]([ul_PostTime]) ON [PRIMARY]
GO


INSERT INTO blog_Member
      (mem_Level, mem_Name, mem_Password, mem_Sex, mem_Email, mem_MSN, 
      mem_QQ, mem_HomePage, mem_LastVisit, mem_Status, mem_PostComms, 
      mem_Intro, mem_IP, mem_Count)
VALUES (0, 'admin', '52ae54648d53d7545d95c46c94656084', 0, 
      'admin@oucsoft.com', NULL, NULL, 'http://www.oucsoft.com', GETDATE(), 0, 0, 
      'admin', '127.0.0.1', 0)

