Option Explicit On 
Option Strict On

Imports System.Xml.Serialization

Public Class BlogIndex


    Private _categories() As TCategory
    Private _categoriesIndexById As System.Collections.Hashtable
    Public Property Categories() As TCategory()
        Get
            Return Me._categories
        End Get
        Set(ByVal Value As TCategory())
            Me._categories = Value
            Dim table As New System.Collections.Hashtable
            If Not Value Is Nothing Then
                For i As Integer = 0 To Value.Length - 1
                    table.Add(Value(i).ID, Value(i))
                Next
            End If
            Me._categoriesIndexById = table
        End Set
    End Property

    Private _users() As TUser
    Private _usersIndexById As System.Collections.Hashtable
    Public Property Users() As TUser()
        Get
            Return Me._users
        End Get
        Set(ByVal Value As TUser())
            Me._users = Value
            Dim table As New System.Collections.Hashtable
            If Not Value Is Nothing Then
                For i As Integer = 0 To Value.Length - 1
                    table.Add(Value(i).ID, Value(i))
                Next
            End If
            Me._usersIndexById = table
        End Set
    End Property

    Private _tags() As TTag
    Private _tagsIndexById As System.Collections.Hashtable
    Private _tagsIndexByName As System.Collections.Hashtable
    Public Property Tags() As TTag()
        Get
            Return Me._tags
        End Get
        Set(ByVal Value As TTag())
            Me._tags = Value
            Dim table As New System.Collections.Hashtable
            If Not Value Is Nothing Then
                For i As Integer = 0 To Value.Length - 1
                    table.Add(Value(i).ID, Value(i))
                Next
            End If
            Me._tagsIndexById = table
            table = New System.Collections.Hashtable
            If Not Value Is Nothing Then
                For i As Integer = 0 To Value.Length - 1
                    If Not table.Contains(Value(i).Name) Then
                        table.Add(Value(i).Name, Value(i))
                    End If
                Next
            End If
            Me._tagsIndexByName = table
        End Set
    End Property

    Private _archives() As String
    Public Property Archives() As String()
        Get
            Return _archives
        End Get
        Set(ByVal Value As String())
            Me._archives = Value
        End Set
    End Property

    Private _createTime As DateTime
    Public Property CreateTime() As DateTime
        Get
            Return Me._createTime
        End Get
        Set(ByVal Value As DateTime)
            Me._createTime = Value
        End Set
    End Property

    Private _totalArticleCount As Integer
    Public Property TotalArticleCount() As Integer
        Get
            Return Me._totalArticleCount
        End Get
        Set(ByVal Value As Integer)
            Me._totalArticleCount = Value
        End Set
    End Property


    Public Function GetCategoryInfoById(ByVal id As Integer) As TCategory
        'If Me._categories Is Nothing Then
        '    Return Nothing
        'End If
        'For Each c As TCategory In Me._categories
        '    If Not c Is Nothing Then
        '        If c.ID = id Then
        '            Return c
        '        End If
        '    End If
        'Next
        Dim table As System.Collections.Hashtable = Me._categoriesIndexById
        If table Is Nothing Then
            Return Nothing
        End If
        If table.Contains(id) Then
            Return CType(table(id), TCategory)
        End If
        Return Nothing
    End Function

    Public Function GetCategoryArticleCount(ByVal intCateId As Integer) As Integer
        Dim table As System.Collections.Hashtable = Me._categoriesIndexById
        If table Is Nothing Then
            Return 0
        End If
        If table.Contains(intCateId) Then
            Return CType(table(intCateId), TCategory).Count
        End If
        Return 0
    End Function


    Public Function GetUserInfoById(ByVal id As Integer) As TUser
        Dim table As System.Collections.Hashtable = Me._usersIndexById
        If table Is Nothing Then
            Return Nothing
        End If
        If table.Contains(id) Then
            Return CType(table(id), TUser)
        End If
        Return Nothing
    End Function

    Public Function GetAuthorArticleCount(ByVal intAuthorId As Integer) As Integer
        Dim table As System.Collections.Hashtable = Me._usersIndexById
        If table Is Nothing Then
            Return 0
        End If
        If table.Contains(intAuthorId) Then
            Return CType(table(intAuthorId), TUser).Count
        End If
        Return 0
    End Function


    Public Function GetTagInfoById(ByVal id As Integer) As TTag
        Dim table As System.Collections.Hashtable = Me._tagsIndexById
        If table Is Nothing Then
            Return Nothing
        End If
        If table.Contains(id) Then
            Return CType(table(id), TTag)
        End If
        Return Nothing
    End Function

    Public Function GetTagInfoByName(ByVal name As String) As TTag
        Dim table As System.Collections.Hashtable = Me._tagsIndexByName
        If table Is Nothing Then
            Return Nothing
        End If
        If table.Contains(name) Then
            Return CType(table(name), TTag)
        End If
        Return Nothing
    End Function

    Public Function GetTagArticleCount(ByVal intTagId As Integer) As Integer
        Dim table As System.Collections.Hashtable = Me._tagsIndexById
        If table Is Nothing Then
            Return 0
        End If
        If table.Contains(intTagId) Then
            Return CType(table(intTagId), TTag).Count
        End If
        Return 0
    End Function


    Public Function GetMonthArticleCount(ByVal dtMonth As DateTime) As Integer
        If Me._archives Is Nothing Then Return 0
        For Each m As String In Me.Archives
            Dim mc As String() = m.Split(vbTab.Chars(0))
            Dim strYM As String = mc(0)
            Dim count As Integer = CInt(mc(1))
            Dim intY As Integer = CInt(strYM.Split(New Char() {"-"c})(0))
            Dim intM As Integer = CInt(strYM.Split(New Char() {"-"c})(1))
            If dtMonth.Year = intY And dtMonth.Month = intM Then
                Return count
            End If
        Next
        Return 0
    End Function

    'Public Sub CopyFrom(ByVal source As BlogIndex)
    '    Me.Categories = source.Categories
    '    Me.Tags = source.Tags
    '    Me.Users = source.Users
    '    Me.Archives = source.Archives
    '    Me.CreateTime = source.CreateTime
    'End Sub

    Public Sub Save(ByVal filePath As String)
        Dim serializer As New XmlSerializer(GetType(BlogIndex))
        Dim writer As New System.IO.StreamWriter(filePath, False, System.Text.Encoding.UTF8)
        Try
            serializer.Serialize(writer, Me)
            'Catch ex As Exception
        Finally
            writer.Close()
        End Try
    End Sub

    Public Shared Function LoadBlogIndex(ByVal filepath As String) As BlogIndex
        If Not (System.IO.File.Exists(filepath)) Then
            Return Nothing
        End If

        Dim serializer As New XmlSerializer(GetType(BlogIndex))
        Dim reader As New System.IO.StreamReader(filepath, System.Text.Encoding.UTF8)
        Dim objTemp As BlogIndex
        Try
            objTemp = CType(serializer.Deserialize(reader), BlogIndex)
        Finally
            reader.Close()
        End Try
        Return objTemp
    End Function

End Class

