Option Explicit On 
Option Strict On

Imports System.Web
Imports System.Reflection
Imports System.Collections

Public Class GlobalCache


    Private Class FileCache
        Public FileName As String
        Public CacheKey As String
        Public Sub New(ByVal filename As String, ByVal cachekey As String)
            Me.FileName = filename
            Me.CacheKey = cachekey
        End Sub
    End Class


    Private _blogContext As BlogPageContext

    Private ReadOnly Property context() As HttpContext
        Get
            Return Me._blogContext.HttpContext
        End Get
    End Property

    Private ReadOnly Property blogPath() As String
        Get
            Return Me._blogContext.BlogPath
        End Get
    End Property

    Private ReadOnly Property blogGuid() As String
        Get
            Return Me._blogContext.Page.BlogGuid 'BlogConfiguration.GetInstance().ZC_BLOG_CLSID
        End Get
    End Property

    Private ReadOnly Property blogRootUrl() As String
        Get
            Return Me._blogContext.Page.BlogRootUrl
        End Get
    End Property

    'Public Sub New(ByVal context As HttpContext, ByVal blogPath As String)
    '    Me.context = context
    '    Me.blogPath = blogPath
    'End Sub

    Public Sub New(ByVal blogContext As BlogPageContext)
        Me._blogContext = blogContext
    End Sub

    Protected ReadOnly Property Application() As HttpApplicationState
        Get
            Return Me._blogContext.HttpContext.Application 'Page.Application()
        End Get
    End Property

    'Protected Shared Function GetMemberValue(ByVal strMemberName As String, ByVal obj As Object) As Object
    '    Return ObjectMemberHelper.GetMemberValue(strMemberName, obj)
    'End Function

    Protected Function LoadFromFile(ByVal strFullName As String, ByVal strCharset As String) As String
        'עжļǷڣڣֱӷؿַ
        If Not System.IO.File.Exists(strFullName) Then
            Return ""
        End If
        Return TextFileHelper.LoadFromFile(strFullName, strCharset)
    End Function

    Protected Sub SaveToFile(ByVal strFullName As String, ByVal strContent As String, ByVal strCharset As String)
        TextFileHelper.SaveToFile(strFullName, strContent, strCharset)
    End Sub

    Public ReadOnly Property BlogIndex() As BlogIndex
        Get
            Dim globalKey As String = Me.blogGuid & "BLOG_INDEX"
            If Not (Me.context.Cache(globalKey)) Is Nothing Then
                Return CType(Me.context.Cache(globalKey), BlogIndex)
            End If

            Dim cachefile As String = System.IO.Path.Combine(Me.blogPath, "CACHE/blogindex.cache")
            Dim blogidx As BlogIndex
            blogidx = BlogIndex.LoadBlogIndex(cachefile)
            If blogidx Is Nothing Then
                Return Nothing
            End If
            Me.context.Cache.Insert(globalKey, blogidx, New System.Web.Caching.CacheDependency(cachefile))
            Return blogidx
        End Get
    End Property


    Public ReadOnly Property BlogConfig() As BlogConfiguration
        Get
            Dim globalKey As String = Me.blogGuid & "BLOG_CONFIG"
            If Not (Me.context.Cache(globalKey)) Is Nothing Then
                Return CType(Me.context.Cache(globalKey), BlogConfiguration)
            End If

            Dim configfile As String = System.IO.Path.Combine(Me.blogPath, "blogconfig.xml")
            Dim config As BlogConfiguration
            config = BlogConfiguration.LoadFromFile(configfile)
            If config Is Nothing Then
                Return Nothing
            End If
            Me.context.Cache.Insert(globalKey, config, New System.Web.Caching.CacheDependency(configfile))
            Return config
        End Get
    End Property


    Public ReadOnly Property BlogMessages() As BlogMessages
        Get
            Dim globalKey As String = Me.blogGuid & "BLOG_MESSAGES"
            If Not (Me.context.Cache(globalKey)) Is Nothing Then
                Return CType(Me.context.Cache(globalKey), BlogMessages)
            End If

            Dim configfile As String = System.IO.Path.Combine(Me.blogPath, "blogmessages.xml")
            Dim messages As BlogMessages
            messages = BlogMessages.LoadFromFile(configfile)
            If messages Is Nothing Then
                Return Nothing
            End If
            Me.context.Cache.Insert(globalKey, messages, New System.Web.Caching.CacheDependency(configfile))
            Return messages
        End Get
    End Property


    <HtmlExportTemplateItem("<#CACHE_INCLUDE_STATISTICS#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeStatistics() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_STATISTICS")
        End Get
    End Property


    <HtmlExportTemplateItem("<#CACHE_INCLUDE_FAVORITE#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeFavorite() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_FAVORITE")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_LINK#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeLink() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_LINK")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_MISC#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeMisc() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_MISC")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_CALENDAR#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeCalendar() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_CALENDAR")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_CALENDAR_NOW#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeCalendarNow() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_CALENDAR_NOW")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_COMMENTS#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeComments() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_COMMENTS")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_PREVIOUS#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludePrevious() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_PREVIOUS")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_ARCHIVES#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeArchives() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_ARCHIVES")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_TAGS#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeTags() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_TAGS")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_CATALOG#>", checkbeforereplace:=True)> _
        Public ReadOnly Property IncludeCatalog() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_CATALOG")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_NAVBAR#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeNavbar() As String
        Get
            '滻BLOGĿ¼ǩ
            Dim s As String = Me.getFileCache("CACHE_INCLUDE_NAVBAR")
            s = Replace(s, "<#ZC_BLOG_HOST#>", Me.blogRootUrl)
            s = Replace(s, "<%=ZC_BLOG_HOST%>", Me.blogRootUrl)
            s = Replace(s, "<#BlogRootUrl#>", Me.blogRootUrl)
            s = Replace(s, "<%=BlogRootUrl%>", Me.blogRootUrl)
            Return s
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_AUTHORS#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeAuthors() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_AUTHORS")
        End Get
    End Property

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_TRACKBACKS#>", checkbeforereplace:=True)> _
    Public ReadOnly Property IncludeTrackbacks() As String
        Get
            Return Me.getFileCache("CACHE_INCLUDE_TRACKBACKS")
        End Get
    End Property

    <HtmlExportTemplateItem("<#INCLUDE_GOOGLE_SITESEARCH#>")> _
    Public ReadOnly Property IncludeGoogleSiteSearch() As String
        Get
            Return Me.getFileCache("INCLUDE_GOOGLE_SITESEARCH")
        End Get
    End Property

    <HtmlExportTemplateItem("<#INCLUDE_GOOGLE_ADSENSE#>")> _
    Public ReadOnly Property IncludeGoogleAdSense() As String
        Get
            Return Me.getFileCache("INCLUDE_GOOGLE_ADSENSE")
        End Get
    End Property


    <HtmlExportTemplateItem("<#INCLUDE_GOOGLE_ANALYTICS#>")> _
    Public ReadOnly Property IncludeGoogleAnalytics() As String
        Get
            Return Me.getFileCache("INCLUDE_GOOGLE_ANALYTICS")
        End Get
    End Property

    Public ReadOnly Property TemplateArticleCommentPostVerify() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE_COMMENTPOST-VERIFY")
        End Get
    End Property

    Public ReadOnly Property TemplateArticleTag() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE_TAG")
        End Get
    End Property

    Public ReadOnly Property TemplateArticleTrackback() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE_TRACKBACK")
        End Get
    End Property

    Public ReadOnly Property TemplateArticleMuti() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE-MULTI")
        End Get
    End Property

    Public ReadOnly Property TemplateArticleSingle() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE-SINGLE")
        End Get
    End Property

    Public ReadOnly Property TemplatePagebar() As String
        Get
            Return Me.getFileCache("TEMPLATE_PAGEBAR")
        End Get
    End Property

    Public ReadOnly Property TemplateCatalog() As String
        Get
            Return Me.getFileCache("TEMPLATE_CATALOG")
        End Get
    End Property

    Public ReadOnly Property TemplateDefault() As String
        Get
            Return Me.getFileCache("TEMPLATE_DEFAULT")
        End Get
    End Property

    Public ReadOnly Property TemplateSearch() As String
        Get
            Return Me.getFileCache("TEMPLATE_SEARCH")
        End Get
    End Property

    Public ReadOnly Property TemplateSingle() As String
        Get
            Return Me.getFileCache("TEMPLATE_SINGLE")
        End Get
    End Property

    Public ReadOnly Property TemplateArticle() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE")
        End Get
    End Property

    Public ReadOnly Property TemplateArticleNavbarL() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE_NVABAR_L")
        End Get
    End Property

    Public ReadOnly Property TemplateArticleNavbarR() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE_NVABAR_R")
        End Get
    End Property

    Public ReadOnly Property TemplateArticleCommnet() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE_COMMENT")
        End Get
    End Property

    Public ReadOnly Property TemplateArticleCommnetPost() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE_COMMENTPOST")
        End Get
    End Property

    Public ReadOnly Property TemplateArticleMutiList() As String
        Get
            Return Me.getFileCache("TEMPLATE_ARTICLE-MULTI-LIST")
        End Get
    End Property


    Private Function getFileCache(ByVal cacheKey As String) As String

        Dim globalKey As String = Me.blogGuid & cacheKey

        If Not (Me.context.Cache(globalKey)) Is Nothing Then
            Return CType(Me.context.Cache(globalKey), String)
        End If

        Me.initFileCacheList()

        Dim filecache As filecache

        For Each tempcache As filecache In Me._fileCacheList
            If (tempcache.CacheKey = cacheKey) Then
                filecache = tempcache
                Exit For
            End If
        Next

        If filecache Is Nothing Then
            Return ""
        End If

        Dim strContent As String = ""
        Dim strFilePath As String
        If filecache.FileName.Substring(0, 1) = "/" Then
            strFilePath = System.IO.Path.Combine(blogPath, "." & filecache.FileName)
        Else
            strFilePath = System.IO.Path.Combine(blogPath, filecache.FileName)
        End If
        strContent = LoadFromFile(strFilePath, "utf-8")

        Me.context.Cache.Insert(globalKey, strContent, New System.Web.Caching.CacheDependency(strFilePath))

        Return CType(Me.context.Cache(globalKey), String)

    End Function


    Private _fileCacheList As ArrayList

    Private Sub initFileCacheList()

        If Not Me._fileCacheList Is Nothing Then
            Return
        End If

        Dim aryFileCaches As New ArrayList

        aryFileCaches.Add(New FileCache("/INCLUDE/archives.asp", "CACHE_INCLUDE_ARCHIVES"))

        aryFileCaches.Add(New FileCache("/INCLUDE/authors.asp", "CACHE_INCLUDE_AUTHORS"))

        aryFileCaches.Add(New FileCache("/INCLUDE/calendar.asp", "CACHE_INCLUDE_CALENDAR"))

        aryFileCaches.Add(New FileCache("/INCLUDE/catalog.asp", "CACHE_INCLUDE_CATALOG"))

        aryFileCaches.Add(New FileCache("/INCLUDE/comments.asp", "CACHE_INCLUDE_COMMENTS"))

        aryFileCaches.Add(New FileCache("/INCLUDE/favorite.asp", "CACHE_INCLUDE_FAVORITE"))

        aryFileCaches.Add(New FileCache("/INCLUDE/link.asp", "CACHE_INCLUDE_LINK"))

        aryFileCaches.Add(New FileCache("/INCLUDE/misc.asp", "CACHE_INCLUDE_MISC"))

        aryFileCaches.Add(New FileCache("/INCLUDE/navbar.asp", "CACHE_INCLUDE_NAVBAR"))

        aryFileCaches.Add(New FileCache("/INCLUDE/previous.asp", "CACHE_INCLUDE_PREVIOUS"))

        aryFileCaches.Add(New FileCache("/INCLUDE/statistics.asp", "CACHE_INCLUDE_STATISTICS"))

        aryFileCaches.Add(New FileCache("/INCLUDE/tags.asp", "CACHE_INCLUDE_TAGS"))

        aryFileCaches.Add(New FileCache("/INCLUDE/calendar.asp", "CACHE_INCLUDE_CALENDAR_NOW"))

        aryFileCaches.Add(New FileCache("/INCLUDE/trackbacks.asp", "CACHE_INCLUDE_TRACKBACKS"))


        aryFileCaches.Add(New FileCache("/INCLUDE/google_sitesearch.html", "INCLUDE_GOOGLE_SITESEARCH"))

        aryFileCaches.Add(New FileCache("/INCLUDE/google_adsense.html", "INCLUDE_GOOGLE_ADSENSE"))

        aryFileCaches.Add(New FileCache("/INCLUDE/google_analytics.html", "INCLUDE_GOOGLE_ANALYTICS"))


        aryFileCaches.Add(New FileCache("/TEMPLATE/b_article_commentpost-verify.html", "TEMPLATE_ARTICLE_COMMENTPOST-VERIFY"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/b_article_tag.html", "TEMPLATE_ARTICLE_TAG"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/b_article_trackback.html", "TEMPLATE_ARTICLE_TRACKBACK"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/b_article-multi.html", "TEMPLATE_ARTICLE-MULTI"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/b_article-single.html", "TEMPLATE_ARTICLE-SINGLE"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/b_pagebar.html", "TEMPLATE_PAGEBAR"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/catalog.html", "TEMPLATE_CATALOG"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/default.html", "TEMPLATE_DEFAULT"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/search.html", "TEMPLATE_SEARCH"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/single.html", "TEMPLATE_SINGLE"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/article.html", "TEMPLATE_ARTICLE"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/b_article_nvabar_l.html", "TEMPLATE_ARTICLE_NVABAR_L"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/b_article_nvabar_r.html", "TEMPLATE_ARTICLE_NVABAR_R"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/b_article_comment.html", "TEMPLATE_ARTICLE_COMMENT"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/b_article_commentpost.html", "TEMPLATE_ARTICLE_COMMENTPOST"))

        aryFileCaches.Add(New FileCache("/TEMPLATE/b_article-multi-list.html", "TEMPLATE_ARTICLE-MULTI-LIST"))

        Me._fileCacheList = aryFileCaches

    End Sub


End Class
