Option Explicit On 
Option Strict On

Imports System.Collections


Public Class BlogBuilder
    Inherits PageHandlerBase


    Public Sub New(ByVal context As BlogPageContext)
        MyBase.New(context)
    End Sub


    Private _blogIndex As BlogIndex

    'Private _totalArticleCount As Integer


#Region "Public Methods"

    Public Function BuildBlogIndex() As Boolean

        If (Me._blogIndex Is Nothing) Then
            Me._blogIndex = New BlogIndex
        End If

        Dim users() As TUser = (New UserManager).GetUsers()
        Dim cates() As TCategory = (New CategoryManager).GetCategories()
        Dim tags() As TTag = (New TagManager).GetTags()

        Dim am As New ArticleManager

        Dim monthCounts As String() = am.GetMonthArchivesStat(-1) 'ȡ·ݵͳ
        Dim articleCount As Integer = am.GetTotalCount() '

        Me._blogIndex.Archives = monthCounts
        Me._blogIndex.Categories = cates
        Me._blogIndex.Users = users
        Me._blogIndex.Tags = tags
        Me._blogIndex.CreateTime = Now()

        Me._blogIndex.TotalArticleCount = articleCount

        Me._blogIndex.Save(System.IO.Path.Combine(Me.BlogPath, "CACHE/blogindex.cache"))

    End Function


    '*********************************************************
    'ؽۡhtmlļ
    '*********************************************************
    Public Function BuildHtmlLatestComments() As Boolean

        Dim objArticle As TArticle
        Dim am As New ArticleManager
        Dim cm As New CommentManager
        Dim comments As TComment() = cm.GetOrderedComments(BlogConfig.MSG_COUNT, True)
        Dim strComments As String = ""

        Dim s As String
        Dim i As Integer
        If Not IsNothing(comments) Then

            For Each comment As TComment In comments
                s = comment.Content
                s = Replace(s, vbCrLf, "")
                If Len(s) > BlogConfig.RECENT_COMMENT_WORD_MAX Then s = Left(s, BlogConfig.RECENT_COMMENT_WORD_MAX - 4) & "..."
                'objArticle = New TArticle
                'If am.LoadInfoByID(comment.log_ID, objArticle) Then
                'strComments = strComments & "<li><a href=""" & (New PageUrlManager(Me.BlogContext)).GetArticleUrl(objArticle) & "#cmt" & comment.ID & """ title=""" & comment.PostTime & " post by " & comment.Author & """>" + s + "</a></li>"
                strComments = strComments & "<li><a href=""" & (New PageUrlManager(Me.BlogContext)).GetArticleUrl(comment.LogID) & "#cmt" & comment.ID & """ title=""" & comment.PostTime & " post by " & comment.Author & """>" + s + "</a></li>"
                'End If
                objArticle = Nothing
            Next

        End If

        Call SaveToFile(System.IO.Path.Combine(BlogPath, "INCLUDE/comments.asp"), strComments, "utf-8")

        Return True

    End Function

    '*********************************************************
    'ؽáhtmlļ
    '*********************************************************
    Public Function BuildHtmlLatestTrackbacks() As Boolean

        Dim am As New ArticleManager
        Dim tm As New TrackbackManager
        Dim tbs As TTrackback() = tm.GetOrderedTrackbacks(BlogConfig.MSG_COUNT, True)
        Dim objArticle As TArticle
        Dim strTrackbacks As String
        Dim s As String

        If Not IsNothing(tbs) Then
            For Each tb As TTrackback In tbs
                s = tb.Title
                s = Replace(s, vbCrLf, "")
                If Len(s) > BlogConfig.RECENT_COMMENT_WORD_MAX Then s = Left(s, BlogConfig.RECENT_COMMENT_WORD_MAX - 5) & "..."
                objArticle = New TArticle
                If am.LoadInfoByID(tb.LogID, objArticle) Then
                    strTrackbacks = strTrackbacks & "<li><a href=""" & (New PageUrlManager(Me.BlogContext)).GetArticleUrl(objArticle.ID) & "#tb" & tb.ID & """ title=""" & tb.PostTime & " post by " & Replace(tb.Blog, """", "") & """>" + s + "</a></li>"
                End If
                objArticle = Nothing
            Next
        End If

        Call SaveToFile(System.IO.Path.Combine(BlogPath, "INCLUDE/trackbacks.asp"), strTrackbacks, "utf-8")

        Return True

    End Function

#End Region

    Private Function BuildHtmlMonthArchives() As Boolean

        Dim sb As New System.Text.StringBuilder
        Dim strArchives As String = ""
        Dim am As New ArticleManager

        Dim counter As Integer = 1
        For i As Integer = Me._blogIndex.Archives.Length - 1 To 0 Step -1  'For Each m As String In Me._blogIndex.Archives
            Dim m As String = Me._blogIndex.Archives(i)
            Dim mc As String() = Split(m, vbTab)
            Dim strYM As String = mc(0)
            Dim strY As String = strYM.Split(New Char() {"-"c})(0)
            Dim strM As String = strYM.Split(New Char() {"-"c})(1)
            Dim intCount As Integer = CInt(mc(1))

            strArchives = "<li><a href=""" & Page.BlogRootUrl & "Catalog.aspx?date=" & strYM & """>" _
                & strY & " " & Messages.MONTH_NAMES(CInt(strM)) _
                & " (" & intCount.ToString() & ")" _
                & "</a></li>"
            sb.Append(strArchives)
            If (counter = BlogConfig.ARCHIVE_COUNT) Then
                Exit For
            End If
            counter = counter + 1
        Next

        Call SaveToFile(System.IO.Path.Combine(BlogPath, "INCLUDE/archives.asp"), sb.ToString(), "utf-8")

        Return True

    End Function


    Private Function BuildHtmlCategories() As Boolean

        Dim cm As New CategoryManager
        Dim strCatalog As String = ""

        Dim cates As TCategory() = cm.GetTreeViewCategories()
        If (cates Is Nothing) Then
            Return True
        End If

        'ʹAjax̬װӷ
        If Me.BlogConfig.UseAjaxCategories Then
            Return Me.buildHtmlCategoriesAjaxFiles(cates, Nothing)
        Else
            Return Me.buildHtmlCategoriesInOneFile(cates)
        End If

    End Function

    Private Function buildHtmlCategoriesInOneFile(ByVal cates As TCategory()) As Boolean
        Dim sb As System.Text.StringBuilder = New System.Text.StringBuilder
        For Each cate As TCategory In cates
            exportHtmlCategoryTree(cate, sb, False)
        Next
        Dim strCatalog As String = sb.ToString()
        Call SaveToFile(System.IO.Path.Combine(BlogPath, "INCLUDE/catalog.asp"), strCatalog, "utf-8")
        Return True
    End Function

    Private Function buildHtmlCategoriesAjaxFiles(ByVal cates As TCategory(), ByVal fileName As String) As Boolean

        If cates Is Nothing Then
            Return True
        End If
        If fileName Is Nothing Then
            fileName = System.IO.Path.Combine(blogpath, "INCLUDE/catalog.asp")
        End If

        Dim sb As System.Text.StringBuilder = New System.Text.StringBuilder
        For Each cate As TCategory In cates
            exportHtmlCategoryTree(cate, sb, True)
        Next
        Dim strCatalog As String = sb.ToString()
        SaveToFile(fileName, strCatalog, "utf-8")

        For Each cate As TCategory In cates
            fileName = System.IO.Path.Combine(blogpath, "INCLUDE/CATEGORIES/cate_childs_" & cate.ID.ToString() & ".html")
            buildHtmlCategoriesAjaxFiles(cate.Childs, fileName)
        Next

        Return True
    End Function

    Private Sub exportHtmlCategoryTree(ByVal cate As TCategory, ByRef sb As System.Text.StringBuilder, ByVal useAjax As Boolean)

        Dim strClass As String
        strClass = "Closed"

        If Not useAjax Then '̬Ŀ¼
            If (Me.BlogConfig.CategoryExpandChilds) Then 'ȱʡǴĿ¼
                strClass = "Opened"
            End If
        End If

        Dim hasChilds As Boolean = True
        If cate.Childs Is Nothing Then
            hasChilds = False
        Else
            If cate.Childs.Length = 0 Then
                hasChilds = False
            End If
        End If

        If Not hasChilds Then
            strClass = "Child"
        End If

        Dim imgtag As String = ""
        Dim imgsrc As String = Me.BlogConfig.BlogRootUrl & "IMAGE/COMMON/s.gif"
        'ӷľ̬HtmlļINCLUDEĿ¼
        Dim ajaxFileName As String = "CATEGORIES/cate_childs_" & cate.ID.ToString() & ".html"
        If Not hasChilds Then
            imgtag = "<img src=""" & imgsrc + """ class=""s"" />"
        Else
            If useAjax Then
                imgtag = "<img src=""" & imgsrc & """ class=""s"" onclick=""AjaxLoadHtml(this,'Opened','Closed',1,'li','ul','" & ajaxFileName & "');"" alt=""Open/Close"" />"
            Else
                imgtag = "<img src=""" & imgsrc & """ class=""s"" onclick=""ExCls(this,'Opened','Closed',1);"" alt=""Open/Close"" />"
            End If
        End If

        sb.Append("<li id=""li_cate_" & cate.ID.ToString() & """ class=""")
        sb.Append(strClass)
        sb.Append(""">")
        sb.Append(imgtag)
        sb.Append("<a href=""" & (New PageUrlManager(Me.BlogContext)).GetCategoryArticlesUrl(page.BlogRootUrl, cate) & """>" + cate.Name + " (" & cate.Count & ")" + "</a>")
        sb.Append("<a href=""" & page.BlogRootUrl & "Rss.aspx?cate=" & cate.ID.ToString() & """ target=""_blank"">")
        sb.Append("<img src=""" & page.BlogRootUrl & "IMAGE/LOGO/rss.png"" border=""0"" alt=""rss"">")
        sb.Append("</a>")

        If Not useAjax Then '̬ӷ
            If hasChilds Then
                sb.Append(vbCrLf) : sb.Append("<ul>")
                For Each child As TCategory In cate.Childs
                    'ݹãĿ¼
                    exportHtmlCategoryTree(child, sb, False)
                Next
                sb.Append(vbCrLf) : sb.Append("</ul>")
            End If
        Else 'ʹAjax̬װ
            'If hasChilds Then 'һԡ<ul></ul>ǩ
            '    sb.Append(vbCrLf) : sb.Append("<ul id=""ul_cate_childs_" & cate.ID.ToString() & """>")
            '    sb.Append(Me.Messages.MSG_LOADING)
            '    sb.Append(vbCrLf) : sb.Append("</ul>")
            'End If
        End If
        sb.Append("</li>")
        sb.Append(vbCrLf)

    End Sub


    Private Function BuildHtmlAuthors() As Boolean

        Dim strAuthor As String = ""
        Dim user As TUser
        Dim users() As TUser = (New UserManager).GetUsers()

        If Not IsNothing(users) Then
            For Each user In users
                If Not IsNothing(user) Then
                    strAuthor = strAuthor & "<li><a href=""" & (New PageUrlManager(Me.BlogContext)).GetAuthorArticlesUrl(user) & """>" + user.Name + " (" & user.Count & ")" + "</a></li>"
                End If
            Next
        End If

        Call SaveToFile(System.IO.Path.Combine(BlogPath, "INCLUDE/authors.asp"), strAuthor, "utf-8")
        Return True
    End Function


    '*********************************************************
    '̬Tagsļ
    '*********************************************************
    Private Function BuildHtmlTags() As Boolean

        If Not Me.BlogConfig.BuildTagsHtmlFile Then 'Tag࣬԰ѡص
            Return True
        End If

        Dim strTag As String = ""
        Dim tm As New TagManager
        Dim orderedtags As TTag() = tm.GetOrderedTags()

        If Not IsNothing(orderedtags) Then
            For Each tag As TTag In orderedtags
                strTag = strTag & "<li><a href=""" & (New PageUrlManager(Me.BlogContext)).GetTagArticlesUrl(tag) & """>" + tag.Name + " (" & tag.Count & ")" + "</a>" _
                    & " <a href=""" & page.BlogRootUrl & "Rss.aspx?tagsID=" & tag.ID.ToString() & """ target=""_blank"">" _
                    & " <img src=""" & page.BlogRootUrl & "IMAGE/LOGO/rss.png"" border=""0"" alt=""rss""></a></li>"
            Next
        End If

        Call SaveToFile(System.IO.Path.Combine(BlogPath, "INCLUDE/tags.asp"), strTag, "utf-8")

        Return True
    End Function


    '*********************************************************
    '*********************************************************
    Private Function BuildHtmlLatestArticles() As Boolean

        Dim strPrevious As String
        Dim am As New ArticleManager
        Dim articles As TArticle()
        articles = am.GetPrevious(BlogConfig.PREVIOUS_COUNT)

        If Not IsNothing(articles) Then
            For Each objArticle As TArticle In articles
                strPrevious = strPrevious & "<li><a href=""" & (New PageUrlManager(Me.BlogContext)).GetArticleUrl(objArticle.ID) & """>" & objArticle.Title & "</a></li>"
            Next
        End If

        Call SaveToFile(System.IO.Path.Combine(BlogPath, "INCLUDE/previous.asp"), strPrevious, "utf-8")

        Return True

    End Function


    Private Function BlogReStatistics() As Boolean

        Dim cm As New CategoryManager
        Dim category As TCategory
        Dim cates() As TCategory = (New CategoryManager).GetCategories
        For Each category In cates
            If Not IsNothing(category) Then
                cm.UpdateArticleCount(category.ID)
            End If
        Next

        Dim um As New UserManager
        Dim user As TUser
        Dim users() As TUser = (New UserManager).GetUsers()
        For Each user In users
            If Not IsNothing(user) Then
                um.UpdateArticleCount(user.ID)
                um.UpdateCommentCount(user.ID)
            End If
        Next

        Dim tm As New TagManager
        Dim tag As TTag
        Dim tags() As TTag = (New TagManager).GetTags()
        If Not IsNothing(tags) Then
            For Each tag In tags
                If Not IsNothing(tag) Then
                    tm.UpdateArticleCount(tag.ID)
                End If
            Next
        End If

    End Function


    '*********************************************************
    '*********************************************************
    Private Function BuildHtmlStatistics() As Boolean

        Dim strStatistics As String = ""
        Dim articleCount, commentCount, trackbackCount As Integer

        Dim am As New ArticleManager
        articleCount = am.GetTotalCount()
        Dim cm As New CommentManager
        commentCount = cm.GetTotalCount()
        Dim tm As New TrackbackManager
        trackbackCount = tm.GetTotalCount()

        strStatistics = strStatistics & "<li>" & Messages.MSG_ARTICLE_TOTAL_NUMBER & ":" & articleCount.ToString & "</li>"
        strStatistics = strStatistics & "<li>" & Messages.MSG_COMMENT_TOTAL_COUNT & ":" & commentCount.ToString() & "</li>"
        strStatistics = strStatistics & "<li>" & Messages.MSG_TRACKBACK_TOTAL_COUNT & ":" & trackbackCount.ToString() & "</li>"
        strStatistics = strStatistics & "<li>" & Messages.MSG_CURRENT_STYLE & ":" & BlogConfig.BlogCss & "</li>"
        strStatistics = strStatistics & "<li>" & Messages.MSG_CURRENT_LANGUAGE & ":" & BlogConfig.BlogLanguage & "</li>"

        ' Me._totalArticleCount = articleCount

        Call SaveToFile(System.IO.Path.Combine(BlogPath, "INCLUDE/statistics.asp"), strStatistics, "utf-8")

        Return True

    End Function


    '*********************************************************
    '*********************************************************
    Public Function MakeBlogReBuild() As Boolean

        'ͳ
        BlogReStatistics()

        'ļ
        BuildBlogIndex()

        'ע⣬ԱBuildBlogIndex
        BuildHtmlMonthArchives()

        'ɡվͳơhtmlļ
        BuildHtmlStatistics()

        BuildHtmlLatestArticles()
        BuildHtmlCurrentCalendar()

        BuildHtmlCategories()
        BuildHtmlAuthors()
        BuildHtmlTags()

        BuildHtmlLatestComments()
        BuildHtmlLatestTrackbacks()

        'XML
        ExportStaticRSS()
        ExportStaticATOM()
        ExoportStaticSitemap() '̬Google Sitemapļ

        MakeBlogReBuild = True

    End Function

    '*********************************************************
    ' Ŀģ    
    '*********************************************************
    Private Function BuildHtmlCurrentCalendar() As Boolean

        Dim strCalendar As String
        strCalendar = (New Calendar(Me.BlogContext)).MakeCalendar(Date.Now.ToString("yyyy-MM-dd"))

        Call SaveToFile(System.IO.Path.Combine(BlogPath, "INCLUDE/calendar.asp"), strCalendar, "utf-8")
        Return True

    End Function


    Private Function ExoportStaticSitemap() As Boolean
        Dim xx As XmlExporter = New XmlExporter(Me.BlogContext)
        Return xx.ExportStaticSitemap
    End Function

    Private Function ExportStaticRSS() As Boolean
        Dim xx As XmlExporter = New XmlExporter(Me.BlogContext)
        Return xx.ExportStaticRSS()
    End Function


    Private Function ExportStaticATOM() As Boolean
        Dim xx As XmlExporter = New XmlExporter(Me.BlogContext)
        Return xx.ExportStaticATOM()
    End Function


End Class
