Option Explicit On 
Option Strict On

Public Class PageArticleManager
    Inherits PageHandlerBase

    Public Sub New(ByVal context As BlogPageContext)
        MyBase.New(context)
    End Sub


    '********************************************************
    'ؽ
    '********************************************************
    Private Function BuildHtmlLatestComments() As Boolean
        Dim bb As BlogBuilder
        bb = New BlogBuilder(Me.BlogContext)
        bb.BuildHtmlLatestComments()
    End Function


    Public Function PostArticle(ByVal id As String, ByVal cateID As String, ByVal authorID As String, ByVal level As String, ByVal posttime As String, ByVal title As String, ByVal strTags As String, ByVal strAlias As String, ByVal intro As String, ByVal content As String, ByRef articleId As Integer, ByRef errMessage As String) As Boolean

        Dim s As String

        Dim objRegExp As System.Text.RegularExpressions.Regex

        If id <> "0" Then 'If Request.Form("edtID") <> "0" Then
            Dim objTestArticle As PageArticle
            objTestArticle = New PageArticle(Me.BlogContext)
            If objTestArticle.LoadInfoByID(CInt(id)) Then
                If Not ((objTestArticle.AuthorID = CurrentUser.ID) OrElse (Me.Page.CheckRights("Root") = True)) Then
                    errMessage = Me.Messages.ERROR_MESSAGES(6)
                    Return False
                End If
                'objTestArticle.DelFile()
            Else
                'Call ShowError(9)
                errMessage = Me.Messages.ERROR_MESSAGES(9)
                Return False
            End If
        End If

        Dim objArticle As PageArticle

        objArticle = New PageArticle(Me.BlogContext)
        objArticle.ID = CInt(id)
        objArticle.CateID = CInt(cateID)
        objArticle.AuthorID = CInt(authorID)
        objArticle.Level = CInt(level)
        objArticle.PostTime = CDate(posttime) 'CDate(Request.Form("edtYear") & "-" & Request.Form("edtMonth") & "-" & Request.Form("edtDay") & " " & Request.Form("edtTime"))
        objArticle.Title = title
        objArticle.Alias = strAlias
        objArticle.Intro = intro
        objArticle.Content = content

        Dim strTagIds As String = ""
        Dim tags() As TTag
        tags = parseSaveTags(strTags, ",")
        If Not tags Is Nothing Then
            For Each tag As TTag In tags
                strTagIds = strTagIds & "{" & tag.ID.ToString() & "}"
            Next
        End If
        objArticle.Tag = strTagIds

        If objArticle.Intro = "" Then
            s = objArticle.Content
            objRegExp = New System.Text.RegularExpressions.Regex("<[^>]*>", Text.RegularExpressions.RegexOptions.ECMAScript Or Text.RegularExpressions.RegexOptions.IgnoreCase)
            s = objRegExp.Replace(s, "")
            s = Left(s, BlogConfig.TB_EXCERPT_MAX) & "..."
            objArticle.Intro = s
        End If

        'objArticle.Title = Me.UbbHtmlHandler.HandleHtml(objArticle.Title, "[japan-html]")
        'objArticle.Intro = Me.UbbHtmlHandler.HandleHtml(objArticle.Intro, "[japan-html]")
        'objArticle.Content = Me.UbbHtmlHandler.HandleHtml(objArticle.Content, "[japan-html]")
        objArticle.[Alias] = StringHelper.FilterFileName(objArticle.[Alias]) 'Me.UbbHtmlHandler.HandleHtml(objArticle.[Alias], "[filename]")

        Dim tm As New TagManager
        Dim isNewArticle As Boolean
        isNewArticle = CBool(IIf(objArticle.ID = 0, True, False))
        If objArticle.Post Then
            articleId = objArticle.ID

            If isNewArticle Then
                tm.SaveArticleTags(objArticle.ID, objArticle.Title, tags)
            Else
                tm.UpdateArticleTags(objArticle.ID, objArticle.Title, tags)
            End If

            'עʹþ̬ҳ棬ôҪؽ
            If Me.BlogConfig.BuildRealStaicPage Then
                If objArticle.Build() Then
                    Me.SaveToFile(System.IO.Path.Combine(BlogPath, "post/" & objArticle.ID.ToString() & ".html"), objArticle.Html, "utf-8")
                End If
            End If

            PostArticle = True
        End If

    End Function


    Public Function DelArticle(ByVal intID As Integer, ByRef errMessage As String) As Boolean

        Dim objArticle As PageArticle

        If intID <> 0 Then

            Dim objTestArticle As PageArticle
            objTestArticle = New PageArticle(Me.BlogContext)
            If objTestArticle.LoadInfoByID(intID) Then
                If Not ((objTestArticle.AuthorID = CurrentUser.ID) Or (page.CheckRights("Root") = True)) Then
                    errMessage = Me.Messages.ERROR_MESSAGES(6)
                    Return False
                Else
                    objArticle = objTestArticle
                End If
            Else
                errMessage = Me.Messages.ERROR_MESSAGES(9)
                Return False 'Call ShowError(9)
            End If

        End If

        If Not objArticle Is Nothing Then 'If objArticle.LoadInfoByID(intID) Then
            If objArticle.Del() Then DelArticle = True
            Me.BuildHtmlLatestComments()
            Return True
        Else
            Return False
        End If

    End Function


    '*********************************************************
    ' Ŀģ    Manager Articles
    '*********************************************************
    Function ExportArticleManageTable(ByVal intPage As Integer, ByVal intCate As Integer, ByVal intLevel As Integer, ByVal strTitle As String, ByVal intCount As Integer) As Boolean

        If intPage <= 0 Then intPage = 1 'Call CheckParameter(intPage, "int", 1)
        If (intCount <= 0) Then intCount = BlogConfig.MANAGE_COUNT 'Call CheckParameter(intCount, "int", BlogConfig.MANAGE_COUNT)

        Dim i As Integer

        Response.Write("<form id=""edit"" method=""post"" enctype=""application/x-www-form-urlencoded"" action=""../ADMIN/Admin.aspx?act=ArticleMng"">")
        Response.Write("<p>" & Messages.MSG_INCLUDE & " <input id=""title"" name=""title"" style=""width:50px;"" type=""text"" value="""" /> ")

        Response.Write(Messages.MSG_CATEGORY & " <select class=""edit"" size=""1"" id=""cate"" name=""cate"" style=""width:100px;"" ><option value=""-1"">" & Messages.MSG_ANY & "</option> ")

        Dim category As TCategory
        Dim cates() As TCategory = (New CategoryManager).GetOrderedCategories()
        For Each category In cates
            If Not IsNothing(category) Then
                Response.Write("<option value=""" & category.ID & """ ")
                Response.Write(">" & Me.Server.HtmlEncode(category.Name) & "</option>")
            End If
        Next
        Response.Write("</select> ")

        Response.Write(Messages.MSG_TYPE & " <select class=""edit"" size=""1"" id=""level"" name=""level"" style=""width:80px;"" ><option value=""-1"">" & Messages.MSG_ANY & "</option> ")

        For i = LBound(Messages.ARTICLE_TYPE_NAMES) + 1 To UBound(Messages.ARTICLE_TYPE_NAMES)
            Response.Write("<option value=""" & i & """ ")
            Response.Write(">" & Messages.ARTICLE_TYPE_NAMES(i) & "</option>")
        Next
        Response.Write("</select> ")
        Response.Write(Messages.MSG_SHOW & " <input id=""count"" name=""count"" style=""width:20px;"" type=""text"" value="""" />" & Messages.MSG_ITEM & " ")
        Response.Write("<INPUT TYPE=""submit"" value=""" & Messages.MSG_POST & """>")
        Response.Write("</p></form>")

        Dim isRootUser As Boolean = page.CheckRights("Root")

        If Not IsNothing(strTitle) Then
            strTitle = UnEscape(strTitle)
        End If

        Response.Write("<form id=""edit2"" method=""post"" enctype=""application/x-www-form-urlencoded"" action=""" & page.BlogRootUrl & "Cmd.aspx?act=MutiArticle"">")
        response.Write("<table border=""1"" width=""100%"" cellspacing=""1"" cellpadding=""1"" style=""behavior:url(" & page.BlogRootUrl & "SCRIPT/sort.htc);"">")
        Response.Write("<THEAD><tr align=""center""><td>" & Messages.MSG_ID & "</td><td>" & Messages.MSG_CATEGORY & "</td><td>" & Messages.MSG_USER & "</td><td>" & Messages.MSG_TYPE & "</td><td>" & Messages.MSG_TIME & "</td><td>" & Messages.MSG_TITLE & "</td><td></td><td><INPUT TYPE=""checkbox"" name=""selAll"" id=""name=""selAll"""" onclick=""if(this.checked==true){for (var i=0;i<document.getElementsByName('selAnnounce').length;i++) document.getElementsByName('selAnnounce')[i].checked=true;}else{for (var i=0;i<document.getElementsByName('selAnnounce').length;i++) document.getElementsByName('selAnnounce')[i].checked=false;}""></td></tr></THEAD><TBODY>")

        Dim am As New ArticleManager
        Dim aryArticles() As TArticle
        Dim pageCount As Integer 'ҳ
        aryArticles = am.GetManagedArticles(isRootUser, CurrentUser.ID.ToString(), intCate, intLevel, strTitle, intPage, intCount, pageCount)
        If Not IsNothing(aryArticles) And aryArticles.Length > 0 Then 'If (Not objRS.BOF) And (Not objRS.EOF) Then

            For i = 0 To aryArticles.Length - 1
                Dim objArticle As TArticle = aryArticles(i)
                Response.Write("<tr>")
                If objArticle.IsTop <> 0 Then
                    Response.Write("<td  style=""background-color: #FFD0D0"">" & objArticle.ID & "</td>")
                Else
                    Response.Write("<td>" & objArticle.ID & "</td>")
                End If

                'If Me.Categories(objArticle.CateID) Is Nothing Then
                '    Response.Write("<td>" & Me.Messages.MSG_UNKNOWN_CATEGORY & "</td>")
                'Else
                Response.Write("<td>" & Me.Categories(objArticle.CateID).Name & "</td>")
                'End If
                Response.Write("<td>" & Me.Users(objArticle.AuthorID).Name & "</td>")

                Response.Write("<td>" & Messages.ARTICLE_TYPE_NAMES(objArticle.Level) & "</td>")
                'Response.Write("<td>" & FormatDateTime(objArticle.PostTime, vbShortDate) & "</td>")
                Response.Write("<td>" & objArticle.PostTime.ToString("yyyy-MM-dd") & "</td>")
                'Response.Write("<td align=""center""><a href=""" & page.BlogRootUrl & "View.aspx?id=" & objArticle.ID.ToString() & """ target=""_blank"">" & Left(objArticle.Title, 14) & "</a></td>")
                Response.Write("<td><a href=""" & page.BlogRootUrl & "View.aspx?id=" & objArticle.ID.ToString() & """ target=""_blank"">" & server.HtmlEncode(objArticle.Title) & "</a></td>")
                'Response.Write("<td align=""center""><a href=""" & page.BlogRootUrl & "Cmd.aspx?act=ArticleEdt&type=" & BlogConfig.BLOG_WEBEDIT 
                Response.Write("<td align=""center""><a href=""" & page.BlogRootUrl & "Cmd.aspx?act=ArticleEdt&type=WYSIWYG" _
                    & "&id=" & objArticle.ID & """>[" & Messages.MSG_EDIT_WYSIWYG _
                    & "]</a><a href=""" & page.BlogRootUrl & "Cmd.aspx?act=ArticleEdt&id=" & objArticle.ID & """>[" & Messages.MSG_EDIT_NORMAL & "]</a>" _
                    & " <a onclick='return window.confirm(""" & Messages.MSG_OK_TO_CONTINUE_OR_CANCEL & """);' href=""" & page.BlogRootUrl & "Cmd.aspx?act=ArticleDel&id=" & objArticle.ID & """>[" & Messages.MSG_DELETE & "]</a></td>")
                Response.Write("<td align=""center""><input type=""checkbox"" id=""selAnnounce"" name=""selAnnounce"" value=""" & objArticle.ID & """ /></td>")
                Response.Write("</tr>")

            Next

        End If

        Response.Write("</TBODY></table>")

        Dim strPage As String = ""
        For i = 1 To pageCount 'objRS.PageCount
            strPage = strPage & "<a href='../ADMIN/Admin.aspx?act=ArticleMng&amp;page=" & i & "&cate=" & ReQuest("cate") & "&level=" & ReQuest("level") & "&title=" & Escape(ReQuest("title")) & "&time=" & ReQuest("time") & "&count=" & ReQuest("count") & "'>[" & Replace(Messages.MSG_PAGE_NUMBER, "%s", i.ToString()) & "]</a> "
        Next

        Response.Write("<br>" & Messages.MSG_SET_SELECTED_ITEMS_TO & " " & Messages.MSG_CATEGORY & " <select class=""edit"" size=""1"" id=""edtcate"" name=""edtcate"" style=""width:100px;"" ><option value=""-1"">" & Messages.MSG_NOT_CHANGED & "</option> ")

        For Each category In cates
            If Not IsNothing(category) Then
                Response.Write("<option value=""" & category.ID & """ ")
                Response.Write(">" & Me.Server.HtmlEncode(category.Name) & "</option>")
            End If
        Next
        Response.Write("</select> ")

        Response.Write(Messages.MSG_TYPE & " <select class=""edit"" size=""1"" id=""edtlevel"" name=""edtlevel"" style=""width:80px;"" ><option value=""-1"">" & Messages.MSG_NOT_CHANGED & "</option> ")

        For i = LBound(Messages.ARTICLE_TYPE_NAMES) + 1 To UBound(Messages.ARTICLE_TYPE_NAMES)
            Response.Write("<option value=""" & i & """ ")
            Response.Write(">" & Messages.ARTICLE_TYPE_NAMES(i) & "</option>")
        Next
        Response.Write("</select> ")

        Response.Write(Messages.MSG_STICKY & " <select class=""edit"" size=""1"" id=""edttop"" name=""edttop"" style=""width:80px;"" ><option value=""2"">" & Messages.MSG_NOT_CHANGED & "</option> ")
        Response.Write("<option value=""-1"">" & Messages.MSG_STICKY & "</option>")
        Response.Write("<option value=""0"">" & Messages.MSG_NOT_STICKY & "</option>")
        Response.Write("</select> ")
        Response.Write("<input type=""checkbox"" id=""edtdelete"" name=""edtdelete"" value=""1"" onclick=""if(this.checked==true){edtlevel.disabled=true;edtcate.disabled=true;edttop.disabled=true;}else{edtlevel.disabled=false;edtcate.disabled=false;edttop.disabled=false;}""/><label for=""edtdelete"">" & Messages.MSG_DELETE & "</label>")
        Response.Write("<INPUT TYPE=""submit"" value=""" & Messages.MSG_POST & """></form>")
        Response.Write("<hr/>")
        Response.Write(Messages.MSG_PAGE & ": " & strPage)

        Return True

    End Function



    '*********************************************************
    ' Ŀģ    Parse Tag ʽ
    '*********************************************************
    Private Function parseSaveTags(ByVal strTag As String, ByVal separator As String) As TTag()

        Dim s As String
        Dim strTags() As String

        Dim arraytags As New System.Collections.ArrayList
        Dim arraynewtags As New System.Collections.ArrayList        'Dim newtags() As TTag

        Dim objTag As TTag
        Dim i As Integer
        Dim b As Boolean

        strTag = Trim(strTag) 'strTag = Me.UbbHtmlHandler.HandleHtml(strTag, "[normalname]")
        strTags = strTag.Split(separator.ToCharArray())

        For i = 0 To strTags.Length - 1
            If ((Not strTags(i) Is Nothing) AndAlso strTags(i).Trim() <> "") Then
                strTags(i) = strTags(i).Trim()

                b = False
                objTag = Me.Tags.GetTagInfoByName(strTags(i)) 'ȴӻȡ
                If Not objTag Is Nothing Then
                    arraytags.Add(objTag)
                    b = True
                End If

                If b = False Then 'ڻвڣҪTag
                    Dim objNewTag As TTag
                    Dim tm As New TagManager
                    objNewTag = New TTag
                    objNewTag.Name = strTags(i) 'objNewTag.Order = 0'objNewTag.Intro = ""
                    If tm.Post(objNewTag, True) Then
                        arraynewtags.Add(objNewTag)
                    End If
                End If

            End If
        Next

        arraytags.AddRange(arraynewtags)
        Return CType(arraytags.ToArray(GetType(TTag)), TTag())

    End Function


End Class
