Option Explicit On 
Option Strict On

Imports System.Web

Class PageCategoryManager
    Inherits PageHandlerBase

    Public Sub New(ByVal context As BlogPageContext)
        MyBase.New(context)
    End Sub


    '*********************************************************
    ' Ŀģ    Manager Categories
    '*********************************************************
    Public Function ExportCategoryList(ByVal intPage As Integer) As Boolean

        Dim i As Integer
        Dim strPage As String

        Response.Write("<form id=""edit"" method=""post"" action="""">")
        Response.Write("<p>" & Messages.MSG_ADD_NEW_CATEGORY & ": </p>")
        Response.Write("<p><a href=""" & page.BlogRootUrl & "Cmd.aspx?act=CategoryEdt"">[" & Messages.MSG_NEW_CATEGORY & "]</a></p>")
        Response.Write("</form>")

        If intPage <= 0 Then intPage = 1

        Response.Write("<table border=""1"" width=""100%"" cellspacing=""1"" cellpadding=""1"">")
        Response.Write("<tr>")
        Response.Write("<td>" & Messages.MSG_ID & "</td>")
        Response.Write("<td>" & Messages.MSG_PARENT_CATEGORY & Messages.MSG_ID & "</td>")
        Response.Write("<td>" & Messages.MSG_NAME & "</td>")
        Response.Write("<td>" & Messages.MSG_ORDER & "</td>")
        Response.Write("<td>" & Messages.MSG_EXCERPT & "</td>")
        Response.Write("<td></td><td></td></tr>")

        Dim cates() As TCategory
        Dim cm As New CategoryManager
        cates = cm.GetOrderedCategories()

        If Not IsNothing(cates) Then
            For i = 0 To cates.Length - 1
                Response.Write("<tr>")
                Response.Write("<td>" & cates(i).ID & "</td>")
                Response.Write("<td>" & cates(i).ParentID & "</td>")
                Response.Write("<td><a href=""" & page.BlogRootUrl & "Catalog.aspx?cate=" & cates(i).ID & """  target=""_blank"">" & cates(i).Name & "</a></td>")
                Response.Write("<td>" & cates(i).Order & "</td>")
                Response.Write("<td>" & cates(i).Intro & "</td>")
                Response.Write("<td align=""center""><a href=""" & page.BlogRootUrl & "Cmd.aspx?act=CategoryEdt&id=" & cates(i).ID & """>[" & Messages.MSG_EDIT & "]</a></td>")
                Response.Write("<td align=""center""><a onclick='return window.confirm(""" & Messages.MSG_OK_TO_CONTINUE_OR_CANCEL & """);' href=""" & page.BlogRootUrl & "Cmd.aspx?act=CategoryDel&amp;id=" & cates(i).ID & """>[" & Messages.MSG_DELETE & "]</a></td>")
                Response.Write("</tr>")
            Next
        End If

        Response.Write("</table>")

        For i = 1 To 1
            strPage = strPage & "<a href='../ADMIN/Admin.aspx?act=CategoryMng&amp;page=" & i & "'>[" & Replace(Messages.MSG_PAGE_NUMBER, "%s", i.ToString()) & "]</a> "
        Next
        Response.Write("<hr/>" & Messages.MSG_PAGE & ": " & strPage)

        ExportCategoryList = True

    End Function

    ''*********************************************************
    '' Ŀģ    Post Category
    ''*********************************************************
    'Public Function PostCategory() As Boolean
    '    Dim objCategory As TCategory
    '    objCategory = New TCategory
    '    objCategory.ID = CInt(Request.Form("edtID"))
    '    objCategory.Name = Request.Form("edtName")
    '    objCategory.Order = CStr(Request.Form("edtOrder")) 'CInt(Request.Form("edtOrder"))
    '    'objCategory.Alias = Request.Form("edtAlias")
    '    objCategory.Intro = Request.Form("edtAlias")
    '    If (New CategoryManager).Post(objCategory) Then PostCategory = True
    '    objCategory = Nothing
    'End Function


    '*********************************************************
    ' Ŀģ    Del Category
    '*********************************************************
    Public Function DelCategory(ByVal intID As Integer, ByRef errMessage As String) As Boolean

        Dim cm As New CategoryManager
        Try
            If cm.Del(intID) Then
                Return True
            End If
        Catch ex As NotEmptyCategoryException
            errMessage = Me.Messages.ERROR_MESSAGES(13)
            Return False 'Me.ShowError(13)
        End Try

        Return False

    End Function


End Class
