Option Explicit On 
Option Strict On

Imports System.Web
Imports System.Net

Class PageTrackbackManager
    Inherits PageHandlerBase

    Public Sub New(ByVal context As BlogPageContext)
        MyBase.New(context)
    End Sub


    Private Function BuildHtmlLatestTrackbacks() As Boolean
        Dim bb As BlogBuilder = New BlogBuilder(Me.BlogContext)
        Return bb.BuildHtmlLatestTrackbacks()
    End Function


    '*********************************************************
    ' Ŀģ    Manager Trackbacks
    '*********************************************************
    Public Function ExportTrackbackList(ByVal intPage As Integer) As Boolean

        If intPage <= 0 Then intPage = 1

        Dim isRootUser As Boolean = page.CheckRights("Root")

        Response.Write("<table border=""1"" width=""100%"" cellspacing=""1"" cellpadding=""1"">")
        Response.Write("<tr><td>" & Messages.MSG_ID & "</td><td>" & Messages.MSG_TRACKBACK & "</td><td>" & Messages.MSG_TITLE & "</td><td>" & Messages.MSG_CONTENT & "</td><td></td></tr>")

        Dim tm As New TrackbackManager
        Dim pagecount As Integer 'ҳ
        Dim aryTB() As TTrackback = tm.GetManagedTrackbacks(isRootUser, currentUser.ID, intPage, BlogConfig.MANAGE_COUNT, pagecount)

        If Not aryTB Is Nothing Then 'If (Not objRS.bof) And (Not objRS.eof) Then
            For Each tb As TTrackback In aryTB 'i = 1 To objRS.PageSize
                Response.Write("<tr>")
                Response.Write("<td>" & tb.ID & "</td>")  'objRS("log_ID")
                'Response.Write("<td><a title=""" & tb.Title & """ target=""_blank"" href=""" & tb.Url & """>" & Left(tb.Blog, 14) & "</a></td>")
                Response.Write("<td><a title=""" & tb.Title & """ target=""_blank"" href=""" & tb.Url & """>" & server.HtmlEncode(tb.Blog) & "</a></td>")
                'Response.Write("<td><a href=""" & page.BlogRootUrl & "View.aspx?id=" & tb.log_ID & "#tb" & tb.ID & """ target=""_blank"">" & Left(tb.Title, 12) & "</a></td>")
                Response.Write("<td><a href=""" & page.BlogRootUrl & "View.aspx?id=" & tb.LogID & "#tb" & tb.ID & """ target=""_blank"">" & server.HtmlEncode(tb.Title) & "</a></td>")
                'Response.Write("<td>" & Left(tb.Excerpt, 18) & "</td>")
                If (tb.Excerpt.Length > 18) Then
                    Response.Write("<td>" & server.HtmlEncode(tb.Excerpt.Substring(0, 18) & "...") & "</td>")
                Else
                    Response.Write("<td>" & server.HtmlEncode(tb.Excerpt) & "</td>")
                End If
                Response.Write("<td align=""center""><a href=""" & page.BlogRootUrl & "Cmd.aspx?act=TrackbackDel&id=" & tb.ID & "&log_id=" & tb.LogID & """ onclick='return window.confirm(""" & Messages.MSG_OK_TO_CONTINUE_OR_CANCEL & """);'>[" & Messages.MSG_DELETE & "]</a></td>")
                Response.Write("</tr>")
            Next
        End If
        Response.Write("</table>")

        Dim strPage As String = ""
        For i As Integer = 1 To pagecount
            strPage = strPage & "<a href='../ADMIN/Admin.aspx?act=TrackbackMng&amp;page=" & i & "'>[" & Replace(Messages.MSG_PAGE_NUMBER, "%s", i.ToString()) & "]</a> "
        Next

        Response.Write("<hr/>" & Messages.MSG_PAGE & ": " & strPage)

        ExportTrackbackList = True

    End Function


    '*********************************************************
    ' Ŀģ    Post Trackback
    '*********************************************************
    Public Function PostTrackback(ByVal intID As Integer) As Boolean

        Dim tm As TrackbackManager = New TrackbackManager
        Dim objTrackback As TTrackback
        Dim objArticle As PageArticle 'TArticle
        objTrackback = New TTrackback
        objArticle = New PageArticle(Me.BlogContext)

        objTrackback.LogID = intID
        objTrackback.Url = Request.Form("url")
        objTrackback.Title = Request.Form("title")
        objTrackback.Blog = Request.Form("blog_name")
        objTrackback.Excerpt = Request.Form("excerpt")
        objTrackback.PostTime = Now()

        Dim errmsg As String
        If Me.post(objTrackback) Then  'If objTrackback.Post Then
            If objArticle.LoadInfoByID(objTrackback.LogID) Then
                objArticle.Statistic() 'ͳ
                Me.BuildHtmlLatestTrackbacks() 'BlogReBuild_Trackbacks()
                PostTrackback = True
            End If
        End If

        objTrackback = Nothing

    End Function

    Private Function post(ByVal tb As TTrackback) As Boolean


        tb.Blog = Me.Server.HtmlEncode(tb.Blog)
        tb.Title = Me.Server.HtmlEncode(tb.Title)
        tb.Excerpt = Me.Server.HtmlEncode(tb.Excerpt)
        tb.Url = Me.Server.HtmlEncode(tb.Url)

        'Call ReturnTbXML("undiscovered"):Exit Function
        'Call CheckParameter(log_ID, "int", 0)
        'If IsDate(PostTime) = False Then PostTime = Now()
        tb.IP = Request.ServerVariables("REMOTE_ADDR")
        tb.Agent = Request.ServerVariables("HTTP_USER_AGENT")

        Dim errmsg As String
        Dim tbm As New TrackbackManager
        If (tbm.Post(tb, errmsg, Me.BlogConfig.HOMEPAGE_MAX, Me.BlogConfig.EMAIL_MAX, Me.BlogConfig.TB_EXCERPT_MAX)) Then
            Me.ReturnTbXML("succeed")
            post = True
        Else
            Me.ReturnTbXML(errmsg)
            'Post = False
        End If

    End Function



    '*********************************************************
    ' Ŀģ    Del Trackback
    '*********************************************************
    Public Function DelTrackback(ByVal intId As Integer, ByVal intLogId As Integer, ByRef errMessage As String) As Boolean

        Dim tm As New TrackbackManager
        Dim am As New ArticleManager

        Dim objTrackback As TTrackback
        If (tm.LoadInfoByID(intId, objTrackback) = False) Then
            errMessage = Me.Messages.ERROR_MESSAGES(19)
            Return False 'Call ShowError(19)
        End If

        Dim objTestArticle As PageArticle
        objTestArticle = New PageArticle(Me.BlogContext)
        If objTestArticle.LoadInfoByID(objTrackback.LogID) Then
            If Not ((objTestArticle.AuthorID = CurrentUser.ID) Or (page.CheckRights("Root") = True)) Then
                errMessage = Me.Messages.ERROR_MESSAGES(6)
                Return False 'Exit Function
            End If
        Else
            errMessage = Me.Messages.ERROR_MESSAGES(9)
            Return False 'Call ShowError(9)
        End If

        If tm.Del(intId) = False Then
            Return False
        End If

        objTestArticle.Statistic()
        Me.BuildHtmlLatestTrackbacks()
        Return True

    End Function



    '*********************************************************
    ' Ŀģ    Send Trackback
    '*********************************************************
    Public Function SendTrackback(ByVal articleId As Integer, ByVal trackbackUrl As String, ByRef errMessage As String) As Boolean

        Dim objTrackback As TTrackback
        objTrackback = New TTrackback

        Dim objArticle As PageArticle
        objArticle = New PageArticle(Me.BlogContext) 'New TArticle

        If objArticle.LoadInfoByID(articleId) Then 'If objArticle.LoadInfoByID(CInt(Request.Form("edtID"))) Then
            objTrackback.Url = objArticle.Url
            objTrackback.Title = objArticle.Title
            objTrackback.Blog = BlogConfig.BlogName
            objTrackback.Excerpt = Left(objArticle.HtmlContent, 250)
        Else
            errMessage = Me.Messages.ERROR_MESSAGES(9)
            Return False 'Call ShowError(9)
        End If

        If Me.Send(trackbackUrl, objTrackback) Then 'If Me.Send(Request.Form("edtTrackback"), objTrackback) Then
            Return True 'SendTrackback = True
        End If

    End Function


    Private Sub ReturnTbXML(ByVal strMsg As String)

        Dim strXML As String

        strXML = "<?xml version=""1.0"" encoding=""UTF-8"" standalone=""yes""?><response><error>%e</error><message>%m</message></response>"

        If strMsg = "undiscovered" Then 'δӦID
            strXML = Replace(strXML, "%e", "1")
            strXML = Replace(strXML, "%m", strMsg)
        ElseIf strMsg = "repetition" Then 'ظPING
            strXML = Replace(strXML, "%e", "1")
            strXML = Replace(strXML, "%m", strMsg)
        ElseIf strMsg = "invalid parameter" Then 'Ƿ
            strXML = Replace(strXML, "%e", "1")
            strXML = Replace(strXML, "%m", strMsg)
        ElseIf strMsg = "none data" Then '
            strXML = Replace(strXML, "%e", "1")
            strXML = Replace(strXML, "%m", strMsg)
        Else 'PING ɹ
            strXML = Replace(strXML, "%e", "0")
            strXML = Replace(strXML, "%m", strMsg)
        End If

        'Response.ContentType = "text/html"
        Response.ContentType = "text/xml"
        Response.Clear()
        Response.Write(strXML)

    End Sub


    Private Function Send(ByVal strAddress As String, ByVal tb As TTrackback) As Boolean

        Dim strSendTB As String
        strSendTB = "title=" & Server.UrlEncode(tb.Title) & "&url=" & Server.UrlEncode(tb.Url) & "&excerpt=" & Server.UrlEncode(tb.Excerpt) & "&blog_name=" & Server.UrlEncode(tb.Blog)

        'Dim objPing As Object
        'objPing = Server.CreateObject("MSXML2.ServerXMLHTTP")
        'objPing.open("POST", strAddress, False)
        'objPing.setRequestHeader("Content-Type", "application/x-www-form-urlencoded")
        'objPing.Send(strSendTB)

        'Dim postData As String = "firstone" + ChrW(61) + inputData

        Dim encoding As New System.Text.ASCIIEncoding
        Dim bytes1() As Byte
        bytes1 = encoding.GetBytes(strSendTB)

        Dim wReq As WebRequest = WebRequest.Create(strAddress)
        Dim httpReq As HttpWebRequest
        If TypeOf wReq Is HttpWebRequest Then
            httpReq = CType(wReq, HttpWebRequest)
            httpReq.KeepAlive = False
            httpReq.Method = "POST"
            httpReq.ContentType = "application/x-www-form-urlencoded"
            ' Set the content length of the string being posted.
            httpReq.ContentLength = bytes1.Length 'postData.Length
            Dim newStream As System.IO.Stream = httpReq.GetRequestStream()
            newStream.Write(bytes1, 0, bytes1.Length)
            'Console.WriteLine("The value of 'ContentLength' property after sending the data is {0}", myHttpWebRequest.ContentLength)
            newStream.Close()
        End If

        'Response.ContentType = "text/xml"
        'Response.Clear
        'Response.Write objPing.responseXML.xml
        'objPing = Nothing

        Send = True

    End Function

End Class
