Option Explicit On 
Option Strict On


Public Class PageUrlManager
    Inherits PageHandlerBase


    Public Sub New(ByVal context As BlogPageContext)
        MyBase.New(context)
    End Sub

   
    Public Shared Function GetCategoryArticlesUrl(ByVal blogHost As String, ByVal cate As TCategory) As String
        Return blogHost & "Catalog.aspx?" & "cate=" & cate.ID
    End Function

    Public Function GetCategoryArticlesUrl(ByVal cate As TCategory) As String
        Return Me.Page.BlogRootUrl & "Catalog.aspx?" & "cate=" & cate.ID
    End Function

    Public Function GetCategoryArticlesUrl(ByVal intCateId As Integer, ByVal intCurrentPage As Integer) As String
        Return Me.Page.BlogRootUrl & "Catalog.aspx?cate=" & intCateId.ToString() & "&amp;page=" & intCurrentPage.ToString()
    End Function

    Public Function GetMonthArchiveUrl(ByVal dtmYearMonth As DateTime, ByVal intCurrentPage As Integer) As String
        Return Me.Page.BlogRootUrl & "Catalog.aspx?date=" & Year(dtmYearMonth) & "-" & Month(dtmYearMonth) & "&amp;page=" & intCurrentPage.ToString()
    End Function

    Public Function GetAuthorArticlesUrl(ByVal intAuthorId As Integer, ByVal intCurrentPage As Integer) As String
        Return Me.Page.BlogRootUrl & "Catalog.aspx?auth=" & intAuthorId & "&amp;page=" & intCurrentPage.ToString()
    End Function
    Public Function GetAuthorArticlesUrl(ByVal user As TUser) As String
        Return Me.Page.BlogRootUrl & "Catalog.aspx?" & "auth=" & user.ID
    End Function

    Public Function GetTagArticlesUrl(ByVal strTag As String, ByVal intCurrentPage As Integer) As String
        Return Me.Page.BlogRootUrl & "Catalog.aspx?tag=" & Server.UrlEncode(strTag) & "&amp;page=" & intCurrentPage.ToString()
    End Function

    Public Function GetTagArticlesUrl(ByVal tag As TTag) As String
        Return Me.Page.BlogRootUrl & "Catalog.aspx?" & "tags=" & Me.BlogContext.HttpContext.Server.UrlEncode(tag.Name)
    End Function

    Public Function GetDefaultPageUrl(ByVal intCurrentPage As Integer) As String
        Return Me.Page.BlogRootUrl & "Default.aspx?page=" & intCurrentPage.ToString()
    End Function


    'Public Shared Function GetArticleUrl(ByVal bloghost As String, ByVal directory As String, ByVal filetype As String, ByVal article As TArticle) As String
    '    'ʹURLдֻҪα̬URLַͿ
    '    'If Level = 2 Then
    '    'Url = ZC_BLOG_HOST & "View.aspx?id=" & ID
    '    'Else
    '    Return bloghost & directory & "/" & article.ID & "." & filetype    'Url = ZC_BLOG_HOST & ZC_STATIC_DIRECTORY & "/" & FileName & "." & ZC_STATIC_TYPE
    '    'End If
    'End Function
    'Public Function GetArticleUrl(ByVal article As TArticle) As String
    '    Return Me.Page.BlogRootUrl & BlogConfig.STATIC_DIRECTORY & "/" & article.ID & "." & BlogConfig.STATIC_TYPE
    'End Function
    'Public Function GetArticleUrl(ByVal articleId As String) As String
    '    Return Me.Page.BlogRootUrl & BlogConfig.STATIC_DIRECTORY & "/" & articleId & "." & BlogConfig.STATIC_TYPE
    'End Function

    Public Function GetArticleUrl(ByVal articleId As Integer) As String
        Return Me.Page.BlogRootUrl & BlogConfig.STATIC_DIRECTORY & "/" & articleId.ToString() & "." & BlogConfig.STATIC_TYPE
    End Function

    Public Function GetTrackbackUrl(ByVal articleId As Integer) As String
        Return Me.Page.BlogRootUrl & "Cmd.aspx?act=tb&amp;id=" & articleId
    End Function

    Public Function GetCommentUrl(ByVal articleId As Integer) As String
        Return Me.GetArticleUrl(articleId) & "#comment"
    End Function

End Class
