Option Explicit On 
Option Strict On

Imports System.Web

Public Class PageUserManager
    Inherits PageHandlerBase

    Public Sub New(ByVal context As BlogPageContext)
        MyBase.New(context)
    End Sub


    '*********************************************************
    ' Ŀģ    û½
    '*********************************************************
    Public Function Login(ByRef errMessage As String) As Boolean

        If Request.Form("edtCheckOut") <> Session("loginvalid").ToString() Then
            errMessage = "Verification Code Error!" 'Me.Messages.ZVA_ErrorMsg(8) 'Call ShowError(8)
            Return False
        End If

        Try
            If Me.Verify(CurrentUser) = False Then
                'errMessage = Me.Messages.ZVA_ErrorMsg(8) 'Call ShowError(8)
                Return False
            End If
        Catch ex As Exception
            errMessage = ex.Message
            Return False
        End Try

        Return True        'Response.Redirect(page.BlogRootUrl & "Cmd.aspx?act=admin")

    End Function

    '*********************************************************
    ' Ŀģ    û˳
    '*********************************************************
    Public Sub Logout()
        Response.Cookies("username").Value = ""
        Response.Cookies("password").Value = ""
        Response.Write("<script language=""JavaScript"" src=""" & page.BlogRootUrl & "script/common.js"" type=""text/javascript""></script>")
        Response.Write("<script language=""JavaScript"" type=""text/javascript"">")
        Response.Write("SetCookie(""username"","""","""");")
        Response.Write("SetCookie(""password"","""","""");")
        Response.Write("window.location=""" & page.BlogRootUrl & """;")
        Response.Write("</script>")
    End Sub


    '*********************************************************
    ' Ŀģ    Manager Users
    '*********************************************************
    Public Function ExportUserList(ByVal intPage As Integer) As Boolean

        If intPage <= 0 Then intPage = 1 'Call CheckParameter(intPage, "int", 1)

        If page.CheckRights("UserCrt") = True Then
            Response.Write("<form id=""edit"" method=""post"" action="""">")
            Response.Write("<p>" & Messages.MSG_ADD_NEW_USER & ": </p>")
            Response.Write("<p><a href=""../ADMIN/EditUser.aspx"">[" & Messages.MSG_NEW_USER & "]</a></p>")
            Response.Write("</form>")
        End If

        Dim isRootUser As Boolean
        isRootUser = page.CheckRights("Root")
        Dim pagesize As Integer = BlogConfig.MANAGE_COUNT
        Dim pagecount As Integer

        Dim i As Integer
        Dim strPage As String = ""

        Dim um As New UserManager
        Dim users() As TUser
        users = um.GetManagedUserList(isRootUser, Me.CurrentUser.ID, intPage, pagesize, pagecount)
        If Not IsNothing(users) Then

            Response.Write("<table border=""1"" width=""100%"" cellspacing=""1"" cellpadding=""1"">")
            Response.Write("<tr><td>" & Messages.MSG_ID & "</td><td>" & Messages.MSG_TYPE & "</td><td>" & Messages.MSG_NAME & "</td><td>" & Messages.MSG_ARTICLE_TOTAL_NUMBER & "</td><td>" & Messages.MSG_COMMENT_TOTAL_COUNT & "</td><td></td><td></td></tr>")
            For i = 0 To users.Length - 1

                Response.Write("<tr>")
                Response.Write("<td>" & users(i).ID & "</td>")
                Response.Write("<td>" & Messages.USER_ROLE_NAMES(users(i).Level) & "</td>")
                Response.Write("<td><a href=""" & page.BlogRootUrl & "Catalog.aspx?auth=" & users(i).ID & """  target=""_blank"">" & users(i).Name & "</a></td>")
                Response.Write("<td>" & users(i).Count & "</td>")
                Response.Write("<td>" & users(i).CommentCount & "</td>")
                Response.Write("<td align=""center""><a href=""../ADMIN/EditUser.aspx?id=" & users(i).ID & """>[" & Messages.MSG_EDIT & "]</a></td>")
                Response.Write("<td align=""center""><a onclick='return window.confirm(""" & Messages.MSG_OK_TO_CONTINUE_OR_CANCEL & """);' href=""" & page.BlogRootUrl & "Cmd.aspx?act=UserDel&amp;id=" & users(i).ID & """>[" & Messages.MSG_DELETE & "]</a></td>")
                Response.Write("</tr>")

            Next

            Response.Write("</table>")

        End If

        For i = 1 To pagecount
            strPage = strPage & "<a href='../ADMIN/Admin.aspx?act=UserMng&amp;page=" & i & "'>[" & Replace(Messages.MSG_PAGE_NUMBER, "%s", i.ToString()) & "]</a> "
        Next
        Response.Write("<hr/>" & Messages.MSG_PAGE & ": " & strPage)

        ExportUserList = True

    End Function

    ''*********************************************************
    '' Ŀģ    Edit User
    ''*********************************************************
    'Public Function EditUser() As Boolean

    '    Dim objUser As TUser
    '    objUser = New TUser
    '    objUser.ID = CInt(Request.Form("edtID"))
    '    objUser.Level = CInt(Request.Form("edtLevel"))
    '    objUser.Name = Request.Form("edtName")
    '    objUser.Password = Request.Form("edtPassword")
    '    objUser.Email = Request.Form("edtEmail")
    '    objUser.Homepage = Request.Form("edtHomepage")

    '    If Not ((CInt(objUser.ID) = CurrentUser.ID) Or (page.CheckRights("Root") = True)) Then Exit Function

    '    'Dim um As New UserManager'If objUser.Edit(CurrentUser) Then EditUser = True
    '    'If um.Edit(objUser, Me.CurrentUser) Then EditUser = True
    '    If Me.Edit(objUser, Me.CurrentUser) Then EditUser = True

    '    objUser = Nothing

    'End Function

    Public Function Edit(ByVal editedUser As TUser, ByVal currentUser As TUser) As Boolean

        If Not CheckRegExp(editedUser.Name, "[username]") Then
            Throw New IllegalInputException("INCORRECT User Name!")   'BusinessRuleException(ErrorMessage(7)) 'Call ShowError(7)
        End If

        If Not CheckRegExp(editedUser.Email, "[email]") Then
            Throw New IllegalInputException("INCORRECT Email!") 'BusinessRuleException(ErrorMessage(30)) 'Call ShowError(30)
        End If

        If Len(editedUser.Homepage) > 0 Then
            If Not CheckRegExp(editedUser.Homepage, "[homepage]") Then
                Throw New IllegalInputException("INCORRECT URL!") 'BusinessRuleException(ErrorMessage(30)) 'Call ShowError(30)
            End If
        End If

        If ((editedUser.Level < 1) Or (editedUser.Level > 5)) Then Throw New NotEnoughPowerException("Not Enough Power to edit User info.") 'BusinessRuleException(ErrorMessage(16)) 'Call ShowError(16)
        If (editedUser.Name = "") Then Throw New IllegalInputException("Empty User Name!") 'BusinessRuleException(ErrorMessage(7)) 'Call ShowError(7)
        If Len(editedUser.Name) > Me.BlogConfig.USERNAME_MAX Then Throw New IllegalInputException("User Name exceed length!") 'BusinessRuleException(ErrorMessage(7)) 'Call ShowError(7)
        'If Not CheckRegExp(editedUser.Name, "[username]") Then Throw New IncorrectUserNameOrPasswordException("INCORRECT User Name!") 'BusinessRuleException(ErrorMessage(7)) 'Call ShowError(7)
        'editedUser.Email = FilterSQL(editedUser.Email)
        'editedUser.HomePage = FilterSQL(editedUser.HomePage)
        'editedUser.Email = TransferHTML(editedUser.Email, "[html-format]")
        'editedUser.Homepage = TransferHTML(editedUser.Homepage, "[html-format]")
        If Len(editedUser.Email) = 0 Then Throw New IllegalInputException("INCORRECT Email!") 'BusinessRuleException(ErrorMessage(29)) 'Call ShowError(29)
        If Len(editedUser.Email) > Me.BlogConfig.EMAIL_MAX Then Throw New IllegalInputException("INCORRECT Email!") 'BusinessRuleException(ErrorMessage(29)) 'Call ShowError(29)
        If Len(editedUser.Homepage) > Me.BlogConfig.HOMEPAGE_MAX Then Throw New IllegalInputException("Homepage URL is TOO long!") 'BusinessRuleException(ErrorMessage(29)) 'ShowError(29)
        'If Not CheckRegExp(editedUser.Name, "[username]") Then Throw New IncorrectUserNameOrPasswordException("INCORRECT User Name!") 'BusinessRuleException(ErrorMessage(7)) 'Call ShowError(7)
        'If Not CheckRegExp(editedUser.Email, "[email]") Then Throw New IncorrectUrlException("INCORRECT Email!") 'BusinessRuleException(ErrorMessage(30)) 'Call ShowError(30)
        'If Len(editedUser.Homepage) > 0 Then
        'If Not CheckRegExp(editedUser.Homepage, "[homepage]") Then Throw New IncorrectUrlException("INCORRECT URL!") 'BusinessRuleException(ErrorMessage(30)) 'Call ShowError(30)
        'End If

        If editedUser.ID = 0 Then
            'If editedUser.Level <= currentUser.Level Then Throw New NotEnoughPowerException("Not Enough Power to edit User info.") 'BusinessRuleException(ErrorMessage(6)) 'ShowError(6)
            If Len(editedUser.Password) <> Me.BlogConfig.PASSWORD_MAX Then Throw New IllegalInputException("INCORRECT Password!") 'BusinessRuleException(ErrorMessage(7)) 'ShowError(7)
            'If Not CheckRegExp(editedUser.Password, "[password]") Then Throw New IncorrectUserNameOrPasswordException("INCORRECT Password!") 'ErrorMessage(7)) 'Call ShowError(7)
            If Not CheckRegExp(editedUser.Password, "[password]") Then
                Throw New IllegalInputException("INCORRECT Password!") 'ErrorMessage(7)) 'Call ShowError(7)
            End If
            'Else
            '    If (editedUser.ID = currentUser.ID) And (editedUser.Level <> currentUser.Level) Then Throw New NotEnoughPowerException("Not Enough Power to edit User info.") 'BusinessRuleException(ErrorMessage(6)) 'ShowError(6)
            '    If (editedUser.ID <> currentUser.ID) And (editedUser.Level <= currentUser.Level) Then Throw New NotEnoughPowerException("Not Enough Power to edit User info.") 'BusinessRuleException(ErrorMessage(6)) 'ShowError(6)
            '    'Dim targetUser As New TUser
            '    'If Me.LoadInfoByID(editedUser.ID, targetUser) Then 'targetUser = New TUser
            '    '    If Len(editedUser.Password) = 0 Then editedUser.Password = targetUser.Password
            '    '    If Len(editedUser.Password) <> passwordMax Then Throw New NotEnoughPowerException("INCORRECT Password!") 'BusinessRuleException(ErrorMessage(6)) 'Call ShowError(6)
            '    '    'If Not CheckRegExp(editedUser.Password, "[password]") Then Throw New IncorrectUserNameOrPasswordException("INCORRECT Password!") 'BusinessRuleException(ErrorMessage(7)) 'Call ShowError(7)
            '    'Else
            '    '    Throw New BusinessRulesException("CAN NOT Find the user's info!")
            '    '    Exit Function
            '    'End If
        End If

        Dim um As New UserManager
        'If um.Edit(editedUser, currentUser, Me.BlogConfig.USERNAME_MAX, Me.BlogConfig.PASSWORD_MAX, Me.BlogConfig.EMAIL_MAX, Me.BlogConfig.HOMEPAGE_MAX) Then
        If um.Edit(editedUser, currentUser) Then
            Edit = True
            If (editedUser.ID = currentUser.ID) Then
                Response.Redirect(page.BlogRootUrl & "Cmd.aspx?act=login")
            End If
        Else
            Edit = False
        End If

    End Function


    '*********************************************************
    ' Ŀģ    Del User
    '*********************************************************
    Function DelUser(ByVal intID As Integer, ByRef errMessage As String) As Boolean

        Dim uploads() As TUploadFile
        Dim um As New UserManager
        Try
            If um.Del(intID, CurrentUser, uploads) Then
                If Not uploads Is Nothing Then
                    For Each u As TUploadFile In uploads
                        If System.IO.File.Exists(System.IO.Path.Combine(blogPath, "upload/" & u.FileName)) Then
                            System.IO.File.Delete(System.IO.Path.Combine(blogPath, "upload/" & u.FileName))
                        End If
                    Next
                End If
                Return True
            Else
                Return False
            End If
        Catch ex1 As NotEnoughPowerException
            errMessage = Me.Messages.ERROR_MESSAGES(6) 'Me.ShowError(6)
            Return False
        Catch ex2 As DeleteUserException
            errMessage = Me.Messages.ERROR_MESSAGES(17) 'Me.ShowError(17)
            Return False
        Catch ex As Exception
            Return False
        End Try

    End Function


    '*********************************************************
    ' Ŀģ    List User Rights
    '*********************************************************
    Public Function ListUser_Rights() As Boolean

        Dim s As String
        Dim i As Integer
        Dim strAction As String
        Dim aryAction() As String

        strAction = "login|verify|logout|admin|cmt|tb|vrs|ArticleMng|ArticleEdt|ArticlePst|ArticleDel|CategoryMng|CategoryPst|CategoryDel|CommentMng|CommentDel|TrackbackMng|TrackbackDel|TrackbackSnd|UserMng|UserEdt|UserCrt|UserDel|BlogReBuild|FileReBuild|FileMng|FileUpload|FileDel|Search|BlogMng|SettingMng|SettingSav|PlugInMng|rss|Root"

        aryAction = Split(strAction, "|")

        s = Messages.ZC_MSG019

        Response.Write(Messages.MSG_NAME & ":" & CurrentUser.Name & "<br/><br/>")
        Response.Write(Messages.MSG_TYPE & ":" & Messages.USER_ROLE_NAMES(CurrentUser.Level) & "<br/><br/>")

        For i = LBound(aryAction) To UBound(aryAction)

            If Not page.CheckRights(aryAction(i)) Then s = Replace(s, "%s", ":False" & "<br/><br/>", 1, 1) Else s = Replace(s, "%s", ":True" & "<br/><br/>", 1, 1)

        Next

        Response.Write(s)
        ListUser_Rights = True

    End Function


    Public Function Verify(ByVal user As PageUser) As Boolean

        Dim strUserName As String
        Dim strPassword As String

        If user.LoginType = "Cookies" Then
            If Request.Cookies("password") Is Nothing Then
                strPassword = ""
            Else
                strPassword = Request.Cookies("password").Value
            End If
            If Request.Cookies("username") Is Nothing Then
                strUserName = ""
            Else
                strUserName = Unescape(Request.Cookies("username").Value)   'strUserName = vbsunescape(Request.Cookies("username"))
            End If

        ElseIf user.LoginType = "Form" Then
            If Request.Form("password") Is Nothing Then
                strPassword = ""
            Else
                strPassword = Request.Form("password")
            End If
            If Request.Form("username") Is Nothing Then
                strUserName = ""
            Else
                strUserName = Request.Form("username")
            End If

        ElseIf user.LoginType = "QueryString" Then
            If Request.QueryString("password") Is Nothing Then
                strPassword = ""
            Else
                strPassword = Request.QueryString("password")
            End If
            If Request.QueryString("username") Is Nothing Then
                strUserName = ""
            Else
                strUserName = Request.QueryString("username")
            End If

        ElseIf user.LoginType = "Self" Then
            strPassword = user.Password
            strUserName = user.Name
        Else
            Return False
        End If

        If (strPassword = "") Then
            Return False
        End If
        If (strUserName = "") Then
            Return False
        End If
        'strUserName = FilterSQL(strUserName)
        'strPassword = FilterSQL(strPassword)
        'If Len(strUserName) > ZC_USERNAME_MAX Then Call ShowError(7)
        'If Len(strPassword) <> ZC_PASSWORD_MAX Then Call ShowError(7)
        'If Not CheckRegExp(strUserName, "[username]") Then Call ShowError(7)
        'If Not CheckRegExp(strPassword, "[password]") Then Call ShowError(7)
        'Dim objRS As ADODB.Recordset
        'objRS = objConn.Execute("SELECT [mem_ID],[mem_Level],[mem_Password] FROM [blog_Member] WHERE [mem_Name]='" & strUserName & "'")
        'If (Not objRS.BOF) And (Not objRS.EOF) Then
        '    If StrComp(strPassword, objRS("mem_Password").Value.ToString()) = 0 Then
        '        user.ID = CInt(objRS("mem_ID").Value)
        '        LoadInfoByID(ID)
        '        Verify = True
        '    Else
        '        If user.LoginType = "Cookies" Then Response.Cookies("password").Value = ""
        '    End If
        'Else
        '    If user.LoginType = "Cookies" Then Response.Cookies("password").Value = ""
        'End If

        If Not CheckRegExp(strUserName, "[username]") Then
            Throw New IllegalInputException("Incorrect User Name!")   'Me.ErrorMessage(7)) 'Then Call ShowError(7)
        End If
        If Not CheckRegExp(strPassword, "[password]") Then
            Throw New IllegalInputException("Incorrect Password!") 'Me.ErrorMessage(7)) 'Call ShowError(7)
        End If

        Dim um As New UserManager
        If um.Verify(user, strUserName, strPassword, Me.BlogConfig.USERNAME_MAX, Me.BlogConfig.PASSWORD_MAX) Then
            Return True
        Else
            '¼ʧܣôCookie
            If user.LoginType = "Cookies" Then Response.Cookies("password").Value = ""
            Return False
        End If
        Return False
    End Function


    Public Function Register(ByVal newUser As TUser, ByVal currentUser As TUser, ByRef userNameExist As Boolean, ByRef message As String) As Boolean

        If (Len(newUser.Password) <> Me.BlogConfig.PASSWORD_MAX) Or (Not CheckRegExp(newUser.Password, "[password]")) Then

            'Throw New IllegalInputException("INCORRECT Password!")   'BusinessRuleException(ErrorMessage(7))
            message = Me.Messages.ERROR_MESSAGES(7)
            System.Diagnostics.Debug.WriteLine(message)
            Return False

        End If

        newUser.Email = Me.Server.HtmlEncode(newUser.Email)
        newUser.Homepage = Me.Server.HtmlEncode(newUser.Homepage)

        'Dim userNameExist As Boolean
        Dim um As New UserManager
        Try

            If um.Register(newUser, currentUser, userNameExist) Then

                Return True
            Else

                If (userNameExist) Then
                    System.Diagnostics.Debug.WriteLine("User Name already Exist!")
                End If

                Return False

            End If

        Catch ex As Exception

            'Response.Clear()
            'Response.Write(ex.Message)
            'Response.End()
            System.Diagnostics.Debug.WriteLine(ex.Message)
            message = ex.Message

            Return False

        End Try

        Return True

    End Function


End Class
