Option Explicit On 
Option Strict On

Public Class XmlExporter
    Inherits PageHandlerBase


    Public Sub New(ByVal context As BlogPageContext)
        MyBase.New(context)
    End Sub


    Public Function ExportRSSbyTags(ByVal TagsID As Integer) As String

        Dim Rss2Export As TRss2Export
        Rss2Export = New TRss2Export

        'With Rss2Export

        Dim tagName As String
        Rss2Export.TimeZone = BlogConfig.TimeZone
        tagName = Tags(TagsID).Name
        Rss2Export.AddChannelAttribute("title", Me.Server.HtmlEncode(BlogConfig.BlogTitle) & " - " & tagName)
        Rss2Export.AddChannelAttribute("link", Me.Server.HtmlEncode(page.BlogRootUrl))
        Rss2Export.AddChannelAttribute("description", Me.Server.HtmlEncode(BlogConfig.BlogSubTitle) & " - " & tagName)
        Rss2Export.AddChannelAttribute("generator", "Oucsoft WSBLog " & BlogConfig.BlogVERSION)
        Rss2Export.AddChannelAttribute("language", BlogConfig.BlogLanguage)
        Rss2Export.AddChannelAttribute("copyright", Me.Server.HtmlEncode(BlogConfig.BlogCOPYRIGHT))
        Rss2Export.AddChannelAttribute("pubDate", Now)

        Dim objArticle As TArticle
        Dim aryArticles() As TArticle
        Dim pageArticle As pageArticle
        Dim am As New ArticleManager
        aryArticles = am.GetTagArticles(TagsID, 3, True, False, BlogConfig.RSS2_COUNT)
        If Not aryArticles Is Nothing Then
            For Each objArticle In aryArticles
                pageArticle = New pageArticle(Me.BlogContext, objArticle)

                Rss2Export.AddItem(pageArticle.HtmlTitle, _
                    Users(pageArticle.AuthorID).Email & " (" & Users(pageArticle.AuthorID).Name & ")", _
                    pageArticle.HtmlUrl, pageArticle.PostTime, pageArticle.HtmlUrl, pageArticle.HtmlIntro, _
                    Me.Server.HtmlEncode(Categories(pageArticle.CateID).Name), pageArticle.CommentUrl, _
                    pageArticle.WfwComment, pageArticle.WfwCommentRss, pageArticle.TrackbackUrl)

            Next
        End If

        ExportRSSbyTags = Rss2Export.Xml
        Rss2Export = Nothing

    End Function

    Public Function ExportRSSbyCate(ByVal CateID As Integer) As String

        Dim Rss2Export As TRss2Export
        Rss2Export = New TRss2Export

        'With Rss2Export

        Dim cateName As String
        Dim cateIntro As String
        Rss2Export.TimeZone = BlogConfig.TimeZone


        cateName = Me.Server.HtmlEncode(Me.Categories(CateID).Name)
        cateIntro = Me.Server.HtmlEncode(Me.Categories(CateID).Intro)

        Rss2Export.AddChannelAttribute("title", Me.Server.HtmlEncode(BlogConfig.BlogTitle) & " - " & cateName)
        Rss2Export.AddChannelAttribute("link", Me.Server.HtmlEncode(page.BlogRootUrl))
        Rss2Export.AddChannelAttribute("description", Me.Server.HtmlEncode(BlogConfig.BlogSubTitle) & " - " & cateIntro)
        Rss2Export.AddChannelAttribute("generator", "Oucsoft WSBLog " & BlogConfig.BlogVERSION)
        Rss2Export.AddChannelAttribute("language", BlogConfig.BlogLanguage)
        Rss2Export.AddChannelAttribute("copyright", Me.Server.HtmlEncode(BlogConfig.BlogCOPYRIGHT))
        Rss2Export.AddChannelAttribute("pubDate", Now)

        Dim objArticle As TArticle
        Dim aryArticles() As TArticle
        Dim pageArticle As pageArticle
        Dim am As New ArticleManager
        aryArticles = am.GetCategoryArticles(CateID, 3, True, BlogConfig.RSS2_COUNT)
        If Not aryArticles Is Nothing Then
            For Each objArticle In aryArticles
                pageArticle = New pageArticle(Me.BlogContext, objArticle)

                Rss2Export.AddItem(pageArticle.HtmlTitle, _
                    Users(pageArticle.AuthorID).Email & " (" & Users(pageArticle.AuthorID).Name & ")", _
                    pageArticle.HtmlUrl, pageArticle.PostTime, pageArticle.HtmlUrl, pageArticle.HtmlIntro, _
                    Me.Server.HtmlEncode(Categories(objArticle.CateID).Name), pageArticle.CommentUrl, _
                    pageArticle.WfwComment, pageArticle.WfwCommentRss, pageArticle.TrackbackUrl)
            Next
        End If

        ExportRSSbyCate = Rss2Export.Xml
        Rss2Export = Nothing

    End Function


    Public Function ExportMutiSitemapStaticFile() As Boolean

        Dim Map2Export As TSiteMap
        Map2Export = New TSiteMap
        Map2Export.TimeZone = BlogConfig.TimeZone

        Dim objArticle As TArticle
        Dim am As ArticleManager = New ArticleManager
        Dim aryArticles() As TArticle

        aryArticles = am.GetAllArticles(3, True, -1)

        Dim f As Integer = 1 'ڼļ
        Dim r As Integer = 0 'ڼ¼
        Dim filename As String
        'Dim saved As Boolean = False

        If Not aryArticles Is Nothing And aryArticles.Length > 0 Then

            For idx As Integer = 0 To aryArticles.Length - 1

                objArticle = aryArticles(idx)

                r = r + 1

                Map2Export.AddItem((New PageUrlManager(Me.BlogContext)).GetArticleUrl(objArticle.ID), objArticle.PostTime, "weekly", "0.8")

                'ע⣬googleƣÿsitemapļ֧5ַԣÿ5¼һļ
                'ÿ5¼ߵһ¼ͱһ

                If r = 50000 Or idx = aryArticles.Length - 1 Then

                    filename = System.IO.Path.Combine(Me.BlogPath, "sitemap" & f.ToString() & ".xml")
                    Me.SaveToFile(filename, Map2Export.Xml, "utf-8")

                    If idx < aryArticles.Length - 1 Then '滹м¼
                        r = 0
                        f = f + 1
                        Map2Export = Nothing
                        Map2Export = New TSiteMap
                        Map2Export.TimeZone = BlogConfig.TimeZone

                    End If

                End If


            Next

        End If

        Map2Export = Nothing
        Return True

    End Function


    Public Function ExportStaticSitemap() As Boolean

        Dim Map2Export As TSiteMap
        Map2Export = New TSiteMap

        Map2Export.TimeZone = BlogConfig.TimeZone

        Dim i As Integer
        Dim url As String

        Dim objArticle As TArticle
        Dim am As ArticleManager = New ArticleManager
        Dim aryArticles() As TArticle

        'ע⣬googleƣÿsitemapļ֧5ַ
        aryArticles = am.GetAllArticles(3, True, 50000)

        If Not aryArticles Is Nothing And aryArticles.Length > 0 Then 'If (Not objRS.bof) And (Not objRS.eof) Then
            For Each objArticle In aryArticles 'objArticle = New TArticle
                Map2Export.AddItem((New PageUrlManager(Me.BlogContext)).GetArticleUrl(objArticle.ID), objArticle.PostTime, "weekly", "0.8")
            Next
        End If

        Map2Export.SaveToFile(System.IO.Path.Combine(BlogPath, "sitemap.xml"))

        Map2Export = Nothing
        Return True

    End Function


    '*********************************************************
    ' Ŀģ    Export RSS 2.0
    '*********************************************************
    Public Function ExportStaticRSS() As Boolean

        Dim Rss2Export As TRss2Export
        Dim objArticle As TArticle
        Rss2Export = New TRss2Export

        Rss2Export.TimeZone = BlogConfig.TimeZone

        Rss2Export.AddChannelAttribute("title", Me.Server.HtmlEncode(BlogConfig.BlogTitle))
        Rss2Export.AddChannelAttribute("link", Me.Server.HtmlEncode(page.BlogRootUrl))
        Rss2Export.AddChannelAttribute("description", Me.Server.HtmlEncode(BlogConfig.BlogSubTitle))
        Rss2Export.AddChannelAttribute("generator", "Oucsoft WSBLog " & BlogConfig.BlogVERSION)
        Rss2Export.AddChannelAttribute("language", BlogConfig.BlogLanguage)
        Rss2Export.AddChannelAttribute("copyright", Me.Server.HtmlEncode(BlogConfig.BlogCOPYRIGHT))
        Rss2Export.AddChannelAttribute("pubDate", Now)

        Dim am As ArticleManager = New ArticleManager
        Dim aryArticles() As TArticle
        aryArticles = am.GetAllArticles(3, True, BlogConfig.RSS2_COUNT)

        If Not aryArticles Is Nothing And aryArticles.Length > 0 Then 'If (Not objRS.bof) And (Not objRS.eof) Then

            For Each objArticle In aryArticles 'objArticle = New TArticle

                Dim pageArticle As pageArticle = New pageArticle(Me.BlogContext, objArticle)
                Rss2Export.AddItem(pageArticle.HtmlTitle, Users(pageArticle.AuthorID).Email & " (" & Users(pageArticle.AuthorID).Name & ")", _
                    pageArticle.HtmlUrl, pageArticle.PostTime, pageArticle.HtmlUrl, pageArticle.HtmlIntro, _
                    Me.Server.HtmlEncode(Categories(pageArticle.CateID).Name), pageArticle.CommentUrl, pageArticle.WfwComment, _
                    pageArticle.WfwCommentRss, pageArticle.TrackbackUrl)
            Next
        End If

        Rss2Export.SaveToFile(System.IO.Path.Combine(BlogPath, "rss.xml"))

        Rss2Export = Nothing

        Return True

    End Function



    '*********************************************************
    ' Ŀģ    Export ATOM 1.0
    '*********************************************************
    Public Function ExportStaticATOM() As Boolean

        Dim objArticle As TArticle
        Dim Atom10Export As TAtom10Export
        Atom10Export = New TAtom10Export

        Atom10Export.TimeZone = BlogConfig.TimeZone

        Dim AtomEntry As TAtomEntry

        Dim AtomFeed As TAtomFeed
        AtomFeed = New TAtomFeed(Atom10Export.XmlDoc)
        With AtomFeed

            .atomTitle = Me.Server.HtmlEncode(BlogConfig.BlogTitle)
            .atomSubtitle = Me.Server.HtmlEncode(BlogConfig.BlogSubTitle)
            .atomId = page.BlogRootUrl
            .atomLink("alternate", "text/html", page.BlogRootUrl)
            .atomLink("self", "application/atom+xml", page.BlogRootUrl & "atom.xml")
            '.atomPerson "author",BlogUser.Name,BlogUser.Email,BlogUser.Homepage
            .atomGenerator("Oucsoft WSBLog", "http://www.oucsoft.com/", BlogConfig.BlogVERSION)
            .atomUpdated = Now.ToString()

        End With

        Atom10Export.GetFeed(AtomFeed.Node)

        Dim i As Integer
        'Dim objRS
        'objRS = objConn.Execute("SELECT [log_ID],[log_Tag],[log_CateID],[log_Title],[log_Intro],NULL,[log_Level],[log_AuthorID],[log_PostTime],[log_CommNums],[log_ViewNums],[log_TrackbackNums],[log_Url] FROM [blog_Article] WHERE ([log_ID]>0) AND ([log_Level]>2) ORDER BY [log_PostTime] DESC")

        Dim am As ArticleManager = New ArticleManager
        Dim aryArticles() As TArticle
        aryArticles = am.GetAllArticles(3, True, BlogConfig.RSS2_COUNT)

        If Not aryArticles Is Nothing And aryArticles.Length > 0 Then 'If (Not objRS.bof) And (Not objRS.eof) Then
            'For i = 1 To BlogConfig.RSS2_COUNT
            For Each objArticle In aryArticles 'objArticle = New TArticle

                AtomEntry = New TAtomEntry(Atom10Export.XmlDoc)
                'If objArticle.LoadInfoByArray(New Object() {objRS("log_ID"), objRS("log_Tag"), objRS("log_CateID"), objRS("log_Title"), objRS("log_Intro"), Nothing, objRS("log_Level"), objRS("log_AuthorID"), objRS("log_PostTime"), objRS("log_CommNums"), objRS("log_ViewNums"), objRS("log_TrackbackNums"), objRS("log_Url")}) Then
                Dim pageArticle As pageArticle = New pageArticle(Me.BlogContext, objArticle)

                With AtomEntry
                    .atomTitle = pageArticle.HtmlTitle
                    .atomPerson("author", Users(pageArticle.AuthorID).Name, Users(pageArticle.AuthorID).Email, Users(pageArticle.AuthorID).Homepage)
                    '.atomCategory("", Categories(pageArticle.CateID).Url, Categories(pageArticle.CateID).HtmlName)
                    .atomCategory("", (New PageUrlManager(Me.BlogContext)).GetCategoryArticlesUrl(Categories(pageArticle.CateID)), Me.Server.HtmlEncode(Categories(pageArticle.CateID).Name))
                    .atomUpdated = pageArticle.PostTime.ToString()
                    .atomPublished = pageArticle.PostTime.ToString()
                    .atomSummary = pageArticle.HtmlIntro
                    .atomLink("alternate", "text/html", (New PageUrlManager(Me.BlogContext)).GetArticleUrl(objArticle.ID))
                    .atomId = (New PageUrlManager(Me.BlogContext)).GetArticleUrl(objArticle.ID)
                End With

                Atom10Export.GetEntry(AtomEntry.Node)
                'AtomEntry = Nothing
                'objArticle = Nothing
            Next
        End If

        'If (Not objRS.bof) And (Not objRS.eof) Then
        'For i = 1 To BlogConfig.RSS2_COUNT
        'objArticle = New TArticle
        'AtomEntry = New TAtomEntry
        'With AtomEntry
        '    If objArticle.LoadInfoByArray(New Object() {objRS("log_ID"), objRS("log_Tag"), objRS("log_CateID"), objRS("log_Title"), objRS("log_Intro"), Nothing, objRS("log_Level"), objRS("log_AuthorID"), objRS("log_PostTime"), objRS("log_CommNums"), objRS("log_ViewNums"), objRS("log_TrackbackNums"), objRS("log_Url")}) Then

        '        .atomTitle = objArticle.HtmlTitle
        '        .atomPerson("author", Users(objArticle.AuthorID).Name, Users(objArticle.AuthorID).Email, Users(objArticle.AuthorID).Homepage)
        '        .atomCategory("", Categories(objArticle.CateID).Url, Categories(objArticle.CateID).HtmlName)
        '        .atomUpdated = objArticle.PostTime
        '        .atomPublished = objArticle.PostTime
        '        .atomSummary = objArticle.HtmlIntro
        '        .atomLink("alternate", "text/html", objArticle.Url)
        '        .atomId = objArticle.Url
        '    End If
        'End With
        'Atom10Export.GetEntry(AtomEntry.Node)
        'AtomEntry = Nothing
        'objArticle = Nothing
        'objRS.MoveNext()
        'If objRS.eof Then Exit For
        'Next
        'End If

        'Atom10Export.Execute(Me.Response)

        Atom10Export.SaveToFile(System.IO.Path.Combine(BlogPath, "atom.xml"))

        Atom10Export = Nothing

        Return True 'ExportATOM = True

        'Response.ContentType = "text/html"
        'Response.Clear()

    End Function


    '*********************************************************
    ' Ŀģ    Export Comment RSS
    '*********************************************************
    Public Function RssComment() As String

        Dim Rss2Export As TRss2Export
        Rss2Export = New TRss2Export

        'With Rss2Export
        Dim intID As Integer
        'Call CheckParameter(intID, "int", 0)
        If Not IsNothing(Request.QueryString("id")) Then
            If IsNumeric(Request.QueryString("id")) Then intID = CInt(Request.QueryString("id"))
        Else
            intID = 1
        End If

        Dim objArticle As PageArticle = New PageArticle(Me.BlogContext)
        If objArticle.LoadInfoByID(intID) Then

            Rss2Export.TimeZone = BlogConfig.TimeZone

            Rss2Export.AddChannelAttribute("title", Me.Server.HtmlEncode(BlogConfig.BlogTitle) & "-" & objArticle.HtmlTitle)
            Rss2Export.AddChannelAttribute("link", objArticle.HtmlUrl)
            Rss2Export.AddChannelAttribute("generator", "Oucsoft WSBLog " & BlogConfig.BlogVERSION)
            Rss2Export.AddChannelAttribute("language", BlogConfig.BlogLanguage)
            Rss2Export.AddChannelAttribute("pubDate", objArticle.PostTime)

            If objArticle.CommNums > 0 Then

                Dim i As Integer
                Dim allComments() As TComment = objArticle.GetComments()
                Dim objComment As TComment
                If Not allComments Is Nothing Then
                    For Each objComment In allComments 'Do While Not objRS.eof
                        Rss2Export.AddItem("Re:" & objArticle.HtmlTitle, objComment.Email & " (" & objComment.Author & ")", _
                            objArticle.HtmlUrl & "#cmt" & objComment.ID, _
                            objComment.PostTime, objArticle.HtmlUrl & "#cmt" & objComment.ID, _
                            (New PageComment(Me.BlogContext, objComment)).HtmlContent, "", "", "", "", "")
                    Next
                End If
            End If
        End If

        Return Rss2Export.Xml

    End Function


End Class
