Option Explicit On 
Option Strict On

Imports System.Web

Public Class PageArticle
    Inherits TArticle


    Private _html As String
    Public ReadOnly Property Html() As String
        Get
            Return Me._html
        End Get
    End Property


    Public Sub New(ByVal context As BlogPageContext)

        Me._blogContext = context

        PostTime = Now()
        ID = 0
        CateID = 0
        AuthorID = 0
        Level = 4 'ĬΪͨ
        Title = Me.BlogContext.Messages.MSG_UNTITLED_ARTICLE
        IP = Request.ServerVariables("REMOTE_ADDR")

    End Sub

    Public Sub New(ByVal context As BlogPageContext, ByVal article As TArticle)

        Me._blogContext = context
        Me.CopyFrom(article)

    End Sub

    Private _blogContext As BlogPageContext
    Protected ReadOnly Property BlogContext() As BlogPageContext '= New BlogPageContext
        Get
            Return Me._blogContext
        End Get
    End Property

    Public ReadOnly Property BlogConfig() As BlogConfiguration
        Get
            Return Me.BlogContext.BlogConfig
        End Get
    End Property

    Protected ReadOnly Property UbbHtmlHandler() As IUbbHtmlHandler
        Get
            Return Me.BlogContext.UbbHtmlHandler
        End Get
    End Property

    Public Function EncodedUrl(ByVal source As String) As String
        Return Me.Server.UrlEncode(source)
    End Function

    Public ReadOnly Property Url() As String
        Get
            Return (New PageUrlManager(Me.BlogContext)).GetArticleUrl(Me.ID)
        End Get
    End Property


    Private haveTryLoadTags As Boolean = False
    Private _articleTagIds() As Integer
    Private _articleTags() As TTag

    Private Function parseTagIdsFromFieldCache() As Integer()
        Dim i As Integer
        Dim s As String
        Dim t As String
        Dim ts() As String
        Dim tagId As Integer
        Dim strId As String
        Dim arrayIds As New System.Collections.ArrayList

        If Tag Is Nothing Then
            Return Nothing
        End If

        If Tag.Trim() <> "" Then
            s = Tag
            s = s.Replace("}", "")
            ts = s.Split("{"c)
            For i = 0 To ts.Length - 1
                If ts(i).Trim() <> "" Then
                    strId = ts(i).Trim()
                    Try
                        If IsNumeric(strId) Then
                            tagId = CInt(strId)
                            arrayIds.Add(tagId)
                        End If
                    Catch
                        'do nothing
                    End Try
                End If
            Next
        End If
        Return CType(arrayIds.ToArray(GetType(Integer)), Integer())
    End Function

    Private Function tagIdsToTags(ByVal ids() As Integer) As TTag()
        If ids Is Nothing Then
            Return Nothing
        End If
        Dim arrayTags As New System.Collections.ArrayList
        For Each tagId As Integer In ids
            If Not TagsCache(tagId) Is Nothing Then
                arrayTags.Add(TagsCache(tagId)) 's = s + TagsCache(tagId).Name + ","
            End If
        Next
        Return CType(arrayTags.ToArray(GetType(TTag)), TTag())
    End Function

    Private Sub loadTags()

        If Me.BlogConfig.USE_ARTICLE_TAG_CACHE_FIELD Then
            Me._articleTagIds = Me.parseTagIdsFromFieldCache
        Else
            Me._articleTagIds = (New TagManager).GetArticleTagIds(Me.ID)
        End If

        Me._articleTags = Me.tagIdsToTags(Me._articleTagIds)
    End Sub

    Public ReadOnly Property ArticleTagIds() As Integer()
        Get
            If Not haveTryLoadTags Then
                Me.loadTags()
                haveTryLoadTags = True
            End If
            Return Me._articleTagIds
        End Get
    End Property

    Public ReadOnly Property ArticleTags() As TTag()
        Get
            If Not haveTryLoadTags Then
                Me.loadTags()
                haveTryLoadTags = True
            End If
            Return Me._articleTags
        End Get
    End Property


    Private fPageDescription As String

    <HtmlExportTemplateItem("<#PageDescription#>")> _
    Public Property PageDescription() As String
        Get
            If (Me.fPageDescription Is Nothing) Then
                Return Page.WebSiteDescription
            Else
                Return Me.fPageDescription
            End If
        End Get
        Set(ByVal Value As String)
            Me.fPageDescription = Value
        End Set
    End Property


    Private fPageKeywords As String

    <HtmlExportTemplateItem("<#PageKeywords#>")> _
    Public Property PageKeywords() As String

        Get

            'վKeywordӵҳKeywordУҪ޸
            Me.fPageKeywords = "" 'Me.Page.WebSiteKeywords

            'ΪKeywordһ
            Dim cateName As String = Me.Server.HtmlEncode(Me.Categories(CateID).Name)
            If Not cateName Is Nothing Then
                Me.fPageKeywords = cateName & " " & Me.fPageKeywords
            End If

            'tagΪKeywordһ
            Dim t() As Integer = Me.ArticleTagIds 'Me.getAllTagIDs()
            If Not t Is Nothing Then
                If t.Length > 0 Then
                    For i As Integer = LBound(t) To UBound(t)
                        If t(i) <> 0 Then
                            Dim j As Integer = CInt(t(i))
                            If Not Me.TagsCache(j) Is Nothing Then
                                Me.fPageKeywords = Me.Server.HtmlEncode(Me.TagsCache(j).Name) & " " & Me.fPageKeywords
                            End If
                        End If
                    Next
                End If
            End If

            If (Me.fPageKeywords = "") Then
                Return Page.WebSiteKeywords
            Else
                Return Me.fPageKeywords
            End If

        End Get

        Set(ByVal Value As String)
            Me.fPageKeywords = Value
        End Set

    End Property


#Region "Blog Context"


    'Private ZC_MSG099 As String = Language.ZC_MSG099
    'Private ZC_MSG043 As String = Language.ZC_MSG043
    'Private BlogPath As String
    'Private context As HttpContext
    'Dim objConn As ADODB.Connection

    Private ReadOnly Property Page() As BlogPageBase
        Get
            Return Me.BlogContext.Page
        End Get
    End Property

    'Protected context As HttpContext
    Protected ReadOnly Property BlogPath() As String
        Get
            Return Me.BlogContext.BlogPath
        End Get
    End Property

    Protected ReadOnly Property Categories() As PageCategoryCache
        Get
            Return Me.BlogContext.Categories
        End Get
    End Property

    Protected ReadOnly Property Users() As PageUserCache
        Get
            Return Me.BlogContext.Users
        End Get
    End Property

    Protected ReadOnly Property TagsCache() As PageTagCache
        Get
            Return Me.BlogContext.Tags
        End Get
    End Property


#End Region

#Region "Http Context"

    Protected ReadOnly Property Request() As HttpRequest
        Get
            Return Me.BlogContext.HttpContext.Request
        End Get
    End Property

    Protected ReadOnly Property Response() As HttpResponse
        Get
            Return Me.BlogContext.HttpContext.Response
        End Get
    End Property

    Protected ReadOnly Property Session() As System.Web.SessionState.HttpSessionState
        Get
            Return Me.BlogContext.HttpContext.Session
        End Get
    End Property

    Protected ReadOnly Property Server() As HttpServerUtility
        Get
            Return Me.BlogContext.HttpContext.Server
        End Get
    End Property


#End Region

    'Private OriginalIntro As String
    'Private OriginalContent As String
    'Private fTemplate As String
    'Private fDirectory As String


    Private _exportType As PageArticleExportTypes
    Public ReadOnly Property ExportType() As PageArticleExportTypes
        Get
            Return Me._exportType
        End Get
    End Property

    Public ReadOnly Property Template() As String
        Get
            If Me.ExportType = PageArticleExportTypes.SingleArticle Then
                Return Me.BlogContext.GlobalCache.TemplateArticle 'Return Me.BlogContext.GlobalCache.TemplateArticleSingle
            ElseIf Me.ExportType = PageArticleExportTypes.SearchArticle Then
                Return Me.BlogContext.GlobalCache.TemplateArticleMuti
            ElseIf Me.ExportType = PageArticleExportTypes.MutiArticle Then
                Return Me.BlogContext.GlobalCache.TemplateArticleMuti
            ElseIf Me.ExportType = PageArticleExportTypes.MutiArticleList Then
                Return Me.BlogContext.GlobalCache.TemplateArticleMutiList
            Else
                Return Me.BlogContext.GlobalCache.TemplateArticle
            End If
        End Get
    End Property



#Region "Property"

    Public ReadOnly Property Directory() As String
        Get
            'If IsNothing(FDirectory) Then
            Directory = Me.BlogContext.BlogConfig.STATIC_DIRECTORY
            'Else
            '    Directory = FDirectory
            'End If
        End Get
        'Set(ByVal strDirectory As String)
        '    FDirectory = strDirectory
        'End Set
    End Property

    <HtmlExportTemplateItem("<#BlogTitle#>")> _
    Public Shadows Property Title() As String
        Get
            Return MyBase.Title
        End Get
        Set(ByVal Value As String)
            MyBase.Title = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/trackback_url#>")> _
    Public ReadOnly Property TrackbackUrl() As String
        Get
            Return New PageUrlManager(Me.BlogContext).GetTrackbackUrl(ID)
        End Get
    End Property

    Public ReadOnly Property CommentUrl() As String
        Get
            Return New PageUrlManager(Me.BlogContext).GetCommentUrl(ID)
        End Get
    End Property



    'Public ReadOnly Property TrackbackUrl() As String
    '    Get
    '        TrackbackUrl = Me.BlogContext.BlogConfig.BLOG_HOST & "Cmd.aspx?act=tb&id=" & ID
    '    End Get
    'End Property


    Public ReadOnly Property WfwComment() As String
        Get
            WfwComment = Me.Page.BlogRootUrl & "xml-rpc/Comment.aspx?id=" & ID
        End Get
    End Property


    'aryTemplateTagsName(38) = "<#article/commentrss#>"
    'aryTemplateTagsValue(38) = WfwCommentRss
    <HtmlExportTemplateItem("<#article/commentrss#>")> _
    Public ReadOnly Property WfwCommentRss() As String
        Get
            WfwCommentRss = Me.Page.BlogRootUrl & "Cmd.aspx?act=rss&id=" & ID
        End Get
    End Property


    'aryTemplateTagsName(39) = "<#article/commentposturl#>"
    'aryTemplateTagsValue(39) = CommentPostUrl
    <HtmlExportTemplateItem("<#article/commentposturl#>")> _
    Public ReadOnly Property CommentPostUrl() As String
        Get
            CommentPostUrl = Me.Page.BlogRootUrl & "Cmd.aspx?act=cmt"
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/content#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property HtmlContent() As String
        Get
            'HtmlContent = Me.UbbHtmlHandler.HandleHtml(Me.UbbHtmlHandler.UbbCode(Content, "[face][link][autolink][font][code][image][typeset][media][flash][key][upload]"), "[html-japan][vbCrlf][upload]")
            Return Me.UbbHtmlHandler.HandleArticle(Content)
        End Get
    End Property

    Public ReadOnly Property HtmlTitle() As String
        Get
            'HtmlTitle = TransferHTML(Title, "[html-japan][html-format]")
            HtmlTitle = Me.Server.HtmlEncode(Title)
        End Get
    End Property

    Public ReadOnly Property HtmlIntro() As String
        Get
            'HtmlIntro = Me.UbbHtmlHandler.HandleHtml(Me.UbbHtmlHandler.UbbCode(Intro, "[face][link][autolink][font][code][image][typeset][media][flash][key][upload]"), "[html-japan][vbCrlf][upload]")
            Return Me.UbbHtmlHandler.HandleArticle(Intro)
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/intro#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property HtmlIntroExport() As String
        Get
            If Me.ExportType = PageArticleExportTypes.SearchArticle Then 'If intType = BlogConfig.DISPLAY_MODE_SEARCH Then
                Return Search(Me.Server.HtmlEncode(Intro & Content), Request.QueryString("q"))
            Else
                If Level = 2 Then
                    Return Me.BlogContext.Messages.MSG_LOGIN_TO_VIEW_HIDDEN_ARTICLE
                Else
                    Return HtmlIntro
                End If
            End If
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/url#>")> _
    Public ReadOnly Property HtmlUrl() As String
        Get
            HtmlUrl = Me.Server.HtmlEncode(Url)
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/id#>")> _
    Public Shadows Property ID() As Integer
        Get
            Return MyBase.ID
        End Get
        Set(ByVal Value As Integer)
            MyBase.ID = Value
        End Set
    End Property


    <HtmlExportTemplateItem("<#article/level#>")> _
    Public Shadows Property Level() As Integer
        Get
            Return MyBase.Level
        End Get
        Set(ByVal Value As Integer)
            MyBase.Level = Value
        End Set
    End Property


    <HtmlExportTemplateItem("<#article/title#>")> _
    Public ReadOnly Property HtmlTile() As String
        Get
            If Me.ExportType = PageArticleExportTypes.SearchArticle Then
                Return Search(Title, Request.QueryString("q"))
            Else
                Return HtmlTitle
            End If
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/posttime#>")> _
    Public Shadows Property PostTime() As DateTime
        Get
            Return MyBase.PostTime
        End Get
        Set(ByVal Value As DateTime)
            MyBase.PostTime = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/commnums#>")> _
    Public Shadows Property CommNums() As Integer
        Get
            Return MyBase.CommNums
        End Get
        Set(ByVal Value As Integer)
            MyBase.CommNums = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/viewnums#>")> _
    Public Shadows Property ViewNums() As Integer
        Get
            Return MyBase.ViewNums
        End Get
        Set(ByVal Value As Integer)
            MyBase.ViewNums = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/trackbacknums#>")> _
    Public Shadows Property TrackbackNums() As Integer
        Get
            Return MyBase.TrackbackNums
        End Get
        Set(ByVal Value As Integer)
            MyBase.TrackbackNums = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/category/id#>")> _
    Public ReadOnly Property CategoryID() As Integer
        Get
            'aryTemplateTagsValue(12) = Categories(CateID).ID.ToString()
            Return Categories(CateID).ID
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/category/name#>")> _
    Public ReadOnly Property CategoryName() As String
        Get
            'aryTemplateTagsValue(13) = GetHtmlName(Categories(CateID).Name) 'Categories(CateID).HtmlName
            Return Me.Server.HtmlEncode(Categories(CateID).Name)
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/category/order#>")> _
    Public ReadOnly Property CategoryOrder() As String
        Get
            Return Categories(CateID).Order.ToString()
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/category/count#>")> _
        Public ReadOnly Property CategoryCount() As Integer
        Get
            Return (Categories(CateID).Count)
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/category/url#>")> _
    Public ReadOnly Property CategoryUrl() As String
        Get
            'aryTemplateTagsValue(17) = PageCategory.GetHtmlUrl(Categories(CateID)) 'Categories(CateID).HtmlUrl
            'Return PageCategory.GetHtmlUrl(Categories(CateID))
            Return Me.Server.HtmlEncode((New PageUrlManager(Me.BlogContext)).GetCategoryArticlesUrl(Categories(CateID)))
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/author/id#>")> _
    Public Shadows Property AuthorID() As Integer
        Get
            'aryTemplateTagsValue(18) = Users(AuthorID).ID.ToString()
            Return MyBase.AuthorID 'Return Users(AuthorID).ID
        End Get
        Set(ByVal Value As Integer)
            MyBase.AuthorID = Value
        End Set
    End Property


    <HtmlExportTemplateItem("<#article/author/name#>")> _
    Public ReadOnly Property AuthorName() As String
        Get
            Return Users(AuthorID).Name
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/author/level#>")> _
    Public ReadOnly Property AuthorLevel() As String
        Get
            Return Me.BlogContext.Messages.USER_ROLE_NAMES(Users(AuthorID).Level)
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/author/email#>")> _
    Public ReadOnly Property AuthorEmail() As String
        Get
            Return Users(AuthorID).Email
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/author/homepage#>")> _
    Public ReadOnly Property AuthorHomepage() As String
        Get
            Return Users(AuthorID).Homepage
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/author/count#>")> _
        Public ReadOnly Property AuthorCount() As Integer
        Get
            Return Users(AuthorID).Count
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/author/url#>")> _
    Public ReadOnly Property AuthorUrl() As String
        Get
            'Return PageUser.GetHtmlUrl(Users(AuthorID))
            Return Me.Server.HtmlEncode((New PageUrlManager(Me.BlogContext)).GetAuthorArticlesUrl((Users(AuthorID))))
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/longdate#>")> _
        Public ReadOnly Property PosttimeLongdate() As String
        Get
            Return FormatDateTime(PostTime, vbLongDate)
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/shortdate#>")> _
            Public ReadOnly Property PosttimeShortdate() As String
        Get
            Return FormatDateTime(PostTime, vbShortDate)
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/longtime#>")> _
    Public ReadOnly Property PosttimeLongtime() As String
        Get
            Return FormatDateTime(PostTime, vbLongTime)
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/shorttime#>")> _
    Public ReadOnly Property PosttimeShorttime() As String
        Get
            Return FormatDateTime(PostTime, vbShortTime)
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/year#>")> _
        Public ReadOnly Property PosttimeYear() As String
        Get
            Return Year(PostTime).ToString()
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/month#>")> _
            Public ReadOnly Property PosttimeMonth() As String
        Get
            Return Month(PostTime).ToString()
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/monthname#>")> _
    Public ReadOnly Property PosttimeMonthName() As String
        Get
            Return Me.BlogContext.Messages.MONTH_ABBREVIATIONS(Month(PostTime))
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/day#>")> _
    Public ReadOnly Property PosttimeDay() As String
        Get
            Return Day(PostTime).ToString()
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/weekday#>")> _
    Public ReadOnly Property PosttimeWeekday() As String
        Get
            Return Weekday(PostTime).ToString()
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/weekdayname#>")> _
        Public ReadOnly Property PosttimeWeekdayName() As String
        Get
            Return Me.BlogContext.Messages.WEEK_DAY_ABBREVIATIONS(Weekday(PostTime))
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/hour#>")> _
    Public ReadOnly Property PosttimeHour() As String
        Get
            Return Hour(PostTime).ToString()
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/minute#>")> _
    Public ReadOnly Property PosttimeMinute() As String
        Get
            Return Minute(PostTime).ToString()
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/posttime/second#>")> _
        Public ReadOnly Property PosttimeSecond() As String
        Get
            Return Second(PostTime).ToString()
        End Get
    End Property

    <HtmlExportTemplateItem("<#file/id#>", checkbeforereplace:=True)> _
    Public ReadOnly Property QuotedFileIds() As String
        Get
            Dim i As Integer
            Dim aryIds() As String
            Dim strFileIds As String = ""
            aryIds = ArticleManager.GetQuotedFileIds(Me.Content & Me.Intro)
            For i = 0 To UBound(aryIds)
                If Not IsNothing(aryIds(i)) And Trim(aryIds(i)) <> "" Then
                    strFileIds = strFileIds & aryIds(i) & "_"
                End If
            Next
            Return strFileIds
            'Html = Replace(Html, "<#file/id#>", strFileID)
        End Get
    End Property

    <HtmlExportTemplateItem("<#template:article_commentpost#>")> _
    Public ReadOnly Property CommentPostFormExport() As String
        Get
            If Level < 4 Then Exit Property
            Dim templateCommentpost As String = Me.BlogContext.GlobalCache.TemplateArticleCommnetPost
            Dim templateCommentpostVerify As String = Me.BlogContext.GlobalCache.TemplateArticleCommentPostVerify
            templateCommentpost = Replace(templateCommentpost, "<#template:article_commentpost-verify#>", templateCommentpostVerify)
            Return templateCommentpost
        End Get
    End Property

    Private _isStaticPage As Boolean = False
    Public Property IsStaticPage() As Boolean
        Get
            Return Me._isStaticPage
        End Get
        Set(ByVal Value As Boolean)
            Me._isStaticPage = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#StaticPageCommentVerificationCodeSupport#>")> _
    Public ReadOnly Property StaticPageCommentVerificationCodeSupport() As String
        Get
            If Me.IsStaticPage Then
                Return "<script language=javascript src=""" & Me.Page.BlogRootUrl & "JSHelper.aspx?act=CommentVerify"" type=""text/javascript""></script>"
            Else
                Return ""
            End If
        End Get
    End Property

#End Region



#Region "Ƕ׵ģԪ"

    <HtmlExportTemplateItem("<#template:article_tag#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property TagsExport() As String
        Get
            Dim ts() As TTag = Me.ArticleTags
            Dim i As Integer
            Dim s As String
            Dim template As String
            Dim sbTags As New System.Text.StringBuilder
            Dim objPageTag As PageTag
            Dim objTag As TTag

            If Not ts Is Nothing AndAlso ts.Length > 0 Then
                template = Me.BlogContext.GlobalCache.TemplateArticleTag
                For Each objTag In ts
                    If (Not objTag Is Nothing) Then
                        Dim exporter As New HtmlExport(template)
                        objPageTag = New PageTag(Me.BlogContext, objTag)
                        sbTags.Append(exporter.Export(objPageTag))
                    End If
                Next
            End If

            Return sbTags.ToString()
        End Get
    End Property


    <HtmlExportTemplateItem("<#comments_file_url#>")> _
   Public ReadOnly Property CommentsFileUrl() As String
        Get
            'Return Me.BlogContext.BlogConfig.BLOG_HOST & "post/" & Me.ID.ToString() & "_comment.html"
            Return Me.Page.BlogRootUrl & "View.aspx?act=ViewComments&logid=" & Me.ID.ToString()

        End Get
    End Property


    <HtmlExportTemplateItem("<#template:article_comment#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property CommentsExport() As String
        Get
            'Ǿ̬htmlҳ棬Ҫjavascript̬װ
            If Me.ExportType = PageArticleExportTypes.SingleArticle And Me.IsStaticPage Then 'If Not BlogConfig.COMMENT_STATIC_SHOW And Me.ExportType = PageArticleExportTypes.SingleArticle Then
                Return "<span name=""CommentStr"" id=""CommentStr""><script>Comment_Initialize();</script></span>"
            End If
            ''̬
            'If CommNums = 0 Then
            '    Return "<span name=""CommentStr"" id=""CommentStr""></span>"
            'Else
            Return "<span name=""CommentStr"" id=""CommentStr"">" _
                & (New PageCommentManager(Me.BlogContext)).GetHtmlComments(Me.ID) _
                & "</span>"
            'End If
        End Get
    End Property

    <HtmlExportTemplateItem("<#template:article_trackback#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property TrackbacksExport() As String
        Get
            If TrackbackNums = 0 Then
                Return ""
            End If

            Dim count As Integer = 0
            Dim i As Integer

            Dim objTB As TTrackback
            Dim objPageTB As PageTrackback

            Dim strC As String = ""
            Dim sbTBs As New System.Text.StringBuilder

            Dim tm As New TrackbackManager
            Dim allTbs() As TTrackback = tm.GetArticleTrackbacks(ID)

            If Not IsNothing(allTbs) And allTbs.Length > 0 Then

                For i = 0 To allTbs.Length - 1
                    objTB = allTbs(i)
                    objPageTB = New PageTrackback(Me.BlogContext, objTB)
                    count = count + 1
                    objPageTB.Count = count

                    strC = Me.BlogContext.GlobalCache.TemplateArticleTrackback

                    Dim exporter As HtmlExport
                    exporter = New HtmlExport(strC)
                    sbTBs.Append(exporter.Export(objPageTB))

                Next

            End If

            Return sbTBs.ToString()

        End Get
    End Property

#End Region

#Region "һƪһƪ"

    Private haveTryGetPreviousArticle As Boolean = False
    Private _fPreviousArticle As TArticle = Nothing

    Private ReadOnly Property previousArticle() As TArticle
        Get
            If Me.haveTryGetPreviousArticle = False Then
                Dim am As New ArticleManager
                Dim objNavArticle As TArticle
                objNavArticle = am.GetPreviousArticle(Me.ID, True, True)
                Me._fPreviousArticle = objNavArticle
                Me.haveTryGetPreviousArticle = True
            End If
            Return Me._fPreviousArticle
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/nav_l/url#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property PreviousArticleUrl() As String
        Get
            If Not Me.previousArticle Is Nothing Then
                Dim strurl As String
                strurl = (New PageUrlManager(Me.BlogContext)).GetArticleUrl(Me.previousArticle.ID)   'objNavArticle.Url
                Return strurl
            Else
                Return "#"
            End If
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/nav_l/name#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property PreviousArticleName() As String
        Get
            If Not Me.previousArticle Is Nothing Then
                Return Me.previousArticle.Title
            Else
                Return ""
            End If
        End Get
    End Property

    <HtmlExportTemplateItem("<#template:article_navbar_l#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property NavbarLeft() As String
        Get
            If BlogConfig.USE_NAVIGATE_ARTICLE = False Then
                Return ""
            End If
            Dim s As String
            s = Me.BlogContext.GlobalCache.TemplateArticleNavbarL
            s = Replace(s, "<#article/nav_l/url#>", Me.PreviousArticleUrl)
            s = Replace(s, "<#article/nav_l/name#>", Me.PreviousArticleName)
            Return s
        End Get
    End Property


    Private haveTryGetNextArticle As Boolean = False
    Private _fNextArticle As TArticle = Nothing

    Private ReadOnly Property nextArticle() As TArticle
        Get
            If Me.haveTryGetNextArticle = False Then
                Dim am As New ArticleManager
                Dim objNavArticle As TArticle
                objNavArticle = am.GetNextArticle(Me.ID, True, True)
                Me._fNextArticle = objNavArticle
                Me.haveTryGetNextArticle = True
            End If
            Return Me._fNextArticle
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/nav_r/url#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property NextArticleUrl() As String
        Get
            If Not Me.nextArticle Is Nothing Then
                Dim strurl As String
                strurl = New PageUrlManager(Me.BlogContext).GetArticleUrl(Me.nextArticle.ID)   'objNavArticle.Url
                Return strurl
            Else
                Return "#"
            End If
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/nav_r/name#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property NextArticleName() As String
        Get
            If Not Me.nextArticle Is Nothing Then
                Return Me.nextArticle.Title
            Else
                Return ""
            End If
        End Get
    End Property


    <HtmlExportTemplateItem("<#template:article_navbar_r#>", CheckBeforeReplace:=True)> _
    Public ReadOnly Property NavbarRight() As String
        Get
            If BlogConfig.USE_NAVIGATE_ARTICLE = False Then
                Return ""
            End If
            Dim s As String
            s = Me.BlogContext.GlobalCache.TemplateArticleNavbarR
            s = Replace(s, "<#article/nav_l/url#>", Me.NextArticleUrl)
            s = Replace(s, "<#article/nav_l/name#>", Me.NextArticleName)
            Return s
        End Get
    End Property


#End Region

#Region "Public Method"


    Public Function GetComments() As TComment()
        Dim cm As New CommentManager
        Return cm.GetArticleComments(Me.ID, False)
    End Function

    Public Function LoadInfoByID(ByVal logID As Integer) As Boolean
        Dim am As New ArticleManager
        Return am.LoadInfoByID(logID, Me)
    End Function

    'Public Function _GetPreviousArticleID() As Integer
    '    If Me.previousArticle Is Nothing Then
    '        Return 0
    '    End If
    '    Return previousArticle.ID
    'End Function

    'Public Function _GetNextArticleID() As Integer
    '    If Me.nextArticle Is Nothing Then
    '        Return 0
    '    End If
    '    Return nextArticle.ID
    'End Function

    Public Function Del() As Boolean
        Dim am As New ArticleManager
        Return am.Del(Me.ID)
    End Function

    '********************************************************
    'ɾļ
    '********************************************************
    'Public Function DelFile() As Boolean
    '    Dim am As New ArticleManager
    '    Return am.DelFile(Me, Me.BlogPath)
    'End Function


    '*********************************************************
    'ύ
    '*********************************************************
    Public Function Post() As Boolean
        Dim am As New ArticleManager
        Return am.Post(Me, Me.BlogContext.BlogConfig.TB_EXCERPT_MAX)
    End Function


    Public Function Build() As Boolean
        Return Me.Export(PageArticleExportTypes.SingleArticle)
    End Function


    Public Function Export(ByVal exportType As PageArticleExportTypes) As Boolean

        '
        Me._exportType = exportType

        Dim exporter As New HtmlExport(Template)
        Me._html = exporter.Export(Me)

        'ʾϢ
        exporter = New HtmlExport(Me._html)
        Me._html = exporter.Export(Me.Page.Messages)

        '
        exporter = New HtmlExport(Me._html)
        Me._html = exporter.Export(Me.BlogContext.BlogConfig)

        'Ϣ
        exporter = New HtmlExport(Me._html)
        Me._html = exporter.Export(Me.BlogContext.GlobalCache)

        Return True

    End Function


    Public Function Statistic() As Boolean
        Dim am As New ArticleManager
        am.Statistic(Me.ID)
    End Function


#End Region



    Private Shared Function Search(ByVal strText As String, ByVal strQuestion As String) As String
        Return StringHelper.Search(strText, strQuestion)
    End Function

End Class


Public Enum PageArticleExportTypes
    SingleArticle
    MutiArticle
    MutiArticleList
    SearchArticle
End Enum

