Option Explicit On 
Option Strict On

Imports System.Web


Public Class PageArticleList
    Inherits PageHandlerBase


    Public Sub New(ByVal context As BlogPageContext)
        MyBase.New(context)
    End Sub


    Private _articleExportType As PageArticleExportTypes = PageArticleExportTypes.MutiArticle

    Private _pageCount As Integer

    Private _currentPage As Integer

    Private _articles() As TArticle

    Private _listType As PageArticleListTypes
    Public ReadOnly Property ListType() As PageArticleListTypes
        Get
            Return Me._listType
        End Get
    End Property

    Private _html As String
    Public ReadOnly Property Html() As String
        Get
            Return Me._html
        End Get
    End Property

    Public ReadOnly Property Template() As String
        Get
            If Me.ListType = PageArticleListTypes.DefaultPage Then 'If TemplateName.Trim().ToLower() = "default" Then
                Return Me.BlogContext.GlobalCache.TemplateDefault
            ElseIf Me.ListType = PageArticleListTypes.SearchResult Then 'ElseIf TemplateName.Trim().ToLower() = "search" Then
                Return Me.BlogContext.GlobalCache.TemplateSearch
            Else
                Return Me.BlogContext.GlobalCache.TemplateCatalog
            End If
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/id#>")> _
    Public ReadOnly Property ArticleIds() As String
        Get
            Dim s As String = ""
            If BlogConfig.VIEW_COUNT And BlogConfig.SHOW_LIST_VIEW_COUNT And Not (Me._articles Is Nothing) Then
                For Each article As TArticle In Me._articles
                    s = s & article.ID.ToString() & "_"
                Next
            End If
            Return s
        End Get
    End Property

    Private fPageDescription As String

    <HtmlExportTemplateItem("<#PageDescription#>")> _
    Public Property PageDescription() As String
        Get
            If (Me.fPageDescription Is Nothing) Then
                Return page.WebSiteDescription
            Else
                Return Me.fPageDescription
            End If
        End Get
        Set(ByVal Value As String)
            Me.fPageDescription = Value
        End Set
    End Property

    Private fPageKeywords As String
    <HtmlExportTemplateItem("<#PageKeywords#>")> _
    Public Property PageKeywords() As String
        Get
            If (Me.fPageKeywords Is Nothing) Then
                Return page.WebSiteKeywords
            Else
                Return Me.fPageKeywords
            End If
        End Get
        Set(ByVal Value As String)
            Me.fPageKeywords = Value
        End Set
    End Property


    Private _title As String = BlogConfig.BlogSubtitle
    <HtmlExportTemplateItem("<#BlogTitle#>")> _
    Public Property Title() As String
        Get
            Return Me._title
        End Get
        Set(ByVal Value As String)
            Me._title = Value
        End Set
    End Property

    Private _displayCount As Integer = Me.BlogConfig.DISPLAY_COUNT
    Public Property DisplayCount() As Integer
        Get
            Return Me._displayCount
        End Get
        Set(ByVal Value As Integer)
            Me._displayCount = Value
        End Set
    End Property

    Private _cateId As Integer
    Private _authorId As Integer
    Private _archiveDate As DateTime
    Private _tagName As String

    <HtmlExportTemplateItem("<#CACHE_INCLUDE_CALENDAR_NOW#>")> _
    Public ReadOnly Property CalendarExport() As String
        Get
            Dim s As String
            If (Me.ListType = PageArticleListTypes.MonthArchive) Then
                If Not (Me._archiveDate.Year = Now.Year And Me._archiveDate.Month = Now.Month) Then
                    s = "<script language=""JavaScript"" src=""" & page.BlogRootUrl & "JSHelper.aspx?date=" & Me._archiveDate.ToString("yyyy-MM-dd") & """ type=""text/javascript""></script>"
                End If
            End If
            If s Is Nothing OrElse s.Length = 0 Then
                s = Me.BlogContext.GlobalCache.IncludeCalendarNow
            End If
            Return s
        End Get
    End Property

    <HtmlExportTemplateItem("<#template:article-multi#>")> _
    Public ReadOnly Property ArticleList() As String
        Get
            'Html = Replace(Html, "<#template:article-multi#>", Template_Article_Multi)
            Dim sb As New System.Text.StringBuilder
            Dim objArticle As PageArticle

            If Not IsNothing(Me._articles) AndAlso Me._articles.Length > 0 Then
                For i As Integer = 0 To Me._articles.Length - 1
                    If Not IsNothing(Me._articles(i)) Then
                        objArticle = New PageArticle(Me.BlogContext, Me._articles(i))
                        If objArticle.Export(_articleExportType) = True Then
                            sb.Append(objArticle.Html) : sb.Append(vbCrLf) 'aryArticleList(i) = objArticle.Html
                        End If
                    End If
                Next
            End If
            Return sb.ToString()
        End Get
    End Property


    Private Function getPageUrl(ByVal intPage As Integer) As String
        Dim s As String = "#"
        Dim url As New PageUrlManager(Me.BlogContext)
        If Me.ListType = PageArticleListTypes.Category Then 'intCateId > 0 Then t = t & "cate=" & intCateId & "&amp;"
            s = url.GetCategoryArticlesUrl(Me._cateId, intPage)
        ElseIf Me.ListType = PageArticleListTypes.MonthArchive Then 'If Not IsNothing(dtmYearMonth) Then t = t & "date=" & Year(CDate(dtmYearMonth)) & "-" & Month(CDate(dtmYearMonth)) & "&amp;"
            s = url.GetMonthArchiveUrl(Me._archiveDate, intPage)
        ElseIf Me.ListType = PageArticleListTypes.Author Then 'If intAuthorId > 0 Then t = t & "auth=" & intAuthorId & "&amp;"
            s = url.GetAuthorArticlesUrl(Me._authorId, intPage)
        ElseIf Me.ListType = PageArticleListTypes.Tag Then 'If Not (strTagsName = "") Then t = t & "tags=" & Server.UrlEncode(strTagsName) & "&amp;"
            s = url.GetTagArticlesUrl(Me._tagName, intPage)
        Else
            s = url.GetDefaultPageUrl(intPage)
        End If
        Return s
    End Function


    <HtmlExportTemplateItem("<#template:pagebar_previous#>", checkbeforereplace:=True)> _
    Public ReadOnly Property PageBarPrevious() As String
        Get
            If Me._currentPage = 1 Then
                Return ""
            Else
                '"<a href=""" & page.BlogRootUrl & "Catalog.aspx?" & t & "page=" & intNowPage - 1 & """>" & Messages.ZC_MSG156 & "</a>"
                Dim s As String = Me.getPageUrl(Me._currentPage - 1)
                Return "<a href=""" & s & """>" & Messages.MSG_PREVIOUS_ARTICLE & "</a>"
            End If
        End Get
    End Property

    <HtmlExportTemplateItem("<#template:pagebar_next#>", checkbeforereplace:=True)> _
    Public ReadOnly Property PageBarNext() As String
        Get
            If Me._currentPage >= Me._pageCount Then
                Return ""
            Else
                'Template_PageBar_Next = "<a href=""" & page.BlogRootUrl & "Catalog.aspx?" & t & "page=" & intNowPage + 1 & """>" & Messages.ZC_MSG155 & "</a>"
                Dim s As String = Me.getPageUrl(Me._currentPage - 1)
                Return "<a href=""" & s & """>" & Messages.MSG_NEXT_ARTICLE & "</a>"
            End If
        End Get
    End Property


    <HtmlExportTemplateItem("<#template:pagebar#>", checkbeforereplace:=True)> _
    Public ReadOnly Property PageBarExport() As String
        Get

            If Me._pageCount <= 0 Then
                Return ""
            End If

            Dim i As Integer
            Dim a, b As Integer
            Dim s As String
            Dim strBarTemplate As String = Me.BlogContext.GlobalCache.TemplatePagebar
            Dim strBarItem As String
            Dim sb As New System.Text.StringBuilder

            s = Me.getPageUrl(1) 's = page.BlogRootUrl & "Catalog.aspx?" & t & "page=1"

            strBarItem = strBarTemplate
            strBarItem = Replace(strBarItem, "<#pagebar/page/url#>", s)
            strBarItem = Replace(strBarItem, "<#pagebar/page/number#>", "&lt;&lt;")
            sb.Append(strBarItem)

            If Me._pageCount > BlogConfig.PAGEBAR_COUNT Then
                a = Me._currentPage
                b = Me._currentPage + BlogConfig.PAGEBAR_COUNT
                If a > BlogConfig.PAGEBAR_COUNT Then
                    a = a - 1
                    b = b - 1
                End If
                If b > Me._pageCount Then
                    b = Me._pageCount
                    a = Me._pageCount - BlogConfig.PAGEBAR_COUNT
                End If
            Else
                a = 1
                b = Me._pageCount
            End If

            For i = a To b
                s = Me.getPageUrl(i) 'page.BlogRootUrl & "Catalog.aspx?" & t & "page=" & i
                strBarItem = strBarTemplate 'strPageBar = Me.BlogContext.GlobalCache.TemplatePagebar
                strBarItem = Replace(strBarItem, "<#pagebar/page/url#>", s)
                strBarItem = Replace(strBarItem, "<#pagebar/page/number#>", i.ToString())
                sb.Append(strBarItem)
            Next

            s = Me.getPageUrl(Me._pageCount) 's = page.BlogRootUrl & "Catalog.aspx?" & t & "page=" & intAllPage
            strBarItem = strBarTemplate 'strPageBar = Me.BlogContext.GlobalCache.TemplatePagebar
            strBarItem = Replace(strBarItem, "<#pagebar/page/url#>", s)
            strBarItem = Replace(strBarItem, "<#pagebar/page/number#>", "&gt;&gt;")
            sb.Append(strBarItem)

            Return sb.ToString()
        End Get
    End Property


    Private Function innerExport() As Boolean
        Dim exporter As HtmlExport

        exporter = New HtmlExport(Me.Template)
        Me._html = exporter.Export(Me)

        'صʾϢ
        exporter = New HtmlExport(Html)
        Me._html = exporter.Export(Me.Messages)

        '
        exporter = New HtmlExport(Html)
        Me._html = exporter.Export(Me.BlogContext.BlogConfig)

        ''
        'exporter = New HtmlExport(Html)
        'Me._html = exporter.Export(Me.BlogContext.GlobalCache)

    End Function

    Public Function BuildSearchResult(ByVal strQuestion As String) As Boolean
        Me._articleExportType = PageArticleExportTypes.SearchArticle
        Me._listType = PageArticleListTypes.SearchResult

        If Not (strQuestion Is Nothing) AndAlso strQuestion.Trim().Length > 0 Then
            strQuestion = strQuestion.Trim()
            Title = Server.HtmlEncode(strQuestion)
            Dim i As Integer
            Dim s As String
            Dim intPageCount As Integer
            Dim objArticle As PageArticle
            If Len(strQuestion) = 0 Then
                Return True
            End If
            If CheckRegExp(strQuestion, "[nojapan]") Then Exit Function
            Dim am As New ArticleManager
            Me._articles = am.SearchArticles(strQuestion, BlogConfig.SEARCH_COUNT)
        End If

        Me.innerExport()

        Return True

    End Function

    Private Function getFileNameTime(ByVal dt1 As DateTime) As String
        Return dt1.ToString("yyMMdd") & Right("0" & dt1.Hour.ToString(), 2) & Right("0" & dt1.Minute.ToString(), 2) & Right("0" & dt1.Second.ToString(), 2)
    End Function

    Public Function BuildCategoryArticles(ByVal intCateId As Integer, ByVal intPage As Integer, ByVal articleExportType As PageArticleExportTypes) As Boolean

        '黺Ƿ
        Dim blogIdx As BlogIndex = Me.BlogContext.GlobalCache.BlogIndex
        If blogIdx Is Nothing Then blogIdx = New BlogIndex 'Ϊ˷ֹIndex
        Dim cacheFile As String = System.IO.Path.Combine(Me.BlogPath, "CACHE/" & getFileNameTime(blogIdx.CreateTime) & "_category_" & intCateId.ToString() & "_page_" & intPage.ToString() & ".html")
        If (System.IO.File.Exists(cacheFile)) Then
            Me._html = Me.LoadFromFile(cacheFile, "utf-8")
            Return True
        End If

        Me._articleExportType = articleExportType
        Me._listType = PageArticleListTypes.Category
        Me._currentPage = intPage
        Me._cateId = intCateId
        Dim intPageCount As Integer = Convert.ToInt32(Math.Ceiling(blogIdx.GetCategoryArticleCount(intCateId) / Me.DisplayCount))
        Me._pageCount = intPageCount

        Title = Categories(intCateId).Name
        'ؼ
        Me.fPageKeywords = Me.Server.HtmlEncode(Categories(intCateId).Name) & " " & Me.Page.WebSiteKeywords

        Dim am As New ArticleManager
        Me._articles = am.QueryArticles(Me.DisplayCount, intPage, intCateId, 0, Nothing)

        Me.innerExport()

        Me.SaveToFile(cacheFile, Me._html, "utf-8")

        Return True
    End Function

    Public Function BuildAuthorArticles(ByVal intAuthorId As Integer, ByVal intPage As Integer, ByVal articleExportType As PageArticleExportTypes) As Boolean

        '黺Ƿ
        Dim blogIdx As BlogIndex = Me.BlogContext.GlobalCache.BlogIndex
        If blogIdx Is Nothing Then blogIdx = New BlogIndex 'Ϊ˷ֹIndex
        Dim cacheFile As String = System.IO.Path.Combine(Me.BlogPath, "CACHE/" & getFileNameTime(blogIdx.CreateTime) & "_author_" & intAuthorId.ToString() & "_page_" & intPage.ToString() & ".html")
        If (System.IO.File.Exists(cacheFile)) Then
            Me._html = Me.LoadFromFile(cacheFile, "utf-8")
            Return True
        End If

        Me._articleExportType = articleExportType
        Me._listType = PageArticleListTypes.Author
        Me._currentPage = intPage
        Me._authorId = intAuthorId
        Dim intPageCount As Integer = Convert.ToInt32(Math.Ceiling(blogIdx.GetAuthorArticleCount(intAuthorId) / Me.DisplayCount))
        Me._pageCount = intPageCount

        Title = Users(intAuthorId).Name

        Dim am As New ArticleManager
        Me._articles = am.QueryArticles(Me.DisplayCount, intPage, 0, intAuthorId, Nothing)

        Me.innerExport()

        Me.SaveToFile(cacheFile, Me._html, "utf-8")

        Return True

    End Function

    Public Function BuildTagArticles(ByVal strTagName As String, ByVal intPage As Integer, ByVal articleExportType As PageArticleExportTypes) As Boolean

        Me._articleExportType = articleExportType
        Me._listType = PageArticleListTypes.Tag
        Me._currentPage = intPage
        Dim intTagId As Integer
        If Not (strTagName Is Nothing) Then
            Dim tag As TTag = Me.Tags.GetTagInfoByName(strTagName)
            'For Each tag In Tags
            If Not (tag Is Nothing) Then
                'If UCase(tag.Name) = UCase(strTagName) Then
                intTagId = tag.ID
                'ؼ
                Me.fPageKeywords = Me.Server.HtmlEncode(tag.Name) & " " & Me.Page.WebSiteKeywords
                'End If
            End If
            'Next
            Title = strTagName
        End If
        Me._tagName = strTagName

        '黺Ƿ
        Dim blogIdx As BlogIndex = Me.BlogContext.GlobalCache.BlogIndex
        If blogIdx Is Nothing Then blogIdx = New BlogIndex 'Ϊ˷ֹIndex
        Dim cacheFile As String = System.IO.Path.Combine(Me.BlogPath, "CACHE/" & getFileNameTime(blogIdx.CreateTime) & "_tag_" & intTagId.ToString() & "_page_" & intPage.ToString() & ".html")
        If (System.IO.File.Exists(cacheFile)) Then
            Me._html = Me.LoadFromFile(cacheFile, "utf-8")
            Return True
        End If

        Dim intPageCount As Integer = Convert.ToInt32(Math.Ceiling(blogIdx.GetTagArticleCount(intTagId) / Me.DisplayCount))
        Me._pageCount = intPageCount

        Dim am As New ArticleManager
        Me._articles = am.GetTagArticles(Me.DisplayCount, intPage, intTagId) 'Me._articles = am.QueryArticles(Me.DisplayCount, intPage, 0, 0, Nothing, intTagId)

        Me.innerExport()

        Me.SaveToFile(cacheFile, Me._html, "utf-8")

        Return True
    End Function

    Public Function BuildMonthArchive(ByVal dtmYearMonth As DateTime, ByVal intPage As Integer, ByVal articleExportType As PageArticleExportTypes) As Boolean

        '黺Ƿ
        Dim blogIdx As BlogIndex = Me.BlogContext.GlobalCache.BlogIndex
        If blogIdx Is Nothing Then blogIdx = New BlogIndex 'Ϊ˷ֹIndex
        Dim cacheFile As String = System.IO.Path.Combine(Me.BlogPath, "CACHE/" & getFileNameTime(blogIdx.CreateTime) & "_month_" & dtmYearMonth.ToString("yyyyMM") & "_page_" & intPage.ToString() & ".html")
        If (System.IO.File.Exists(cacheFile)) Then
            Me._html = Me.LoadFromFile(cacheFile, "utf-8")
            Return True
        End If

        Me._articleExportType = articleExportType
        Me._listType = PageArticleListTypes.MonthArchive
        Me._currentPage = intPage
        Me._archiveDate = dtmYearMonth

        Dim intPageCount As Integer = Convert.ToInt32(Math.Ceiling(blogIdx.GetMonthArticleCount(dtmYearMonth) / Me.DisplayCount))
        Me._pageCount = intPageCount

        Title = Year(CDate(dtmYearMonth)) & " " & Messages.MONTH_NAMES(Month(CDate(dtmYearMonth)))

        Dim am As New ArticleManager
        Me._articles = am.QueryArticles(Me.DisplayCount, intPage, 0, 0, dtmYearMonth)

        Me.innerExport()

        Me.SaveToFile(cacheFile, Me._html, "utf-8")

        Return True
    End Function

    Public Function BuildDefaultPage(ByVal intPage As Integer, ByVal articleExportType As PageArticleExportTypes) As Boolean

        '黺Ƿ
        Dim blogIdx As BlogIndex = Me.BlogContext.GlobalCache.BlogIndex
        If blogIdx Is Nothing Then blogIdx = New BlogIndex 'Ϊ˷ֹIndex
        Dim cacheFile As String = System.IO.Path.Combine(Me.BlogPath, "CACHE/" & getFileNameTime(blogIdx.CreateTime) & "_default_page_" & intPage.ToString() & ".html")
        Me._currentPage = intPage
        If (System.IO.File.Exists(cacheFile)) Then
            Me._html = Me.LoadFromFile(cacheFile, "utf-8")
            Return True
        End If

        Me._articleExportType = articleExportType
        Me._listType = PageArticleListTypes.DefaultPage

        Dim intPageCount As Integer = Convert.ToInt32(Math.Ceiling(blogIdx.TotalArticleCount / Me.DisplayCount))
        Me._pageCount = intPageCount

        Dim am As New ArticleManager
        Me._articles = am.QueryArticles(Me.DisplayCount, intPage, 0, 0, Nothing)

        Me.innerExport()

        Me.SaveToFile(cacheFile, Me._html, "utf-8")

        Return True
    End Function

End Class

Public Enum PageArticleListTypes
    DefaultPage
    Category
    Author
    MonthArchive
    Tag
    SearchResult
End Enum

