Option Explicit On 
Option Strict On

Public Class PageCategory
    Inherits TCategory


    Public Sub New(ByVal context As BlogPageContext)
        Me._blogContext = context
    End Sub

    Private _blogContext As BlogPageContext
    Protected ReadOnly Property BlogContext() As BlogPageContext
        Get
            Return Me._blogContext
        End Get
    End Property


    Public ReadOnly Property Url() As String
        Get
            Url = (New PageUrlManager(Me.BlogContext)).GetCategoryArticlesUrl(Me)
        End Get
    End Property

    Public ReadOnly Property HtmlName() As String
        Get
            HtmlName = Me.BlogContext.HttpContext.Server.HtmlEncode(Name)
        End Get
    End Property


    Public ReadOnly Property HtmlUrl() As String
        Get
            HtmlUrl = Me.BlogContext.HttpContext.Server.HtmlEncode(Url)
        End Get
    End Property


End Class

