Option Explicit On 
Option Strict On

Public Class PageComment
    Inherits TComment

    Public Sub New(ByVal context As BlogPageContext)

        Me._blogContext = context

    End Sub


    Public Sub New(ByVal context As BlogPageContext, ByVal source As TComment)

        Me._blogContext = context

        Me.CopyFrom(source)

    End Sub


    Private _blogContext As BlogPageContext
    Protected ReadOnly Property BlogContext() As BlogPageContext '= New BlogPageContext
        Get
            Return Me._blogContext
        End Get
    End Property

 
    <HtmlExportTemplateItem("<#article/comment/id#>")> _
    Public Shadows Property ID() As Integer
        Get
            Return MyBase.ID
        End Get
        Set(ByVal Value As Integer)
            MyBase.ID = Value
        End Set
    End Property


    <HtmlExportTemplateItem("<#article/comment/name#>")> _
    Public Shadows Property Author() As String
        Get
            Return MyBase.Author
        End Get
        Set(ByVal Value As String)
            MyBase.Author = Value
        End Set
    End Property


    <HtmlExportTemplateItem("<#article/comment/url#>")> _
    Public Shadows Property Homepage() As String
        Get
            Return MyBase.Homepage
        End Get
        Set(ByVal Value As String)
            MyBase.Homepage = Value
        End Set
    End Property


    <HtmlExportTemplateItem("<#article/comment/email#>")> _
        Public Shadows Property Email() As String
        Get
            Return MyBase.Email
        End Get
        Set(ByVal Value As String)
            MyBase.Email = Value
        End Set
    End Property


    <HtmlExportTemplateItem("<#article/comment/posttime#>")> _
            Public Shadows Property PostTime() As DateTime
        Get
            Return MyBase.PostTime
        End Get
        Set(ByVal Value As DateTime)
            MyBase.PostTime = Value
        End Set
    End Property


    'µۼ
    Private _count As Integer

    <HtmlExportTemplateItem("<#article/comment/count#>")> _
    Public Property Count() As Integer
        Get
            Return Me._count
        End Get
        Set(ByVal Value As Integer)
            Me._count = Value
        End Set
    End Property


    <HtmlExportTemplateItem("<#article/comment/authorid#>")> _
        Public Shadows Property AuthorID() As Integer
        Get
            Return MyBase.AuthorID
        End Get
        Set(ByVal Value As Integer)
            MyBase.AuthorID = Value
        End Set
    End Property

    Public ReadOnly Property SafeEmail() As String
        Get
            SafeEmail = Replace(Email, "@", "[AT]")
        End Get
    End Property

    Public ReadOnly Property FirstContact() As String
        Get
            If Len(Homepage) > 0 Then
                FirstContact = Homepage
            Else
                FirstContact = "mailto:" & SafeEmail
            End If
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/comment/content#>")> _
    Public ReadOnly Property HtmlContent() As String
        Get
            'Return Me.BlogContext.UbbHtmlHandler.HandleHtml(Me.BlogContext.UbbHtmlHandler.UbbCode(Content, "[link][autolink][font][face]"), "[enter][nofollow]")
            Return Me.BlogContext.UbbHtmlHandler.HandleComment(Content)
        End Get
    End Property

End Class
