Option Explicit On 
Option Strict On

Public Class PageTag
    Inherits TTag

    Public Sub New(ByVal context As BlogPageContext)
        Me._blogContext = context
    End Sub

    Public Sub New(ByVal context As BlogPageContext, ByVal source As TTag)
        Me._blogContext = context
        Me.CopyFrom(source)
    End Sub

    Private _blogContext As BlogPageContext
    Protected ReadOnly Property BlogContext() As BlogPageContext
        Get
            Return Me._blogContext
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/tag/id#>")> _
    Public Shadows Property ID() As Integer
        Get
            Return MyBase.ID
        End Get
        Set(ByVal Value As Integer)
            MyBase.ID = Value
        End Set
    End Property


    <HtmlExportTemplateItem("<#article/tag/count#>")> _
    Public Shadows Property Count() As Integer
        Get
            Return MyBase.Count
        End Get
        Set(ByVal Value As Integer)
            MyBase.Count = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/tag/encodename#>")> _
        Public ReadOnly Property UrlEncodedName() As String
        Get
            Return Me.BlogContext.HttpContext.Server.UrlEncode(Name)
        End Get
    End Property

    Public ReadOnly Property Url() As String
        Get
            Return New PageUrlManager(Me.BlogContext).GetTagArticlesUrl(Me)
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/tag/url#>")> _
    Public ReadOnly Property HtmlUrl() As String
        Get
            Return Me.BlogContext.HttpContext.Server.HtmlEncode(Url)
        End Get
    End Property

    <HtmlExportTemplateItem("<#article/tag/intro#>")> _
    Public ReadOnly Property HtmlIntro() As String
        Get
            HtmlIntro = Me.BlogContext.HttpContext.Server.HtmlEncode(Intro)
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/tag/name#>")> _
    Public ReadOnly Property HtmlName() As String
        Get
            Return Me.BlogContext.HttpContext.Server.HtmlEncode(Name)
        End Get
    End Property

End Class

