Option Explicit On 
Option Strict On


Public Class PageTrackback
    Inherits TTrackback

    Public Sub New(ByVal context As BlogPageContext)

        Me._blogContext = context

    End Sub


    Public Sub New(ByVal context As BlogPageContext, ByVal source As TTrackback)

        Me._blogContext = context

        Me.CopyFrom(source)

    End Sub


    Private _blogContext As BlogPageContext
    Protected ReadOnly Property BlogContext() As BlogPageContext '= New BlogPageContext
        Get
            Return Me._blogContext
        End Get
    End Property


    <HtmlExportTemplateItem("<#article/trackback/id#>")> _
    Public Shadows Property ID() As Integer
        Get
            Return MyBase.ID
        End Get
        Set(ByVal Value As Integer)
            MyBase.ID = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/trackback/name#>")> _
    Public Shadows Property Blog() As String
        Get
            Return MyBase.Blog
        End Get
        Set(ByVal Value As String)
            MyBase.Blog = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/trackback/url#>")> _
        Public Shadows Property Url() As String
        Get
            Return MyBase.Url
        End Get
        Set(ByVal Value As String)
            MyBase.Url = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/trackback/title#>")> _
             Public Shadows Property Title() As String
        Get
            Return MyBase.Title
        End Get
        Set(ByVal Value As String)
            MyBase.Title = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/trackback/posttime#>")> _
    Public Shadows Property posttime() As DateTime
        Get
            Return MyBase.PostTime
        End Get
        Set(ByVal Value As DateTime)
            MyBase.PostTime = Value
        End Set
    End Property

    Public _count As Integer
    <HtmlExportTemplateItem("<#article/trackback/count#>")> _
    Public Property Count() As Integer
        Get
            Return Me._count
        End Get
        Set(ByVal Value As Integer)
            Me._count = Value
        End Set
    End Property

    <HtmlExportTemplateItem("<#article/trackback/content#>")> _
    Public ReadOnly Property HtmlExcerpt() As String
        Get
            Return Me.BlogContext.HttpContext.Server.HtmlEncode(Excerpt)
        End Get
    End Property

End Class
