Option Explicit On 
Option Strict On


Public Class PageUser
    Inherits TUser


    Public Sub New(ByVal context As BlogPageContext)
        Me._blogContext = context
    End Sub


    Private _blogContext As BlogPageContext
    Protected ReadOnly Property BlogContext() As BlogPageContext
        Get
            Return Me._blogContext
        End Get
    End Property

    Public ReadOnly Property Url() As String
        Get
            Url = New PageUrlManager(Me.BlogContext).GetAuthorArticlesUrl(Me)
        End Get
    End Property

    Public ReadOnly Property HtmlUrl() As String
        Get
            HtmlUrl = Me.BlogContext.HttpContext.Server.HtmlEncode(Url)
        End Get
    End Property

    Private fLoginType As String

    Public Property LoginType() As String
        Get
            If IsNothing(fLoginType) = True Then
                LoginType = "Cookies"
            Else
                LoginType = fLoginType
            End If
        End Get
        Set(ByVal strLoginType As String)
            If (strLoginType = "Form") Or (strLoginType = "QueryString") Or (strLoginType = "Self") Then
                fLoginType = strLoginType
            Else
                fLoginType = "Cookies"
            End If
        End Set
    End Property

End Class
