Option Explicit On 
Option Strict On

Public Class DateTimeHelper


    Public Shared Function IsMyDateTimeString(ByVal source As String) As Boolean
        If source Is Nothing Then Return False
        Dim parts() As String
        parts = source.Split(New Char() {"-"c, " "c, ":"c})
        Dim i As Integer
        For i = 0 To parts.Length - 1
            If Not IsNumeric(parts(i)) Then Return False
        Next
        Return True
    End Function

    'Public Shared Function GetMyDateTimeString(ByVal source As String) As String
    '    Dim strFormat As String = "yyyy-MM-dd hh:mm:ss"
    '    Return GetMyDateTime(source).ToString(strFormat)
    'End Function

    Public Shared Function GetMyDateTime(ByVal source As String) As DateTime
        Dim parts() As String
        parts = source.Split(New Char() {"-"c, " "c, ":"c})
        If (parts.Length = 1) Then
            Return New DateTime(Integer.Parse(parts(0)), 1, 1)
        ElseIf (parts.Length = 2) Then
            Return New DateTime(Integer.Parse(parts(0)), Integer.Parse(parts(1)), 1)
        ElseIf (parts.Length = 3) Then
            Return New DateTime(Integer.Parse(parts(0)), Integer.Parse(parts(1)), Integer.Parse(parts(2)))
        ElseIf (parts.Length = 4) Then
            Return New DateTime(Integer.Parse(parts(0)), Integer.Parse(parts(1)), Integer.Parse(parts(2)), Integer.Parse(parts(3)), 0, 0)
        ElseIf (parts.Length = 5) Then
            Return New DateTime(Integer.Parse(parts(0)), Integer.Parse(parts(1)), Integer.Parse(parts(2)), Integer.Parse(parts(3)), Integer.Parse(parts(4)), 0)
        ElseIf (parts.Length = 6) Then
            Return New DateTime(Integer.Parse(parts(0)), Integer.Parse(parts(1)), Integer.Parse(parts(2)), Integer.Parse(parts(3)), Integer.Parse(parts(4)), Integer.Parse(parts(5)))
        Else
            'Return ""
        End If
    End Function


    Public Shared Function ParseDateForISO8601(ByVal dtmDate As DateTime, ByVal timezone As String) As String

        Dim dtmDay, dtmWeekDay, dtmMonth, dtmYear As String
        Dim dtmHours, dtmMinutes, dtmSeconds As String
        Dim strTimeZone As String

        dtmYear = Year(dtmDate).ToString()
        dtmMonth = Right("00" & Month(dtmDate), 2)
        dtmDay = Right("00" & Day(dtmDate), 2)
        dtmHours = Right("00" & Hour(dtmDate), 2)
        dtmMinutes = Right("00" & Minute(dtmDate), 2)
        dtmSeconds = Right("00" & Second(dtmDate), 2)
        strTimeZone = Left(timezone, 3) & ":" & Right(timezone, 2)

        ParseDateForISO8601 = dtmYear & "-" & dtmMonth & "-" & dtmDay & "T" & dtmHours & ":" & dtmMinutes & ":" & dtmSeconds & strTimeZone

    End Function

    Public Shared Function ParseDateForRFC3339(ByVal dtmDate As DateTime, ByVal timezone As String) As String

        Dim dtmDay, dtmWeekDay, dtmMonth, dtmYear As String
        Dim dtmHours, dtmMinutes, dtmSeconds As String
        Dim strTimeZone As String

        dtmYear = Year(dtmDate).ToString()
        dtmMonth = Right("00" & Month(dtmDate), 2)
        dtmDay = Right("00" & Day(dtmDate), 2)
        dtmHours = Right("00" & Hour(dtmDate), 2)
        dtmMinutes = Right("00" & Minute(dtmDate), 2)
        dtmSeconds = Right("00" & Second(dtmDate), 2)
        strTimeZone = Left(timezone, 3) & ":" & Right(timezone, 2)

        ParseDateForRFC3339 = dtmYear & "-" & dtmMonth & "-" & dtmDay & "T" & dtmHours & ":" & dtmMinutes & ":" & dtmSeconds & strTimeZone

    End Function

    Public Shared Function ParseDateForRFC822(ByVal dtmDate As DateTime, ByVal timezone As String) As String

        Dim dtmDay, dtmWeekDay, dtmMonth, dtmYear As String
        Dim dtmHours, dtmMinutes, dtmSeconds As String

        Select Case Weekday(dtmDate)
            Case 1 : dtmWeekDay = "Sun"
            Case 2 : dtmWeekDay = "Mon"
            Case 3 : dtmWeekDay = "Tue"
            Case 4 : dtmWeekDay = "Wed"
            Case 5 : dtmWeekDay = "Thu"
            Case 6 : dtmWeekDay = "Fri"
            Case 7 : dtmWeekDay = "Sat"
        End Select

        Select Case Month(dtmDate)
            Case 1 : dtmMonth = "Jan"
            Case 2 : dtmMonth = "Feb"
            Case 3 : dtmMonth = "Mar"
            Case 4 : dtmMonth = "Apr"
            Case 5 : dtmMonth = "May"
            Case 6 : dtmMonth = "Jun"
            Case 7 : dtmMonth = "Jul"
            Case 8 : dtmMonth = "Aug"
            Case 9 : dtmMonth = "Sep"
            Case 10 : dtmMonth = "Oct"
            Case 11 : dtmMonth = "Nov"
            Case 12 : dtmMonth = "Dec"
        End Select

        dtmYear = Year(dtmDate).ToString
        dtmDay = Right("00" & Day(dtmDate), 2)
        dtmHours = Right("00" & Hour(dtmDate), 2)
        dtmMinutes = Right("00" & Minute(dtmDate), 2)
        dtmSeconds = Right("00" & Second(dtmDate), 2)

        ParseDateForRFC822 = dtmWeekDay & ", " & dtmDay & " " & dtmMonth & " " & dtmYear & " " & dtmHours & ":" & dtmMinutes & ":" & dtmSeconds & " " & timezone

    End Function


End Class
