Option Explicit On 
Option Strict On

Imports System.Reflection

<AttributeUsage(AttributeTargets.Field Or AttributeTargets.Property, AllowMultiple:=True, Inherited:=False)> _
Public NotInheritable Class HtmlExportTemplateItemAttribute
    Inherits Attribute

    Public Sub New(ByVal name As String)
        Me._name = name
    End Sub

    Private _name As String
    Public ReadOnly Property Name() As String
        Get
            Return Me._name
        End Get
    End Property

    Private _checkBeforeReplace As Boolean
    Public Property CheckBeforeReplace() As Boolean
        Get
            Return Me._checkBeforeReplace
        End Get
        Set(ByVal Value As Boolean)
            Me._checkBeforeReplace = Value
        End Set
    End Property

    Private _cstypeBoolean As Boolean = True
    Public Property CStyleBoolean() As Boolean
        Get
            Return Me._cstypeBoolean
        End Get
        Set(ByVal Value As Boolean)
            Me._cstypeBoolean = Value
        End Set
    End Property

End Class

Public Class HtmlExport


    Public Sub New(ByVal template As String)
        Me._template = template
    End Sub

    Private _template As String
    Public Property Template() As String
        Get
            Return Me._template
        End Get
        Set(ByVal Value As String)
            Me._template = Value
        End Set
    End Property

    Private _result As String
    Public ReadOnly Property Result() As String
        Get
            Return Me._result
        End Get
    End Property

    Public Function Export(ByVal obj As Object) As String

        Me._result = Me._template

        Dim type As type = obj.GetType()
        Dim members As New System.Collections.ArrayList

        members.AddRange(type.GetFields())
        members.AddRange(type.GetProperties())

        For Each member As MemberInfo In members

            If (member.MemberType = MemberTypes.Field Or member.MemberType = MemberTypes.Property) Then

                Dim attributes() As HtmlExportTemplateItemAttribute
                attributes = CType(attribute.GetCustomAttributes(member, GetType(HtmlExportTemplateItemAttribute)), HtmlExportTemplateItemAttribute())

                If Not attributes Is Nothing And attributes.Length > 0 Then
                    For Each attribute As HtmlExportTemplateItemAttribute In attributes

                        Dim needreplace As Boolean = False
                        If attribute.CheckBeforeReplace Then
                            If (Me._result.IndexOf(attribute.Name) >= 0) Then
                                needreplace = True
                            End If
                        Else
                            needreplace = True
                        End If

                        If (needreplace) Then
                            Dim objValue As Object
                            Dim strValue As String
                            If member.MemberType = MemberTypes.Field Then
                                objValue = CType(member, FieldInfo).GetValue(obj)
                            ElseIf member.MemberType = MemberTypes.Property Then
                                objValue = CType(member, PropertyInfo).GetValue(obj, Nothing)
                            End If

                            If objValue Is Nothing Then
                                strValue = ""
                            Else
                                strValue = objValue.ToString()
                                'booleanֵ⴦һ£
                                If objValue.GetType().Equals(GetType(Boolean)) Then
                                    If attribute.CStyleBoolean Then strValue = CStr(IIf(CBool(objValue), "true", "false"))
                                End If
                            End If
                            Me._result = Me._result.Replace(attribute.Name, strValue)
                        End If

                    Next
                End If

            End If

        Next

        Return Me._result

    End Function

End Class
