Option Explicit On 
Option Strict On

Imports System.Text


'---------------------------------------------------
'JavaScript escape and unescape equivalent
'--------------------------------------------------
Public Class JSEscapeUnescape


    Public Shared Function Escape(ByVal src As String) As String
        If src Is Nothing Then
            Return Nothing
        End If

        Dim i As Integer
        Dim j As Char
        Dim tmp As StringBuilder = New StringBuilder

        For i = 0 To src.Length - 1

            j = src.Chars(i)

            If Char.IsDigit(j) Or Char.IsLower(j) Or Char.IsUpper(j) Then
                tmp.Append(j)
            ElseIf (AscW(j) < 16 * 16) Then
                tmp.Append("%")
                If AscW(j) < 16 Then
                    tmp.Append("0")
                End If
                tmp.Append(Hex(AscW(j)))
            Else
                tmp.Append("%u")
                If (AscW(j) < 16 * 16 * 16) Then
                    tmp.Append("0")
                End If
                tmp.Append(Hex(AscW(j)))
            End If
        Next

        Return tmp.ToString()

    End Function

    Private Shared Function isHex(ByVal ch As Char) As Boolean
        If Asc(ch) >= Asc("0") And Asc(ch) <= Asc("9") Or Asc(ch) >= Asc("a") And Asc(ch) <= Asc("f") Or Asc(ch) >= Asc("A") And Asc(ch) <= Asc("F") Then
            Return True
        End If
        Return False
    End Function

    Public Shared Function Unescape(ByVal src As String) As String

        If src Is Nothing Then
            Return Nothing
        End If

        Dim sbtmp As StringBuilder = New StringBuilder
        Dim lastPos As Integer = 0
        Dim pos As Integer = 0
        Dim ch As Char
        While (lastPos < src.Length)

            pos = src.IndexOf("%", lastPos)

            If pos = lastPos Then

                If (pos + 6 <= src.Length) AndAlso (src.Chars(pos + 1) = "u"c Or src.Chars(pos + 1) = "U"c) _
                    AndAlso isHex(src.Chars(pos + 2)) AndAlso isHex(src.Chars(pos + 3)) AndAlso isHex(src.Chars(pos + 4)) AndAlso isHex(src.Chars(pos + 5)) Then

                    ch = ChrW(Integer.Parse(src.Substring(pos + 2, 4), System.Globalization.NumberStyles.AllowHexSpecifier))
                    sbtmp.Append(ch)
                    lastPos = pos + 6

                ElseIf (pos + 3 <= src.Length) AndAlso isHex(src.Chars(pos + 1)) AndAlso isHex(src.Chars(pos + 2)) Then

                    ch = ChrW(Integer.Parse(src.Substring(pos + 1, 2), System.Globalization.NumberStyles.AllowHexSpecifier))
                    sbtmp.Append(ch)
                    lastPos = pos + 3

                Else

                    sbtmp.Append(src.Substring(pos, 1)) 'Եһ%
                    lastPos = pos + 1

                End If

            Else

                If pos = -1 Then
                    sbtmp.Append(src.Substring(lastPos))
                    lastPos = src.Length()
                Else
                    sbtmp.Append(src.Substring(lastPos, pos - lastPos))
                    lastPos = pos
                End If

            End If

            'System.Diagnostics.Debug.WriteLine(sbtmp.ToString())

        End While

        Return sbtmp.ToString()

    End Function

    'Public Shared Function test() As String
    '    Dim tmp As String = "~!@#$%^&*()_+|\=-,./?><;'][{}"""
    '    System.Diagnostics.Debug.WriteLine("testing escape : " + tmp)
    '    tmp = Escape(tmp)
    '    System.Diagnostics.Debug.WriteLine(tmp)
    '    System.Diagnostics.Debug.WriteLine("testing unescape :" + tmp)
    '    System.Diagnostics.Debug.WriteLine(Unescape(tmp))
    'End Function

End Class
