Option Explicit On 
Option Strict On

Imports System.Reflection

Public Class ObjectMemberHelper

    Private Sub New()
        '
    End Sub

    Public Shared Function GetMemberValue(ByVal strMemberName As String, ByVal obj As Object) As Object

        Dim type As System.Type = obj.GetType()

        Dim members() As MemberInfo = type.GetMember(strMemberName) ', MemberTypes.Field And MemberTypes.Property, BindingFlags.Static)
        Dim memInfo As MemberInfo = members(0)
        If (memInfo.MemberType = MemberTypes.Field) Then
            Return CType(memInfo, FieldInfo).GetValue(obj)
        ElseIf (memInfo.MemberType = MemberTypes.Property) Then
            Return CType(memInfo, PropertyInfo).GetValue(obj, Nothing)
        Else
            Return Nothing
            'throw new MemberTypeException("Ա" + memberInfo.Name +"FieldProperty");
        End If

    End Function


    Public Shared Function SetMemberValue(ByVal strMemberName As String, ByVal memberValue As Object, ByVal obj As Object) As Boolean

        Dim type As System.Type = obj.GetType()

        Dim members() As MemberInfo = type.GetMember(strMemberName) ', MemberTypes.Field And MemberTypes.Property, BindingFlags.Static)

        If members Is Nothing Or members.Length = 0 Then
            Return False
        End If

        Dim memInfo As MemberInfo = members(0)
        If (memInfo.MemberType = MemberTypes.Field) Then
            Dim fi As FieldInfo = CType(memInfo, FieldInfo)
            Dim ft As System.Type = fi.FieldType
            fi.SetValue(obj, Convert.ChangeType(memberValue, ft))
        ElseIf (memInfo.MemberType = MemberTypes.Property) Then
            'CType(memInfo, PropertyInfo).SetValue(obj, memberValue, Nothing)
            Dim pi As PropertyInfo = CType(memInfo, PropertyInfo)
            Dim pt As System.Type = pi.PropertyType
            pi.SetValue(obj, Convert.ChangeType(memberValue, pt), Nothing)
        Else
            Return False 'Nothing
            'throw new MemberTypeException("Ա" + memberInfo.Name +"FieldProperty");
        End If

    End Function


End Class
