Option Explicit On 
Option Strict On

Imports System.Text.RegularExpressions

Public Class RegexUbbHtmlHandler
    Inherits UbbHtmlHandlerBase

    Public Sub New()

    End Sub


    Public Sub New(ByVal strHintMsgPlayPauseMedia As String, ByVal strHintMsgQuoteFrom As String, ByVal strHintMsgClick2Download As String)

        Me._hintMessagePlayPauseMedia = strHintMsgPlayPauseMedia
        Me._hintMessageQuoteFrom = strHintMsgQuoteFrom
        Me._hintMessageClick2Download = strHintMsgClick2Download
        'ؼ
        'Dim km As New KeywordManager
        'Me.Keywords = km.GetKeywords()

    End Sub

    'Private Shared instance As UBB = Nothing
    'Public Shared Function GetInstance() As UBB
    '    If instance Is Nothing Then
    '        SyncLock GetType(UBB)
    '            instance = New UBB
    '        End SyncLock
    '    End If
    '    Return instance
    'End Function

    '<HtmlExportTemplateItem("<#ZC_MSG103#>")> Public ZC_MSG103 As String = "/ ý"
    Private _hintMessagePlayPauseMedia As String = "Play/Pause Media"
    Public Property HintMessagePlayPauseMedia() As String
        Get
            Return Me._hintMessagePlayPauseMedia
        End Get
        Set(ByVal Value As String)
            Me._hintMessagePlayPauseMedia = Value
        End Set
    End Property

    Private _hintMessageQuoteFrom As String = "Quote From"
    Public Property HintMessageQuoteFrom() As String
        Get
            Return Me._hintMessageQuoteFrom
        End Get
        Set(ByVal Value As String)
            Me._hintMessageQuoteFrom = Value
        End Set
    End Property

    Private _hintMessageClick2Download As String = "Click To Download"
    Public Property HintMessageClick2Download() As String
        Get
            Return Me._hintMessageClick2Download
        End Get
        Set(ByVal Value As String)
            Me._hintMessageClick2Download = Value
        End Set
    End Property


    Public Overrides Function HandleComment(ByVal strContent As String) As String
        Return Me.HandleHtml(Me.UbbCode(strContent, "[font][face]"), "[enter][nofollow]")
    End Function

    Public Overrides Function HandleArticle(ByVal strContent As String) As String
        Return Me.HandleHtml(Me.UbbCode(strContent, "[face][link][autolink][font][code][image][typeset][media][flash][key][upload]"), "[html-japan][vbCrlf][upload]")
    End Function


    '*********************************************************
    ' Ŀģ    UBB
    ' 룺    
    ' 룺    
    ' أ    
    '*********************************************************
    Protected Function UbbCode(ByVal strContent As String, ByVal para As String) As String

        If strContent Is Nothing Then
            Return ""
        End If
        'Dim objRegExp As Regex
        Dim objRegExp As RegExp = New RegExp
        objRegExp.IgnoreCase = True
        'objRegExp.Global = True
        'Dim Matches As MatchCollection

        If Me.UbbLinkEnable And InStr(para, "[link]") > 0 Then 'ZC_UBB_LINK_ENABLE And InStr(strType, "[link]") > 0 Then

            objRegExp.Pattern = "(\[URL\])((http:|https:|ftp:)\/\/\S+?)(\[\/URL\])"
            strContent = objRegExp.Replace(strContent, "<a href=""$2"" target=""_blank"">$2</a>")

            objRegExp.Pattern = "(\[URL\])(.+?)(\[\/URL\])"
            strContent = objRegExp.Replace(strContent, "<a href=""http://$2"" target=""_blank"">$2</a>")

            objRegExp.Pattern = "(\[URL=)((http:|https:|ftp:)\/\/\S+?)(\])(.+?)(\[\/URL\])"
            strContent = objRegExp.Replace(strContent, "<a href=""$2"" target=""_blank"">$5</a>")

            objRegExp.Pattern = "(\[URL=)(\S+?)(\])(\S+?)(\[\/URL\])"
            strContent = objRegExp.Replace(strContent, "<a href=""http://$2"" target=""_blank"">$4</a>")

            objRegExp.Pattern = "(\[EMAIL\])(\S+\@\S+?)(\[\/EMAIL\])"
            strContent = objRegExp.Replace(strContent, "<a href=""mailto:$2"" >$2</a>")

            objRegExp.Pattern = "(\[EMAIL=)(\S+\@\S+?)(\])(.+?)(\[\/EMAIL\])"
            strContent = objRegExp.Replace(strContent, "<a href=""mailto:$2"" target=""_blank"">$4</a>")

        End If

        If Me.UbbFontEnable And InStr(para, "[font]") > 0 Then 'If ZC_UBB_FONT_ENABLE And InStr(strType, "[font]") > 0 Then

            objRegExp.Pattern = "(\[I\])([\u0000-\uffff]+?)(\[\/I\])"
            strContent = objRegExp.Replace(strContent, "<i>$2</i>")

            objRegExp.Pattern = "(\[B\])([\u0000-\uffff]+?)(\[\/B\])"
            strContent = objRegExp.Replace(strContent, "<b>$2</b>")

            objRegExp.Pattern = "(\[U\])([\u0000-\uffff]+?)(\[\/U\])"
            strContent = objRegExp.Replace(strContent, "<u>$2</u>")

            objRegExp.Pattern = "(\[S\])([\u0000-\uffff]+?)(\[\/S\])"
            strContent = objRegExp.Replace(strContent, "<s>$2</s>")

            objRegExp.Pattern = "(\[QUOTE\])([\u0000-\uffff]+?)(\[\/QUOTE\])"
            strContent = objRegExp.Replace(strContent, "<div class=""quote""'>$2" & vbCrLf & "</div>")

            objRegExp.Pattern = "(\[QUOTE=)(.+?)(\])([\u0000-\uffff]+?)(\[\/QUOTE\])"
            strContent = objRegExp.Replace(strContent, "<div class=""quote quote2""><div class=""quote-title"">" & HintMessageQuoteFrom & " $2</div>$4" & vbCrLf & "</div>")

        End If


        If Me.UbbCodeEnable And InStr(para, "[code]") > 0 Then
            Dim strCode As String
            Dim amatch As Match
            Dim matches As MatchCollection

            strContent = Replace(strContent, vbLf, "")

            '[CODELITE]
            objRegExp.Pattern = "(\[CODE_LITE\])(.+?)(\[\/CODE_LITE\])"
            Matches = objRegExp.Execute(strContent)

            For Each amatch In matches

                strCode = amatch.Value
                strCode = HandleHtml(strCode, "[<][>][space][vbTab]")
                strCode = Replace(strCode, vbCr, "<br/>")

                'strContent = Replace(strContent, amatch.Value, strCode)
                'objRegExp.Global = False
                'objRegExp.Pattern = "(\[CODE_LITE\](<br\/>)?)(.+?)(\[\/CODE_LITE\])"
                'strContent = objRegExp.Replace(strContent, "<p class=""code"">$3</p>")
                'objRegExp.Global = True

                objRegExp.Pattern = "(\[CODE_LITE\](<br\/>)?)(.+?)(\[\/CODE_LITE\])"
                strCode = objRegExp.Replace(strCode, "<p class=""code"">$3</p>")
                strContent = Replace(strContent, amatch.Value, strCode)

            Next
            matches = Nothing

            '[CODE]
            objRegExp.Pattern = "(\[CODE\])(.+?)(\[\/CODE\])"
            matches = objRegExp.Execute(strContent)

            For Each amatch In matches

                strCode = amatch.Value
                strCode = HandleHtml(strCode, "[<][>][space][vbTab]")
                strCode = Replace(strCode, vbCr, Chr(8) & Chr(11) & Chr(9) & Chr(12))

                'strContent = Replace(strContent, amatch.Value, strCode)
                'objRegExp.Global = False
                'objRegExp.Pattern = "(\[CODE\])(.+?)(\[\/CODE\])"
                'strContent = objRegExp.Replace(strContent, "<textarea class=""code"" rows=""10"" cols=""50"">$2</textarea>")
                'objRegExp.Global = True

                objRegExp.Pattern = "(\[CODE\])(.+?)(\[\/CODE\])"
                strCode = objRegExp.Replace(strCode, "<textarea class=""code"" rows=""10"" cols=""50"">$2</textarea>")
                strContent = Replace(strContent, amatch.Value, strCode)

            Next
            matches = Nothing

            strContent = Replace(strContent, vbCr, vbCrLf)
            strContent = Replace(strContent, Chr(8) & Chr(11) & Chr(9) & Chr(12), vbCr)

        End If

        If Me.UbbEmotionFaceEnable And InStr(para, "[face]") > 0 Then        'If ZC_UBB_FACE_ENABLE And InStr(strType, "[face]") > 0 Then

            objRegExp.Pattern = "(\[F\])(.+?)(\[\/F\])"
            strContent = objRegExp.Replace(strContent, "<img src=""" & Me.AbsoluteWebSiteUrl & "image/face/$2.gif"" style=""padding:2px;border:0;"" height=""" & Me.UbbEmotionFaceSize & """ width=""" & Me.UbbEmotionFaceSize & """ title=""$2"" alt=""$2"" />")
        End If

        'If ZC_UBB_UPLOAD_ENABLE And InStr(strType, "[upload]") > 0 Then
        If Me.UbbUploadEnable And InStr(para, "[upload]") > 0 Then
            objRegExp.Pattern = "(?:\[UPLOAD=)([0-9]+)(?:\])"
            strContent = objRegExp.Replace(strContent, "<a href=""" & Me.AbsoluteWebSiteUrl & "Down.aspx?id=$1"" target=""_blank"">" & HintMessageClick2Download & "</a>")

        End If

        'If ZC_UBB_IMAGE_ENABLE And InStr(strType, "[image]") > 0 Then
        If Me.UbbImageEnable And InStr(para, "[image]") > 0 Then '[img]

            objRegExp.Pattern = "(\[IMG=)([0-9]*),([0-9]*),([^\n\[]*)(\])(.+?)(\[\/IMG\])"
            strContent = objRegExp.Replace(strContent, "<img src=""$6"" alt=""$4"" title=""$4"" width=""$2"" height=""$3"" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")
            'strContent = objRegExp.Replace(strContent, "<img src=""$6"" alt=""$4"" title=""$4"" width=""$2"" height=""$3"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

            objRegExp.Pattern = "(\[IMG=)([0-9]*),([^\n\[]*)(\])(.+?)(\[\/IMG\])"
            strContent = objRegExp.Replace(strContent, "<img src=""$5"" alt=""$3"" title=""$3"" width=""$2"" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")
            'strContent = objRegExp.Replace(strContent, "<img src=""$5"" alt=""$3"" title=""$3"" width=""$2"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

            objRegExp.Pattern = "(\[IMG=)([0-9]*)(\])(.+?)(\[\/IMG\])"
            strContent = objRegExp.Replace(strContent, "<img src=""$4"" alt="""" title="""" width=""$2"" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")
            'strContent = objRegExp.Replace(strContent, "<img src=""$4"" alt="""" title="""" width=""$2"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

            objRegExp.Pattern = "(\[IMG\])(.+?)(\[\/IMG\])"
            strContent = objRegExp.Replace(strContent, "<img src=""$2"" alt="""" title="""" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")
            'strContent = objRegExp.Replace(strContent, "<img src=""$2"" alt="""" title="""" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

            objRegExp.Pattern = "(\[IMG_LEFT=)([0-9]*),([0-9]*),([^\n\[]*)(\])(.+?)(\[\/IMG_LEFT\])"
            strContent = objRegExp.Replace(strContent, "<img class=""float-left"" style=""float:left"" src=""$6"" alt=""$4"" title=""$4"" width=""$2"" height=""$3"" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

            objRegExp.Pattern = "(\[IMG_LEFT=)([0-9]*),([^\n\[]*)(\])(.+?)(\[\/IMG_LEFT\])"
            strContent = objRegExp.Replace(strContent, "<img class=""float-left"" style=""float:left"" src=""$5"" alt=""$3"" title=""$3"" width=""$2"" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

            objRegExp.Pattern = "(\[IMG_LEFT=)([0-9]*)(\])(.+?)(\[\/IMG_LEFT\])"
            strContent = objRegExp.Replace(strContent, "<img class=""float-left"" style=""float:left"" src=""$4"" alt="""" title="""" width=""$2"" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

            objRegExp.Pattern = "(\[IMG_LEFT\])(.+?)(\[\/IMG_LEFT\])"
            strContent = objRegExp.Replace(strContent, "<img class=""float-left"" style=""float:left"" src=""$2"" alt="""" title="""" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")


            objRegExp.Pattern = "(\[IMG_RIGHT=)([0-9]*),([0-9]*),(.*)(\])(.+?)(\[\/IMG_RIGHT\])"
            strContent = objRegExp.Replace(strContent, "<img class=""float-right"" style=""float:right"" src=""$6"" alt=""$4"" title=""$4"" width=""$2"" height=""$3"" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

            objRegExp.Pattern = "(\[IMG_RIGHT=)([0-9]*),(.*)(\])(.+?)(\[\/IMG_RIGHT\])"
            strContent = objRegExp.Replace(strContent, "<img class=""float-right"" style=""float:right"" src=""$5"" alt=""$3"" title=""$3"" width=""$2"" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

            objRegExp.Pattern = "(\[IMG_RIGHT=)([0-9]*)(\])(.+?)(\[\/IMG_RIGHT\])"
            strContent = objRegExp.Replace(strContent, "<img class=""float-right"" style=""float:right"" src=""$4"" alt="""" title="""" width=""$2"" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

            objRegExp.Pattern = "(\[IMG_RIGHT\])(.+?)(\[\/IMG_RIGHT\])"
            strContent = objRegExp.Replace(strContent, "<img class=""float-right"" style=""float:right"" src=""$2"" alt="""" title="""" onload=""resizeimg(this);"" onmouseover=""overimg(this);"" onmouseout=""outimg(this);""  onclick=""openimg(this);""/>")

        End If

        'If ZC_UBB_FLASH_ENABLE And InStr(strType, "[flash]") > 0 Then
        If Me.UbbFlashEnable And InStr(para, "[flash]") > 0 Then '[flash]

            objRegExp.Pattern = "(\[FLASH=)([0-9]*),([0-9]*),([a-zA-Z]*)(\])(.+?)(\[\/FLASH\])"
            strContent = objRegExp.Replace(strContent, "<object classid=""clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"" codebase=""http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0"" width=""$2"" height=""$3""><param name=""movie"" value=""$6""><param name=""quality"" value=""high""><param name=""play"" value=""$4""><embed src=""$6"" quality=""high"" pluginspage=""http://www.macromedia.com/go/getflashplayer"" type=""application/x-shockwave-flash"" width=""$2"" height=""$3"" play=""$4""></embed></object>")

        End If

        'If ZC_UBB_TYPESET_ENABLE And InStr(strType, "[typeset]") > 0 Then
        If Me.UbbTypesetEnable And InStr(para, "[typeset]") > 0 Then

            objRegExp.Pattern = "(\[ALIGN-CENTER\])([\u0000-\uffff]+?)(\[\/ALIGN-CENTER\])"
            strContent = objRegExp.Replace(strContent, "<div style=""margin:10px 0 10px 0;text-align:center;"">$2</div>")

            objRegExp.Pattern = "(\[ALIGN-LELT\])([\u0000-\uffff]+?)(\[\/ALIGN-LELT\])"
            strContent = objRegExp.Replace(strContent, "<div style=""margin:10px 0 10px 0;text-align:left;"">$2</div>")

            objRegExp.Pattern = "(\[ALIGN-RIGHT\])([\u0000-\uffff]+?)(\[\/ALIGN-RIGHT\])"
            strContent = objRegExp.Replace(strContent, "<div style=""margin:10px 0 10px 0;text-align:right;"">$2</div>")

            objRegExp.Pattern = "(\[HR\])([\u0000-\uffff]?)(\[\/HR\])"
            strContent = objRegExp.Replace(strContent, "<hr/>")

            objRegExp.Pattern = "(\[FONT-FACE=)([a-zA-Z\x20]*)(\])([\u0000-\uffff]+?)(\[\/FONT-FACE\])"
            strContent = objRegExp.Replace(strContent, "<font face=""$2"">$4</font>")

            objRegExp.Pattern = "(\[FONT-SIZE=)([1-7]*)(\])([\u0000-\uffff]+?)(\[\/FONT-SIZE\])"
            strContent = objRegExp.Replace(strContent, "<font size=""$2"">$4</font>")

            objRegExp.Pattern = "(\[FONT-COLOR=)([#0-9a-zA-Z]*)(\])([\u0000-\uffff]+?)(\[\/FONT-COLOR\])"
            strContent = objRegExp.Replace(strContent, "<font color=""$2"">$4</font>")

        End If

        'If ZC_UBB_MEDIA_ENABLE And InStr(strType, "[media]") > 0 Then
        If Me.UbbMediaEnable And InStr(para, "[media]") > 0 Then
            '[WMA]
            objRegExp.Pattern = "(\[WMA=)([a-zA-Z]*)(\])(.+?)(\[\/WMA\])"
            strContent = objRegExp.Replace(strContent, "<object classid=""clsid:22D6F312-B0F6-11D0-94AB-0080C74C7E95"" height=""45"" width=""350""><param name=""ShowStatusBar"" value=""-1""><param name=""AutoStart"" value=""$2""><param name=""Filename"" value=""$4""><embed type=""application/x-mplayer2"" pluginspage=""http://www.microsoft.com/Windows/MediaPlayer/"" src=""$4"" autostart=""true"" width=""350"" height=""45""></embed></object>")

            '[WMV]
            objRegExp.Pattern = "(\[WMV=)([0-9]*),([0-9]*),([a-zA-Z]*)(\])(.+?)(\[\/WMV\])"
            strContent = objRegExp.Replace(strContent, "<object classid=""clsid:22D6F312-B0F6-11D0-94AB-0080C74C7E95""  width=""$2"" height=""$3""><param name=""ShowStatusBar"" value=""-1""><param name=""AutoStart"" value=""$4""><param name=""Filename"" value=""$6""><embed type=""application/x-mplayer2"" pluginspage=""http://www.microsoft.com/Windows/MediaPlayer/"" src=""$6"" autostart=""$4""></embed></object>")

            '[RMV]
            objRegExp.Pattern = "(\[RM=)([0-9]*),([0-9]*),([a-zA-Z]*)(\])(.+?)(\[\/RM\])"
            strContent = objRegExp.Replace(strContent, "<object classid=""clsid:CFCDAA03-8BE4-11CF-B84B-0020AFBBCCFA"" width=""$2"" height=""$3""><param name=""src"" value=""$6""><param name=""controls"" value=""imagewindow""><param name=""console"" value=""one""><param name=""AutoStart"" value=""$4""><embed src=""$6"" type=""audio/x-pn-realaudio-plugin"" width=""$2"" height=""$3"" nojava=""true"" controls=""imagewindow,ControlPanel,StatusBar"" console=""one"" autostart=""$4""></object>")

            '[RA]
            objRegExp.Pattern = "(\[RA=)([a-zA-Z]*)(\])(.+?)(\[\/RA\])"
            strContent = objRegExp.Replace(strContent, "<object classid=""clsid:CFCDAA03-8BE4-11CF-B84B-0020AFBBCCFA"" width=""350"" height=""36""><param name=""src"" value=""$4""><param name=""controls"" value=""ControlPanel""><param name=""console"" value=""one""><param name=""AutoStart"" value=""$2""><embed src=""$4"" type=""audio/x-pn-realaudio-plugin"" nojava=""true"" controls=""ControlPanel,StatusBar"" console=""one"" autostart=""$2"" width=""350"" height=""36""></object>")

            '[QT]
            objRegExp.Pattern = "(\[QT=)([0-9]*),([0-9]*),([a-zA-Z]*)(\])(.+?)(\[\/QT\])"
            strContent = objRegExp.Replace(strContent, "<object classid=""clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B"" codebase=""http://www.apple.com/qtactivex/qtplugin.cab"" width=""$2"" height=""$3"" ><param name=""src"" value=""$6"" ><param name=""autoplay"" value=""$4"" ><embed  src=""qtmimetype.pntg"" type=""image/x-macpaint"" pluginspage=""http://www.apple.com/quicktime/download"" qtsrc=""$6"" width=""$2"" height=""$3"" autoplay=""$4"" ></embed></object>")

            '[MEDIA]
            objRegExp.Pattern = "(\[MEDIA=)([a-zA-Z]*),([0-9]*),([0-9]*)(\])(.+?)(\[\/MEDIA\])"
            strContent = objRegExp.Replace(strContent, "<div class=""media""><a href="""" onclick=""javascript:ShowMedia(this.nextSibling,'$6','$2',$3,$4);return(false);"">" & HintMessagePlayPauseMedia & "</a><div class=""media-object""></div></div>")

            objRegExp.Pattern = "(\[MEDIA=)([0-9]*),([0-9]*)(\])(.+?)(\[\/MEDIA\])"
            strContent = objRegExp.Replace(strContent, "<div class=""media""><a href="""" onclick=""javascript:ShowMedia(this.nextSibling,'$5','AUTO',$2,$3);return(false);"">" & HintMessagePlayPauseMedia & "</a><div class=""media-object""></div></div>")

            objRegExp.Pattern = "(\[MEDIA\])(.+?)(\[\/MEDIA\])"
            strContent = objRegExp.Replace(strContent, "<div class=""media""><a href="""" onclick=""javascript:ShowMedia(this.nextSibling,'$2','AUTO',400,300);return(false);"">" & HintMessagePlayPauseMedia & "</a><div class=""media-object""></div></div>")

        End If

        'If ZC_UBB_AUTOLINK_ENABLE And InStr(strType, "[autolink]") > 0 Then
        If Me.UbbAutoLinkEnable And InStr(para, "[autolink]") > 0 Then

            objRegExp.Pattern = "(^|\r\n|\n)((http|https|ftp|mailto|gopher|news|telnet|mms|rtsp|ed2k|tencent|nfcall|dic|pig2pig|callto|exeem|ymsgr|thunder|p4p|pplive|synacast|ppstream|feed|wangwang|qqtv|rssfeed|msnim|chrome|file|ppg):{1}\/{0,2}[^<>\f\n\r\t\v]+?)(\r\n|\n|$)"
            strContent = objRegExp.Replace(strContent, vbCrLf & "<a href=""$2""  target=""_blank"">$2</a>" & vbCrLf)

            objRegExp.Pattern = "(^|\r\n|\n)((http|https|ftp|mailto|gopher|news|telnet|mms|rtsp|ed2k|tencent|nfcall|dic|pig2pig|callto|exeem|ymsgr|thunder|p4p|pplive|synacast|ppstream|feed|wangwang|qqtv|rssfeed|msnim|chrome|file|ppg):{1}\/{0,2}[^<>\f\n\r\t\v]+?)(\r\n|\n|$)"
            strContent = objRegExp.Replace(strContent, vbCrLf & "<a href=""$2""  target=""_blank"">$2</a>" & vbCrLf)

        End If

        'If ZC_UBB_AUTOKEY_ENABLE And InStr(strType, "[key]") > 0 Then
        If Me.UbbAutoKeywordEnable And (InStr(para, "[key]") > 0 Or InStr(para, "[keyword]") > 0) Then
            Dim i As Integer
            Dim j As Integer
            Dim amatch As Match
            Dim matches As MatchCollection

            If Not Me.UbbKeywords Is Nothing Then 'If IsArray(Keywords) Then
                For Each keyword As UbbKeyword In Me.UbbKeywords 'For i = LBound(Keywords, 2) To UBound(Keywords, 2)

                    'objRegExp.Pattern = "((<.*)(" & Keywords(1, i).ToString() & ")(.*>))|((<a.*)(" & Keywords(1, i).ToString() & ")(\/a>))"
                    objRegExp.Pattern = "((<.*)(" & keyword.Word & ")(.*>))|((<a.*)(" & keyword.Word & ")(\/a>))"

                    Matches = objRegExp.Execute(strContent)
                    For Each match As Match In Matches
                        strContent = Replace(strContent, amatch.Value, vbVerticalTab & vbTab & vbVerticalTab)
                    Next

                    'strContent = Replace(strContent, Keywords(1, i).ToString(), "<a href=""" & Keywords(2, i).ToString() & """ target=""_blank"">" & Keywords(1, i).ToString() & "</a>")
                    strContent = Replace(strContent, keyword.Word, "<a href=""" & keyword.Url & """ target=""_blank"">" & keyword.Word & "</a>")

                    For Each match As Match In Matches
                        strContent = Replace(strContent, vbVerticalTab & vbTab & vbVerticalTab, amatch.Value, 1, 1)
                    Next
                    Matches = Nothing

                Next
            End If

        End If

        objRegExp = Nothing
        UbbCode = strContent

    End Function


    '*********************************************************
    ' Ŀģ    
    ' 룺    
    ' 룺    Ҫ滻ַ
    ' أ    
    '*********************************************************
    Protected Function HandleHtml(ByVal source As String, ByVal para As String) As String

        Dim objRegExp As RegExp

        If IsNothing(source) Or source = "" Then HandleHtml = "" : Exit Function

        'Ȼ"&"
        If InStr(para, "[&]") > 0 Then source = Replace(source, "&", "&amp;")
        If InStr(para, "[<]") > 0 Then source = Replace(source, "<", "&lt;")
        If InStr(para, "[>]") > 0 Then source = Replace(source, ">", "&gt;")
        If InStr(para, "[""]") > 0 Then source = Replace(source, """", "&quot;")
        If InStr(para, "[space]") > 0 Then source = Replace(source, " ", "&nbsp;")
        If InStr(para, "[enter]") > 0 Then
            source = Replace(source, vbCrLf, "<br/>")
            source = Replace(source, vbLf, "<br/>")
        End If

        'If InStr(para, "[vbCrlf]") > 0 And ZC_AUTO_NEWLINE Then
        If InStr(para, "[vbCrlf]") > 0 And Me.AutoNewLineEnable Then

            objRegExp = New RegExp
            objRegExp.IgnoreCase = True
            'objRegExp.Global = True

            objRegExp.Pattern = "((</?form[^\n<]*>)|(<select[^\n<]*>)|(<textarea[^\n<]*>)|(</?option[^\n<]*>)|(</?dl[^\n<]*>)|(</?dt[^\n<]*>)|(</?dd[^\n<]*>)|(</?th[^\n<]*>)|(</?tr[^\n<]*>)|(</?td[^\n<]*>)|(</?tbody[^\n<]*>)|(</?table[^\n<]*>)|(</?hr[^\n<]*>)|(</?div[^\n<]*>)|(</?ul[^\n<]*>)|(</?li[^\n<]*>)|(</?ol[^\n<]*>)|(</?h1[^\n<]*>)|(</?h2[^\n<]*>)|(</?h3[^\n<]*>)|(</?h4[^\n<]*>)|(</?h5[^\n<]*>)|(</?h6[^\n<]*>)|(</?p[^\n<]*>))(\x20*(\r\n|\n))"

            source = objRegExp.Replace(source, "$1")

            objRegExp.Pattern = "(\r\n|\n)"
            source = objRegExp.Replace(source, "<br/>")

            source = Replace(source, "<html>", "")
            source = Replace(source, "</html>", "")
            source = Replace(source, "<body>", "")
            source = Replace(source, "</body>", "")

        End If

        If InStr(para, "[vbTab]") > 0 Then source = Replace(source, vbTab, "&nbsp;&nbsp;")
        If InStr(para, "[upload]") > 0 Then
            'source = Replace(source, "src=""upload/", "src=""" & ZC_BLOG_HOST & "upload/")
            'source = Replace(source, "href=""upload/", "href=""" & ZC_BLOG_HOST & "upload/")
            'source = Replace(source, "value=""upload/", "value=""" & ZC_BLOG_HOST & "upload/")
            'source = Replace(source, "href=""http://upload/", "href=""" & ZC_BLOG_HOST & "upload/")
            source = Replace(source, "src=""upload/", "src=""" & Me.AbsoluteWebSiteUrl & "upload/")
            source = Replace(source, "href=""upload/", "href=""" & Me.AbsoluteWebSiteUrl & "upload/")
            source = Replace(source, "value=""upload/", "value=""" & Me.AbsoluteWebSiteUrl & "upload/")
            source = Replace(source, "href=""http://upload/", "href=""" & Me.AbsoluteWebSiteUrl & "upload/")
        End If
        If InStr(para, "[no-asp]") > 0 Then
            source = Replace(source, "<" & "%", "&lt;" & "%")
            source = Replace(source, "%" & ">", "%" & "&gt;")
        End If

        'If ZC_COMMENT_NOFOLLOW_ENABLE And InStr(para, "[nofollow]") > 0 Then
        If Me.LinkNofollowEnable And InStr(para, "[nofollow]") > 0 Then
            source = Replace(source, "<a ", "<a rel=""nofollow"" ")
        End If

        If InStr(para, "[nohtml]") > 0 Then

            objRegExp = New RegExp
            objRegExp.IgnoreCase = True
            'objRegExp.Global = True
            objRegExp.Pattern = "<[^>]*>"
            source = objRegExp.Replace(source, "")

        End If
        If InStr(para, "[wapnohtml]") > 0 Then
            source = Replace(source, "<br/>", vbCrLf)
            source = Replace(source, "<br>", vbCrLf)
            objRegExp = New RegExp
            objRegExp.IgnoreCase = True
            'objRegExp.Global = True
            objRegExp.Pattern = "<(\s)*(/)*(\s)*br(\s)*(/)*(\s)*>"
            source = objRegExp.Replace(source, vbCrLf)
            objRegExp.Pattern = "<[^>]*>"
            source = objRegExp.Replace(source, "")
            objRegExp.Pattern = vbCrLf
            source = objRegExp.Replace(source, "<br/>")
        End If
        If InStr(para, "[filename]") > 0 Then
            source = Replace(source, "/", "")
            source = Replace(source, "\", "")
            source = Replace(source, ":", "")
            source = Replace(source, "?", "")
            source = Replace(source, "*", "")
            source = Replace(source, """", "")
            source = Replace(source, "<", "")
            source = Replace(source, ">", "")
            source = Replace(source, "|", "")
            source = Replace(source, " ", "")
        End If
        If InStr(para, "[normalname]") > 0 Then
            source = Replace(source, "$", "")
            source = Replace(source, "(", "")
            source = Replace(source, ")", "")
            source = Replace(source, "*", "")
            source = Replace(source, "+", "")
            source = Replace(source, ".", "")
            source = Replace(source, "[", "")
            source = Replace(source, "]", "")
            source = Replace(source, "{", "")
            source = Replace(source, "}", "")
            source = Replace(source, "?", "")
            source = Replace(source, "\", "")
            source = Replace(source, "^", "")
            source = Replace(source, "|", "")
            source = Replace(source, ":", "")
            source = Replace(source, """", "")
        End If
        If InStr(para, "[textarea]") > 0 Then
            source = Replace(source, "&", "&amp;")
            source = Replace(source, "%", "&#037;")
            source = Replace(source, "<", "&lt;")
            source = Replace(source, ">", "&gt;")
        End If

        If Me.Japanese2HtmlEntityEnable And InStr(para, "[japan-html]") > 0 Then
            source = Replace(source, "", "&#12460;")
            source = Replace(source, "", "&#12462;")
            source = Replace(source, "", "&#12450;")
            source = Replace(source, "", "&#12466;")
            source = Replace(source, "", "&#12468;")
            source = Replace(source, "", "&#12470;")
            source = Replace(source, "", "&#12472;")
            source = Replace(source, "", "&#12474;")
            source = Replace(source, "", "&#12476;")
            source = Replace(source, "", "&#12478;")
            source = Replace(source, "", "&#12480;")
            source = Replace(source, "", "&#12482;")
            source = Replace(source, "", "&#12485;")
            source = Replace(source, "", "&#12487;")
            source = Replace(source, "", "&#12489;")
            source = Replace(source, "", "&#12496;")
            source = Replace(source, "", "&#12497;")
            source = Replace(source, "", "&#12499;")
            source = Replace(source, "", "&#12500;")
            source = Replace(source, "", "&#12502;")
            source = Replace(source, "", "&#12502;")
            source = Replace(source, "", "&#12503;")
            source = Replace(source, "", "&#12505;")
            source = Replace(source, "", "&#12506;")
            source = Replace(source, "", "&#12508;")
            source = Replace(source, "", "&#12509;")
            source = Replace(source, "", "&#12532;")
        End If

        If Me.Japanese2HtmlEntityEnable And InStr(para, "[html-japan]") > 0 Then
            source = Replace(source, "&#12460;", "")
            source = Replace(source, "&#12462;", "")
            source = Replace(source, "&#12450;", "")
            source = Replace(source, "&#12466;", "")
            source = Replace(source, "&#12468;", "")
            source = Replace(source, "&#12470;", "")
            source = Replace(source, "&#12472;", "")
            source = Replace(source, "&#12474;", "")
            source = Replace(source, "&#12476;", "")
            source = Replace(source, "&#12478;", "")
            source = Replace(source, "&#12480;", "")
            source = Replace(source, "&#12482;", "")
            source = Replace(source, "&#12485;", "")
            source = Replace(source, "&#12487;", "")
            source = Replace(source, "&#12489;", "")
            source = Replace(source, "&#12496;", "")
            source = Replace(source, "&#12497;", "")
            source = Replace(source, "&#12499;", "")
            source = Replace(source, "&#12500;", "")
            source = Replace(source, "&#12502;", "")
            source = Replace(source, "&#12502;", "")
            source = Replace(source, "&#12503;", "")
            source = Replace(source, "&#12505;", "")
            source = Replace(source, "&#12506;", "")
            source = Replace(source, "&#12508;", "")
            source = Replace(source, "&#12509;", "")
            source = Replace(source, "&#12532;", "")
        End If
        If InStr(para, "[html-format]") > 0 Then
            source = Replace(source, "&", "&amp;")
            source = Replace(source, "<", "&lt;")
            source = Replace(source, ">", "&gt;")
            source = Replace(source, """", "&quot;")
        End If

        HandleHtml = source

    End Function


    Private Class RegExp

        Public Sub New()
            'Me.objRegex = New Regex(pattern)
        End Sub

        Private objRegex As Regex

        Private _ignoreCase As Boolean
        Public Property IgnoreCase() As Boolean
            Get
                Return Me._ignoreCase
            End Get
            Set(ByVal Value As Boolean)
                Me._ignoreCase = Value
            End Set
        End Property

        Private _multiLine As Boolean
        Public Property Multiline() As Boolean
            Get
                Return Me._multiLine
            End Get
            Set(ByVal Value As Boolean)
                Me._multiLine = Value
            End Set
        End Property

        Private options As RegexOptions = RegexOptions.ECMAScript

        Public WriteOnly Property Pattern() As String
            Set(ByVal Value As String)
                If (Me.IgnoreCase) Then
                    Me.options = Me.options Or RegexOptions.IgnoreCase
                End If
                If (Me.Multiline) Then
                    Me.options = Me.options Or RegexOptions.Multiline
                End If
                'System.Diagnostics.Debug.WriteLine(Me.options.ToString())
                Me.objRegex = New Regex(Value, Me.options)
            End Set
        End Property

        Public Function Execute(ByVal input As String) As MatchCollection
            If input Is Nothing Then
                input = ""
            End If
            Return Me.objRegex.Matches(input)
        End Function

        Public Function Replace(ByVal input As String, ByVal replacement As String) As String
            If input Is Nothing Then
                Return Nothing
            End If
            Return Me.objRegex.Replace(input, replacement)
        End Function

        Public Function Test(ByVal input As String) As Boolean
            If input Is Nothing Then
                Return False
            End If
            Return Me.objRegex.IsMatch(input)
        End Function

    End Class

End Class


