Option Explicit On 
Option Strict On

Imports System.Xml
'Imports System.Web
Imports System.IO

'*********************************************************
' Ŀģ    TAtom10Export
' 룺    
' أ    
'*********************************************************
Class TAtom10Export

    Public TimeZone As String

    Private objXMLdoc As XmlDocument
    Public ReadOnly Property XmlDoc() As XmlDocument
        Get
            Return Me.objXMLdoc
        End Get
    End Property

    Private objXMLfeed As XmlElement


    ' ʼ
    Public Sub New()

        On Error Resume Next

        'objXMLdocгʼ粻ܽ򱨴
        objXMLdoc = New XmlDocument 'objXMLdoc = Server.CreateObject("Microsoft.XMLDOM")

        If Err.Number <> 0 Then

        End If

        Dim objPI As XmlProcessingInstruction

        objPI = objXMLdoc.CreateProcessingInstruction("xml-stylesheet", "type=""text/css"" href=""css/atom.css""")
        objXMLdoc.InsertBefore(objPI, objXMLdoc.ChildNodes(0))
        objPI = Nothing

        objPI = objXMLdoc.CreateProcessingInstruction("xml", "version=""1.0"" encoding=""UTF-8"" standalone=""yes""")
        objXMLdoc.InsertBefore(objPI, objXMLdoc.ChildNodes(0))
        objPI = Nothing

        objXMLfeed = objXMLdoc.CreateElement("feed")

    End Sub

    '' ͷ
    'Private Sub Class_Terminate()
    '    objXMLfeed = Nothing
    '    objXMLdoc = Nothing
    'End Sub

    Public ReadOnly Property Xml() As String
        Get
            Xml = objXMLdoc.InnerXml
        End Get
    End Property


    Public Sub GetFeed(ByVal objAtomFeed As XmlElement)

        objXMLfeed = objAtomFeed
        objXMLdoc.AppendChild(objXMLfeed)
        objXMLfeed.SetAttribute("xmlns", "http://www.w3.org/2005/Atom")

        Dim i As Integer
        Dim objItemNodes As XmlNodeList
        objItemNodes = objXMLfeed.GetElementsByTagName("updated")

        For i = 0 To (objItemNodes.Count - 1) '.Length - 1)
            objItemNodes(i).InnerText = ParseDateForRFC3339(CDate(objItemNodes(i).InnerText))
        Next

        objItemNodes = Nothing

    End Sub


    Public Sub GetEntry(ByVal objEntryFeed As XmlElement)

        Dim i As Integer
        Dim objItemNodes As XmlNodeList
        objItemNodes = objEntryFeed.GetElementsByTagName("updated")

        For i = 0 To (objItemNodes.Count - 1) '.Length - 1)
            objItemNodes(i).InnerText = ParseDateForRFC3339(CDate(objItemNodes(i).InnerText))
        Next

        objItemNodes = Nothing

        objItemNodes = objEntryFeed.GetElementsByTagName("published")

        For i = 0 To (objItemNodes.Count - 1) '.Length - 1)
            objItemNodes(i).InnerText = ParseDateForRFC3339(CDate(objItemNodes(i).InnerText))
        Next

        objItemNodes = Nothing

        objXMLfeed.AppendChild(objEntryFeed)

    End Sub


    'Public Function Execute(ByVal response As HttpResponse) As Boolean
    '    'Response.ContentType = "text/html"
    '    response.ContentType = "text/xml"
    '    response.Clear()
    '    response.Write(Xml)
    '    Execute = True
    'End Function


    Public Function SaveToFile(ByVal strFileName As String) As Boolean

        objXMLdoc.Save(strFileName)

        SaveToFile = True

    End Function

    Private Function ParseDateForRFC3339(ByVal dtmDate As DateTime) As String
        Return DateTimeHelper.ParseDateForRFC3339(dtmDate, TimeZone)
    End Function



End Class



Public MustInherit Class TAtomElementBase

    Protected objXMLdoc As XmlDocument

    Protected Sub New(ByVal xmlDoc As XmlDocument)
        Me.objXMLdoc = xmlDoc
    End Sub

    Protected Function CommomAppendNode(ByVal strElement As String, ByVal strText As String, ByVal strType As String) As XmlNode

        Dim objSingleNode As XmlElement
        Dim objNodeText As XmlText
        Dim objNodeCdata As XmlCDataSection
        objSingleNode = CType(objXMLdoc.CreateNode(XmlNodeType.Element, strElement, ""), XmlElement) 'objSingleNode = objXMLdoc.CreateNode("element", strElement, "")

        If strType = "" Then

            objNodeText = CType(objXMLdoc.CreateNode(XmlNodeType.Text, "", ""), XmlText) '"text"
            objNodeText.Value = strText 'objNodeText.NodeValue = strText
            objSingleNode.AppendChild(objNodeText)

        ElseIf strType = "text" Then

            objSingleNode.SetAttribute("type", strType)  'objSingleNode.setAttribute("type", strType)
            objNodeText = CType(objXMLdoc.CreateNode(XmlNodeType.Text, "", ""), XmlText) 'objNodeText = objXMLdoc.CreateNode("text", "", "")
            objNodeText.Value = strText
            objSingleNode.AppendChild(objNodeText)

        ElseIf strType = "html" Then

            objSingleNode.SetAttribute("type", strType)
            objNodeCdata = CType(objXMLdoc.CreateNode(XmlNodeType.CDATA, "", ""), XmlCDataSection) 'objNodeCdata = objXMLdoc.CreateNode("cdatasection", "", "")
            objNodeCdata.Value = strText
            objSingleNode.AppendChild(objNodeCdata)

        ElseIf strType = "xhtml" Then

            objSingleNode.SetAttribute("type", strType)
            objNodeText = CType(objXMLdoc.CreateNode(XmlNodeType.Text, "", ""), XmlText) 'objNodeText = objXMLdoc.CreateNode("text", "", "")
            objNodeText.Value = strText
            objSingleNode.AppendChild(objNodeText)

        End If

        CommomAppendNode = objSingleNode

        objSingleNode = Nothing

    End Function

End Class
