Option Explicit On 
Option Strict On

Imports System.Xml

'*********************************************************
' Ŀģ    ־
' 룺    
' أ    
'*********************************************************
Public Class TAtomEntry
    Inherits TAtomElementBase

    'Public atomAuthor
    'Public atomCategory
    'Public atomContributor
    'Public atomLink
    'Public atomTitle
    'Public atomUpdated
    'Public atomPublished
    'Public atomContent
    'Public atomSummary
    'Public atomId
    'Public atomRights

    'Private objXMLdoc
    Private objEntryNode As XmlElement

    Public Sub New(ByVal xmlDoc As XmlDocument)

        MyBase.New(xmlDoc)

        'Server.CreateObject("Microsoft.XMLDOM")
        'objXMLdoc = New XmlDocument
        objEntryNode = objXMLdoc.CreateElement("entry")

    End Sub

    'Private Sub Class_Terminate()
    '    objXMLdoc = Nothing
    '    objEntryNode = Nothing
    'End Sub


    Public ReadOnly Property Node() As XmlElement
        Get
            Node = objEntryNode
        End Get
    End Property


    Public WriteOnly Property atomSummary() As String
        Set(ByVal strSummary As String)
            objEntryNode.AppendChild(CommomAppendNode("summary", strSummary, "html"))
        End Set
    End Property


    Public WriteOnly Property atomRights() As String
        Set(ByVal strRights As String)
            objEntryNode.AppendChild(CommomAppendNode("rights", strRights, ""))
        End Set
    End Property


    Public WriteOnly Property atomId() As String
        Set(ByVal strID As String)
            objEntryNode.AppendChild(CommomAppendNode("id", strID, ""))
        End Set
    End Property


    Public WriteOnly Property atomUpdated() As String
        Set(ByVal dtmUpdated As String)
            objEntryNode.AppendChild(CommomAppendNode("updated", dtmUpdated, ""))
        End Set
    End Property


    Public WriteOnly Property atomPublished() As String
        Set(ByVal dtmPublished As String)
            objEntryNode.AppendChild(CommomAppendNode("published", dtmPublished, ""))
        End Set
    End Property


    Public WriteOnly Property atomTitle() As String
        Set(ByVal strTitle As String)
            objEntryNode.AppendChild(CommomAppendNode("title", strTitle, "html"))
        End Set
    End Property


    Public WriteOnly Property atomTag() As String
        Set(ByVal strTag As String)
            objEntryNode.AppendChild(CommomAppendNode("tag", strTag, ""))
        End Set
    End Property


    Public Sub atomContent(ByVal strContent As String, ByVal strType As String)
        objEntryNode.AppendChild(CommomAppendNode("content", strContent, strType))
    End Sub


    Public Sub atomCategory(ByVal strTerm As String, ByVal strScheme As String, ByVal strLabel As String)

        Dim objSingleNode As XmlElement

        objSingleNode = CType(objXMLdoc.CreateNode("element", "category", ""), XmlElement)

        objSingleNode.SetAttribute("term", strTerm)
        objSingleNode.SetAttribute("scheme", strScheme)
        objSingleNode.SetAttribute("label", strLabel)

        objEntryNode.AppendChild(objSingleNode)
        objSingleNode = Nothing

    End Sub


    Public Sub atomPerson(ByVal strPerson As String, ByVal strName As String, ByVal strEmail As String, ByVal strUrl As String)

        Dim objSingleNode As XmlElement
        Dim objNodeText As XmlText

        Dim objAuthorNameNode As XmlElement
        Dim objAuthorUrlNode As XmlElement
        Dim objAuthorEmailNode As XmlElement

        objSingleNode = CType(objXMLdoc.CreateNode(XmlNodeType.Element, strPerson, ""), XmlElement)

        If strName <> "" Then
            objAuthorNameNode = CType(objXMLdoc.CreateNode("element", "name", ""), XmlElement)
            objNodeText = CType(objXMLdoc.CreateNode("text", "", ""), XmlText)
            objNodeText.Value = strName
            objAuthorNameNode.AppendChild(objNodeText)
            objSingleNode.AppendChild(objAuthorNameNode)
            objNodeText = Nothing
        End If

        If strUrl <> "" Then
            objAuthorUrlNode = CType(objXMLdoc.CreateNode("element", "uri", ""), XmlElement)
            objNodeText = CType(objXMLdoc.CreateNode("text", "", ""), XmlText)
            objNodeText.Value = strUrl
            objAuthorUrlNode.AppendChild(objNodeText)
            objSingleNode.AppendChild(objAuthorUrlNode)
            objNodeText = Nothing
        End If

        If strEmail <> "" Then
            objAuthorEmailNode = CType(objXMLdoc.CreateNode("element", "email", ""), XmlElement) 'objAuthorEmailNode = objXMLdoc.CreateNode("element", "email", "")
            objNodeText = CType(objXMLdoc.CreateNode("text", "", ""), XmlText)
            objNodeText.Value = strEmail
            objAuthorEmailNode.AppendChild(objNodeText)
            objSingleNode.AppendChild(objAuthorEmailNode)
            objNodeText = Nothing
        End If

        objEntryNode.AppendChild(objSingleNode)

        objSingleNode = Nothing

    End Sub

    Public Sub atomLink(ByVal strRel As String, ByVal strType As String, ByVal strHref As String)

        Dim objSingleNode As XmlElement
        Dim objNodeText As XmlText

        objSingleNode = CType(objXMLdoc.CreateNode(XmlNodeType.Element, "link", ""), XmlElement) 'objXMLdoc.CreateNode("element", "link", "")

        objSingleNode.SetAttribute("rel", strRel)
        objSingleNode.SetAttribute("type", strType)
        objSingleNode.SetAttribute("href", strHref)

        objEntryNode.AppendChild(objSingleNode)
        objSingleNode = Nothing

    End Sub


    Public Sub GetComment(ByVal objCommentFeed As XmlNode)

        objEntryNode.AppendChild(objCommentFeed)

    End Sub

    'Private Function CommomAppendNode(ByVal strElement, ByVal strText, ByVal strType)

    '    Dim objSingleNode
    '    Dim objNodeText
    '    Dim objNodeCdata
    '    objSingleNode = objXMLdoc.CreateNode("element", strElement, "")

    '    If strType = "" Then

    '        objNodeText = objXMLdoc.CreateNode("text", "", "")
    '        objNodeText.NodeValue = strText
    '        objSingleNode.AppendChild(objNodeText)

    '    ElseIf strType = "text" Then

    '        objSingleNode.setAttribute("type", strType)
    '        objNodeText = objXMLdoc.CreateNode("text", "", "")
    '        objNodeText.NodeValue = strText
    '        objSingleNode.AppendChild(objNodeText)

    '    ElseIf strType = "html" Then

    '        objSingleNode.setAttribute("type", strType)
    '        objNodeCdata = objXMLdoc.CreateNode("cdatasection", "", "")
    '        objNodeCdata.NodeValue = strText
    '        objSingleNode.AppendChild(objNodeCdata)

    '    ElseIf strType = "xhtml" Then

    '        objSingleNode.setAttribute("type", strType)
    '        objNodeText = objXMLdoc.CreateNode("text", "", "")
    '        objNodeText.NodeValue = strText
    '        objSingleNode.AppendChild(objNodeText)

    '    End If

    '    CommomAppendNode = objSingleNode

    '    objSingleNode = Nothing

    'End Function


End Class
