Option Explicit On 
Option Strict On

Imports System.Xml

'*********************************************************
' Ŀģ    BLOGϢ
' 룺    
' أ    
'*********************************************************
Class TAtomFeed
    Inherits TAtomElementBase

    'Public atomAuthor
    'Public atomCategory
    'Public atomContributor
    'Public atomGenerator
    'Public atomIcon
    'Public atomId
    'Public atomLink
    'Public atomLogo
    'Public atomRights
    'Public atomSubtitle
    'Public atomTitle
    'Public atomUpdated

    'Private objXMLdoc
    Private objFeedNode As XmlElement


    Public Sub New(ByVal xmlDoc As XmlDocument)

        MyBase.New(xmlDoc)
        'objXMLdoc = Server.CreateObject("Microsoft.XMLDOM")
        'objXMLdoc = New XmlDocument
        objFeedNode = objXMLdoc.CreateElement("feed")
    End Sub

    'Private Sub Class_Terminate()
    '    objXMLdoc = Nothing
    '    objFeedNode = Nothing
    'End Sub

    Public ReadOnly Property Node() As XmlElement
        Get
            Node = objFeedNode
        End Get
    End Property

    Public WriteOnly Property atomCategory() As String
        Set(ByVal strCategory As String)
            objFeedNode.AppendChild(CommomAppendNode("category", strCategory, ""))
        End Set
    End Property

    Public WriteOnly Property atomIcon() As String
        Set(ByVal strIcon As String)
            objFeedNode.AppendChild(CommomAppendNode("icon", strIcon, ""))
        End Set
    End Property

    Public WriteOnly Property atomId() As String
        Set(ByVal strId As String)
            objFeedNode.AppendChild(CommomAppendNode("id", strId, ""))
        End Set
    End Property

    Public WriteOnly Property atomLogo() As String
        Set(ByVal strLogo As String)
            objFeedNode.AppendChild(CommomAppendNode("logo", strLogo, ""))
        End Set
    End Property

    Public WriteOnly Property atomRights() As String
        Set(ByVal strRights As String)
            objFeedNode.AppendChild(CommomAppendNode("sights", strRights, "text"))
        End Set
    End Property

    Public WriteOnly Property atomSubtitle() As String
        Set(ByVal strSubtitle As String)
            objFeedNode.AppendChild(CommomAppendNode("subtitle", strSubtitle, "html"))
        End Set
    End Property

    Public WriteOnly Property atomTitle() As String
        Set(ByVal strTitle As String)
            objFeedNode.AppendChild(CommomAppendNode("title", strTitle, "html"))
        End Set
    End Property

    Public WriteOnly Property atomUpdated() As String
        Set(ByVal strUpdated As String)
            objFeedNode.AppendChild(CommomAppendNode("updated", strUpdated, ""))
        End Set
    End Property


    Public Sub atomPerson(ByVal strPerson As String, ByVal strName As String, ByVal strEmail As String, ByVal strUrl As String)

        Dim objSingleNode As XmlElement
        Dim objNodeText As XmlText

        Dim objAuthorNameNode As XmlElement
        Dim objAuthorUrlNode As XmlElement
        Dim objAuthorEmailNode As XmlElement

        objSingleNode = CType(objXMLdoc.CreateNode("element", strPerson, ""), XmlElement)

        If strName <> "" Then
            objAuthorNameNode = CType(objXMLdoc.CreateNode("element", "name", ""), XmlElement)
            objNodeText = CType(objXMLdoc.CreateNode("text", "", ""), XmlText)
            objNodeText.Value = strName
            objAuthorNameNode.AppendChild(objNodeText)
            objSingleNode.AppendChild(objAuthorNameNode)
            objNodeText = Nothing
        End If

        If strUrl <> "" Then
            objAuthorUrlNode = CType(objXMLdoc.CreateNode("element", "uri", ""), XmlElement)
            objNodeText = CType(objXMLdoc.CreateNode("text", "", ""), XmlText)
            objNodeText.Value = strUrl
            objAuthorUrlNode.AppendChild(objNodeText)
            objSingleNode.AppendChild(objAuthorUrlNode)
            objNodeText = Nothing
        End If

        If strEmail <> "" Then
            objAuthorEmailNode = CType(objXMLdoc.CreateNode("element", "email", ""), XmlElement)
            objNodeText = CType(objXMLdoc.CreateNode("text", "", ""), XmlText)
            objNodeText.Value = strEmail
            objAuthorEmailNode.AppendChild(objNodeText)
            objSingleNode.AppendChild(objAuthorEmailNode)
            objNodeText = Nothing
        End If

        objFeedNode.AppendChild(objSingleNode)

        objSingleNode = Nothing

    End Sub


    Public Sub atomLink(ByVal strRel As String, ByVal strType As String, ByVal strHref As String)

        Dim objSingleNode As XmlElement
        Dim objNodeText As XmlText

        objSingleNode = CType(objXMLdoc.CreateNode("element", "link", ""), XmlElement)

        objSingleNode.SetAttribute("rel", strRel)
        objSingleNode.SetAttribute("type", strType)
        objSingleNode.SetAttribute("href", strHref)

        objFeedNode.AppendChild(objSingleNode)
        objSingleNode = Nothing

    End Sub


    Public Sub atomGenerator(ByVal strGenerator As String, ByVal strUri As String, ByVal strVersion As String)

        Dim objSingleNode As XmlElement
        Dim objNodeText As XmlText

        objSingleNode = CType(objXMLdoc.CreateNode("element", "generator", ""), XmlElement)
        objNodeText = CType(objXMLdoc.CreateNode("text", "", ""), XmlText)

        objNodeText.Value = strGenerator
        objSingleNode.SetAttribute("uri", strUri)
        objSingleNode.SetAttribute("version", strVersion)

        objSingleNode.AppendChild(objNodeText)
        objFeedNode.AppendChild(objSingleNode)

        objSingleNode = Nothing
        objNodeText = Nothing

    End Sub


    'Private Function CommomAppendNode(ByVal strElement, ByVal strText, ByVal strType)

    '    Dim objSingleNode
    '    Dim objNodeText
    '    Dim objNodeCdata
    '    objSingleNode = objXMLdoc.createNode("element", strElement, "")

    '    If strType = "" Then

    '        objNodeText = objXMLdoc.createNode("text", "", "")
    '        objNodeText.NodeValue = strText
    '        objSingleNode.AppendChild(objNodeText)

    '    ElseIf strType = "text" Then

    '        objSingleNode.setAttribute("type", strType)
    '        objNodeText = objXMLdoc.createNode("text", "", "")
    '        objNodeText.NodeValue = strText
    '        objSingleNode.AppendChild(objNodeText)

    '    ElseIf strType = "html" Then

    '        objSingleNode.setAttribute("type", strType)
    '        objNodeCdata = objXMLdoc.createNode("cdatasection", "", "")
    '        objNodeCdata.NodeValue = strText
    '        objSingleNode.AppendChild(objNodeCdata)

    '    ElseIf strType = "xhtml" Then

    '        objSingleNode.setAttribute("type", strType)
    '        objNodeText = objXMLdoc.createNode("text", "", "")
    '        objNodeText.NodeValue = strText
    '        objSingleNode.AppendChild(objNodeText)

    '    End If

    '    CommomAppendNode = objSingleNode

    '    objSingleNode = Nothing

    'End Function

End Class


