Option Explicit On 
Option Strict On

Imports System.Xml
'Imports System.Web

'*********************************************************
' Ŀģ    TRss2Export
' 룺    
' أ    
'*********************************************************
Class TRss2Export

    Public TimeZone As String

    Private objXMLdoc As XmlDocument
    Private objXMLrss As XmlElement
    Private objXMLchannel As XmlElement

    ' ʼ
    Public Sub New()

        'On Error Resume Next

        'objXMLdocгʼ粻ܽ򱨴
        'objXMLdoc = Server.CreateObject("Microsoft.XMLDOM")
        objXMLdoc = New XmlDocument

        If Err.Number <> 0 Then

        End If

        Dim objPI As XmlProcessingInstruction

        objPI = objXMLdoc.createProcessingInstruction("xml-stylesheet", "type=""text/css"" href=""css/rss.css""")
        objXMLdoc.insertBefore(objPI, objXMLdoc.childNodes(0))
        objPI = Nothing

        objPI = objXMLdoc.createProcessingInstruction("xml", "version=""1.0"" encoding=""UTF-8"" standalone=""yes""")
        objXMLdoc.insertBefore(objPI, objXMLdoc.childNodes(0))
        objPI = Nothing

        objXMLrss = objXMLdoc.createElement("rss")

        objXMLchannel = objXMLdoc.createElement("channel")


        objXMLrss.AppendChild(objXMLchannel)
        objXMLdoc.AppendChild(objXMLrss)

        objXMLrss.setAttribute("version", "2.0")
        objXMLrss.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/")
        objXMLrss.setAttribute("xmlns:trackback", "http://madskills.com/public/xml/rss/module/trackback/")
        objXMLrss.setAttribute("xmlns:wfw", "http://wellformedweb.org/CommentAPI/")
        objXMLrss.setAttribute("xmlns:slash", "http://purl.org/rss/1.0/modules/slash/")


    End Sub

    '' ͷ
    'Private Sub Class_Terminate()
    '    objXMLrss = Nothing
    '    objXMLdoc = Nothing
    'End Sub

    Public ReadOnly Property Xml() As String
        Get
            'Xml = objXMLdoc.xml
            Xml = objXMLdoc.InnerXml
        End Get
    End Property

    Private fStrWebLink As String
    Public Property WebLink() As String
        Get
            WebLink = fStrWebLink
        End Get
        Set(ByVal strWebLink As String)
            fStrWebLink = strWebLink
        End Set
    End Property

    Private fStrAuthor As String
    Public Property Author() As String
        Get
            Author = fStrAuthor
        End Get
        Set(ByVal strAuthor As String)
            fStrAuthor = strAuthor
        End Set
    End Property


    Public Function AddChannelAttribute(ByVal title As String, ByVal value As Object) As Boolean

        Dim objXMLitem As XmlElement
        objXMLitem = objXMLdoc.CreateElement(title)

        If title = "pubDate" Then value = ParseDateForRFC822(CDate(value))

        'objXMLitem.text = value
        objXMLitem.InnerText = value.ToString()
        objXMLchannel.AppendChild(objXMLitem)

        AddChannelAttribute = True

    End Function


    Public Function AddItem(ByVal title As String, ByVal author As String, ByVal link As String, ByVal pubDate As DateTime, ByVal guid As String, _
        ByVal description As String, ByVal category As String, ByVal comments As String, _
        ByVal wfw_comment As String, ByVal wfw_commentRss As String, ByVal trackback_ping As String) As Boolean

        Dim objXMLitem As XmlElement
        objXMLitem = objXMLdoc.CreateElement("item")
        
        If (Len(title) > 0) Then
            objXMLitem.AppendChild(objXMLdoc.CreateElement("title"))
            objXMLitem.SelectSingleNode("title").InnerText = title
        End If
        If (Len(author) > 0) Then
            objXMLitem.AppendChild(objXMLdoc.CreateElement("author"))
            objXMLitem.SelectSingleNode("author").InnerText = author
        End If
        If (Len(link) > 0) Then
            objXMLitem.AppendChild(objXMLdoc.CreateElement("link"))
            objXMLitem.SelectSingleNode("link").InnerText = link
        End If
        If (Len(pubDate) > 0) Then
            objXMLitem.AppendChild(objXMLdoc.CreateElement("pubDate"))
            objXMLitem.SelectSingleNode("pubDate").InnerText = ParseDateForRFC822(pubDate)
        End If
        If (Len(guid) > 0) Then
            objXMLitem.AppendChild(objXMLdoc.CreateElement("guid"))
            objXMLitem.SelectSingleNode("guid").InnerText = guid
        End If

        If (Len(description) > 0) Then

            Dim objXMLcdata As XmlCDataSection 'Dim objXMLcdata As XmlNode

            objXMLitem.AppendChild(objXMLdoc.CreateElement("description"))
            'objXMLcdata = objXMLdoc.CreateNode("cdatasection", "", "")
            'objXMLcdata.NodeValue = description
            objXMLcdata = objXMLdoc.CreateCDataSection(description)
            objXMLitem.SelectSingleNode("description").AppendChild(objXMLcdata)

            objXMLcdata = Nothing

        End If

        If (Len(category) > 0) Then
            objXMLitem.AppendChild(objXMLdoc.CreateElement("category"))
            objXMLitem.SelectSingleNode("category").InnerText = category
        End If

        If (Len(comments) > 0) Then
            objXMLitem.AppendChild(objXMLdoc.CreateElement("comments"))
            objXMLitem.SelectSingleNode("comments").InnerText = comments
        End If

        If (Len(wfw_comment) > 0) Then
            'objXMLitem.AppendChild(objXMLdoc.CreateElement("wfw:comment"))
            'objXMLitem.SelectSingleNode("wfw:comment").InnerText = wfw_comment
            objXMLitem.AppendChild(objXMLdoc.CreateElement("wfw:comment")).InnerText = wfw_comment
        End If
        If (Len(wfw_commentRss) > 0) Then
            'objXMLitem.AppendChild(objXMLdoc.CreateElement("wfw:commentRss"))
            'objXMLitem.SelectSingleNode("wfw:commentRss").InnerText = wfw_commentRss
            objXMLitem.AppendChild(objXMLdoc.CreateElement("wfw:commentRss")).InnerText = wfw_commentRss
        End If
        If (Len(trackback_ping) > 0) Then
            'objXMLitem.AppendChild(objXMLdoc.CreateElement("trackback:ping"))
            'objXMLitem.SelectSingleNode("trackback:ping").InnerText = trackback_ping
            objXMLitem.AppendChild(objXMLdoc.CreateElement("trackback:ping")).InnerText = trackback_ping
        End If

        objXMLchannel.AppendChild(objXMLitem)

        AddItem = True

    End Function

    'Public Function Execute(ByVal response As HttpResponse) As Boolean
    '    'response.ContentType = "text/html"
    '    response.ContentType = "text/xml"
    '    response.Clear()
    '    response.Write(Xml)
    '    Execute = True
    'End Function


    Public Function SaveToFile(ByVal strFileName As String) As Boolean

        objXMLdoc.Save(strFileName)

        SaveToFile = True

    End Function

    Private Function ParseDateForRFC822(ByVal dtmDate As DateTime) As String
        Return DateTimeHelper.ParseDateForRFC822(dtmDate, Me.TimeZone)
    End Function

End Class