Option Explicit On 
Option Strict On

Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.ComponentModel


Public Class TagsInputPannel
    Inherits System.Web.UI.WebControls.WebControl
    Implements INamingContainer


    Private _tags As String = "Tag1,Tag2,Tag3,..."

    Public Property Tags() As String
        Get
            Return Me._tags
        End Get
        Set(ByVal Value As String)
            Me._tags = Value
        End Set
    End Property

    Private _separator As String = ","
    Public Property Separator() As String
        Get
            Return Me._separator
        End Get
        Set(ByVal Value As String)
            Me._separator = Value
        End Set
    End Property

    Private _tagsField As String = "edtTag"
    Public Property TagsField() As String
        Get
            Return Me._tagsField
        End Get
        Set(ByVal Value As String)
            Me._tagsField = Value
        End Set
    End Property

    Private _hintDisplayTags As String = "Display Used Tags"

    Public Property HintDisplayTags() As String
        Get
            Return Me._hintDisplayTags
        End Get
        Set(ByVal Value As String)
            Me._hintDisplayTags = Value
        End Set
    End Property

    Protected Overrides Sub Render(ByVal writer As System.Web.UI.HtmlTextWriter)

        Dim aryTags() As String
        aryTags = Me.Tags.Split(Me.Separator.ToCharArray)
        Dim sb As New System.Text.StringBuilder

        sb.Append("<span style=""CURSOR:pointer"" onclick=""if(document.getElementById('ulTag').style.display=='none')")
        sb.Append("{document.getElementById('ulTag').style.display='block';}else{document.getElementById('ulTag').style.display='none'};"">")
        sb.Append(Me.HintDisplayTags) : sb.Append("&gt;&gt;")
        sb.Append("</span>")
        sb.Append(vbCrLf)

        sb.Append("<ul id=""ulTag"" style=""DISPLAY:none"">")
        sb.Append(vbCrLf)

        For Each strtag As String In aryTags
            If Not IsNothing(strtag) AndAlso strtag <> "" Then
                sb.Append("<span style='cursor:pointer;' onclick='AddTag(""" & strtag & """)' />" & Me.Page.Server.HtmlEncode(strtag) & "&nbsp;&nbsp;</span>")
                sb.Append(vbCrLf)
            End If
        Next

        sb.Append("</ul>")
        sb.Append(vbCrLf)

        writer.Write(sb.ToString())

    End Sub

    Protected Overrides Sub OnPreRender(ByVal e As System.EventArgs)

        Dim scriptKey As String = "TagsInputPannelSupportScript"
        If Not Page.IsStartupScriptRegistered(scriptKey) Then
            Dim scriptBlock As String = Me.getScriptBlock()
            Page.RegisterStartupScript(scriptKey, scriptBlock)
        End If

    End Sub


    Private Function getScriptBlock() As String

        Dim sb As New System.Text.StringBuilder
        sb.Append("	<script language=javascript>") : sb.Append(vbCrLf)
        sb.Append("	<!--") : sb.Append(vbCrLf)

        sb.Append("	function AddTag(i) {") : sb.Append(vbCrLf)
        sb.Append("		var strKey=document.getElementById(""" & Me.TagsField & """).value;") : sb.Append(vbCrLf)
        sb.Append("		var strNow = i + """ & Me.Separator & """; ") : sb.Append(vbCrLf)
        sb.Append("") : sb.Append(vbCrLf)
        sb.Append("		if(strKey.indexOf(strNow)==-1){") : sb.Append(vbCrLf)
        sb.Append("			strKey=strKey+strNow;") : sb.Append(vbCrLf)
        sb.Append("		}") : sb.Append(vbCrLf)
        sb.Append("		document.getElementById(""edtTag"").value=strKey;") : sb.Append(vbCrLf)
        sb.Append("	}") : sb.Append(vbCrLf)

        sb.Append("//-->") : sb.Append(vbCrLf)
        sb.Append("</script>") : sb.Append(vbCrLf)

        Return sb.ToString()
    End Function


End Class
