Option Explicit On 
Option Strict On


Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.ComponentModel


Public Class UploadFileDialog
    Inherits System.Web.UI.WebControls.WebControl
    Implements INamingContainer

    Private _title As String = "Upload File"
    <Bindable(True), Category("Appearance")> _
    Public Property Title() As String
        Get
            Return Me._title
        End Get
        Set(ByVal Value As String)
            Me._title = Value
        End Set
    End Property

    Private _diologWidth As Integer = 300
    <Bindable(True), Category("Appearance")> _
    Public Property DialogWidth() As Integer
        Get
            Return Me._diologWidth
        End Get
        Set(ByVal Value As Integer)
            Me._diologWidth = Value
        End Set
    End Property


    Private _dialogHeight As Integer = 150
    <Bindable(True), Category("Appearance")> _
    Public Property DialogHeight() As Integer
        Get
            Return Me._dialogHeight
        End Get
        Set(ByVal Value As Integer)
            Me._dialogHeight = Value
        End Set
    End Property

    Private _buttonBackgroudImage As String = ""
    <Bindable(True), Category("Appearance")> _
    Public Property ButtonBackgroudImage() As String
        Get
            Return Me._buttonBackgroudImage
        End Get
        Set(ByVal Value As String)
            Me._buttonBackgroudImage = Value
        End Set
    End Property

    Private _closeBoxImage As String = ""
    <Bindable(True), Category("Appearance")> _
    Public Property CloseBoxImage() As String
        Get
            Return Me._closeBoxImage
        End Get
        Set(ByVal Value As String)
            Me._closeBoxImage = Value
        End Set
    End Property


    Private _closeBoxImageMouseOver As String = ""
    <Bindable(True), Category("Appearance")> _
    Public Property CloseBoxImageMouseOver() As String
        Get
            Return Me._closeBoxImageMouseOver
        End Get
        Set(ByVal Value As String)
            Me._closeBoxImageMouseOver = Value
        End Set
    End Property

    Private _icon As String = ""
    <Bindable(True), Category("Appearance")> _
    Public Property Icon() As String
        Get
            Return Me._icon
        End Get
        Set(ByVal Value As String)
            Me._icon = Value
        End Set
    End Property

    Private _buttonTextUpload As String = "Upload"
    <Bindable(True), Category("Appearance")> _
    Public Property ButtonTextUpload() As String
        Get
            Return Me._buttonTextUpload
        End Get
        Set(ByVal Value As String)
            Me._buttonTextUpload = Value
        End Set
    End Property

    Private _uploadServiceUrl As String = "Upload.aspx"
    Public Property UploadServiceUrl() As String
        Get
            Return Me._uploadServiceUrl
        End Get
        Set(ByVal Value As String)
            Me._uploadServiceUrl = Value
        End Set
    End Property


    'Private _supportScript As String = "UploadDialog.js"
    'Public Property SupportScript() As String
    '    Get
    '        Return Me._supportScript
    '    End Get
    '    Set(ByVal Value As String)
    '        Me._supportScript = Value
    '    End Set
    'End Property

    Private _hintAutoRename As String = "Auto Rename"
    <Bindable(True), Category("Appearance")> _
    Public Property HintAutoRename() As String
        Get
            Return Me._hintAutoRename
        End Get
        Set(ByVal Value As String)
            Me._hintAutoRename = Value
        End Set
    End Property

    Private _buttonTextSubmit As String = "Submit"
    <Bindable(True), Category("Appearance")> _
    Public Property ButtonTextSubmit() As String
        Get
            Return Me._buttonTextSubmit
        End Get
        Set(ByVal Value As String)
            Me._buttonTextSubmit = Value
        End Set
    End Property

    Private _buttonTextReset As String = "Reset"
    <Bindable(True), Category("Appearance")> _
    Public Property ButtonTextReset() As String
        Get
            Return Me._buttonTextReset
        End Get
        Set(ByVal Value As String)
            Me._buttonTextReset = Value
        End Set
    End Property

    Private _hintUploading As String = "Uploading"
    <Bindable(True), Category("Appearance")> _
    Public Property HintUploading() As String
        Get
            Return Me._hintUploading
        End Get
        Set(ByVal Value As String)
            Me._uploadServiceUrl = Value
        End Set
    End Property

    Private _hideSelectList As Boolean = False
    Public Property HideSelectList() As Boolean
        Get
            Return Me._hideSelectList
        End Get
        Set(ByVal Value As Boolean)
            Me._hideSelectList = Value
        End Set
    End Property

    Private _middle As Boolean = False
    <Bindable(True), Category("Appearance")> _
    Public Property Middle() As Boolean
        Get
            Return Me._middle
        End Get
        Set(ByVal Value As Boolean)
            Me._middle = Value
        End Set
    End Property

    Private _left As Integer
    <Bindable(True), Category("Appearance")> _
    Public Property Left() As Integer
        Get
            Return Me._left
        End Get
        Set(ByVal Value As Integer)
            Me._left = Value
        End Set
    End Property

    Private _top As Integer
    <Bindable(True), Category("Appearance")> _
    Public Property Top() As Integer
        Get
            Return Me._top
        End Get
        Set(ByVal Value As Integer)
            Me._top = Value
        End Set
    End Property


    Protected Overrides Sub Render(ByVal writer As System.Web.UI.HtmlTextWriter)

        Dim sb As New System.Text.StringBuilder

        'sb.Append("<SCRIPT LANGUAGE=""javascript"" src=""" & Me.SupportScript & """></SCRIPT>") : sb.Append(vbCrLf)

        sb.Append("<input id=""btnUpload"" type=""button""") : sb.Append(vbCrLf)
        sb.Append(" Style = ""width:62px;height:22px;border:0;""")
        sb.Append(" background:url('" & Me.ButtonBackgroudImage & "');line-height:20px;"" value=""" & Me.ButtonTextUpload & """")
        sb.Append(" onclick=""showUploadDialog();"" />") : sb.Append(vbCrLf)

        sb.Append("<input type=""hidden"" id=""uploadFileID""/>")
        sb.Append("<input type=""hidden"" id=""uploadFileName""/>")
        sb.Append("<span id=""uploadResponseMessage""></span>")
        sb.Append(vbCrLf)

        sb.Append("<span id=""spanUploadFileDialog"">") : sb.Append(vbCrLf)
        sb.Append("</span>") : sb.Append(vbCrLf)

        writer.Write(sb.ToString())

    End Sub

    Protected Overrides Sub OnPreRender(ByVal e As System.EventArgs)

        Dim scriptKey As String = "UploadFileDialogSupportScript"
        If Not Page.IsClientScriptBlockRegistered(scriptKey) Then
            Dim scriptBlock As String = Me.getScriptBlock()
            'System.Diagnostics.Debug.Write(scriptBlock)
            Page.RegisterClientScriptBlock(scriptKey, scriptBlock)
        End If

    End Sub

    Private Function getScriptBlock() As String

        Dim sb As New System.Text.StringBuilder

        sb.Append("<script language=javascript>") : sb.Append(vbCrLf)
        sb.Append("<!--") : sb.Append(vbCrLf)

        sb.Append(" function dialog(){") : sb.Append(vbCrLf)
        'sb.Append("    var path =""../IMAGE/COMMON/"";") : sb.Append(vbCrLf)
        sb.Append("    var title = '" & Me.Title & "';") : sb.Append(vbCrLf)
        sb.Append("    var width = " & Me.DialogWidth.ToString() & ";") : sb.Append(vbCrLf)
        sb.Append("    var height = " & Me.DialogHeight.ToString() & ";") : sb.Append(vbCrLf)
        sb.Append("    var buttonBackgroudImage = '" & Me.ButtonBackgroudImage & "';") : sb.Append(vbCrLf)
        sb.Append("    var closeBoxImage = '" & Me.CloseBoxImage & "';") : sb.Append(vbCrLf)
        sb.Append("    var closeBoxImageMouseOver = '" & Me.CloseBoxImageMouseOver & "';") : sb.Append(vbCrLf)
        sb.Append("    var dialogBoxIconImage = '" & Me.Icon & "';") : sb.Append(vbCrLf)

        sb.Append("") : sb.Append(vbCrLf)
        sb.Append("    var sFunc = '<input id=""dialogOk"" type=""button"" style=""width:62px;height:22px;border:0;background:url(\'' + buttonBackgroudImage + '\');line-height:20px;"" value=""OK"" onclick=""new dialog().reset();"" />';") : sb.Append(vbCrLf)
        sb.Append("    var sClose = '<input type=""image"" id=""dialogBoxClose"" onclick=""new dialog().reset();"" src=""' + closeBoxImage + '"" border=""0"" width=""17"" height=""17"" onmouseover=""this.src=\'' + closeBoxImageMouseOver + '\';"" onmouseout=""this.src=\'' + closeBoxImage + '\';"" align=""absmiddle"" />';") : sb.Append(vbCrLf)
        sb.Append("     ") : sb.Append(vbCrLf)
        sb.Append("    var sBody = '\") : sb.Append(vbCrLf)
        sb.Append("        <table id=""dialogBodyBox"" border=""0"" align=""center"" cellpadding=""0"" cellspacing=""0"">\") : sb.Append(vbCrLf)
        sb.Append("            <tr height=""10""><td colspan=""4""></td></tr>\") : sb.Append(vbCrLf)
        sb.Append("            <tr>\") : sb.Append(vbCrLf)
        sb.Append("                <td width=""10""></td>\") : sb.Append(vbCrLf)
        sb.Append("                <td align=""center"" valign=""absmiddle""><img id=""dialogBoxFace"" src=""' + dialogBoxIconImage + '"" /></td>\") : sb.Append(vbCrLf)
        sb.Append("                <td id=""dialogMsg"" style=""font-size:12px;color:#000;""></td>\") : sb.Append(vbCrLf)
        sb.Append("                <td width=""10""></td>\") : sb.Append(vbCrLf)
        sb.Append("            </tr>\") : sb.Append(vbCrLf)
        sb.Append("            <tr height=""10""><td colspan=""4"" align=""center""></td></tr>\") : sb.Append(vbCrLf)
        sb.Append("            <tr><td id=""dialogFunc"" colspan=""4"" align=""center"">' + sFunc + '</td></tr>\") : sb.Append(vbCrLf)
        sb.Append("            <tr height=""10""><td colspan=""4"" align=""center""></td></tr>\") : sb.Append(vbCrLf)
        sb.Append("        </table>\") : sb.Append(vbCrLf)
        sb.Append("    ';") : sb.Append(vbCrLf)
        sb.Append("    ") : sb.Append(vbCrLf)
        sb.Append("    var sBox = '\") : sb.Append(vbCrLf)
        sb.Append("        <table id=""dialogBox"" width=""' + width + 'px"" border=""0"" cellpadding=""0"" cellspacing=""0"" style=""border:1px solid #000;display:none;z-index:10001;"">\") : sb.Append(vbCrLf)
        sb.Append("            <tr height=""1"" bgcolor=""#D6E3EB""><td></td></tr>\") : sb.Append(vbCrLf)
        sb.Append("            <tr height=""25"" bgcolor=""#6795B4"">\") : sb.Append(vbCrLf)
        sb.Append("                <td>\") : sb.Append(vbCrLf)
        sb.Append("                    <table onselectstart=""return false;"" style=""-moz-user-select:none;"" width=""100%"" border=""0"" cellpadding=""0"" cellspacing=""0"">\") : sb.Append(vbCrLf)
        sb.Append("                        <tr>\") : sb.Append(vbCrLf)
        sb.Append("                            <td width=""6""></td>\") : sb.Append(vbCrLf)
        sb.Append("                            <td id=""dialogBoxTitle"" style=""color:#fff;cursor:move;font-size:12px;font-weight:bold;"">'+ title +'</td>\") : sb.Append(vbCrLf)
        sb.Append("                            <td id=""dialogClose"" width=""27"" align=""right"" valign=""middle"">\") : sb.Append(vbCrLf)
        sb.Append("                                ' + sClose + '\") : sb.Append(vbCrLf)
        sb.Append("                            </td>\") : sb.Append(vbCrLf)
        sb.Append("                            <td width=""6""></td>\") : sb.Append(vbCrLf)
        sb.Append("                        </tr>\") : sb.Append(vbCrLf)
        sb.Append("                    </table>\") : sb.Append(vbCrLf)
        sb.Append("                </td>\") : sb.Append(vbCrLf)
        sb.Append("            </tr>\") : sb.Append(vbCrLf)
        sb.Append("            <tr height=""2"" bgcolor=""#EDEDED""><td></td></tr>\") : sb.Append(vbCrLf)
        sb.Append("            <tr id=""dialogHeight"" style=""height:' + height + '"">\") : sb.Append(vbCrLf)
        sb.Append("                <td id=""dialogBody"" style=""background:#fff;color:#000;"">' + sBody + '</td>\") : sb.Append(vbCrLf)
        sb.Append("            </tr>\") : sb.Append(vbCrLf)
        sb.Append("        </table>\") : sb.Append(vbCrLf)
        sb.Append("        <div id=""dialogBoxShadow"" style=""display:none;z-index:10000;""></div>\") : sb.Append(vbCrLf)
        sb.Append("    ';") : sb.Append(vbCrLf)
        sb.Append("    ") : sb.Append(vbCrLf)
        sb.Append("    function $(_sId){return document.getElementById(_sId)}") : sb.Append(vbCrLf)
        sb.Append("") : sb.Append(vbCrLf)

        sb.Append("this.hideModule = function(_sType, _sDisplay){") : sb.Append(vbCrLf)
        sb.Append("  var aType = document.getElementsByTagName(_sType);") : sb.Append(vbCrLf)
        sb.Append("  for (var i = 0; i < aType.length; i++){") : sb.Append(vbCrLf)
        sb.Append("    aType[i].style.display	= _sDisplay;") : sb.Append(vbCrLf)
        sb.Append("  }") : sb.Append(vbCrLf)
        sb.Append("}") : sb.Append(vbCrLf)

        sb.Append("    this.shadow = function(){") : sb.Append(vbCrLf)
        sb.Append("        var oShadow = $('dialogBoxShadow');") : sb.Append(vbCrLf)
        sb.Append("        var oDialog = $('dialogBox');") : sb.Append(vbCrLf)
        sb.Append("        oShadow['style']['position'] = ""absolute"";") : sb.Append(vbCrLf)
        sb.Append("        oShadow['style']['background']    = ""#000"";") : sb.Append(vbCrLf)
        sb.Append("        oShadow['style']['display']    = """";") : sb.Append(vbCrLf)
        sb.Append("        oShadow['style']['opacity']    = ""0.2"";") : sb.Append(vbCrLf)
        sb.Append("        oShadow['style']['filter'] = ""alpha(opacity=20)"";") : sb.Append(vbCrLf)
        sb.Append("        oShadow['style']['top'] = oDialog.offsetTop + 6+ 'px';") : sb.Append(vbCrLf)
        sb.Append("        oShadow['style']['left'] = oDialog.offsetLeft + 6+ 'px';") : sb.Append(vbCrLf)
        sb.Append("        oShadow['style']['width'] = oDialog.offsetWidth+ 'px';") : sb.Append(vbCrLf)
        sb.Append("        oShadow['style']['height'] = oDialog.offsetHeight+ 'px';") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)
        sb.Append(vbCrLf)

        sb.Append("    this.setPosition = function(_sId,left,top){") : sb.Append(vbCrLf)
        sb.Append("        $(_sId)['style']['display'] = '';") : sb.Append(vbCrLf)
        sb.Append("        $(_sId)['style']['position'] = ""absolute"";") : sb.Append(vbCrLf)
        sb.Append("        $('dialogBox')['style']['left'] = left;") : sb.Append(vbCrLf)
        sb.Append("        $('dialogBox')['style']['top'] = top;") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)
        sb.Append("") : sb.Append(vbCrLf)

        sb.Append("    this.middle = function(_sId){") : sb.Append(vbCrLf)
        sb.Append("        $(_sId)['style']['display'] = '';") : sb.Append(vbCrLf)
        sb.Append("        $(_sId)['style']['position'] = ""absolute"";") : sb.Append(vbCrLf)
        sb.Append("        //if (self.pageYOffset) {") : sb.Append(vbCrLf)
        sb.Append("        //    $(_sId)['style']['left'] = (self.innerWidth/2 - ($(_sId).offsetWidth / 2)) + 'px';") : sb.Append(vbCrLf)
        sb.Append("        //    $(_sId)['style']['top'] = (self.innerHeight/2 + self.pageYOffset - ($(_sId).offsetHeight / 2)) + 'px';") : sb.Append(vbCrLf)
        sb.Append("        //} else ") : sb.Append(vbCrLf)
        sb.Append("        if (document.documentElement && document.documentElement.scrollTop){") : sb.Append(vbCrLf)
        sb.Append("            $(_sId)['style']['left'] = (document.documentElement.clientWidth / 2) - ($(_sId).offsetWidth / 2)  + 'px' ;") : sb.Append(vbCrLf)
        sb.Append("            $(_sId)['style']['top'] = (document.documentElement.clientHeight / 2 + document.documentElement.scrollTop) - ($(_sId).offsetHeight / 2) + 'px';") : sb.Append(vbCrLf)
        sb.Append("        } else if (document.body) {") : sb.Append(vbCrLf)
        sb.Append("            $(_sId)['style']['left'] = (document.body.offsetWidth/2 - ($(_sId).offsetWidth / 2)) + 'px';") : sb.Append(vbCrLf)
        sb.Append("            if ( document.body.offsetHeight > $(_sId)['style']['width'] )") : sb.Append(vbCrLf)
        sb.Append("            {") : sb.Append(vbCrLf)
        sb.Append("                $(_sId)['style']['top'] = (document.body.offsetHeight/2 - ($(_sId).offsetHeight / 2)) + 'px';") : sb.Append(vbCrLf)
        sb.Append("            }") : sb.Append(vbCrLf)
        sb.Append("        }") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)
        sb.Append("") : sb.Append(vbCrLf)

        sb.Append("    this.init = function(){") : sb.Append(vbCrLf)
        sb.Append("        $('dialogCase') ? $('dialogCase').parentNode.removeChild($('dialogCase')) : function(){};") : sb.Append(vbCrLf)
        sb.Append("        var oDiv = document.createElement('span');") : sb.Append(vbCrLf)
        sb.Append("        oDiv.id = ""dialogCase"";") : sb.Append(vbCrLf)
        sb.Append("        oDiv.innerHTML = sBox;") : sb.Append(vbCrLf)
        sb.Append("        document.body.appendChild(oDiv);") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)
        sb.Append("    ") : sb.Append(vbCrLf)

        sb.Append("    this.show = function(_sMsg, _sOk){") : sb.Append(vbCrLf)
        sb.Append("        $('dialogFunc').innerHTML = sFunc;") : sb.Append(vbCrLf)
        sb.Append("        $('dialogClose').innerHTML = sClose;") : sb.Append(vbCrLf)
        sb.Append("        $('dialogBodyBox') == null ? $('dialogBody').innerHTML = sBody : function(){};") : sb.Append(vbCrLf)
        sb.Append("        $('dialogMsg') ? $('dialogMsg').innerHTML = _sMsg  : function(){};") : sb.Append(vbCrLf)
        If Me.Middle Then
            sb.Append("        this.middle('dialogBox');") : sb.Append(vbCrLf)
        Else
            sb.Append("        this.setPosition('dialogBox'," & Me.Left.ToString() & "," & Me.Top.ToString() & ");") : sb.Append(vbCrLf)
        End If
        sb.Append("        this.shadow();") : sb.Append(vbCrLf)
        sb.Append("        _sOk ? this.button('dialogOk', _sOk) | $('dialogOk').focus() : $('dialogOk').style.display = 'none';") : sb.Append(vbCrLf)
        If Me.HideSelectList Then
            sb.Append("        this.hideModule('select', 'none');") : sb.Append(vbCrLf)
        End If
        sb.Append("    }") : sb.Append(vbCrLf)
        sb.Append("    ") : sb.Append(vbCrLf)


        sb.Append("    this.hide = function(){") : sb.Append(vbCrLf)
        If Me.HideSelectList Then
            sb.Append("        this.hideModule('select', '');") : sb.Append(vbCrLf)
        End If
        sb.Append("        $('dialogBox').style.display='none';") : sb.Append(vbCrLf)
        sb.Append("        $('dialogBoxShadow').style.display = ""none"";") : sb.Append(vbCrLf)
        sb.Append("        //$('dialogBody').innerHTML = sBody;") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)
        sb.Append("") : sb.Append(vbCrLf)


        sb.Append("    this.reset = function(){") : sb.Append(vbCrLf)
        If Me.HideSelectList Then
            sb.Append("        this.hideModule('select', '');")
        End If
        sb.Append("        $('dialogBox').style.display='none';") : sb.Append(vbCrLf)
        sb.Append("        $('dialogBoxShadow').style.display = ""none"";") : sb.Append(vbCrLf)
        sb.Append("        $('dialogBody').innerHTML = sBody;") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)

        sb.Append(vbCrLf)
        sb.Append("    this.button = function(_sId, _sFuc){") : sb.Append(vbCrLf)
        sb.Append("        if($(_sId)){") : sb.Append(vbCrLf)
        sb.Append("            $(_sId).style.display = '';") : sb.Append(vbCrLf)
        sb.Append("            if($(_sId).addEventListener){") : sb.Append(vbCrLf)
        sb.Append("                if($(_sId).act){$(_sId).removeEventListener('click', function(){eval($(_sId).act)}, false);}") : sb.Append(vbCrLf)
        sb.Append("                $(_sId).act = _sFuc;") : sb.Append(vbCrLf)
        sb.Append("                $(_sId).addEventListener('click', function(){eval(_sFuc)}, false);") : sb.Append(vbCrLf)
        sb.Append("            }else{") : sb.Append(vbCrLf)
        sb.Append("                if($(_sId).act){$(_sId).detachEvent('onclick', function(){eval($(_sId).act)});}") : sb.Append(vbCrLf)
        sb.Append("                $(_sId).act = _sFuc;") : sb.Append(vbCrLf)
        sb.Append("                $(_sId).attachEvent('onclick', function(){eval(_sFuc)});") : sb.Append(vbCrLf)
        sb.Append("            }") : sb.Append(vbCrLf)
        sb.Append("        }") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)
        sb.Append("    ") : sb.Append(vbCrLf)
        sb.Append("}") : sb.Append(vbCrLf)

        'sb.Append("  var sAction = ""../Cmd.aspx?act=FileUpload2&callback=uploadCallback"";") : sb.Append(vbCrLf)

        sb.Append("  var sAction = """ & Me.UploadServiceUrl & """;") : sb.Append(vbCrLf)
        sb.Append("  var sUploadform = '\") : sb.Append(vbCrLf)
        sb.Append("  <form id=""upfile"" method=""post"" enctype=""multipart/form-data"" target=""hiddenIframeUpload"" action='+ sAction +'>\") : sb.Append(vbCrLf)
        sb.Append("      <iframe id=""hiddenIframeUpload"" name=""hiddenIframeUpload"" style=""display:none""></iframe>\") : sb.Append(vbCrLf)
        sb.Append("      <p>\") : sb.Append(vbCrLf)
        sb.Append("          <input type=""checkbox"" id=""chkAutoName"" name=""chkAutoName"" checked=""true""/><label for=""chkAutoName"">" & Me.HintAutoRename & "</label><br />\") : sb.Append(vbCrLf)
        sb.Append("        <input type=""file"" id=""edtFileLoad"" name=""edtFileLoad"" size=""20""><br />\") : sb.Append(vbCrLf)
        sb.Append("          <input type=""submit"" class=""button"" value=""" & Me.ButtonTextSubmit & """ name=""B1"" onclick=""beginUpload();"" style=""BORDER-RIGHT: 0px; BORDER-TOP: 0px; BACKGROUND: url(../IMAGE/COMMON/smb_btn_bg.gif); BORDER-LEFT: 0px; WIDTH: 62px; LINE-HEIGHT: 20px; BORDER-BOTTOM: 0px; HEIGHT: 22px"" />\") : sb.Append(vbCrLf)
        sb.Append("          <input class=""button"" type=""reset"" value=""" & Me.ButtonTextReset & """ name=""B2""  style=""BORDER-RIGHT: 0px; BORDER-TOP: 0px; BACKGROUND: url(../IMAGE/COMMON/smb_btn_bg.gif); BORDER-LEFT: 0px; WIDTH: 62px; LINE-HEIGHT: 20px; BORDER-BOTTOM: 0px; HEIGHT: 22px"" />\") : sb.Append(vbCrLf)
        sb.Append("      </p>\") : sb.Append(vbCrLf)
        sb.Append("  </form>\") : sb.Append(vbCrLf)
        sb.Append("  ';") : sb.Append(vbCrLf)
        sb.Append("  ") : sb.Append(vbCrLf)


        sb.Append("    function showUploadDialog()") : sb.Append(vbCrLf)
        sb.Append("    {") : sb.Append(vbCrLf)
        sb.Append("        var sDialog = new dialog();") : sb.Append(vbCrLf)
        sb.Append("        sDialog.init();") : sb.Append(vbCrLf)
        sb.Append("        sDialog.show(sUploadform,false);//sDialog.event(sUploadform,false);") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)

        sb.Append("    function beginUpload()") : sb.Append(vbCrLf)
        sb.Append("    {") : sb.Append(vbCrLf)
        sb.Append("        document.getElementById(""uploadResponseMessage"").innerHTML=""" & Me.HintUploading & "..."";") : sb.Append(vbCrLf)
        sb.Append("        new dialog().hide();") : sb.Append(vbCrLf)
        sb.Append("        return true;") : sb.Append(vbCrLf)
        sb.Append("    }") : sb.Append(vbCrLf)

        sb.Append("") : sb.Append(vbCrLf)
        sb.Append("//-->") : sb.Append("</script>") : sb.Append(vbCrLf)

        Return sb.ToString()

    End Function

End Class
