using System;
using System.Reflection;
using System.Data;
using com.oucsoft.WSORM.OSql;
using System.Collections;
using System.Data.OleDb;
//using System.Data.SqlClient;

namespace com.oucsoft.WSORM
{
	/// <summary>
	/// ΪSql ServerʵֵSession
	/// </summary>
	public class AccessSession : SessionBase
	{
		
		/// <summary>
		/// 캯
		/// </summary>
		public AccessSession(SessionFactory factory):base(factory)
		{
			this.queryTimeout = 60;
			ParameterToken = "@";
		}	
		

		/// <summary>
		/// ǰݿ
		/// </summary>
		private OleDbConnection currentConn = null;		//private SqlConnection currentConn = null;
		private OleDbTransaction currentTrans = null;		//private SqlTransaction currentTrans = null;
		
		/// <summary>
		/// ԶȡSql
		/// </summary>
		/// <param name="fieldType"></param>
		/// <returns></returns>
		private OleDbType getOleDbType(DbFieldTypes fieldType)
		{
			switch(fieldType)
			{
				case DbFieldTypes.AnsiString:
					return OleDbType.VarChar;
				case DbFieldTypes.String:
					return OleDbType.VarWChar;
				case DbFieldTypes.Int :
					return OleDbType.Integer;
				case DbFieldTypes.Boolean :
					return OleDbType.Boolean;
				case DbFieldTypes.DateTime :
					return OleDbType.Date;
				case DbFieldTypes.Decimal :
					return OleDbType.Decimal;
				case DbFieldTypes.Money :
					return OleDbType.Currency;
				case DbFieldTypes.Real :
					return OleDbType.Double;
				case DbFieldTypes.BigInt :
					return OleDbType.BigInt;
				case DbFieldTypes.Unknown :
				default :
					throw new WSORMException("ʹ˲ͣ");//break;
			}
		}
		
	
		/// <summary>
		/// ȡ뱾ݿصĶԲͬ͵ֵıʾʽ
		/// </summary>
		/// <param name="type"></param>
		/// <param name="val">ֵ</param>
		/// <returns>ݿֵıʾַ</returns>
		protected override string getNativeDbValueExpression(DbFieldTypes type, object val)
		{
			string strtemp = val.ToString();
			if ( type == DbFieldTypes.DateTime )
			{
				DateTime timetemp = (DateTime) val;
				strtemp = timetemp.Year.ToString() + "-" + timetemp.Month.ToString() + "-" + timetemp.Day.ToString() + " " 
					+ timetemp.Hour.ToString() + ":" + timetemp.Minute.ToString() + ":" + timetemp.Second.ToString();
				strtemp = "#" + strtemp + "#";
			}
			else if ( type == DbFieldTypes.String || type == DbFieldTypes.AnsiString )
			{
				strtemp = "'" + this.filterString(strtemp) + "'";
			}
			return strtemp;
		}


		#region ʵ

		protected override void openConnection()
		{
			// ½һݿ
			//this.currentConn = new SqlConnection(this.ConnectionString);
			this.currentConn = new OleDbConnection(this.ConnectionString);
			this.currentConn.Open();
		}
		protected override void beginTransaction()
		{
			this.currentTrans = this.currentConn.BeginTransaction(IsolationLevel.ReadCommitted);// Start a local transaction
		}
		protected override void commitTransaction()
		{
			this.currentTrans.Commit();//ύ
		}
		protected override void rollbackTransaction()
		{
			this.currentTrans.Rollback();
		}
		protected override void closeConnection()
		{
			this.currentConn.Close();
			this.currentTrans = null;
			this.currentConn = null;
		}

		#endregion


		#region ѯʵ ...

		private string queryPageCommandText = "SELECT TOP {0} {1} FROM {2} " + 
			" WHERE {4} NOT IN (SELECT TOP {5} {4} FROM {2} WHERE {3} ORDER BY {6}) AND ({3}) ORDER BY {6}";
		
		private string prepareQueryPageCommand(ObjectMap map, string searchCondition, int offset, int limitCount)
		{
			string strWhere = "";//= "1=1";
			string strOrderby = "";// = map.IDMemberMap.FieldName;
			int i = searchCondition.ToLower().IndexOf("order by ");
			if ( i>=0 )
			{
				strOrderby = searchCondition.Substring(i+9, searchCondition.Length-(i+9)).Trim();
				strWhere = searchCondition.Substring(0,i).Trim();
			}
			if ( strWhere.ToLower().IndexOf("where ") == 0 )
				strWhere.Substring(6,strWhere.Length-6);
			if (strWhere=="")
				strWhere = "1=1";
			if (strOrderby=="")
				strOrderby = map.IDMemberMap.FieldName;

			string sql = String.Format(this.queryPageCommandText,
				limitCount,//{0}
				this.getAllFieldNames(map),//{1}
				this.getSafeIdentifier(map.TableName),//{2} --> Table Name
				strWhere,//{3} --> Search Condition
				map.IDMemberMap.FieldName,//{4} --> ID Field Name
				offset-1,//{5}
				strOrderby//Sort Fields
				);
			return sql;
		}

		protected override string CombineSelectSql(ObjectMap map, string nativeSearchCondition, int offset, int limitCount)
		{
			string strS = nativeSearchCondition;
			string tableName = map.TableName;
			string sql = null;

			string strW = strS;

			if ( strW == null ) 
				strW = "";
			else
				strW = strW.Trim();

			if ( strW != "" )//ѯ
				if ( ! (strW.ToLower().IndexOf("where ") == 0) )
					strW = "where " + strW;

			if ( offset > 1 && limitCount > 0 )
			{
				if ( map.IDMemberMap==null )
					throw new WSORMException("ҳѯҪIDֶΣ");
				sql = this.prepareQueryPageCommand(map, strS, offset, limitCount);

			}
			else if ( offset <= 1 && limitCount > 0 )
			{
				//ӱвѯǰ¼
				sql = "select top " + limitCount.ToString() + " " + this.getAllFieldNames(map) + " from " + getSafeIdentifier(tableName) + " " + strW;
			}
			else
			{
				//ӱвѯм¼
				sql = "select " + this.getAllFieldNames(map) + " from " + getSafeIdentifier(tableName) + " " + strW;
			}
			return sql;
		
		}
		
		protected override string GetNativeSelectSql(ObjectMap map, string searchCondition, int offset, int limitCount)
		{
			string strS = this.getNativeSearchCondition(searchCondition, map);
			return this.CombineSelectSql(map,strS,offset,limitCount);
		}

		protected override string GetNativeQueryCountSql(ObjectMap map, string searchCondition)
		{
			string tableName = map.TableName;
			string strS = this.getNativeSearchCondition(searchCondition, map);
			string strW = strS;

			if ( strW == null ) 
				strW = "";
			else
				strW = strW.Trim();

			if ( strW != "" )//ѯ
				if ( ! (strW.ToLower().IndexOf("where ") == 0) )
					strW = "where " + strW;

			string sql = "";
			sql = "select count(*) from " + getSafeIdentifier(tableName) + " " + strW;

			return sql;
		}

		/// <summary>
		/// ȡݿSqlѯӾ
		/// </summary>
		/// <param name="searchCondition"></param>
		/// <param name="map"></param>
		/// <returns></returns>
		private string getNativeSearchCondition(string searchCondition,ObjectMap map)
		{
			if( searchCondition == null)
				return "";

			string str = "";
			Lexical lex = new Lexical(new System.IO.StringReader(searchCondition));
			Symbol[] syms = lex.SymbolTable;
			//
			//עҪҳʱַ
			//AccessʱҪ#1900-1-1 00:00:00#ʽ
			//ORMȱһ﷨
			//ֻȴպñȽ޴ķʽ
			//ڲѯӵʱ򣬿ܻ
			//
			//(?:(?:(?:(?:19|20)(?:(?:[02468][048])|(?:[13579][26]))-0?2-29))|(?:\d{4}-0?(?!(?:[4|6|9]-31)|(?:2-29)|(?:11-31)|(?:2-30)|(?:2-31))((?!0|(?:1[3-9]))(?:1?[0-9])-(?!0|(?:3[2-9]))(?:[1-3]?[0-9]))))\s+(?!(?:2[4-9]))(?:[1-2]?[0-9]):0?0:0?0
			string d = @"(\d{4})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01])";
			string t = @"(0?[0-9]|1[0-9]|2[0-4]):(0?[0-9]|[1|2|3|4|5][0-9]):(0?[0-9]|[1|2|3|4|5][0-9])$";
			string dt = "^" + d + "(\\s" + t + ")?$";
			System.Text.RegularExpressions.Regex reg = new System.Text.RegularExpressions.Regex(dt);
			
			foreach(Symbol sym in syms)
			{
				if( sym.Type == SymbolTypes.Identifier )
				{
					if( map.MemberMaps.Contains(sym.Content) )
						str += map.MemberMaps[sym.Content].FieldName;// + " ";
					else
						str += sym.Content;// + " ";
				}
				else if( sym.Type == SymbolTypes.String )
				{
					if ( reg.IsMatch (sym.Content) )
					{
						str += "#" + this.filterString(sym.Content) + "#";
					}
					else
					{
						str += "'" + this.filterString(sym.Content) + "'";// + " ";		
					}
				}
				else
				{
					str += sym.Content;// + " ";
				}
			}
			return str;
		}

		public override DataTable QureyTableByNativeSql(string nativeSql)
		{
			//SqlCommand command = new SqlCommand( nativeSql );	
			OleDbCommand command = new  OleDbCommand( nativeSql );	
			//SqlConnection conn = new SqlConnection( this.ConnectionString );
			OleDbConnection conn = new OleDbConnection( this.ConnectionString );
			command.Connection = conn;

			command.CommandTimeout = this.queryTimeout;
			//SqlDataAdapter da = new SqlDataAdapter( command );
            OleDbDataAdapter da = new OleDbDataAdapter( command );
			DataTable tbl = new DataTable();
			da.Fill( tbl );
			return tbl;
		}

		public override object ExecuteScalarByNativeSql(string nativeSql)
		{
			object ret;
			//SqlCommand command = new SqlCommand( nativeSql );	
			OleDbCommand command = new OleDbCommand( nativeSql );	
			//SqlConnection conn = new SqlConnection( this.ConnectionString );
			OleDbConnection conn = new OleDbConnection( this.ConnectionString );
			command.Connection = conn;
			command.CommandTimeout = this.queryTimeout;
			conn.Open();
			try
			{
				ret = command.ExecuteScalar();
			}
			finally
			{
				conn.Close();
			}
			return ret;
		}

		#endregion


		#region Deleteʵ
		
		protected override int dbDelete(string tableName,DbFieldCollection keyFields)
		{
			string sql = this.getDeleteNativeSql(tableName, keyFields.ToArray());
			return this.deleteByNativeSql(sql);
		}

		/// <summary>
		/// ȡDeleteSQL
		/// </summary>
		/// <param name="tableName"></param>
		/// <param name="keyFields">ֵ</param>
		/// <returns></returns>
		private string getDeleteNativeSql(string tableName, DbField[] keyFields)
		{
			string deletesql = "delete from " + this.getSafeIdentifier(tableName);
			string strW = "";
			foreach(DbField keyField in keyFields)
			{
				if ( strW == "" )
					strW = keyField.Name + "=" + this.getNativeDbValueExpression(keyField.Type, keyField.Value);
				else
					strW = strW + " and " + keyField.Name + "=" + this.getNativeDbValueExpression(keyField.Type, keyField.Value);	
			}
			deletesql = deletesql + " where " + strW;//System.Diagnostics.Debug.WriteLine( deletesql);
			return deletesql;
		}

		/// <summary>
		/// ִDelete
		/// </summary>
		/// <param name="deletesql">Delete Sql</param>
		/// <returns>Ӱ</returns>
		private int deleteByNativeSql(string deletesql)
		{
			System.Diagnostics.Debug.WriteLine(deletesql);//Ե SQL 
	
			int effect = 0;
			string sql = deletesql;
			//SqlCommand cmd = this.currentConn.CreateCommand();
			OleDbCommand cmd = this.currentConn.CreateCommand();
			cmd.CommandText = sql;
			cmd.Connection = this.currentConn;	
			cmd.Transaction = this.currentTrans;		//conn.Open();
			effect = cmd.ExecuteNonQuery();//System.Diagnostics.Debug.WriteLine( ret.ToString() );
			return effect;//Ӱ
		}

		#endregion


		#region Updateʵ
		
		
		protected override int dbUpdate(string tableName, DbFieldCollection fields, DbFieldCollection keyFields)
		{
			string updatesql = this.getUpdateSql(tableName, fields, keyFields.ToArray());//ȡUpdate
			int effect = this.sqlUpdate(updatesql, fields);//ִUpdate
			return effect;
		}

		/// <summary>
		/// زUpdate SQL
		/// </summary>
		/// <param name="tableName"></param>
		/// <param name="fields">ҪUpdateֶ</param>
		/// <param name="keyFields">IDֶ</param>
		/// <returns>Update SQL</returns>
		private string getUpdateSql(string tableName, DbFieldCollection fields, DbField[] keyFields)
		{
			string updatesql = "update " + this.getSafeIdentifier(tableName) ;
			string strF = "";
			foreach(DbField field in fields)
			{
				if(strF == "")
				{
					strF = field.Name + "=" + ParameterToken + field.Name;
				}
				else
				{
					strF = strF + "," + field.Name + "=" + ParameterToken + field.Name;
				}
			}
			string strW = "";
			foreach(DbField keyField in keyFields)
			{
				if ( strW == "" )
					strW = keyField.Name + "=" + this.getNativeDbValueExpression(keyField.Type, keyField.Value);
				else
					strW = strW + " and " + keyField.Name + "=" + this.getNativeDbValueExpression(keyField.Type, keyField.Value); 
			}
			updatesql = updatesql + " set " + strF + " where " + strW;
			//System.Diagnostics.Debug.WriteLine(updatesql);
			return updatesql;
		}

		/// <summary>
		/// ִвUpdate SQL
		/// </summary>
		/// <param name="insertsql">Update</param>
		/// <param name="fields">ҪUpdateֶ</param>
		private int sqlUpdate(string updatesql, DbFieldCollection fields)
		{
			System.Diagnostics.Debug.WriteLine(updatesql);//Ե SQL 
#if DEBUG
			foreach(DbField f in fields)
				System.Diagnostics.Debug.WriteLine(f.Name + "\t:\t" + (f.Value==null ? "null" : f.Value.ToString()));
#endif
			int ieffect = 0;
			string sql = updatesql;
			OleDbCommand cmd = this.currentConn.CreateCommand();
			cmd.CommandText = sql;					//SqlConnection conn = new SqlConnection(this.ConnectionString);
			cmd.Connection = this.currentConn;		//conn;
			cmd.Transaction = this.currentTrans;	//conn.Open();
			foreach(DbField field in fields)
			{
				cmd.Parameters.Add(ParameterToken+field.Name,this.getOleDbType(field.Type)).Value 
					= getSafeValue(field.Type, field.Value);
			}
			ieffect = cmd.ExecuteNonQuery();
			//System.Diagnostics.Debug.WriteLine( ret.ToString() );
			return ieffect;//Ӱ
		}

		#endregion


		#region Insertʵ
		
		protected override object dbInsert(string tableName , DbFieldCollection fields, bool returnID)
		{
			string insertsql = this.getInsertSql(tableName, fields);//ȡInsert
			object idret = this.sqlInsert(insertsql,fields,true);//ִInsert
			return idret;
		}
		
		/// <summary>
		/// ȡôInsert SQL
		/// </summary>
		/// <param name="tablename">ҪInsertı</param>
		/// <param name="fields">ҪInsertֶ</param>
		/// <returns>Insert SQL</returns>
		private string getInsertSql(string tablename, DbFieldCollection fields)
		{
			string insertsql = "insert into " + getSafeIdentifier(tablename) + " ";//"insert into [" + tablename + "] ";
			string strF = "" ;
			string strP = "" ;
			foreach(DbField field in fields)
			{
				if(strF=="")
				{
					strF = strF + "(" + field.Name;
					strP = strP + "(" + ParameterToken + field.Name;
				}
				else
				{
					strF = strF + "," + field.Name;
					strP = strP + "," + ParameterToken + field.Name;
				}
			}
			if(strF!="")
			{
				strF = strF + ")";
				strP = strP + ")";
				insertsql = insertsql + strF + " values " + strP ;//+ " SELECT @@IDENTITY";
			}
			return insertsql;
		}

		
		/*Ҫ޸ģΪOracleûselect @@identity*/
		/// <summary>
		/// ʹôInsert SQLִһ
		/// </summary>
		/// <param name="insertsql">Insert SQL</param>
		/// <param name="fields">ֶεֵ</param>
		/// <param name="returnID">еIdentity</param>
		/// <returns></returns>
		private object sqlInsert(string insertsql, DbFieldCollection fields, bool returnID)
		{
			System.Diagnostics.Debug.WriteLine(insertsql);//Ե SQL 
#if DEBUG
			foreach(DbField f in fields)
				System.Diagnostics.Debug.WriteLine(f.Name + "\t:\t" + (f.Value==null ? "null" : f.Value.ToString()));
#endif
			string sql = insertsql;
//			if ( returnID )
//			{
//				sql += ";SELECT @@Identity";
//			}
			
			OleDbCommand cmd = this.currentConn.CreateCommand();//new SqlCommand(sql);
			cmd.CommandText = sql;					//SqlConnection conn = new SqlConnection(this.ConnectionString);
			cmd.Connection = this.currentConn;		//cmd.Connection = conn;
			cmd.Transaction = this.currentTrans;	//conn.Open();
			foreach(DbField field in fields)
			{
				cmd.Parameters.Add(ParameterToken+field.Name,this.getOleDbType(field.Type)).Value 
					= getSafeValue(field.Type, field.Value);	
			}

			object ret = null;
			cmd.ExecuteNonQuery();
			if ( returnID )
			{
				sql = "SELECT @@Identity";
				cmd.CommandText = sql;
				ret = cmd.ExecuteScalar();
			}
			
			//if ( ret != null )
			//	System.Diagnostics.Debug.WriteLine( ret.ToString() );
			//conn.Close();
			return ret;
		}
 

		#endregion


	}
}
