using System;
using System.Diagnostics;

namespace com.oucsoft.WSORM
{
	/// <summary>
	/// ӡDebugϢ
	/// </summary>
	public class DebugHelper
	{
		private DebugHelper()
		{
		}
		
		public static void OutputExceptionInfo(Exception ex)
		{
			//Debug.Unindent();
			Debug.WriteLine("================================================");
			int indent = 0;
			innerOutputExceptionInfo( ex , ref indent );
			for(int i=0; i<indent; i++)
			{
				Debug.Unindent();
			}
			Debug.WriteLine("================================================");
			Debug.WriteLine("");
			
		}

		private static void innerOutputExceptionInfo(Exception ex, ref int indent)
		{
			for(int i=0; i<indent; i++)
			{
				Debug.Indent();
			}
			Debug.WriteLine( " + 쳣\t:\t" + ex.GetType().FullName );
			Debug.WriteLine( " + 쳣Ϣ\t:\t" + ex.Message.Replace("\r","").Replace("\n","") );
			//Debug.WriteLine( " ------------------------------------------------" );
			indent ++;
			if(ex.InnerException != null)
			{
				innerOutputExceptionInfo( ex.InnerException, ref indent );
			}
		}

	}
}
