using System;
using System.Collections;
using System.IO;
using System.Text;
using System.Diagnostics;

namespace com.oucsoft.WSORM.OSql
{

	/// <summary>
	/// ʷ
	/// </summary>
	public class Lexical
	{

		#region ʷ ...

		/*
		ؼ:   ʶĹؼΪint, real, if, then, else, while, order by, group by, null
		ϱʶʱʶΪؼ֣inta,ifbʶΪʶ     
		*/
		private bool isKey(String checkKey)
		{
			if(checkKey.Equals("if")||checkKey.Equals("then")||
				checkKey.Equals("else")||checkKey.Equals("int")||
				checkKey.Equals("real")||checkKey.Equals("while")||
				checkKey.ToLower().Equals("where")||
				checkKey.ToLower().Equals("order")||checkKey.ToLower().Equals("group")||
				checkKey.ToLower().Equals("by")||checkKey.ToLower().Equals("null")||
				checkKey.ToLower().Equals("desc")||checkKey.ToLower().Equals("asc")||checkKey.ToLower().Equals("in"))
			{
				return true;
			}
			return false;
		}
		/*
		ʶ:   һʶĸͷĸ֣Ϣ 
		ֹͣʷشϢ
		: ȷabc, abc123, 
		123abc 

		:   ʶĲΪ:   +  -  /  *  =  ==  <  <=  >  >=  != <> and or not is like
		!ַʱϢ
		*/
		private bool isOperator(String checkOperator)
		{
			if(checkOperator.ToLower().Equals("not")||checkOperator.ToLower().Equals("and")||
				checkOperator.ToLower().Equals("or")||checkOperator.ToLower().Equals("is")||
				checkOperator.ToLower().Equals("like")||checkOperator.ToLower().Equals("between"))
			{
				return true;
			}
			return false;
		}
		/*
		ָ:   ʶķָΪ:   (  )  {  }  ; ,

		:     ʶѭķ:
		digit       0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9
		intnumber   digit+       
		exponent     E ( + | - | ? ) digit+ 
		fraction     . digit+
		realnumber   digit+ exponent | digit+ fraction ( exponent | ? )
		磺ȷ: 123, 123E2, 123.3, 123.3E4 
		: 123A123E, 123.A . 123.3A, 123.3E         
		
		ַ:  'ͷ'
		
		עͷ:  עͲ  // 䲻ʶ.

		*/
   		   
		private bool isLetter(char checkChar)
		{
			int checkInt = (int)checkChar;
			if((checkInt<=122&&checkInt>=97)||(checkInt>=65&&checkInt<=97))
			{
				return true;
			}
			return false;
		}
    
		private bool isDigit(char checkChar)
		{
			int checkInt = (int)checkChar;
			if(checkInt<=57&&checkInt>=48)
			{
				return true;
			}
			return false;
		}
    
		#endregion

		#region  ...

		private int rnum;//к
		private int rpos;//к
		private ArrayList symbolTable;
		private TextReader br;
		private char c;
		private char bC;
		private int state;
		private String str;

		
		/// <summary>
		/// õĴʱ
		/// </summary>
		public Symbol[] SymbolTable
		{
			get
			{
				c = nextChar();
				state = 0;
				analyzer();
				return (Symbol[])symbolTable.ToArray(typeof(Symbol));
			}
		}

		#endregion


		public Lexical(TextReader br)
		{	
			symbolTable = new ArrayList();
			this.br=br;
			c=' ';
			bC=' ';
			state = 0;
			rnum=1;
			rpos=0;
			str="";
		}
		
		private void analyzer()
		{
			bool isRunning=true;

			while(isRunning)
			{
				switch (state)
				{
					case 0:
					
						if(c==' ')            //ո
						{
							install(SymbolTypes.Space, " ", rpos, rnum);
						}
						else if(c=='\t')      //tab
						{
							install(SymbolTypes.Space, "\t", rpos, rnum);
							rpos+=3;
						}
						else if((int)c=='\r')   //س
						{
							install(SymbolTypes.Space, "\r", rpos, rnum);        
						}
						else if((int)c=='\n')   //
						{
							install(SymbolTypes.Space, "\n", rpos, rnum);        
							rpos = 0;
							rnum++;
						}
						else if(c=='+')       //+
						{
							install(SymbolTypes.Operator,"+",rpos,rnum);
						} 
						else if(c=='-')       //-
						{
							install(SymbolTypes.Operator,"-",rpos,rnum);
						}
						else if(c=='/')       ///
						{
							state = 1;
						}
						else if(c=='*')       //*
						{
							install(SymbolTypes.Operator,"*",rpos,rnum);
						}
						else if(c=='=')       //=
						{ 
							state = 2;
						}
						else if(c=='<')       //<
						{
							state = 3;
						}
						else if(c=='>')       //>
						{
							state = 4;
						}
						else if(c=='!')       //!
						{
							state = 5;
						}
						else if(c=='{')       //ָ{
						{
							install(SymbolTypes.Separator,"{",rpos,rnum);
						}
						else if(c=='}')       //ָ}
						{
							install(SymbolTypes.Separator,"}",rpos,rnum);
						}
						else if(c=='(')		  //ָ(
						{
							install(SymbolTypes.Separator,"(",rpos,rnum);
						}
						else if(c==')')		  //ָ)
						{
							install(SymbolTypes.Separator,")",rpos,rnum);
						}
						else if(c==';')       //ָ;
						{
							install(SymbolTypes.Separator,";",rpos,rnum);
						}
						else if(c==',')       //ָ,
						{
							install(SymbolTypes.Separator,",",rpos,rnum);
						}
						else if(c=='\'')      //ַʼ
						{
							str = "";
							state = 14;
						}
							//else if(c=='~')       //
							//{
							//	return;
							//}
						else if(c=='[')		//ǿƿʼʶ 
						{
							install(SymbolTypes.Separator,"[",rpos,rnum);
							str = "";
							state = 15;
						}
						else if((int)c==65535)
						{
							isRunning=false;
							return;
						}
						else if(isLetter(c))  //ַ
						{
							bC = c;
							state = 6;
						}
						else if(isDigit(c))   //ַ
						{
							bC = c;
							str="";
							state = 7;
						}
							//else if(c=='#')
							//{
							//	state=13;
							//}
						else 
						{
							state=0;
							isRunning=false;
							fail(0);
						}
                       
						c = nextChar();
						break;
					case 1:
						if(c=='/')             //ʾעͺĶ,
						{
							while((int)c!=10)
							{
								c = nextChar();
							}
							rpos=0;           //һпʼ
							rnum++;
							c = nextChar();
							state = 0;
						}
						else 
						{
							state = 0;        // һ/, һstate=0
							install(SymbolTypes.Operator,"/",rpos-1,rnum);
						}

						break;
					case 2:
                
						if(c=='=')           //ʾ==
						{
							state = 0;
							install(SymbolTypes.Operator,"==",rpos-1,rnum);
							c = nextChar();
						}
						else 
						{
							state = 0;
							install(SymbolTypes.Operator,"=",rpos-1,rnum);
						}

						break;
					case 3:
						if(c=='=')          //ʾ<=
						{
							state = 0;
							install(SymbolTypes.Operator,"<=",rpos-1,rnum);
							c = nextChar();
						}
						else if(c=='>')		//ʾ<>
						{
							state = 0;
							install(SymbolTypes.Operator,"<>",rpos-1,rnum);
							c = nextChar();
						}
						else 
						{
							state = 0;
							install(SymbolTypes.Operator,"<",rpos-1,rnum);
						}
                
						break;
					case 4:
						if(c=='=')          //ʾ>=
						{
							state = 0;
							install(SymbolTypes.Operator,">=",rpos-1,rnum);
							c = nextChar();
						}
						else 
						{
							state = 0;
							install(SymbolTypes.Operator,">",rpos-1,rnum);
						}

						break;
					case 5:
						if(c=='=')         // ʾ!=
						{
							state = 0;
							install(SymbolTypes.Operator,"!=",rpos-1,rnum);
							c = nextChar();
						}
						else 
						{
							state = 0;
							isRunning=false;
							fail(1);
						}
						break;
				
						//***********************************
						//ʶ, ַĸǶԵ
						//***********************************
					case 6:                      
						String id = ""+bC;
						while(isLetter(c)||isDigit(c))
						{
							id+=c;
							c = nextChar();
						}
						if(isKey(id))
							install(SymbolTypes.Key,id,rpos-id.Length,rnum);
						else if(isOperator(id))
							install(SymbolTypes.Operator,id,rpos-id.Length,rnum);
						else
							install(SymbolTypes.Identifier,id,rpos-id.Length,rnum);
						state = 0;
						break;
						//*********************************************
						//ַ, ַ(ѭ); .(ת״̬);E(ת״̬)
						//**********************************************
					case 7:                         
						str+=bC; 
						while(isDigit(c))            
						{
							str+=c;
							c=nextChar();
						}
						if(c=='.')                  
						{
							state=8;
							c=nextChar();         
						}
						else if(c=='E')              
						{
							state=10;
							c=nextChar();
						}
						
							//ҪжǷ  11w
						else if(isLetter(c))
						{
							state = 0;
							isRunning=false;
							fail(4);
                        
						}
						else                        
						{
							state = 0;
							install(SymbolTypes.Numeric,str,rpos-str.Length,rnum);
						}
						break;
						//***********************************
						//  " ." ַ,ַ
						//***********************************
					case 8:                         
						str+='.';
						if(isDigit(c))
						{
							state = 9;
							str+=c;
							c=nextChar();
						}
						else
						{
							state = 0;
							isRunning=false;
							fail(2);
						}
						break;
						//***********************************************************************************
						//    ".ַ" ַ,ַE(ҪӴʾ,ǿոĸʱ)
						//************************************************************************************
					case 9:
                
						while(isDigit(c))
						{
							str+=c;
							c=nextChar();
						}
						if(c=='E')
						{
							state = 10;
							c=nextChar();
						}

							//ҪжǷ  11w 
						else if(isLetter(c))
						{
							state = 0;
							isRunning=false;
							fail(2);
                        
						}
						else
						{
							state = 0;
							install(SymbolTypes.Numeric,str,rpos-str.Length,rnum);
						}
						break;

						//*********************************************
						// "E"  ַ,  "+";"-";"ַ" ǶԵ,Ǵ
						//********************************************
					case 10:
						str+='E';
						if(c=='+'||c=='-')
						{
							state=11;
							str+=c;
							c=nextChar();
						}
						else if(isDigit(c))
						{
							state=12;
							str+=c;
							c=nextChar();
						}
						else
						{
							state=0;
							isRunning=false;
							fail(2);
						}
						break;
						//*****************************************
						//   "+" "-" ַ, ַǶԵ.Ǵ
						//*****************************************
					case 11:
						if(isDigit(c))
						{
							state=12;
							str+=c;
							c=nextChar();
						}
						else
						{
							state = 0;
							isRunning=false;
							fail(2);
						}
						break;
						//***********************************
						// "Eַ"  ַ,ַֻǶԵ
						//*********************************
					case 12:
						while(isDigit(c))
						{
							str+=c;
							c=nextChar();
						}

						if(isLetter(c))
						{
							state = 0;
							isRunning=false;
							fail(2);
                        
						}
						install(SymbolTypes.Numeric,str,rpos-str.Length,rnum);
						state=0;
						break;
						/*
						case 13: //
					
							id ="#";
							while(isLetter(c))
							{
								id+=c;
								c = nextChar();
							}
							if(id=="#include"&&c=='<')
							{
										    
								id+=c;
								c = nextChar();
								while(isLetter(c)||this.isDigit(c))
								{
							
									id+=c;
									c = nextChar();
								}
								if(c=='>')
								{
									id+=c;
									install("ļ",id,rpos-id.Length,rnum);
									c = nextChar();
								}
								else
									fail(3);
                                         
							}
							else
								fail(0);
							state = 0;
							break;
						*/
						//***************************************
						// ַʼ
						//***************************************
					case 14:
						if((int)c==65535)
						{
							state = 0;
							isRunning=false;
							fail(5);
						}
						else if(c == '\'')//š'
						{
							c = nextChar();//ȡһַ
							if(c == '\'')//ֵڶţôһתƷ
							{
								str+="\'";//һ
								c = nextChar();//ȡһַ
							}
							else//ַ
							{
								install(SymbolTypes.String,str,rpos-str.Length-1,rnum);
								state = 0;//c = nextChar();
							}
						}
						else //if(c != '\'')
						{
							str+=c;
							c = nextChar();
						}
						break;
					case 15:
						if((int)c==65535)
						{
							state = 0;
							isRunning=false;
							fail(4);
						}
						else if(c == ']')//š
						{
							c = nextChar();							
							install(SymbolTypes.Identifier , str , rpos-str.Length-1 , rnum);
							install(SymbolTypes.Separator,"]",rpos-1,rnum);
							state = 0;
						}
						else if ( isLetter(c) || c==' ' || c=='-' || c=='_' )
						{
							str+=c;
							c = nextChar();
						}
						else
						{
							state = 0;
							isRunning=false;
							fail(4);
						}
						break;

				}
			}
		}
 

		private void fail(int i) 
		{
			string typeerror="";;
			switch(i)
			{
				case 0:
					typeerror="Ƿַ";
					break;
				case 1:
					typeerror="";
					break;

				case 2:
					typeerror="ַ";
					break;

				case 3:
					typeerror="";
					break;
				case 4:
					typeerror="ʶ";
					break;
				case 5:
					typeerror="ַ";
					break;

			}
			//Console.Write(typeerror+",λ<"+rnum+","+rpos+">");
			Debug.WriteLine(typeerror+",λ<"+rnum+","+rpos+">");
			throw new LexicalException(typeerror);
		}


		private char nextChar()
		{
			char t;
			rpos++;
			//if(br.Peek() == -1)
			//{
			//	br.Close();
			//	return '~';
			//}
			int i = br.Read();
			if ( i == -1 )
			{
				br.Close();
			}
			t= (char) i;
			return t;
		}
    
		//private void install(String tType,String aValue,int rpos,int rnum)
		private void install(SymbolTypes tType,String aValue,int rpos,int rnum)
		{
			//ArrayList tokenArray = new ArrayList();
			//tokenArray.Add(tType);
			//tokenArray.Add(aValue);
			//tokenArray.Add("<"+rnum.ToString()+","+rpos.ToString()+">");
			//symbolTable.Add(tokenArray);
			Symbol sym = new Symbol(tType,aValue,rpos,rnum);
			Debug.WriteLine(sym.ToString());
			symbolTable.Add(sym);
			
			//ArrayList tempArray=tokenArray;
			//for(int j=0;j<tempArray.Count;j++)
			//{
			//	Console.Write(tempArray[j].ToString()+"     ");
			//}
			//Console.WriteLine();
			str="";
		}
 
	}


	
	#region  ...

	/// <summary>
	/// ʵ
	/// </summary>
	public enum SymbolTypes
	{
		Key,
		Operator,
		Separator,
		Identifier,
		Numeric,
		String,
		Space
	}

	/// <summary>
	/// 
	/// </summary>
	public class Symbol
	{
		public SymbolTypes Type;
		public string Content;
		//private int rnum;//к
		public int RNum;
		//private int rpos;//к
		public int RPos;
		public Symbol(SymbolTypes tType,string aValue,int rpos,int rnum)
		{
			this.Type = tType;
			this.Content = aValue;
			this.RPos = rpos;
			this.RNum = rnum;
		}
		public override string ToString()
		{
			System.Text.StringBuilder sb = new System.Text.StringBuilder();
			sb.Append(this.Type.ToString());
			sb.Append("\t");
			sb.Append(this.Content);
			sb.Append("\t");
			sb.Append("<"+this.RNum.ToString()+","+this.RPos.ToString()+">");
			return sb.ToString();
		}
	}

	/// <summary>
	/// 쳣
	/// </summary>
	public class LexicalException : ApplicationException
	{
		public LexicalException(string message) : base(message)
		{}
	}

	#endregion


}
