using System;
using System.Reflection;

namespace com.oucsoft.WSORM
{
	/// <summary>
	/// ԳԱеĲ
	/// </summary>
	public class MemberHelper
	{
		private MemberHelper()
		{
		}
		
		#region ڳԱͳԱϢMemberInfoĲ


		/// <summary>
		/// ȽϳԱֵǷĳֵ
		/// </summary>
		/// <param name="memberName">Ա</param>
		/// <param name="obj"></param>
		/// <param name="compareVal">ҪԱбȽϵֵ</param>
		/// <returns>ȷtrueȷfalse</returns>
		public static bool MemberEquals(string memberName, object obj, object compareVal)
		{
			object memberVal = MemberHelper.GetMemberValue(memberName,obj);//Աֵ
			if( memberVal==null && compareVal==null )
				return true;
			if( memberVal==null && compareVal!=null)
				return false;
			if( ! memberVal.Equals( compareVal ) )
				return false;
			else
				return true;
		}
			
		/// <summary>
		/// ȡóԱϢǰֻȡFieldProperty
		/// </summary>
		/// <param name="type">Ϣ</param>
		/// <param name="memberName">Ա</param>
		/// <returns></returns>
		public static MemberInfo GetMemberInfo(System.Type type, string memberName)
		{
			MemberInfo[] memberInfos = type.GetMember(memberName);
			if ( memberInfos==null || memberInfos.Length<1 )
				throw new MemberNotFoundException("Ա" + memberName + "ûб֣");
			else if ( memberInfos[0].MemberType != MemberTypes.Field && memberInfos[0].MemberType != MemberTypes.Property )
				throw new MemberTypeException("Ա" + memberName +"FieldProperty");
			else
				return memberInfos[0];
		}

		public static System.Type GetMemberType(MemberInfo memberInfo)
		{
			if ( memberInfo.MemberType == MemberTypes.Field )
				return ((FieldInfo)memberInfo).FieldType;
			else if ( memberInfo.MemberType == MemberTypes.Property )
				return ((PropertyInfo)memberInfo).PropertyType;
			else
				throw new MemberTypeException("Ա" + memberInfo.Name +"FieldProperty");
		}

		/// <summary>
		/// óԱֵFieldProperty
		/// </summary>
		/// <param name="memberInfo"></param>
		/// <param name="obj"></param>
		/// <param name="val"></param>
		public static void SetMemberValue(MemberInfo memberInfo, object obj, object val)
		{
			if ( memberInfo.MemberType == MemberTypes.Field )
			{
				FieldInfo fieldInfo = ((FieldInfo)memberInfo);
				System.Type fieldType = fieldInfo.FieldType;//ֶ
				fieldInfo.SetValue(obj,Convert.ChangeType(val,fieldType));
			}
			else if ( memberInfo.MemberType == MemberTypes.Property )
			{
				PropertyInfo propertyInfo = ((PropertyInfo)memberInfo);
				System.Type propertyType = propertyInfo.PropertyType;
				propertyInfo.SetValue(obj,Convert.ChangeType(val,propertyType),null);
			}
			else
				throw new MemberTypeException("Ա" + memberInfo.Name +"FieldProperty");
		}

		public static void SetMemberValue(string memberName, object obj, object val)
		{
			SetMemberValue( GetMemberInfo(obj.GetType(),memberName),obj,val );
		}

		/// <summary>
		/// ȡóԱֵ
		/// </summary>
		/// <param name="memberInfo">ԱϢ</param>
		/// <param name="obj"></param>
		/// <returns></returns>
		public static object GetMemberValue(MemberInfo memberInfo, object obj)
		{
			if ( memberInfo.MemberType == MemberTypes.Field )
				return ((FieldInfo)memberInfo).GetValue(obj);
			else if ( memberInfo.MemberType == MemberTypes.Property )
				return ((PropertyInfo)memberInfo).GetValue(obj,null);
			else
				throw new MemberTypeException("Ա" + memberInfo.Name +"FieldProperty");

		}

		/// <summary>
		/// ȡóԱֵ
		/// </summary>
		/// <param name="memberName">Ա</param>
		/// <param name="obj"></param>
		/// <returns></returns>
		public static object GetMemberValue(string memberName, object obj)
		{
			MemberInfo memberInfo = GetMemberInfo(obj.GetType(), memberName);
			return GetMemberValue(memberInfo,obj);
		}

		/// <summary>
		/// ԱǷ
		/// </summary>
		/// <param name="memberInfo"></param>
		/// <returns></returns>
		public static bool IsMemberArray(MemberInfo memberInfo)
		{
			if ( memberInfo.MemberType == MemberTypes.Field )
				return ((FieldInfo)memberInfo).FieldType.IsArray ;
			else if ( memberInfo.MemberType == MemberTypes.Property )
				return ((PropertyInfo)memberInfo).PropertyType.IsArray ;
			else
				throw new MemberTypeException("Ա" + memberInfo.Name +"FieldProperty");
			//return false;
		}

		/// <summary>
		/// ԱǷʵĳӿ
		/// </summary>
		/// <param name="memberInfo"></param>
		/// <param name="interfaceType"></param>
		/// <returns></returns>
		public static bool HasMemberInterface(MemberInfo memberInfo, System.Type interfaceType)
		{
			if ( memberInfo.MemberType == MemberTypes.Field )
				return ((FieldInfo)memberInfo).FieldType.GetInterface(interfaceType.FullName) != null ;
			else if ( memberInfo.MemberType == MemberTypes.Property )
				return ((PropertyInfo)memberInfo).PropertyType.GetInterface(interfaceType.FullName) != null ;
			else
				throw new MemberTypeException("Ա" + memberInfo.Name +"FieldProperty");
		}



		#endregion

	}
}
