using System;

namespace com.oucsoft.WSORM
{
	[Flags]
	public enum MemberMapFlags : uint
	{
		/// <summary>
		/// 
		/// </summary>
		Normal = CascadedQuery | CascadedSave | CascadedDelete,

		/// <summary>
		/// ѯʱǷѯ
		/// </summary>
		CascadedQuery = 1,
		/// <summary>
		/// Ƿ棬One2ManyMany2OneʱЧ
		/// </summary>
		CascadedSave = 2,
		/// <summary>
		/// ǷɾOne2ManyʱЧ
		/// </summary>
		CascadedDelete = 4,

		/// <summary>
		/// ǷԣͨĳԱЧ
		/// </summary>
		Ignored = 1024,
		
	}

	/// <summary>
	/// Աӳ
	/// </summary>
	public class MemberMap
	{
		
		#region  ...

		private string memberName = null;
		/// <summary>
		/// Ա
		/// </summary>
		public string MemberName
		{
			get{ return this.memberName; }
		}

		private string fieldName = null;
		/// <summary>
		/// Ӧݿֶ
		/// </summary>
		public string FieldName
		{
			get{ return this.fieldName; }
		}

		private DbFieldTypes fieldType = DbFieldTypes.Unknown;
		/// <summary>
		/// ֶ
		/// </summary>
		public DbFieldTypes FieldType
		{
			get{ return this.fieldType; }
		}

		private MemberMapTypes mapType = MemberMapTypes.NormalField;
		/// <summary>
		/// ӳͣʾһֶӳ䡢IDߡOne2ManyߡMany2One
		/// </summary>
		public MemberMapTypes MemberMapType
		{
			get{ return this.mapType; }
		}

		
		//private string externalType = null;
		private System.Type externalType = null;
		/// <summary>
		/// ⲿͣӳǡOne2ManyߡMany2OneʱЧ
		/// </summary>
		public System.Type ExternalType//public string ExternalType
		{
			get{ return this.externalType; }
			set{ this.externalType = value; }
		}

		private string externalField = null;
		/// <summary>
		/// ƣӳǡOne2ManyߡMany2OneʱЧ
		/// </summary>
		public string ExternalField
		{
			get{ return this.externalField; }
			set{ this.externalField = value; }
		}

		/*
		private string sequenceName = null;
		public string SequenceName
		{
			//ʹ֧SequenceݿʱЧOracle
			get{ return this.sequenceName; }
			set{ this.sequenceName = value; }
		}
		*/

		private MemberMapFlags flag = MemberMapFlags.Normal;
		/// <summary>
		/// ԱӰһЩԣǷԡ桢ɾ
		/// </summary>
		public MemberMapFlags Flag
		{
			get {return this.flag;}
			set {this.flag=value;}
		}

		public bool Ignored
		{
			get{ return (this.flag & MemberMapFlags.Ignored) > 0; }
			set
			{
				if ( value )
					 this.flag = (this.flag | MemberMapFlags.Ignored);
				 else
					 this.flag=(this.flag & ~MemberMapFlags.Ignored); 
			}
		}
		public bool CascadedQuery
		{
			get{ return (this.flag & MemberMapFlags.CascadedQuery) > 0; }
			set
			{
				if ( value )
					this.flag = (this.flag | MemberMapFlags.CascadedQuery);
				else
					this.flag=(this.flag & ~MemberMapFlags.CascadedQuery); 
			}
		}
		public bool CascadedSave
		{
			get{ return (this.flag & MemberMapFlags.CascadedSave) > 0; }
			set
			{
				if ( value )
					this.flag = (this.flag | MemberMapFlags.CascadedSave);
				else
					this.flag=(this.flag & ~MemberMapFlags.CascadedSave); 
			}
		}
		public bool CascadedDelete
		{
			get{ return (this.flag & MemberMapFlags.CascadedDelete) > 0; }
			set
			{
				if ( value )
					this.flag = (this.flag | MemberMapFlags.CascadedDelete);
				else
					this.flag=(this.flag & ~MemberMapFlags.CascadedDelete); 
			}
		}

		#endregion

		/// <summary>
		/// 캯
		/// </summary>
		/// <param name="member">Ա</param>
		/// <param name="field">ݿֶ</param>
		/// <param name="type"></param>
		public MemberMap(string member, string field, DbFieldTypes type)
		{
			this.memberName = member;
			this.fieldName = field;
			this.fieldType = type;
			this.mapType = MemberMapTypes.NormalField;
		}

		/// <summary>
		/// 캯
		/// </summary>
		/// <param name="member">Ա</param>
		/// <param name="field">ݿֶ</param>
		/// <param name="type">ҪӳĳԱ</param>
		/// <param name="mapType">չ</param>
		public MemberMap(string member, string field, DbFieldTypes type, MemberMapTypes mapType)
		{
			this.memberName = member;
			this.fieldName = field;
			this.fieldType = type;
			this.mapType = mapType;
		}

		/// <summary>
		/// 캯
		/// </summary>
		/// <param name="member">Ա</param>
		/// <param name="field">ݿֶ</param>
		/// <param name="fieldtype">ҪӳĳԱ</param>
		/// <param name="externalType">ⲿͣӳǡOne2ManyߡMany2OneʱЧ</param>
		/// <param name="externalField">ⲿֶƣӳǡOne2ManyߡMany2OneʱЧ</param>
		/// <param name="mapType"></param>
		public MemberMap(string member, string field, DbFieldTypes fieldtype, System.Type externalType, string externalField, MemberMapTypes mapType)
		{
			//public MemberMap(string member, string field, DbFieldTypes fieldtype, string externalType, string externalField, MemberMapTypes mapType)
			this.memberName = member;
			this.fieldName = field;
			this.fieldType = fieldtype;
			this.mapType = mapType;
			this.externalType = externalType;
			this.externalField = externalField;
		}

		public MemberMap Clone()
		{
			MemberMap newMap = new MemberMap(
				this.memberName, 
				this.fieldName, 
				this.fieldType ,
				this.externalType,
				this.externalField, 
				this.mapType);
			return newMap;
		}
	}

}
